/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Icon;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.ui.Icons;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UiUtils {
    private UiUtils() {
    }

    public static Icon getElementIcon(ElementKind elementKind, Collection<Modifier> modifiers) {
        return Icons.getElementIcon(elementKind, modifiers);
    }

    @Deprecated
    public static Icon getDeclarationIcon(Element element) {
        return UiUtils.getElementIcon(element.getKind(), element.getModifiers());
    }

    public static boolean open(ClasspathInfo cpInfo, Element el) {
        Object[] openInfo = UiUtils.getOpenInfo(cpInfo, el);
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            assert (openInfo[1] instanceof Integer);
            return UiUtils.doOpen((FileObject)openInfo[0], (Integer)openInfo[1]);
        }
        return false;
    }

    public static boolean open(FileObject toSearch, ElementHandle<? extends Element> toOpen) {
        if (toSearch == null || toOpen == null) {
            throw new IllegalArgumentException("null not supported");
        }
        Object[] openInfo = UiUtils.getOpenInfo(toSearch, toOpen);
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            assert (openInfo[1] instanceof Integer);
            return UiUtils.doOpen((FileObject)openInfo[0], (Integer)openInfo[1]);
        }
        return false;
    }

    private static String getMethodHeader(MethodTree tree, CompilationInfo info, String s) {
        Context context = info.getJavacTask().getContext();
        VeryPretty veryPretty = new VeryPretty(context);
        return veryPretty.getMethodHeader(tree, s);
    }

    private static String getClassHeader(ClassTree tree, CompilationInfo info, String s) {
        Context context = info.getJavacTask().getContext();
        VeryPretty veryPretty = new VeryPretty(context);
        return veryPretty.getClassHeader(tree, s);
    }

    private static String getVariableHeader(VariableTree tree, CompilationInfo info, String s) {
        Context context = info.getJavacTask().getContext();
        VeryPretty veryPretty = new VeryPretty(context);
        return veryPretty.getVariableHeader(tree, s);
    }

    public static String getHeader(TreePath treePath, CompilationInfo info, String formatString) {
        assert (info != null);
        assert (treePath != null);
        Element element = info.getTrees().getElement(treePath);
        if (element != null) {
            return UiUtils.getHeader(element, info, formatString);
        }
        return null;
    }

    public static String getHeader(Element element, CompilationInfo info, String formatString) {
        assert (element != null);
        assert (info != null);
        assert (formatString != null);
        Tree tree = SourceUtils.treeFor(info, element);
        if (tree != null) {
            if (tree.getKind() == Tree.Kind.METHOD) {
                return UiUtils.getMethodHeader((MethodTree)tree, info, formatString);
            }
            if (tree.getKind() == Tree.Kind.CLASS) {
                return UiUtils.getClassHeader((ClassTree)tree, info, formatString);
            }
            if (tree.getKind() == Tree.Kind.VARIABLE) {
                return UiUtils.getVariableHeader((VariableTree)tree, info, formatString);
            }
        }
        return formatString.replaceAll("%name%", element.getSimpleName().toString()).replaceAll("%[a-z]*%", "");
    }

    @Deprecated
    public static boolean open(FileObject fo, int offset) {
        return UiUtils.doOpen(fo, offset);
    }

    static Object[] getOpenInfo(ClasspathInfo cpInfo, Element el) {
        FileObject fo = SourceUtils.getFile(el, cpInfo);
        if (fo != null) {
            return UiUtils.getOpenInfo(fo, ElementHandle.create(el));
        }
        return null;
    }

    static Object[] getOpenInfo(FileObject fo, ElementHandle<? extends Element> handle) {
        assert (fo != null);
        try {
            int offset = UiUtils.getOffset(fo, handle);
            return new Object[]{fo, offset};
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public static int getDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = UiUtils.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int min(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    private static boolean doOpen(FileObject fo, int offset) {
        try {
            OpenCookie oc;
            StyledDocument doc;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            LineCookie lc = (LineCookie)od.getCookie(LineCookie.class);
            if (ec != null && lc != null && offset != -1 && (doc = ec.openDocument()) != null) {
                Line l;
                int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
                int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
                int column = offset - lineOffset;
                if (line != -1 && (l = lc.getLineSet().getCurrent(line)) != null) {
                    l.show(4, column);
                    return true;
                }
            }
            if ((oc = (OpenCookie)od.getCookie(OpenCookie.class)) != null) {
                oc.open();
                return true;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return false;
    }

    private static int getOffset(FileObject fo, final ElementHandle<? extends Element> handle) throws IOException {
        final int[] result = new int[]{-1};
        JavaSource js = JavaSource.forFileObject(fo);
        js.runUserActionTask(new CancellableTask<CompilationController>(){

            @Override
            public void cancel() {
            }

            @Override
            public void run(CompilationController info) {
                try {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
                Object el = handle.resolve(info);
                if (el == null) {
                    throw new IllegalArgumentException();
                }
                FindDeclarationVisitor v = new FindDeclarationVisitor((Element)el, info);
                CompilationUnitTree cu = info.getCompilationUnit();
                v.scan(cu, null);
                Tree elTree = v.declTree;
                if (elTree != null) {
                    result[0] = (int)info.getTrees().getSourcePositions().getStartPosition(cu, elTree);
                }
            }
        }, true);
        return result[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindDeclarationVisitor
    extends TreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo info) {
            this.element = element;
            this.info = info;
        }

        @Override
        public Void visitClass(ClassTree tree, Void d) {
            this.handleDeclaration();
            super.visitClass(tree, d);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void d) {
            this.handleDeclaration();
            super.visitMethod(tree, d);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree tree, Void d) {
            this.handleDeclaration();
            super.visitVariable(tree, d);
            return null;
        }

        public void handleDeclaration() {
            Element found = this.info.getTrees().getElement(this.getCurrentPath());
            if (((Object)this.element).equals(found)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }

    public static final class PrintPart {
        public static final String ANNOTATIONS = "%annotations";
        public static final String NAME = "%name%";
        public static final String TYPE = "%type%";
        public static final String THROWS = "%throws%";
        public static final String IMPLEMENTS = "%implements%";
        public static final String EXTENDS = "%extends%";
        public static final String TYPEPARAMETERS = "%typeparameters%";
        public static final String FLAGS = "%flags%";
        public static final String PARAMETERS = "%parameters%";

        private PrintPart() {
        }
    }
}

