/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.DefaultEnvironment;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.DefaultApplicationContext;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.netbeans.modules.java.source.query.QueryException;
import org.netbeans.modules.java.source.save.Commit;
import org.netbeans.modules.java.source.transform.ChangeSet;
import org.netbeans.modules.java.source.transform.Transformer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopy
extends CompilationController {
    private EngineEnvironment ce;
    private ChangeSet changes;
    private boolean afterCommit = false;
    private WorkingCopyContext wcc = new WorkingCopyContext();
    private TreeMaker treeMaker;

    WorkingCopy(CompilationInfo delegate) throws IOException {
        super(delegate);
    }

    private synchronized void init() throws ReattributionException {
        if (this.changes != null) {
            return;
        }
        CompilationUnitTree tree = this.getCompilationUnit();
        if (tree != null) {
            Context context = this.getContext();
            ASTService model = ASTService.instance(context);
            ArrayList<CompilationUnitTree> units = new ArrayList<CompilationUnitTree>();
            units.add(tree);
            model.setRoot(TreeFactory.instance(context).Root(units));
            UndoListService.instance(context).reset();
        }
        JavacTaskImpl task = this.delegate.getJavacTask();
        this.ce = new DefaultEnvironment(task, this.getCompilationUnit(), Source.instance((Context)task.getContext()).name, this.wcc);
        this.treeMaker = new TreeMaker(this, this.ce.getTreeMaker());
        this.changes = new ChangeSet("<no-description>");
        this.changes.attach(this.ce);
    }

    private Context getContext() {
        return this.getJavacTask().getContext();
    }

    EngineEnvironment getCommandEnvironment() {
        return this.ce;
    }

    @Override
    public JavaSource.Phase toPhase(JavaSource.Phase phase) throws IOException {
        JavaSource.Phase result = super.toPhase(phase);
        if (result.compareTo(JavaSource.Phase.PARSED) >= 0) {
            try {
                this.init();
            }
            catch (ReattributionException ex) {
                IOException ioe = new IOException();
                ioe.initCause(ex);
                throw ioe;
            }
        }
        return result;
    }

    public synchronized TreeMaker getTreeMaker() {
        if (this.treeMaker == null) {
            throw new IllegalStateException("Cannot call getTreeMaker before toPhase.");
        }
        return this.treeMaker;
    }

    void run(Transformer t) {
        if (this.afterCommit) {
            throw new IllegalStateException("The run method can't be called on a WorkingCopy instance after the commit");
        }
        t.init();
        t.attach(this.ce);
        t.apply();
        t.release();
        t.destroy();
    }

    void run(Transformer t, Tree tree) {
        if (this.afterCommit) {
            throw new IllegalStateException("The run method can't be called on a WorkingCopy instance after the commit");
        }
        t.init();
        t.attach(this.ce);
        t.apply(tree);
        t.release();
        t.destroy();
    }

    ChangeSet getChangeSet() {
        return this.changes;
    }

    public synchronized void rewrite(Tree oldTree, Tree newTree) {
        if (this.changes == null) {
            throw new IllegalStateException("Cannot call rewrite before toPhase.");
        }
        if (oldTree == null || newTree == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        this.changes.rewrite(oldTree, newTree);
    }

    List<ModificationResult.Difference> getChanges() throws IOException {
        if (this.afterCommit) {
            throw new IllegalStateException("The commit method can be called only once on a WorkingCopy instance");
        }
        this.afterCommit = true;
        if (this.changes == null) {
            return null;
        }
        try {
            RootTree newRoot = this.changes.commit((RootTree)this.ce.getRootNode());
            if (this.changes.hasChanges()) {
                this.getCommandEnvironment().getModel().setRoot(newRoot);
            }
            Commit save = new Commit(this);
            save.init();
            save.attach(this.ce);
            save.commit();
            save.release();
            save.destroy();
            return this.wcc.diffs;
        }
        catch (QueryException qe) {
            Logger.getLogger("global").log(Level.WARNING, qe.getMessage(), qe);
            return null;
        }
        catch (ReattributionException qe) {
            Logger.getLogger("global").log(Level.WARNING, qe.getMessage(), qe);
            return null;
        }
    }

    private class WorkingCopyContext
    extends DefaultApplicationContext {
        private ArrayList<ModificationResult.Difference> diffs = new ArrayList();
        private Map<Integer, String> userInfo = Collections.emptyMap();

        private WorkingCopyContext() {
        }

        public PrintWriter getOutputWriter(String title) {
            return new PrintWriter(new Writer(){

                public void write(char[] cbuf, int off, int len) throws IOException {
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            }, true);
        }

        public void setResult(Object result, String title) {
            if ("user-info".equals(title)) {
                this.userInfo = (Map)Map.class.cast(result);
            }
        }

        public SourceRewriter getSourceRewriter(JavaFileObject sourcefile) throws IOException {
            return new Rewriter();
        }

        private class Rewriter
        implements SourceRewriter {
            private int offset = 0;
            private CloneableEditorSupport ces;

            private Rewriter() throws IOException {
                FileObject fo = WorkingCopy.this.getFileObject();
                if (fo != null) {
                    DataObject dObj = DataObject.find((FileObject)fo);
                    CloneableEditorSupport cloneableEditorSupport = this.ces = dObj != null ? (CloneableEditorSupport)dObj.getCookie(EditorCookie.class) : null;
                }
                if (this.ces == null) {
                    throw new IOException("Could not find CloneableEditorSupport for " + FileUtil.getFileDisplayName((FileObject)fo));
                }
            }

            public void writeTo(String s) throws IOException, BadLocationException {
                ModificationResult.Difference diff;
                ModificationResult.Difference difference = diff = WorkingCopyContext.this.diffs.size() > 0 ? (ModificationResult.Difference)WorkingCopyContext.this.diffs.get(WorkingCopyContext.this.diffs.size() - 1) : null;
                if (diff != null && diff.getKind() == ModificationResult.Difference.Kind.REMOVE && diff.getEndPosition().getOffset() == this.offset) {
                    diff.kind = ModificationResult.Difference.Kind.CHANGE;
                    diff.newText = s;
                } else {
                    WorkingCopyContext.this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, this.ces.createPositionRef(this.offset, Position.Bias.Forward), this.ces.createPositionRef(this.offset, Position.Bias.Forward), null, s, (String)WorkingCopyContext.this.userInfo.get(this.offset)));
                }
            }

            public void skipThrough(SourceReader in, int pos) throws IOException, BadLocationException {
                ModificationResult.Difference diff;
                char[] buf = in.getCharsTo(pos);
                ModificationResult.Difference difference = diff = WorkingCopyContext.this.diffs.size() > 0 ? (ModificationResult.Difference)WorkingCopyContext.this.diffs.get(WorkingCopyContext.this.diffs.size() - 1) : null;
                if (diff != null && diff.getKind() == ModificationResult.Difference.Kind.INSERT && diff.getStartPosition().getOffset() == this.offset) {
                    diff.kind = ModificationResult.Difference.Kind.CHANGE;
                    diff.oldText = new String(buf);
                } else {
                    WorkingCopyContext.this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.REMOVE, this.ces.createPositionRef(this.offset, Position.Bias.Forward), this.ces.createPositionRef(this.offset + buf.length, Position.Bias.Forward), new String(buf), null, (String)WorkingCopyContext.this.userInfo.get(this.offset)));
                }
                this.offset += buf.length;
            }

            public void copyTo(SourceReader in, int pos) throws IOException {
                char[] buf = in.getCharsTo(pos);
                this.offset += buf.length;
            }

            public void copyRest(SourceReader in) throws IOException {
            }

            public void close(boolean save) {
            }
        }
    }
}

