/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Registry;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenedEditors
implements ChangeListener,
PropertyChangeListener {
    private List<JTextComponent> visibleEditors = new ArrayList<JTextComponent>();
    private Map<JTextComponent, FileObject> visibleEditors2Files = new HashMap<JTextComponent, FileObject>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static OpenedEditors DEFAULT;

    private OpenedEditors() {
        Registry.addChangeListener((ChangeListener)this);
    }

    public static synchronized OpenedEditors getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OpenedEditors();
        }
        return DEFAULT;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        ArrayList<ChangeListener> listenersCopy = null;
        OpenedEditors openedEditors = this;
        synchronized (openedEditors) {
            listenersCopy = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : listenersCopy) {
            l.stateChanged(e);
        }
    }

    public synchronized List<JTextComponent> getVisibleEditors() {
        return Collections.unmodifiableList(this.visibleEditors);
    }

    public synchronized Collection<FileObject> getVisibleEditorsFiles() {
        return Collections.unmodifiableCollection(this.visibleEditors2Files.values());
    }

    @Override
    public synchronized void stateChanged(ChangeEvent e) {
        for (JTextComponent c : this.visibleEditors) {
            c.removePropertyChangeListener(this);
            this.visibleEditors2Files.remove(c);
        }
        this.visibleEditors.clear();
        JTextComponent editor = Registry.getMostActiveComponent();
        if (editor instanceof JEditorPane && "text/x-java".equals(((JEditorPane)editor).getContentType())) {
            this.visibleEditors.add(editor);
        }
        for (JTextComponent c : this.visibleEditors) {
            c.addPropertyChangeListener(this);
            this.visibleEditors2Files.put(c, OpenedEditors.getFileObject(c));
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        FileObject nueFile;
        JTextComponent c = (JTextComponent)evt.getSource();
        FileObject originalFile = this.visibleEditors2Files.get(c);
        if (originalFile != (nueFile = OpenedEditors.getFileObject(c))) {
            this.visibleEditors2Files.put(c, nueFile);
            this.fireChangeEvent();
        }
    }

    static FileObject getFileObject(JTextComponent pane) {
        DataObject file = (DataObject)pane.getDocument().getProperty("stream");
        if (file != null) {
            return file.getPrimaryFile();
        }
        return null;
    }
}

