/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.JavaNode;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassDataObject
extends MultiDataObject {
    public ClassDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
    }

    public Node createNodeDelegate() {
        return new JavaNode((DataObject)this, false);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        if (type.isAssignableFrom(OpenSourceCookie.class)) {
            return (T)((Node.Cookie)type.cast(new OpenSourceCookie()));
        }
        return (T)super.getCookie(type);
    }

    private final class OpenSourceCookie
    implements OpenCookie {
        private OpenSourceCookie() {
        }

        public void open() {
            try {
                FileObject fo = ClassDataObject.this.getPrimaryFile();
                FileObject binaryRoot = null;
                String resourceName = null;
                ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
                if (cp == null || (binaryRoot = cp.findOwnerRoot(fo)) == null) {
                    cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
                    if (cp != null) {
                        binaryRoot = cp.findOwnerRoot(fo);
                        resourceName = cp.getResourceName(fo, '/', false);
                    }
                } else if (binaryRoot != null) {
                    resourceName = cp.getResourceName(fo, '/', false);
                }
                FileObject[] sourceRoots = null;
                if (binaryRoot != null) {
                    sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)binaryRoot.getURL()).getRoots();
                }
                FileObject resource = null;
                if (sourceRoots != null && sourceRoots.length > 0) {
                    cp = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
                    resource = cp.findResource(resourceName + ".java");
                }
                if (resource != null) {
                    DataObject sourceFile = DataObject.find(resource);
                    OpenCookie oc = (OpenCookie)sourceFile.getCookie(OpenCookie.class);
                    if (oc != null) {
                        oc.open();
                    } else {
                        ErrorManager.getDefault().log("SourceFile: " + FileUtil.getFileDisplayName((FileObject)resource) + " has no OpenCookie");
                    }
                } else {
                    if (resourceName == null) {
                        resourceName = fo.getName();
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ClassDataObject.class, (String)"TXT_NoSources", (Object)resourceName.replace('/', '.')));
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (DataObjectNotFoundException nf) {
                ErrorManager.getDefault().notify((Throwable)nf);
            }
        }
    }
}

