/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.modules.java.IndentFileEntry;
import org.netbeans.modules.java.JMapFormat;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class JavaDataLoader
extends MultiFileLoader {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    public static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_INFO = "package-info";
    static final long serialVersionUID = -6286836352608877232L;

    public JavaDataLoader() {
        super("org.netbeans.modules.java.JavaDataObject");
    }

    protected String actionsContext() {
        return "Loaders/text/x-java/Actions/";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(JavaDataLoader.class, (String)"PROP_JavaLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        if (primaryFile.getExt().equals(JAVA_EXTENSION)) {
            return new JavaDataObject(primaryFile, this);
        }
        return null;
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (fo.getAttribute("template") != null && fo.getAttribute("javax.script.ScriptEngine") != null) {
            return null;
        }
        if (fo.getExt().equals(JAVA_EXTENSION)) {
            return fo;
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        if (JAVA_EXTENSION.equals(primaryFile.getExt())) {
            return JavaDataSupport.createJavaFileEntry(obj, primaryFile);
        }
        return new FileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        ErrorManager.getDefault().log("Subclass of JavaDataLoader (" + ((Object)((Object)this)).getClass().getName() + ") has secondary entries but does not override createSecondaryEntries (MultidataObject, FileObject) method.");
        return new FileEntry.Numb(obj, secondaryFile);
    }

    static Map createStringsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("USER", System.getProperty("user.name"));
        map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
        map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
        return map;
    }

    public static class JavaFileEntry
    extends IndentFileEntry {
        static final long serialVersionUID = 8244159045498569616L;

        public JavaFileEntry(MultiDataObject obj, FileObject file) {
            super(obj, file);
        }

        protected Format createFormat(FileObject target, String n, String e) {
            Map map = JavaDataLoader.createStringsMap();
            this.modifyMap(map, target, n, e);
            JMapFormat format = new JMapFormat(map);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            format.setCondDelimiter("$");
            format.setExactMatch(false);
            return format;
        }

        protected void modifyMap(Map map, FileObject target, String n, String e) {
            ClassPath cp = ClassPath.getClassPath((FileObject)target, (String)"classpath/source");
            String resourcePath = "";
            if (cp != null) {
                resourcePath = cp.getResourceName(target);
            } else {
                ErrorManager.getDefault().log(16, "No classpath was found for folder: " + target);
            }
            map.put("NAME", n);
            map.put("PACKAGE", resourcePath.replace('/', '.'));
            map.put("PACKAGE_SLASHES", resourcePath);
            if (target.isRoot()) {
                map.put("PACKAGE_AND_NAME", n);
                map.put("PACKAGE_AND_NAME_SLASHES", n);
            } else {
                map.put("PACKAGE_AND_NAME", resourcePath.replace('/', '.') + '.' + n);
                map.put("PACKAGE_AND_NAME_SLASHES", resourcePath + '/' + n);
            }
            map.put("QUOTES", "\"");
        }

        public FileObject rename(String name) throws IOException {
            if (!JavaDataLoader.PACKAGE_INFO.equals(name) && !Utilities.isJavaIdentifier((String)name)) {
                throw new IOException(NbBundle.getMessage(JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)name));
            }
            FileObject fo = super.rename(name);
            return fo;
        }

        public FileObject copy(FileObject f, String suffix) throws IOException {
            String origName = this.getFile().getName();
            FileObject fo = super.copy(f, suffix);
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (cp != null) {
                String pkgName = cp.getResourceName(f, '.', false);
                JavaDataObject.renameFO(fo, pkgName, fo.getName(), origName);
            }
            return fo;
        }

        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            Logger.getLogger(JavaDataLoader.class.getName()).warning("Please replace template " + this.getFile().toString() + " with the new scripting support. See " + "http://www.netbeans.org/download/dev/javadoc/org-openide-loaders/apichanges.html#scripting");
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)f.getName(), (String)JavaDataLoader.JAVA_EXTENSION);
            } else if (!JavaDataLoader.PACKAGE_INFO.equals(name) && !Utilities.isJavaIdentifier((String)name)) {
                throw new IOException(NbBundle.getMessage(JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)name));
            }
            this.initializeIndentEngine();
            FileObject fo = super.createFromTemplate(f, name);
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            String pkgName = cp != null ? cp.getResourceName(f, '.', false) : "";
            JavaDataObject.renameFO(fo, pkgName, name, this.getFile().getName());
            return fo;
        }
    }
}

