/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.spi.java.loaders.RenameHandler;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class JavaNode
extends DataNode
implements ChangeListener {
    private static final long serialVersionUID = -7396485743899766258L;
    private static final String JAVA_ICON_BASE = "org/netbeans/modules/java/resources/class.png";
    private static final String CLASS_ICON_BASE = "org/netbeans/modules/java/resources/clazz.gif";
    private static final Image NEEDS_COMPILE = Utilities.loadImage((String)"org/netbeans/modules/java/resources/needs-compile.png");
    private final FileBuiltQuery.Status status;
    private final AtomicBoolean isCompiled;
    private static BlockingQueue<Task> queue;

    public JavaNode(DataObject jdo, boolean isJavaSource) {
        super(jdo, Children.LEAF);
        this.setIconBaseWithExtension(isJavaSource ? JAVA_ICON_BASE : CLASS_ICON_BASE);
        if (isJavaSource) {
            FileObject jf = jdo.getPrimaryFile();
            this.isCompiled = new AtomicBoolean(true);
            this.status = FileBuiltQuery.getStatus((FileObject)jf);
            if (this.status != null) {
                this.status.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.status));
                queue.add(new Task(false, true, this));
            }
        } else {
            this.status = null;
            this.isCompiled = null;
        }
    }

    public void setName(String name) {
        RenameHandler handler = JavaNode.getRenameHandler();
        if (handler == null) {
            super.setName(name);
        } else {
            try {
                handler.handleRename((Node)this, name);
            }
            catch (IllegalArgumentException ioe) {
                super.setName(name);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Collection handlers = Lookup.getDefault().lookupAll(RenameHandler.class);
        if (handlers.size() == 0) {
            return null;
        }
        if (handlers.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of RenameHandler found in Lookup; only using first one: " + handlers);
        }
        return (RenameHandler)handlers.iterator().next();
    }

    protected final Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (JavaNode.getRenameHandler() != null) {
            sheet.get("properties").put(this.createNameProperty());
        }
        Sheet.Set ps = new Sheet.Set();
        ps.setName("classpaths");
        ps.setDisplayName(NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_sheet_classpaths"));
        ps.setShortDescription(NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_sheet_classpaths"));
        ps.put(new Node.Property[]{new ClasspathProperty("classpath/compile", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/execute", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_boot_classpath"))});
        sheet.put(ps);
        return sheet;
    }

    private Node.Property createNameProperty() {
        PropertySupport.ReadWrite<String> p = new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getMessage(DataObject.class, (String)"PROP_name"), NbBundle.getMessage(DataObject.class, (String)"HINT_name")){

            public String getValue() {
                return JavaNode.this.getName();
            }

            public Object getValue(String key) {
                if ("suppressCustomEditor".equals(key)) {
                    return Boolean.TRUE;
                }
                return super.getValue(key);
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                JavaNode.this.setName(val);
            }

            public boolean canWrite() {
                return JavaNode.this.canRename();
            }
        };
        return p;
    }

    public void stateChanged(ChangeEvent e) {
        queue.add(new Task(false, true, this));
    }

    public Image getIcon(int type) {
        Image i = super.getIcon(type);
        return this.enhanceIcon(i);
    }

    public Image getOpenedIcon(int type) {
        Image i = super.getOpenedIcon(type);
        return this.enhanceIcon(i);
    }

    private Image enhanceIcon(Image i) {
        if (this.isCompiled != null && !this.isCompiled.get()) {
            i = Utilities.mergeImages((Image)i, (Image)NEEDS_COMPILE, (int)16, (int)0);
        }
        return i;
    }

    static {
        new RequestProcessor("Java Node Badge Processor", 1).post(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Task t;
                            if ((t = (Task)queue.poll(0x7FFFFFF5L, TimeUnit.MILLISECONDS)) == null) {
                                continue;
                            }
                            boolean fire = t.fire;
                            JavaNode node = t.node;
                            if (t.computeBuiltStatus) {
                                boolean newIsCompiled = node.status != null ? node.status.isBuilt() : true;
                                boolean oldIsCompiled = node.isCompiled.getAndSet(newIsCompiled);
                                fire |= newIsCompiled != oldIsCompiled;
                            }
                            if (!fire) continue;
                            node.fireIconChange();
                            node.fireOpenedIconChange();
                        }
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Exceptions.printStackTrace((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        queue = new LinkedBlockingQueue<Task>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClasspathProperty
    extends PropertySupport.ReadOnly<String> {
        private final String id;

        public ClasspathProperty(String id, String displayName, String shortDescription) {
            super(id, String.class, displayName, shortDescription);
            this.id = id;
            this.setValue("oneline", false);
        }

        public String getValue() {
            ClassPath cp = ClassPath.getClassPath((FileObject)JavaNode.this.getDataObject().getPrimaryFile(), (String)this.id);
            if (cp != null) {
                StringBuffer sb = new StringBuffer();
                for (ClassPath.Entry entry : cp.entries()) {
                    URL u = entry.getURL();
                    String item = u.toExternalForm();
                    if (u.getProtocol().equals("file")) {
                        item = new File(URI.create(item)).getAbsolutePath();
                    } else if (u.getProtocol().equals("jar") && item.endsWith("!/")) {
                        URL embedded = FileUtil.getArchiveFile((URL)u);
                        assert (embedded != null) : u;
                        if (embedded.getProtocol().equals("file")) {
                            item = new File(URI.create(embedded.toExternalForm())).getAbsolutePath();
                        }
                    }
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(item);
                }
                return sb.toString();
            }
            return NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_classpath_unknown");
        }
    }

    private static class Task {
        private boolean fire;
        private boolean computeBuiltStatus;
        private JavaNode node;

        public Task(boolean fire, boolean computeBuiltStatus, JavaNode node) {
            this.fire = fire;
            this.computeBuiltStatus = computeBuiltStatus;
            this.node = node;
        }
    }
}

