/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.actions.GoToPanel;
import org.netbeans.modules.java.actions.TypeDescription;
import org.netbeans.modules.java.actions.UiOptions;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.util.Models;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class GoToTypeAction
extends AbstractAction
implements GoToPanel.ContentProvider {
    static final Logger LOGGER = Logger.getLogger(GoToTypeAction.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private ClassIndex.NameKind nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToTypeAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private GoToPanel panel;
    private Set<CacheItem> cache;
    private Dialog dialog;
    private JButton okButton;

    public GoToTypeAction() {
        super(NbBundle.getMessage(GoToTypeAction.class, (String)"TXT_GoToType"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GoToTypeAction.class).getString("editor-popup-TXT_GoToType"));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            JEditorPane[] openedPanes;
            EditorCookie ec;
            this.cache = null;
            this.panel = new GoToPanel(this);
            this.dialog = this.createDialog(this.panel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GoToTypeAction.this.dialog.setVisible(true);
                }
            });
            Node[] arr = TopComponent.getRegistry().getActivatedNodes();
            String initSearchText = null;
            if (arr.length > 0 && (ec = (EditorCookie)arr[0].getCookie(EditorCookie.class)) != null && (openedPanes = ec.getOpenedPanes()) != null && (initSearchText = Utilities.getSelectionOrIdentifier((JTextComponent)openedPanes[0])) != null && org.openide.util.Utilities.isJavaIdentifier((String)initSearchText)) {
                this.panel.setInitialText(initSearchText);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public ListCellRenderer getListCellRenderer(JList list) {
        return new Renderer(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setListModel(GoToPanel panel, String text) {
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (text == null) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        if ((text = text.trim()).length() == 0) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        if (GoToTypeAction.isAllUpper(text)) {
            this.nameKind = ClassIndex.NameKind.CAMEL_CASE;
        } else if (GoToTypeAction.containsWildCard(text) != -1) {
            if (!Character.isJavaIdentifierStart(text.charAt(0))) {
                panel.setModel(EMPTY_LIST_MODEL);
                return;
            }
            this.nameKind = panel.isCaseSensitive() ? ClassIndex.NameKind.REGEXP : ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
        } else {
            this.nameKind = panel.isCaseSensitive() ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
        }
        GoToTypeAction goToTypeAction = this;
        synchronized (goToTypeAction) {
            this.running = new Worker(text);
            this.task = rp.post((Runnable)this.running, 220);
            if (panel.time == -1L) return;
            LOGGER.fine("Worker posted after " + (System.currentTimeMillis() - panel.time) + " ms.");
            return;
        }
    }

    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    private static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private Dialog createDialog(GoToPanel panel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToTypeAction.class, (String)"CTL_OK"));
        this.okButton.setEnabled(false);
        panel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToTypeAction.class, (String)"AN_GoToType"));
        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToTypeAction.class, (String)"AD_GoToType"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(GoToTypeAction.class, (String)"DLG_GoToType"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(panel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        d.setPreferredSize(new Dimension(UiOptions.GoToTypeDialog.getWidth(), UiOptions.GoToTypeDialog.getHeight()));
        Rectangle r = org.openide.util.Utilities.getUsableScreenBounds();
        int maxW = r.width * 9 / 10;
        int maxH = r.height * 9 / 10;
        Dimension dim = d.getPreferredSize();
        dim.width = Math.min(dim.width, maxW);
        dim.height = Math.min(dim.height, maxH);
        d.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dim));
        d.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                GoToTypeAction.this.cleanup();
            }
        });
        return d;
    }

    private void cleanup() {
        if (this.dialog != null) {
            UiOptions.GoToTypeDialog.setHeight(this.dialog.getHeight());
            UiOptions.GoToTypeDialog.setWidth(this.dialog.getWidth());
            this.dialog.dispose();
            this.dialog = null;
            this.cache = null;
        }
    }

    static class CacheItem {
        public final boolean isBinary;
        public final FileObject fileObject;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;
        private ClassPath.Entry defEntry;

        public CacheItem(FileObject fileObject, ClasspathInfo classpathInfo, boolean isBinary) {
            this.isBinary = isBinary;
            this.fileObject = fileObject;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.fileObject == null ? 0 : this.fileObject.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof CacheItem) {
                CacheItem otherItem = (CacheItem)other;
                return this.fileObject == null ? otherItem.fileObject == null : this.fileObject.equals(otherItem.fileObject);
            }
            return false;
        }

        public FileObject getRoot() {
            return this.fileObject;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            Project p = FileOwnerQuery.getOwner((FileObject)this.fileObject);
            if (p != null) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                this.projectName = pi.getDisplayName();
                this.projectIcon = pi.getIcon();
            }
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToPanel panel;

        public DialogButtonListener(GoToPanel panel) {
            this.panel = panel;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GoToTypeAction.this.okButton) {
                this.panel.openSelectedItem();
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        private JPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlPkg = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private JList jList;

        public Renderer(JList list) {
            this.jList = list;
            Container container = list.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new JPanel();
            this.rendererComponent.setLayout(new BorderLayout());
            this.rendererComponent.add((Component)this.jlName, "West");
            this.rendererComponent.add((Component)this.jlPkg, "Center");
            this.rendererComponent.add((Component)this.jlPrj, "East");
            this.jlName.setOpaque(false);
            this.jlPkg.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(list.getFont());
            this.jlPkg.setFont(list.getFont());
            this.jlPrj.setFont(list.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = list.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = list.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            int height = list.getFixedCellHeight();
            int width = list.getFixedCellWidth() - 1;
            width = width < 200 ? 200 : width;
            Dimension size = new Dimension(width, height);
            this.rendererComponent.setMaximumSize(size);
            this.rendererComponent.setPreferredSize(size);
            if (isSelected) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlPkg.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlPkg.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (value instanceof TypeDescription) {
                long time = System.currentTimeMillis();
                TypeDescription td = (TypeDescription)value;
                this.jlName.setIcon(td.getIcon());
                this.jlName.setText(td.getTypeName());
                this.jlPkg.setText(td.getPackageName());
                this.jlPrj.setText(td.getProjectName());
                this.jlPrj.setIcon(td.getProjectIcon());
                this.rendererComponent.setToolTipText(FileUtil.getFileDisplayName((FileObject)td.getFileObject()));
                LOGGER.fine("  Time in paint " + (System.currentTimeMillis() - time) + " ms.");
            } else {
                this.jlName.setText(value.toString());
            }
            return this.rendererComponent;
        }

        public void stateChanged(ChangeEvent event) {
            JViewport jv = (JViewport)event.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(UiUtils.getElementIcon(ElementKind.CLASS, null));
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jv.getExtentSize().width);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private final String text;
        private final long createTime;

        public Worker(String text) {
            this.text = text;
            this.createTime = System.currentTimeMillis();
            LOGGER.fine("Worker for " + text + " - created after " + (System.currentTimeMillis() - ((GoToTypeAction)GoToTypeAction.this).panel.time) + " ms.");
        }

        @Override
        public void run() {
            LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
            List<TypeDescription> types = this.getTypeNames(this.text);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            ListModel model = Models.fromList(types);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            if (!this.isCanceled && model != null) {
                LOGGER.fine("Worker for text " + this.text + " finished after " + (System.currentTimeMillis() - this.createTime) + " ms.");
                GoToTypeAction.this.panel.setModel(model);
                if (GoToTypeAction.this.okButton != null && !types.isEmpty()) {
                    GoToTypeAction.this.okButton.setEnabled(true);
                }
            }
        }

        public void cancel() {
            if (((GoToTypeAction)GoToTypeAction.this).panel.time != -1L) {
                LOGGER.fine("Worker for text " + this.text + " canceled after " + (System.currentTimeMillis() - this.createTime) + " ms.");
            }
            this.isCanceled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<TypeDescription> getTypeNames(String text) {
            long time;
            long sort = 0L;
            long add = 0L;
            long gtn = 0L;
            long sfb = 0L;
            long gsb = 0L;
            long gss = 0L;
            long cp = 0L;
            if (GoToTypeAction.this.cache == null) {
                ClasspathInfo ci;
                int i;
                time = System.currentTimeMillis();
                ClassPath scp = RepositoryUpdater.getDefault().getScannedSources();
                FileObject[] roots = scp.getRoots();
                gss += System.currentTimeMillis() - time;
                FileObject[] root = new FileObject[1];
                HashSet<CacheItem> sources = new HashSet<CacheItem>(roots.length);
                for (i = 0; i < roots.length; ++i) {
                    root[0] = roots[i];
                    time = System.currentTimeMillis();
                    ci = ClasspathInfo.create(EMPTY_CLASSPATH, EMPTY_CLASSPATH, ClassPathSupport.createClassPath((FileObject[])root));
                    if (this.isCanceled) {
                        return null;
                    }
                    sources.add(new CacheItem(roots[i], ci, false));
                    cp += System.currentTimeMillis() - time;
                }
                time = System.currentTimeMillis();
                scp = RepositoryUpdater.getDefault().getScannedBinaries();
                roots = scp.getRoots();
                gsb += System.currentTimeMillis() - time;
                root = new FileObject[1];
                for (i = 0; i < roots.length; ++i) {
                    try {
                        if (this.isCanceled) {
                            ci = null;
                            return ci;
                        }
                        time = System.currentTimeMillis();
                        SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)roots[i].getURL());
                        if (result.getRoots().length == 0) continue;
                        sfb += System.currentTimeMillis() - time;
                        time = System.currentTimeMillis();
                        root[0] = roots[i];
                        ClasspathInfo ci2 = ClasspathInfo.create(ClassPathSupport.createClassPath((FileObject[])root), EMPTY_CLASSPATH, EMPTY_CLASSPATH);
                        sources.add(new CacheItem(roots[i], ci2, true));
                        cp += System.currentTimeMillis() - time;
                        continue;
                    }
                    catch (FileStateInvalidException e) {
                        if (!this.isCanceled) continue;
                        return null;
                    }
                    finally {
                        if (this.isCanceled) {
                            return null;
                        }
                    }
                }
                if (!this.isCanceled) {
                    GoToTypeAction.this.cache = sources;
                } else {
                    return null;
                }
            }
            ArrayList<TypeDescription> types = new ArrayList<TypeDescription>(GoToTypeAction.this.cache.size() * 20);
            for (CacheItem ci : GoToTypeAction.this.cache) {
                String textForQuery;
                time = System.currentTimeMillis();
                switch (GoToTypeAction.this.nameKind) {
                    case REGEXP: 
                    case CASE_INSENSITIVE_REGEXP: {
                        String pattern = text + "*";
                        textForQuery = pattern = pattern.replace("*", ".*").replace('?', '.');
                        break;
                    }
                    default: {
                        textForQuery = text;
                    }
                }
                Set<ElementHandle<TypeElement>> names = ci.classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, GoToTypeAction.this.nameKind, EnumSet.of(ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                if (this.isCanceled) {
                    return null;
                }
                gtn += System.currentTimeMillis() - time;
                time = System.currentTimeMillis();
                for (ElementHandle<TypeElement> name : names) {
                    TypeDescription td = new TypeDescription(ci, name);
                    types.add(td);
                    if (!this.isCanceled) continue;
                    return null;
                }
                add += System.currentTimeMillis() - time;
            }
            if (!this.isCanceled) {
                time = System.currentTimeMillis();
                Collections.sort(types);
                LOGGER.fine("PERF -  GSS:  " + gss + " GSB " + gsb + " CP: " + cp + " SFB: " + sfb + " GTN: " + gtn + "  ADD: " + add + "  SORT: " + (sort += System.currentTimeMillis() - time));
                return types;
            }
            return null;
        }
    }
}

