/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.actions;

import java.io.IOException;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.actions.GoToTypeAction;
import org.netbeans.modules.java.ui.Icons;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeDescription
implements Comparable<TypeDescription> {
    private static final String EMPTY_STRING = "";
    private Icon icon;
    private final GoToTypeAction.CacheItem cacheItem;
    private final ElementHandle<TypeElement> handle;
    private String simpleName;
    private String outerName;
    private String packageName;

    public TypeDescription(GoToTypeAction.CacheItem cacheItem, ElementHandle<TypeElement> handle) {
        this.cacheItem = cacheItem;
        this.handle = handle;
        this.init();
    }

    public void open() {
        if (this.cacheItem.isBinary()) {
            final ClasspathInfo ci = ClasspathInfo.create(this.cacheItem.getRoot());
            JavaSource js = JavaSource.create(ci, new FileObject[0]);
            final ElementHandle<TypeElement> eh = this.handle;
            final Element[] el = new Element[1];
            try {
                js.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void run(CompilationController info) {
                        el[0] = eh.resolve(info);
                        UiUtils.open(ci, el[0]);
                    }
                }, true);
            }
            catch (IOException e) {
                Logger.getLogger(TypeDescription.class.getName()).info("Source not found: " + eh.getBinaryName());
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            FileObject folder;
            FileObject fileObject = folder = this.packageName != null ? this.cacheItem.getRoot().getFileObject(this.packageName.replace(".", "/")) : this.cacheItem.getRoot();
            if (folder != null) {
                FileObject[] ch = folder.getChildren();
                String name = this.outerName == null ? this.simpleName : this.outerName;
                int lastDot = name.indexOf(46);
                if (lastDot != -1) {
                    name = name.substring(0, lastDot);
                }
                for (FileObject fileObject2 : ch) {
                    if (!name.equals(fileObject2.getName()) || !"java".equals(fileObject2.getExt().toLowerCase())) continue;
                    UiUtils.open(fileObject2, this.handle);
                }
            } else {
                Logger.getLogger(TypeDescription.class.getName()).info("Package " + this.packageName + " doesn't exist in root: " + FileUtil.getFileDisplayName((FileObject)this.cacheItem.getRoot()));
            }
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public FileObject getFileObject() {
        return this.cacheItem.getRoot();
    }

    public String getTypeName() {
        StringBuilder sb = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            sb.append(" in ").append(this.outerName);
        }
        return sb.toString();
    }

    public String getPackageName() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        return sb.toString();
    }

    public String getProjectName() {
        String projectName = this.cacheItem.getProjectName();
        return projectName == null ? EMPTY_STRING : projectName;
    }

    public Icon getProjectIcon() {
        return this.cacheItem.getProjectIcon();
    }

    private void init() {
        String typeName = this.handle.getBinaryName();
        int lastDot = typeName.lastIndexOf(46);
        int lastDollar = typeName.lastIndexOf(36);
        if (lastDot == -1) {
            if (lastDollar == -1) {
                this.simpleName = typeName;
            } else {
                this.simpleName = typeName.substring(lastDollar + 1);
                this.outerName = typeName.substring(0, lastDollar).replace('$', '.');
            }
        } else {
            this.packageName = typeName.substring(0, lastDot);
            if (lastDollar == -1) {
                this.simpleName = typeName.substring(lastDot + 1).replace('$', '.');
            } else {
                this.simpleName = typeName.substring(lastDollar + 1);
                this.outerName = typeName.substring(lastDot + 1, lastDollar).replace('$', '.');
            }
        }
        this.icon = Icons.getElementIcon(this.handle.getKind(), null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            sb.append(" in ").append(this.outerName);
        }
        sb.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        if (this.cacheItem.getProjectName() != null) {
            sb.append(" [").append(this.cacheItem.getProjectName()).append("]");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(TypeDescription td) {
        int cmpr = this.compareStrings(this.simpleName, td.simpleName);
        if (cmpr != 0) {
            return cmpr;
        }
        cmpr = this.compareStrings(this.outerName, td.outerName);
        if (cmpr != 0) {
            return cmpr;
        }
        return this.compareStrings(this.packageName, td.packageName);
    }

    public synchronized Icon getIcon() {
        return this.icon;
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null) {
            s1 = EMPTY_STRING;
        }
        if (s2 == null) {
            s2 = EMPTY_STRING;
        }
        return s1.compareTo(s2);
    }
}

