/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class ActivatedDocumentListener
implements ChangeListener {
    private static ActivatedDocumentListener INSTANCE;
    private FileObject lastValidFile;
    public static boolean IGNORE_COMPILE_REQUESTS;

    public static void register() {
        INSTANCE = new ActivatedDocumentListener();
    }

    private ActivatedDocumentListener() {
        Registry.addChangeListener((ChangeListener)this);
    }

    public synchronized void stateChanged(ChangeEvent e) {
        JavaSource activeJS;
        BaseDocument active = Registry.getMostActiveDocument();
        if (active == null) {
            return;
        }
        Object sourceProperty = active.getProperty("stream");
        if (!(sourceProperty instanceof DataObject)) {
            return;
        }
        DataObject source = (DataObject)sourceProperty;
        if (source == null) {
            return;
        }
        FileObject activeFile = source.getPrimaryFile();
        if (this.lastValidFile == activeFile) {
            return;
        }
        if (this.lastValidFile != null) {
            ClassPath cp;
            if (!IGNORE_COMPILE_REQUESTS && (cp = ClassPath.getClassPath((FileObject)this.lastValidFile, (String)"classpath/source")) != null) {
                FileObject owner = cp.findOwnerRoot(this.lastValidFile);
                assert (owner != null);
                try {
                    if ("file".equals(this.lastValidFile.getURL().getProtocol())) {
                        RepositoryUpdater.getDefault().scheduleCompilation(this.lastValidFile, owner);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            this.lastValidFile = null;
        }
        if ((activeJS = JavaSource.forFileObject(activeFile)) == null) {
            return;
        }
        this.lastValidFile = activeFile;
        TimesCollector.getDefault().select(activeFile);
        JavaSourceAccessor.INSTANCE.revalidate(activeJS);
    }

    static {
        IGNORE_COMPILE_REQUESTS = false;
    }
}

