/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.BufferRun;
import org.netbeans.modules.java.source.builder.BufferRunQueue;
import org.netbeans.modules.java.source.builder.CommentRun;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.builder.TokenRun;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentHandlerService
implements CommentHandler {
    private static final Context.Key<CommentHandlerService> commentHandlerKey = new Context.Key();
    private Map<Tree, CommentSetImpl> map = new WeakHashMap<Tree, CommentSetImpl>();
    protected ASTModel model;

    public static CommentHandlerService instance(Context context) {
        CommentHandlerService instance = context.get(commentHandlerKey);
        if (instance == null) {
            instance = new CommentHandlerService(context);
            CommentHandlerService.setCommentHandler(context, instance);
        }
        return instance;
    }

    public static void setCommentHandler(Context context, CommentHandlerService instance) {
        assert (context.get(commentHandlerKey) == null);
        context.put(commentHandlerKey, instance);
    }

    private CommentHandlerService(Context context) {
        this.model = ASTService.instance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            return this.map.containsKey(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommentSet getComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl cs = this.map.get(tree);
            if (cs == null) {
                cs = new CommentSetImpl();
                this.map.put(tree, cs);
            }
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyComments(Tree fromTree, Tree toTree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl from = this.map.get(fromTree);
            if (from != null) {
                CommentSetImpl to = this.map.get(toTree);
                if (to == null) {
                    to = (CommentSetImpl)from.clone();
                    to.setTree(toTree);
                    this.map.put(toTree, to);
                } else {
                    to.addPrecedingComments(from.getPrecedingComments());
                    to.addTrailingComments(from.getTrailingComments());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComment(Tree tree, Comment c) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl set = this.map.get(tree);
            if (set == null) {
                set = new CommentSetImpl();
                this.map.put(tree, set);
            }
            set.addPrecedingComment(c);
        }
    }

    public void mapComments(CompilationUnitTree compilationUnit, CharSequence sbuf, BufferRunQueue runs) {
        final JCTree.JCCompilationUnit toplevel = (JCTree.JCCompilationUnit)compilationUnit;
        SortedMap<Integer, JCTree> positions = this.getPositions(toplevel);
        if (positions.size() == 0) {
            return;
        }
        JCTree lastTree = null;
        LineColMapper lineCol = new LineColMapper(){

            public int getColumn(int offset) {
                return toplevel.lineMap.getColumnNumber(offset);
            }

            public int getLine(int offset) {
                return toplevel.lineMap.getLineNumber(offset);
            }
        };
        CommentSetImpl topComments = (CommentSetImpl)this.getComments(toplevel);
        for (BufferRun run : runs) {
            if (run.getKind() == BufferRun.Kind.TOKEN) break;
            if (run.getKind() != BufferRun.Kind.COMMENT) continue;
            CommentRun cr = (CommentRun)run;
            if (cr.getStyle() == Comment.Style.JAVADOC) break;
            Comment c = cr.toComment(cr.getString(sbuf), lineCol.getColumn(cr.getStart()));
            topComments.addPrecedingComment(c);
        }
        for (int pos : positions.keySet()) {
            JCTree tree = (JCTree)positions.get(pos);
            int start = runs.findRunStartingAt(this.model.getStartPos(tree));
            if (start == -1) continue;
            this.mapComments(start, tree, lastTree, sbuf, runs, lineCol);
            int endPos = this.model.getEndPos(tree, toplevel);
            int tail = runs.findRunEndingWith(endPos);
            if (tail == -1) continue;
            BufferRun br = runs.get(tail);
            if (br.getKind() == BufferRun.Kind.TOKEN && ((TokenRun)br).getToken() == Token.RBRACE) {
                this.mapTrailingBlockComments(start, tail, tree, this.getComments(tree), sbuf, runs, lineCol);
            }
            lastTree = tree;
        }
        for (int tail = runs.findRunEndingWith(this.model.getEndPos(toplevel, toplevel)) + 1; tail < runs.size(); ++tail) {
            if (runs.get(tail).getKind() != BufferRun.Kind.COMMENT) continue;
            CommentRun cr = (CommentRun)runs.get(tail);
            Comment c = cr.toComment(cr.getString(sbuf), lineCol.getColumn(cr.getStart()));
            topComments.addTrailingComment(c);
        }
    }

    private void mapTrailingBlockComments(int begin, int end, JCTree tree, CommentSet comments, CharSequence sbuf, BufferRunQueue runs, LineColMapper lineCol) {
        while (--end > begin && runs.get(end).getKind() != BufferRun.Kind.TOKEN) {
            BufferRun br = runs.get(end);
            if (br.getKind() != BufferRun.Kind.COMMENT) continue;
            CommentRun cr = (CommentRun)br;
            Comment c = cr.toComment(cr.getString(sbuf), lineCol.getColumn(cr.getStart()));
            comments.addTrailingComment(c);
        }
    }

    private void mapComments(int startRun, JCTree tree, JCTree lastTree, CharSequence sbuf, BufferRunQueue runs, LineColMapper lineCol) {
        int i;
        assert (startRun != -1);
        int lastEOL = -1;
        for (i = startRun - 1; i >= 0 && runs.get(i).getKind() != BufferRun.Kind.TOKEN; --i) {
            if (runs.get(i).getKind() != BufferRun.Kind.LINE_ENDING) continue;
            lastEOL = lineCol.getLine(runs.get(i).getStart());
        }
        while (++i < startRun) {
            if (runs.get(i).getKind() != BufferRun.Kind.COMMENT) continue;
            CommentRun cr = (CommentRun)runs.get(i);
            Comment c = cr.toComment(cr.getString(sbuf), lineCol.getColumn(cr.getStart()));
            if (lastTree != null && lineCol.getLine(cr.getEnd()) == lastEOL) {
                CommentSetImpl cs = (CommentSetImpl)this.getComments(lastTree);
                cs.addTrailingComment(c);
                continue;
            }
            this.addComment(tree, c);
        }
    }

    private CommentSetImpl flushTrailingComments(CommentSetImpl comments, CommentSetImpl lastComments) {
        List<Comment> cmts = comments.getPrecedingComments();
        if (cmts.isEmpty()) {
            return comments;
        }
        for (Comment c : cmts) {
            lastComments.addTrailingComment(c);
        }
        return new CommentSetImpl();
    }

    private SortedMap<Integer, JCTree> getPositions(JCTree.JCCompilationUnit tree) {
        final TreeMap<Integer, JCTree> positions = new TreeMap<Integer, JCTree>();
        tree.accept(new TreeScanner(){

            public void scan(JCTree tree) {
                if (tree != null) {
                    tree.accept(this);
                    int pos = CommentHandlerService.this.model.getStartPos(tree);
                    if (pos != -1) {
                        positions.put(pos, tree);
                    }
                }
            }

            public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
                super.visitTypeIdent(tree);
            }

            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                super.visitMethodDef(tree);
            }
        });
        return positions;
    }

    private static interface LineColMapper {
        public int getColumn(int var1);

        public int getLine(int var1);
    }
}

