/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.parser.Scanner;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.builder.BufferRun;

public class CommentRun
extends BufferRun {
    final Comment.Style style;

    public CommentRun(int start, int end, Scanner.CommentStyle style) {
        super(start, end, BufferRun.Kind.COMMENT);
        switch (style) {
            case BLOCK: {
                this.style = Comment.Style.BLOCK;
                break;
            }
            case LINE: {
                this.style = Comment.Style.LINE;
                break;
            }
            case JAVADOC: {
                this.style = Comment.Style.JAVADOC;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown CommentStyle: " + style));
            }
        }
    }

    public Comment.Style getStyle() {
        return this.style;
    }

    public Comment toComment(String text, int indent) {
        return Comment.create(this.style, this.start, this.end, indent, text);
    }

    public String toString() {
        return "CR(" + this.start + "," + this.end + ") " + (Object)((Object)this.style);
    }
}

