/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentSetImpl
implements Cloneable,
CommentSet {
    Tree tree;
    List<Comment> precedingComments = new ArrayList<Comment>();
    List<Comment> trailingComments = new ArrayList<Comment>();

    @Override
    public void addPrecedingComment(String s) {
        this.addPrecedingComment(Comment.create(s));
    }

    @Override
    public void addPrecedingComment(Comment c) {
        this.precedingComments.add(c);
    }

    @Override
    public void addPrecedingComments(List<Comment> comments) {
        this.precedingComments.addAll(comments);
    }

    @Override
    public void addTrailingComment(String s) {
        this.addTrailingComment(Comment.create(s));
    }

    @Override
    public void addTrailingComment(Comment c) {
        this.trailingComments.add(c);
    }

    @Override
    public void addTrailingComments(List<Comment> comments) {
        this.trailingComments.addAll(comments);
    }

    @Override
    public List<Comment> getPrecedingComments() {
        return this.precedingComments;
    }

    @Override
    public List<Comment> getTrailingComments() {
        return this.trailingComments;
    }

    @Override
    public boolean hasComments() {
        return this.precedingComments.size() > 0 || this.trailingComments.size() > 0;
    }

    @Override
    public int pos() {
        return this.precedingComments.size() > 0 ? this.precedingComments.get(0).pos() : -2;
    }

    void setTree(Tree newTree) {
        this.tree = newTree;
    }

    @Override
    public boolean hasChanges() {
        for (Comment c : this.precedingComments) {
            if (!c.isNew()) continue;
            return true;
        }
        for (Comment c : this.trailingComments) {
            if (!c.isNew()) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Unexpected " + e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        sb.append('{');
        for (Comment c : this.precedingComments) {
            if (!first) {
                sb.append(',');
            }
            sb.append(c.getText());
            first = false;
        }
        for (Comment c : this.trailingComments) {
            if (!first) {
                sb.append(',');
            }
            sb.append(c.getText());
            first = false;
        }
        sb.append('}');
        return sb.toString();
    }
}

