/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DumpAST
extends TreeScanner<Object, Object> {
    CommentHandler comments;
    PrintStream out;
    int indent;

    public static void dump(Tree tree, CommentHandler comments, PrintStream out) {
        tree.accept(new DumpAST(out, comments), null);
    }

    DumpAST(PrintStream out, CommentHandler comments) {
        this.out = out;
        this.comments = comments;
        this.indent = 0;
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(". ");
        }
    }

    private void dump(String name, Tree tree) {
        ++this.indent;
        this.indent();
        this.out.print(name + ": ");
        if (tree != null) {
            this.out.println();
            ++this.indent;
            this.scan(tree, null);
            --this.indent;
        } else {
            this.out.println("null");
        }
        --this.indent;
    }

    private void dump(String name, List<? extends Tree> trees) {
        ++this.indent;
        this.indent();
        this.out.print(name);
        if (trees == null) {
            this.out.println(": null");
        } else if (trees.isEmpty()) {
            this.out.println(" {}");
        } else {
            this.out.println(" {");
            ++this.indent;
            for (Tree tree : trees) {
                this.scan(tree, null);
            }
            --this.indent;
            this.indent();
            this.out.println("}");
        }
        --this.indent;
    }

    private void dumpField(String name, Object o) {
        ++this.indent;
        this.indent();
        this.out.println(name + ": " + (o != null ? o.toString() : "null"));
        --this.indent;
    }

    private void dumpFlags(Set<Modifier> flags) {
        StringBuffer buf = new StringBuffer();
        for (Modifier mod : flags) {
            buf.append(mod.name());
            buf.append(' ');
        }
        this.dumpField("flags", buf.toString().trim());
    }

    private void header(String s, Tree tree) {
        this.indent();
        this.out.println(s);
        this.dumpField("pos", Integer.toString(((JCTree)tree).pos));
        if (this.comments.hasComments((JCTree)tree)) {
            CommentSet cs = this.comments.getComments((JCTree)tree);
            this.dumpField("comments", cs.toString());
        }
    }

    @Override
    public Object visitCompilationUnit(CompilationUnitTree tree, Object o) {
        this.header("CompilationUnit", tree);
        this.dump("packageAnnotations", tree.getPackageAnnotations());
        this.dump("pid", tree.getPackageName());
        this.dumpField("sourcefile", tree.getSourceFile());
        this.dumpField("namedImportScope", tree.getImports());
        this.dump("defs", tree.getTypeDecls());
        return o;
    }

    @Override
    public Object visitImport(ImportTree tree, Object o) {
        this.header("Import", tree);
        this.dumpField("staticImport", Boolean.toString(tree.isStatic()));
        this.dump("qualid", tree.getQualifiedIdentifier());
        return o;
    }

    @Override
    public Object visitClass(ClassTree tree, Object o) {
        this.header("Class", tree);
        this.dumpField("name", tree.getSimpleName());
        this.dump("mods", tree.getModifiers());
        this.dump("typarams", tree.getTypeParameters());
        this.dump("extending", tree.getExtendsClause());
        this.dump("implementing", tree.getImplementsClause());
        this.dump("defs", tree.getMembers());
        return o;
    }

    @Override
    public Object visitMethod(MethodTree tree, Object o) {
        this.header("Method", tree);
        this.dumpField("name", tree.getName());
        this.dump("mods", tree.getModifiers());
        this.dump("restype", tree.getReturnType());
        this.dump("typarams", tree.getTypeParameters());
        this.dump("params", tree.getParameters());
        this.dump("thrown", tree.getThrows());
        this.dump("defaultValue", tree.getDefaultValue());
        this.dump("body", tree.getBody());
        return o;
    }

    @Override
    public Object visitVariable(VariableTree tree, Object o) {
        this.header("Variable", tree);
        this.dumpField("name", tree.getName());
        this.dump("mods", tree.getModifiers());
        this.dump("vartype", tree.getType());
        this.dump("init", tree.getInitializer());
        return o;
    }

    @Override
    public Object visitEmptyStatement(EmptyStatementTree tree, Object o) {
        this.header("EmptyStatement", tree);
        return o;
    }

    @Override
    public Object visitBlock(BlockTree tree, Object o) {
        this.header("Block", tree);
        this.dumpField("(flags & Static)", tree.isStatic());
        this.dump("stats", tree.getStatements());
        return o;
    }

    @Override
    public Object visitDoWhileLoop(DoWhileLoopTree tree, Object o) {
        this.header("DoWhileLoop", tree);
        this.dump("body", tree.getStatement());
        this.dump("cond", tree.getCondition());
        return o;
    }

    @Override
    public Object visitWhileLoop(WhileLoopTree tree, Object o) {
        this.header("WhileLoop", tree);
        this.dump("cond", tree.getCondition());
        this.dump("body", tree.getStatement());
        return o;
    }

    @Override
    public Object visitForLoop(ForLoopTree tree, Object o) {
        this.header("ForLoop", tree);
        this.dump("init", tree.getInitializer());
        this.dump("cond", tree.getCondition());
        this.dump("step", tree.getUpdate());
        this.dump("body", tree.getStatement());
        return o;
    }

    @Override
    public Object visitEnhancedForLoop(EnhancedForLoopTree tree, Object o) {
        this.header("EnhancedForLoop", tree);
        this.dump("var", tree.getVariable());
        this.dump("expr", tree.getExpression());
        this.dump("body", tree.getStatement());
        return o;
    }

    @Override
    public Object visitLabeledStatement(LabeledStatementTree tree, Object o) {
        this.header("LabeledStatement", tree);
        this.dumpField("label", tree.getLabel());
        this.dump("body", tree.getStatement());
        return o;
    }

    @Override
    public Object visitSwitch(SwitchTree tree, Object o) {
        this.header("Switch", tree);
        this.dump("selector", tree.getExpression());
        this.dump("cases", tree.getCases());
        return o;
    }

    @Override
    public Object visitCase(CaseTree tree, Object o) {
        this.header("Case", tree);
        this.dump("pat", tree.getExpression());
        this.dump("stats", tree.getStatements());
        return o;
    }

    @Override
    public Object visitSynchronized(SynchronizedTree tree, Object o) {
        this.header("Synchronized", tree);
        this.dump("lock", tree.getExpression());
        this.dump("body", tree.getBlock());
        return o;
    }

    @Override
    public Object visitTry(TryTree tree, Object o) {
        this.header("Try", tree);
        this.dump("body", tree.getBlock());
        this.dump("catchers", tree.getCatches());
        this.dump("finalizer", tree.getFinallyBlock());
        return o;
    }

    @Override
    public Object visitCatch(CatchTree tree, Object o) {
        this.header("Catch", tree);
        this.dump("param", tree.getParameter());
        this.dump("body", tree.getBlock());
        return o;
    }

    @Override
    public Object visitConditionalExpression(ConditionalExpressionTree tree, Object o) {
        this.header("ConditionalExpression", tree);
        this.dump("cond", tree.getCondition());
        this.dump("truepart", tree.getTrueExpression());
        this.dump("falsepart", tree.getFalseExpression());
        return o;
    }

    @Override
    public Object visitIf(IfTree tree, Object o) {
        this.header("If", tree);
        this.dump("cond", tree.getCondition());
        this.dump("thenpart", tree.getThenStatement());
        this.dump("elsepart", tree.getElseStatement());
        return o;
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatementTree tree, Object o) {
        this.header("ExpressionStatement", tree);
        this.dump("expr", tree.getExpression());
        return o;
    }

    @Override
    public Object visitBreak(BreakTree tree, Object o) {
        this.header("Break", tree);
        this.dumpField("label", tree.getLabel());
        return o;
    }

    @Override
    public Object visitContinue(ContinueTree tree, Object o) {
        this.header("Continue", tree);
        this.dumpField("label", tree.getLabel());
        return o;
    }

    @Override
    public Object visitReturn(ReturnTree tree, Object o) {
        this.header("Return", tree);
        this.dump("expr", tree.getExpression());
        return o;
    }

    @Override
    public Object visitThrow(ThrowTree tree, Object o) {
        this.header("Throw", tree);
        this.dump("expr", tree.getExpression());
        return o;
    }

    @Override
    public Object visitAssert(AssertTree tree, Object o) {
        this.header("Assert", tree);
        this.dump("cond", tree.getCondition());
        this.dump("detail", tree.getDetail());
        return o;
    }

    @Override
    public Object visitMethodInvocation(MethodInvocationTree tree, Object o) {
        this.header("MethodInvocation", tree);
        this.dump("typeargs", tree.getTypeArguments());
        this.dump("meth", tree.getMethodSelect());
        this.dump("args", tree.getArguments());
        return o;
    }

    @Override
    public Object visitNewClass(NewClassTree tree, Object o) {
        this.header("NewClass", tree);
        this.dump("encl", tree.getEnclosingExpression());
        this.dump("typeargs", tree.getTypeArguments());
        this.dump("clazz", tree.getIdentifier());
        this.dump("args", tree.getArguments());
        this.dump("def", tree.getClassBody());
        return o;
    }

    @Override
    public Object visitNewArray(NewArrayTree tree, Object o) {
        this.header("NewArray", tree);
        this.dump("elemtype", tree.getType());
        this.dump("dims", tree.getDimensions());
        this.dump("elems", tree.getInitializers());
        return o;
    }

    @Override
    public Object visitParenthesized(ParenthesizedTree tree, Object o) {
        this.header("Parenthesized", tree);
        this.dump("expr", tree.getExpression());
        return o;
    }

    @Override
    public Object visitAssignment(AssignmentTree tree, Object o) {
        this.header("Assignment", tree);
        this.dump("lhs", tree.getVariable());
        this.dump("rhs", tree.getExpression());
        return o;
    }

    @Override
    public Object visitCompoundAssignment(CompoundAssignmentTree tree, Object o) {
        this.header("CompoundAssignment", tree);
        this.dump("lhs", tree.getVariable());
        this.dump("rhs", tree.getExpression());
        return o;
    }

    @Override
    public Object visitUnary(UnaryTree tree, Object o) {
        this.header("Unary", tree);
        this.dump("arg", tree.getExpression());
        return o;
    }

    @Override
    public Object visitBinary(BinaryTree tree, Object o) {
        this.header("Binary", tree);
        this.dump("lhs", tree.getLeftOperand());
        this.dump("rhs", tree.getRightOperand());
        return o;
    }

    @Override
    public Object visitTypeCast(TypeCastTree tree, Object o) {
        this.header("TypeCast", tree);
        this.dump("clazz", tree.getType());
        this.dump("expr", tree.getExpression());
        return o;
    }

    @Override
    public Object visitInstanceOf(InstanceOfTree tree, Object o) {
        this.header("InstanceOf", tree);
        this.dump("expr", tree.getExpression());
        this.dump("clazz", tree.getType());
        return o;
    }

    @Override
    public Object visitArrayAccess(ArrayAccessTree tree, Object o) {
        this.header("ArrayAccess", tree);
        this.dump("indexed", tree.getExpression());
        this.dump("index", tree.getIndex());
        return o;
    }

    @Override
    public Object visitMemberSelect(MemberSelectTree tree, Object o) {
        this.header("MemberSelect", tree);
        this.dumpField("name", tree.getIdentifier());
        this.dump("selected", tree.getExpression());
        return o;
    }

    @Override
    public Object visitIdentifier(IdentifierTree tree, Object o) {
        this.header("Identifier", tree);
        this.dumpField("name", tree.getName());
        return o;
    }

    @Override
    public Object visitLiteral(LiteralTree tree, Object o) {
        this.header("Literal", tree);
        this.dumpField("typetag", (Object)tree.getKind());
        this.dumpField("value", tree.getValue());
        return o;
    }

    @Override
    public Object visitPrimitiveType(PrimitiveTypeTree tree, Object o) {
        this.header("PrimitiveType", tree);
        this.dumpField("typetag", (Object)tree.getKind());
        return o;
    }

    @Override
    public Object visitArrayType(ArrayTypeTree tree, Object o) {
        this.header("ArrayType", tree);
        this.dump("elemtype", tree.getType());
        return o;
    }

    @Override
    public Object visitParameterizedType(ParameterizedTypeTree tree, Object o) {
        this.header("ParameterizedType", tree);
        this.dump("clazz", tree.getType());
        this.dump("arguments", tree.getTypeArguments());
        return o;
    }

    @Override
    public Object visitTypeParameter(TypeParameterTree tree, Object o) {
        this.header("TypeParameter", tree);
        this.dumpField("name", tree.getName());
        this.dump("bounds", tree.getBounds());
        return o;
    }

    @Override
    public Object visitWildcard(WildcardTree tree, Object o) {
        this.header("Wildcard", tree);
        this.dumpField("kind", (Object)tree.getKind());
        this.dump("inner", tree.getBound());
        return o;
    }

    @Override
    public Object visitModifiers(ModifiersTree tree, Object o) {
        this.header("Modifiers", tree);
        this.dumpFlags(tree.getFlags());
        this.dump("annotations", tree.getAnnotations());
        return o;
    }

    @Override
    public Object visitAnnotation(AnnotationTree tree, Object o) {
        this.header("Annotation", tree);
        this.dump("annotationType", tree.getAnnotationType());
        this.dump("args", tree.getArguments());
        return o;
    }

    @Override
    public Object visitErroneous(ErroneousTree tree, Object o) {
        this.header("Erroneous", tree);
        return o;
    }

    @Override
    public Object visitOther(Tree tree, Object o) {
        assert (false);
        return o;
    }
}

