/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import java.io.PrintWriter;
import org.netbeans.modules.java.source.builder.BufferRun;
import org.netbeans.modules.java.source.builder.BufferRunQueue;
import org.netbeans.modules.java.source.builder.CommentRun;

public class DumpScanner
extends TreeScanner {
    BufferRunQueue runs;
    JCTree.JCCompilationUnit toplevel;
    PrintWriter out;
    int level = -1;
    static final String BLANK = "                                                                                                                        ";
    private static final String[] TYPE_NAMES = new String[]{null, "byte", "char", "short", "int", "long", "float", "double", "boolean", "void", "<class>", "<array>", "<method>", "<package>"};

    public static void dump(BufferRunQueue runs, JCTree.JCCompilationUnit toplevel, PrintWriter out) {
        new DumpScanner(runs, toplevel, out).scan(toplevel);
    }

    DumpScanner(BufferRunQueue runs, JCTree.JCCompilationUnit toplevel, PrintWriter out) {
        this.runs = runs;
        this.toplevel = toplevel;
        this.out = out;
    }

    public void scan(JCTree tree) {
        ++this.level;
        super.scan(tree);
        --this.level;
    }

    private static void appendTypeTag(StringBuffer sb, int typetag) {
        if (typetag > 0 && typetag < TYPE_NAMES.length) {
            sb.append(TYPE_NAMES[typetag]);
        } else {
            sb.append("<BadTypeTag:" + typetag + ">");
        }
    }

    public void dumpHead(JCTree t) {
        if (t != null) {
            BufferRun br;
            while ((br = this.runs.getNextBefore(t.pos)) instanceof CommentRun) {
                int pos = br.getStart();
                int endPos = br.getEnd();
                this.out.print(BLANK.substring(0, this.level * 4));
                this.out.println("Comment @ " + pos + "-" + endPos + ": " + br.toString());
            }
            this.out.print(BLANK.substring(0, this.level * 4));
            String cls = t.getClass().getName();
            int dollar = cls.indexOf(36);
            cls = cls.substring(dollar + 1);
            this.out.print(cls);
            this.out.print(" @ " + t.pos);
            if (this.toplevel.endPositions != null) {
                Integer end = (Integer)this.toplevel.endPositions.get(t);
                if (end != null) {
                    int ep = end;
                    this.out.print("-" + ep);
                } else {
                    int ep = TreeInfo.endPos(t);
                    this.out.print("-(" + ep + ")");
                }
            }
            this.out.print("  ");
        }
    }

    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        this.dumpHead(tree);
        if (tree.sourcefile != null) {
            this.out.print(" file:" + tree.sourcefile.toString());
        }
        if (tree.packge != null) {
            this.out.print(" pkg:" + tree.packge.toString());
        }
        this.out.println();
        super.visitTopLevel(tree);
    }

    public void visitImport(JCTree.JCImport tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitImport(tree);
    }

    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.dumpHead(tree);
        this.out.println("\"" + tree.name + "\"");
        super.visitClassDef(tree);
    }

    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        this.dumpHead(tree);
        this.out.println("\"" + tree.name + "\"");
        super.visitMethodDef(tree);
    }

    public void visitVarDef(JCTree.JCVariableDecl tree) {
        this.dumpHead(tree);
        this.out.println("\"" + tree.name + "\"");
        super.visitVarDef(tree);
    }

    public void visitSkip(JCTree.JCSkip tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitSkip(tree);
    }

    public void visitBlock(JCTree.JCBlock tree) {
        this.dumpHead(tree);
        this.out.println("flags:" + tree.flags + " endPos:" + tree.endpos);
        super.visitBlock(tree);
    }

    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitDoLoop(tree);
    }

    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitWhileLoop(tree);
    }

    public void visitForLoop(JCTree.JCForLoop tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitForLoop(tree);
    }

    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitForeachLoop(tree);
    }

    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitLabelled(tree);
    }

    public void visitSwitch(JCTree.JCSwitch tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitSwitch(tree);
    }

    public void visitCase(JCTree.JCCase tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitCase(tree);
    }

    public void visitSynchronized(JCTree.JCSynchronized tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitSynchronized(tree);
    }

    public void visitTry(JCTree.JCTry tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitTry(tree);
    }

    public void visitCatch(JCTree.JCCatch tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitCatch(tree);
    }

    public void visitConditional(JCTree.JCConditional tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitConditional(tree);
    }

    public void visitIf(JCTree.JCIf tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitIf(tree);
    }

    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitExec(tree);
    }

    public void visitBreak(JCTree.JCBreak tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitBreak(tree);
    }

    public void visitContinue(JCTree.JCContinue tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitContinue(tree);
    }

    public void visitReturn(JCTree.JCReturn tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitReturn(tree);
    }

    public void visitThrow(JCTree.JCThrow tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitThrow(tree);
    }

    public void visitAssert(JCTree.JCAssert tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitAssert(tree);
    }

    public void visitApply(JCTree.JCMethodInvocation tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitApply(tree);
    }

    public void visitNewClass(JCTree.JCNewClass tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitNewClass(tree);
    }

    public void visitNewArray(JCTree.JCNewArray tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitNewArray(tree);
    }

    public void visitParens(JCTree.JCParens tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitParens(tree);
    }

    public void visitAssign(JCTree.JCAssign tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitAssign(tree);
    }

    public void visitAssignop(JCTree.JCAssignOp tree) {
        this.dumpHead(tree);
        this.out.println(tree.operator);
        super.visitAssignop(tree);
    }

    public void visitUnary(JCTree.JCUnary tree) {
        this.dumpHead(tree);
        this.out.println(tree.operator);
        super.visitUnary(tree);
    }

    public void visitBinary(JCTree.JCBinary tree) {
        this.dumpHead(tree);
        this.out.println(tree.operator);
        super.visitBinary(tree);
    }

    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitTypeCast(tree);
    }

    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitTypeTest(tree);
    }

    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitIndexed(tree);
    }

    public void visitSelect(JCTree.JCFieldAccess tree) {
        this.dumpHead(tree);
        this.out.println("\"" + tree.name + "\"");
        super.visitSelect(tree);
    }

    public void visitIdent(JCTree.JCIdent tree) {
        this.dumpHead(tree);
        this.out.println("\"" + tree.name + "\"");
        super.visitIdent(tree);
    }

    public void visitLiteral(JCTree.JCLiteral tree) {
        this.dumpHead(tree);
        this.out.println(tree.value);
        super.visitLiteral(tree);
    }

    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        this.dumpHead(tree);
        StringBuffer sb = new StringBuffer();
        DumpScanner.appendTypeTag(sb, (int)tree.typetag);
        this.out.println(sb + " (" + (int)tree.typetag + ")");
        super.visitTypeIdent(tree);
    }

    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitTypeArray(tree);
    }

    public void visitTypeApply(JCTree.JCTypeApply tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitTypeApply(tree);
    }

    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitTypeParameter(tree);
    }

    public void visitWildcard(JCTree.JCWildcard tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitWildcard(tree);
    }

    public void visitAnnotation(JCTree.JCAnnotation tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitAnnotation(tree);
    }

    public void visitModifiers(JCTree.JCModifiers tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitModifiers(tree);
    }

    public void visitErroneous(JCTree.JCErroneous tree) {
        this.dumpHead(tree);
        this.out.println();
        super.visitErroneous(tree);
    }
}

