/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.engine.ElementMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactory
implements ElementMaker {
    private Symtab symtab;
    private Name.Table names;
    private static final Context.Key<ElementFactory> KEY = new Context.Key();

    public static ElementFactory instance(Context context) {
        ElementFactory instance = context.get(KEY);
        if (instance == null) {
            instance = new ElementFactory(context);
            context.put(KEY, instance);
        }
        return instance;
    }

    protected ElementFactory(Context context) {
        this.symtab = Symtab.instance(context);
        this.names = Name.Table.instance((Context)context);
    }

    @Override
    public ExecutableElement Executable(Set<Modifier> modifiers, String simpleName, List<? extends TypeMirror> argtypes, TypeMirror restype, List<? extends TypeMirror> thrownTypes, TypeElement owner) {
        Symbol.ClassSymbol tsym = (Symbol.ClassSymbol)owner;
        ListBuffer<Type> args = new ListBuffer<Type>();
        for (TypeMirror typeMirror : argtypes) {
            args.append((Type)typeMirror);
        }
        ListBuffer<Type> thrown = new ListBuffer<Type>();
        for (TypeMirror typeMirror : thrownTypes) {
            thrown.append((Type)typeMirror);
        }
        Type.MethodType methodType = new Type.MethodType(args.toList(), (Type)restype, thrown.toList(), tsym);
        long l = TreeFactory.modifiersToFlags(modifiers);
        Name name = this.names.fromString(simpleName);
        Symbol.MethodSymbol sym = new Symbol.MethodSymbol(l, name, methodType, tsym);
        tsym.members_field.enter(sym);
        return sym;
    }

    @Override
    public VariableElement Variable(Set<Modifier> modifiers, String simpleName, TypeMirror type, Element owner) {
        ListBuffer args = new ListBuffer();
        long flags = TreeFactory.modifiersToFlags(modifiers);
        Name name = this.names.fromString(simpleName);
        Symbol.VarSymbol sym = new Symbol.VarSymbol(flags, name, (Type)type, (Symbol)owner);
        if (owner instanceof Symbol.ClassSymbol) {
            ((Symbol.ClassSymbol)owner).members_field.enter(sym);
        }
        return sym;
    }
}

