/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.util.Context;
import org.netbeans.modules.java.source.transform.UndoEntry;
import org.netbeans.modules.java.source.transform.UndoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UndoListService
implements UndoList {
    protected static final Context.Key<UndoListService> undolistKey = new Context.Key();
    final UndoEntry nullUndo;
    UndoEntry undoList;

    public UndoListService() {
        this.undoList = this.nullUndo = new UndoEntry(){
            {
                this.endCommand = true;
            }

            public void undo() {
                throw new Error("Not Undoable");
            }

            public void redo() {
                throw new Error("Not Redoable");
            }
        };
    }

    public static synchronized UndoListService instance(Context context) {
        UndoListService instance = context.get(undolistKey);
        if (instance == null) {
            instance = new UndoListService();
            UndoListService.setInstance(context, instance);
        }
        return instance;
    }

    public static void setInstance(Context context, UndoListService undoList) {
        context.put(undolistKey, undoList);
    }

    @Override
    public final void add(UndoEntry u) {
        if (u == null) {
            return;
        }
        u.addAfter(this.undoList);
        this.undoList = u;
    }

    @Override
    public final void addAndApply(UndoEntry u) {
        this.add(u);
        u.redo();
    }

    @Override
    public final void undo() {
        if (this.canUndo()) {
            do {
                this.undoList.undo();
                this.undoList = this.undoList.prev;
            } while (!this.undoList.isEndCommand());
        }
    }

    @Override
    public final void redo() {
        if (this.canRedo()) {
            do {
                this.undoList = this.undoList.next;
                this.undoList.redo();
            } while (this.canRedo() && !this.undoList.isEndCommand());
        }
    }

    @Override
    public final boolean canUndo() {
        return this.undoList != this.nullUndo;
    }

    @Override
    public final boolean canRedo() {
        return this.undoList.next != null;
    }

    @Override
    public final void setEndCommand(boolean b) {
        this.undoList.setEndCommand(b);
    }

    @Override
    public final void clearRedo() {
        this.undoList.next = null;
    }

    @Override
    public final void reset() {
        this.undoList = this.nullUndo;
        this.undoList.prev = null;
        this.undoList.next = null;
    }

    @Override
    public final boolean atEndCommand() {
        return this.undoList.isEndCommand();
    }

    @Override
    public final <T> T getOld(T o) {
        UndoEntry ue = this.undoList;
        while (ue.prev != null) {
            ue = ue.prev;
        }
        while (ue != null) {
            T po = ue.getOld(o);
            if (po != null) {
                return po;
            }
            ue = ue.next;
        }
        return null;
    }
}

