/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.util.Factory;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingArchive
implements Archive {
    private final File archiveFile;
    private final boolean keepOpened;
    private ZipFile zipFile;
    private Map<String, List<ZipRecord>> folders2files;

    public CachingArchive(File archiveFile, boolean keepOpened) {
        this.archiveFile = archiveFile;
        this.keepOpened = keepOpened;
    }

    @Override
    public Iterable<JavaFileObject> getFiles(String folderName, ClassPath.Entry entry, JavaFileFilterImplementation filter) throws IOException {
        this.doInit();
        List<ZipRecord> files = this.folders2files.get(folderName);
        if (files == null) {
            return Collections.emptyList();
        }
        assert (!this.keepOpened || this.zipFile != null);
        return Iterators.translating(files, new JFOFactory(folderName, this.archiveFile, this.zipFile));
    }

    @Override
    public synchronized void clear() {
        this.folders2files = null;
    }

    public synchronized boolean isInitialized() {
        return this.folders2files != null;
    }

    public synchronized void initialize() {
        this.folders2files = this.createMap(this.archiveFile);
    }

    private synchronized void doInit() {
        if (!this.isInitialized()) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<ZipRecord>> createMap(File file) {
        if (!file.canRead()) return Collections.emptyMap();
        try {
            ZipFile zip = new ZipFile(file);
            try {
                HashMap<String, List<ZipRecord>> map = new HashMap<String, List<ZipRecord>>();
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    ArrayList<ZipRecord> list;
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName();
                    int i = name.lastIndexOf(47);
                    String dirname = i == -1 ? "" : name.substring(0, i);
                    String basename = name.substring(i + 1);
                    if (basename.length() == 0) {
                        basename = null;
                    }
                    if ((list = (ArrayList<ZipRecord>)map.get(dirname)) == null) {
                        list = new ArrayList<ZipRecord>();
                        map.put(dirname, list);
                    }
                    if (basename == null) continue;
                    list.add(new ZipRecord(basename, entry.getTime()));
                }
                HashMap<String, List<ZipRecord>> hashMap = map;
                return hashMap;
            }
            finally {
                if (this.keepOpened) {
                    this.zipFile = zip;
                } else {
                    try {
                        zip.close();
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JFOFactory
    implements Factory<JavaFileObject, ZipRecord> {
        private final String pkg;
        private final File archiveFile;
        private final ZipFile zipFile;

        JFOFactory(String pkg, File archiveFile, ZipFile zipFile) {
            this.pkg = pkg;
            this.archiveFile = archiveFile;
            this.zipFile = zipFile;
        }

        @Override
        public JavaFileObject create(ZipRecord parameter) {
            if (this.zipFile == null) {
                return FileObjects.zipFileObject(this.archiveFile, this.pkg, parameter.baseName, parameter.mtime);
            }
            return FileObjects.zipFileObject(this.zipFile, this.pkg, parameter.baseName, parameter.mtime);
        }
    }

    private static class ZipRecord {
        private final long mtime;
        private final String baseName;

        public ZipRecord(String baseName, long mtime) {
            assert (baseName != null);
            this.mtime = mtime;
            this.baseName = baseName;
        }
    }
}

