/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingFileManager
implements JavaFileManager {
    protected final CachingArchiveProvider provider;
    protected final JavaFileFilterImplementation filter;
    protected final ClassPath cp;
    protected final boolean cacheFile;
    protected final boolean ignoreExcludes;

    public CachingFileManager(CachingArchiveProvider provider, ClassPath cp, boolean cacheFile, boolean ignoreExcludes) {
        this(provider, cp, null, cacheFile, ignoreExcludes);
    }

    public CachingFileManager(CachingArchiveProvider provider, ClassPath cp, JavaFileFilterImplementation filter, boolean cacheFile, boolean ignoreExcludes) {
        this.provider = provider;
        this.cp = cp;
        this.cacheFile = cacheFile;
        this.filter = filter;
        this.ignoreExcludes = ignoreExcludes;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException("Recursive listing is not supported in archives");
        }
        String folderName = FileObjects.convertPackage2Folder(packageName);
        LinkedList idxs = new LinkedList();
        for (ClassPath.Entry entry : this.cp.entries()) {
            try {
                Archive archive = this.provider.getArchive(entry.getURL(), this.cacheFile);
                if (archive == null) continue;
                Iterable<JavaFileObject> entries = archive.getFiles(folderName, this.ignoreExcludes ? null : entry, this.filter);
                idxs.add(entries.iterator());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return Iterators.toIterable(Iterators.chained(idxs));
    }

    @Override
    public javax.tools.FileObject getFileForInput(JavaFileManager.Location l, String pkgName, String relativeName) {
        for (ClassPath.Entry root : this.cp.entries()) {
            try {
                Archive archive = this.provider.getArchive(root.getURL(), this.cacheFile);
                if (archive == null) continue;
                Iterable<JavaFileObject> files = archive.getFiles(FileObjects.convertPackage2Folder(pkgName), this.ignoreExcludes ? null : root, this.filter);
                for (JavaFileObject e : files) {
                    if (!relativeName.equals(e.getName())) continue;
                    return e;
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) {
        String[] namePair = FileObjects.getParentRelativePathAndName(className);
        if (namePair == null) {
            return null;
        }
        namePair[1] = namePair[1] + kind.extension;
        for (ClassPath.Entry root : this.cp.entries()) {
            try {
                Archive archive = this.provider.getArchive(root.getURL(), this.cacheFile);
                if (archive == null) continue;
                Iterable<JavaFileObject> files = archive.getFiles(namePair[0], this.ignoreExcludes ? null : root, this.filter);
                for (JavaFileObject e : files) {
                    if (!namePair[1].equals(e.getName())) continue;
                    return e;
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location l, JavaFileObject javaFileObject) {
        if (javaFileObject instanceof FileObjects.Base) {
            FileObjects.Base base = (FileObjects.Base)javaFileObject;
            StringBuilder sb = new StringBuilder();
            sb.append(base.getPackage());
            sb.append('.');
            sb.append(base.getNameWithoutExtension());
            return sb.toString();
        }
        if (javaFileObject instanceof SourceFileObject) {
            FileObject fo = ((SourceFileObject)javaFileObject).file;
            for (FileObject root : this.cp.getRoots()) {
                if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                int index = relativePath.lastIndexOf(46);
                assert (index > 0);
                String result = relativePath.substring(0, index).replace('/', '.');
                return result;
            }
        }
        return null;
    }

    public static URL[] getClassPathRoots(ClassPath cp) {
        assert (cp != null);
        List entries = cp.entries();
        ArrayList<URL> result = new ArrayList<URL>(entries.size());
        for (ClassPath.Entry entry : entries) {
            result.add(entry.getURL());
        }
        return result.toArray(new URL[result.size()]);
    }

    @Override
    public boolean isSameFile(javax.tools.FileObject fileObject, javax.tools.FileObject fileObject0) {
        return fileObject instanceof FileObjects.FileBase && fileObject0 instanceof FileObjects.FileBase && ((FileObjects.FileBase)fileObject).getFile().equals(((FileObjects.FileBase)fileObject).getFile());
    }
}

