/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import org.netbeans.modules.java.source.parsing.FileObjects;

public class OutputFileObject
extends FileObjects.FileBase {
    private final File baseFolder;

    public static OutputFileObject create(File baseFolder, File diskDelegate) {
        assert (baseFolder != null && diskDelegate != null);
        String[] pkgNamePair = FileObjects.getFolderAndBaseName(FileObjects.getRelativePath(baseFolder, diskDelegate), File.separatorChar);
        return new OutputFileObject(baseFolder, diskDelegate, FileObjects.convertFolder2Package(pkgNamePair[0], File.separatorChar), pkgNamePair[1]);
    }

    private OutputFileObject(File baseFolder, File diskDelegate, String packageName, String baseName) {
        super(diskDelegate, packageName, baseName);
        this.baseFolder = baseFolder;
    }

    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("Binary file");
    }

    public boolean delete() {
        return this.f.delete();
    }

    public String getPath() {
        return this.f.getPath();
    }

    public URI toUri() {
        return this.f.toURI();
    }

    public long getLastModified() {
        return this.f.lastModified();
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.f);
    }

    public OutputStream openOutputStream() throws IOException {
        return new FileOutputStream(this.f);
    }

    public Reader openReader(boolean b) throws IOException {
        return new FileReader(this.f);
    }

    public Writer openWriter() throws IOException {
        return new FileWriter(this.f);
    }

    public String toString() {
        return this.f.getAbsolutePath();
    }

    public boolean equals(Object other) {
        if (other instanceof OutputFileObject) {
            OutputFileObject ofo = (OutputFileObject)other;
            return this.baseFolder.equals(ofo.baseFolder) && this.f.equals(ofo.f);
        }
        return false;
    }

    public int hashCode() {
        return this.f.hashCode();
    }
}

