/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFileManager
implements JavaFileManager {
    private static final JavaFileManager.Location ALL = new JavaFileManager.Location(){

        public String getName() {
            return "ALL";
        }

        public boolean isOutputLocation() {
            return false;
        }
    };
    private final JavaFileManager bootPath;
    private final JavaFileManager classPath;
    private final JavaFileManager sourcePath;
    private final JavaFileManager outputhPath;
    private JavaFileObject lastInfered;
    private String lastInferedResult;

    public ProxyFileManager(JavaFileManager bootPath, JavaFileManager classPath, JavaFileManager sourcePath, JavaFileManager outputhPath) {
        assert (bootPath != null);
        assert (classPath != null);
        this.bootPath = bootPath;
        this.classPath = classPath;
        this.sourcePath = sourcePath;
        this.outputhPath = outputhPath;
    }

    private JavaFileManager[] getFileManager(JavaFileManager.Location location) {
        if (location == StandardLocation.CLASS_PATH) {
            JavaFileManager[] javaFileManagerArray;
            if (this.outputhPath == null) {
                JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                javaFileManagerArray = javaFileManagerArray2;
                javaFileManagerArray2[0] = this.classPath;
            } else {
                JavaFileManager[] javaFileManagerArray3 = new JavaFileManager[2];
                javaFileManagerArray3[0] = this.classPath;
                javaFileManagerArray = javaFileManagerArray3;
                javaFileManagerArray3[1] = this.outputhPath;
            }
            return javaFileManagerArray;
        }
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return new JavaFileManager[]{this.bootPath};
        }
        if (location == StandardLocation.SOURCE_PATH && this.sourcePath != null) {
            return new JavaFileManager[]{this.sourcePath};
        }
        if (location == StandardLocation.CLASS_OUTPUT && this.outputhPath != null) {
            return new JavaFileManager[]{this.outputhPath};
        }
        if (location == ALL) {
            JavaFileManager[] javaFileManagerArray;
            if (this.outputhPath == null) {
                JavaFileManager[] javaFileManagerArray4 = new JavaFileManager[3];
                javaFileManagerArray4[0] = this.sourcePath;
                javaFileManagerArray4[1] = this.bootPath;
                javaFileManagerArray = javaFileManagerArray4;
                javaFileManagerArray4[2] = this.classPath;
            } else {
                JavaFileManager[] javaFileManagerArray5 = new JavaFileManager[4];
                javaFileManagerArray5[0] = this.sourcePath;
                javaFileManagerArray5[1] = this.bootPath;
                javaFileManagerArray5[2] = this.classPath;
                javaFileManagerArray = javaFileManagerArray5;
                javaFileManagerArray5[3] = this.outputhPath;
            }
            return javaFileManagerArray;
        }
        return new JavaFileManager[0];
    }

    private JavaFileManager[] getAllFileManagers() {
        ArrayList<JavaFileManager> result = new ArrayList<JavaFileManager>(4);
        result.add(this.bootPath);
        result.add(this.classPath);
        if (this.sourcePath != null) {
            result.add(this.sourcePath);
        }
        if (this.outputhPath != null) {
            result.add(this.outputhPath);
        }
        return result.toArray(new JavaFileManager[result.size()]);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavaFileManager[] fms;
        LinkedList iterators = new LinkedList();
        for (JavaFileManager fm : fms = this.getFileManager(l)) {
            iterators.add(fm.list(l, packageName, kinds, recurse).iterator());
        }
        return Iterators.toIterable(Iterators.chained(iterators));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location l, String packageName, String relativeName) throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManager(l)) {
            FileObject result = fm.getFileForInput(l, packageName, relativeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location l, String packageName, String relativeName, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] fms = this.getFileManager(l);
        assert (fms.length <= 1);
        if (fms.length == 0) {
            return null;
        }
        return fms[0].getFileForOutput(l, packageName, relativeName, sibling);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public void flush() throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getAllFileManagers()) {
            fm.flush();
        }
    }

    @Override
    public void close() throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getAllFileManagers()) {
            fm.close();
        }
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remains) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH || location == StandardLocation.SOURCE_PATH || location == StandardLocation.CLASS_OUTPUT;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManager(l)) {
            JavaFileObject result = fm.getJavaFileForInput(l, className, kind);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] fms = this.getFileManager(l);
        assert (fms.length <= 1);
        if (fms.length == 0) {
            return null;
        }
        return fms[0].getJavaFileForOutput(l, className, kind, sibling);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        JavaFileManager[] fms;
        assert (javaFileObject != null);
        if (javaFileObject == this.lastInfered) {
            return this.lastInferedResult;
        }
        if (javaFileObject instanceof FileObjects.Base) {
            FileObjects.Base base = (FileObjects.Base)javaFileObject;
            StringBuilder sb = new StringBuilder();
            sb.append(base.getPackage());
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(base.getNameWithoutExtension());
            String result = sb.toString();
            this.lastInfered = javaFileObject;
            this.lastInferedResult = result;
            return result;
        }
        for (JavaFileManager fm : fms = this.getFileManager(location)) {
            String result = fm.inferBinaryName(location, javaFileObject);
            if (result == null || result.length() <= 0) continue;
            this.lastInfered = javaFileObject;
            this.lastInferedResult = result;
            return result;
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject0) {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManager(ALL)) {
            if (!fm.isSameFile(fileObject, fileObject0)) continue;
            return true;
        }
        return fileObject.toUri().equals(fileObject0.toUri());
    }
}

