/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.DocumentProvider;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileObject
implements JavaFileObject,
DocumentProvider {
    final FileObject file;
    private final JavaFileObject.Kind kind;
    private URI uri;
    private String text;
    private TokenHierarchy<Void> tokens;
    private final JavaFileFilterImplementation filter;

    public static SourceFileObject create(FileObject file) {
        try {
            return new SourceFileObject(file, null, false);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
    }

    public SourceFileObject(FileObject file, JavaFileFilterImplementation filter, boolean renderNow) throws IOException {
        assert (file != null);
        this.file = file;
        this.filter = filter;
        String ext = this.file.getExt();
        this.kind = "java".equalsIgnoreCase(ext) ? JavaFileObject.Kind.SOURCE : ("class".equalsIgnoreCase(ext) ? JavaFileObject.Kind.CLASS : ("html".equalsIgnoreCase(ext) ? JavaFileObject.Kind.HTML : JavaFileObject.Kind.OTHER));
        if (renderNow) {
            this.text = this.getCharContentImpl().toString();
        }
    }

    @Override
    public boolean isNameCompatible(String simplename, JavaFileObject.Kind kind) {
        assert (simplename != null);
        return this.kind == kind && this.getNameWithoutExtension().equals(simplename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return CharBuffer.wrap(_text);
        }
        return this.getCharContentImpl();
    }

    public TokenHierarchy<Void> getTokenHierarchy() throws IOException {
        if (this.tokens == null) {
            this.getCharContentImpl();
        }
        return this.tokens;
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream(), FileEncodingQuery.getEncoding((FileObject)this.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return new StringReader(_text);
        }
        final StyledDocument doc = SourceFileObject.getDocument(this.isOpened());
        if (doc == null) {
            Reader r = new InputStreamReader(this.file.getInputStream(), FileEncodingQuery.getEncoding((FileObject)this.file));
            if (this.filter != null) {
                r = this.filter.filterReader(r);
            }
            return r;
        }
        final StringBuilder builder = new StringBuilder();
        doc.render(new Runnable(){

            public void run() {
                try {
                    builder.append(doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
        return new StringReader(builder.toString());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        StyledDocument doc = SourceFileObject.getDocument(this.isOpened());
        if (doc == null) {
            return new LckStream(this.file);
        }
        return new DocumentStream(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openInputStream() throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return new ByteArrayInputStream(_text.getBytes());
        }
        final StyledDocument doc = SourceFileObject.getDocument(this.isOpened());
        if (doc == null) {
            return this.file.getInputStream();
        }
        final StringBuilder builder = new StringBuilder();
        doc.render(new Runnable(){

            public void run() {
                try {
                    builder.append(doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
        return new ByteArrayInputStream(builder.toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete() {
        boolean bl;
        if (this.isModified() != null) {
            return false;
        }
        FileLock lock = this.file.lock();
        try {
            this.file.delete(lock);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                lock.releaseLock();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        lock.releaseLock();
        return bl;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.file.getNameExt();
    }

    public String getNameWithoutExtension() {
        return this.file.getName();
    }

    @Override
    public synchronized URI toUri() {
        if (this.uri == null) {
            try {
                this.uri = URI.create(this.file.getURL().toExternalForm());
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return this.uri;
    }

    @Override
    public long getLastModified() {
        if (this.isModified() == null) {
            return this.file.lastModified().getTime();
        }
        return System.currentTimeMillis();
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public String toString() {
        return this.file.getPath();
    }

    public boolean equals(Object other) {
        if (other instanceof SourceFileObject) {
            SourceFileObject otherSource = (SourceFileObject)other;
            return this.file.equals(otherSource.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public StyledDocument getDocument() {
        EditorCookie ec = this.isOpened();
        return ec != null ? SourceFileObject.getDocument(ec) : null;
    }

    @Override
    public void runAtomic(Runnable r) {
        assert (r != null);
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            throw new IllegalStateException();
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)r);
    }

    private EditorCookie isModified() {
        DataObject.Registry regs = DataObject.getRegistry();
        Set modified = regs.getModifiedSet();
        for (DataObject dobj : modified) {
            if (!this.file.equals(dobj.getPrimaryFile())) continue;
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            return ec;
        }
        return null;
    }

    public EditorCookie isOpened() {
        try {
            if (this.kind == JavaFileObject.Kind.CLASS) {
                return null;
            }
            DataObject dobj = DataObject.find((FileObject)this.file);
            return (EditorCookie)dobj.getCookie(EditorCookie.class);
        }
        catch (DataObjectNotFoundException dnf) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharBuffer getCharContentImpl() throws IOException {
        final StyledDocument doc = SourceFileObject.getDocument(this.isOpened());
        final char[][] result = new char[1][];
        final int[] length = new int[1];
        if (doc == null) {
            Reader in = this.openReader(true);
            int red = 0;
            try {
                int rv;
                int len = (int)this.file.getSize();
                result[0] = new char[len + 1];
                while ((rv = in.read(result[0], red, len - red)) > 0 && (red += rv) < len) {
                }
            }
            finally {
                in.close();
            }
            int j = 0;
            for (int i = 0; i < red; ++i) {
                if (result[0][i] == '\r') {
                    if (i + 1 < red && result[0][i + 1] == '\n') continue;
                    result[0][j++] = 10;
                    continue;
                }
                result[0][j++] = result[0][i];
            }
            length[0] = j;
        } else {
            doc.render(new Runnable(){

                public void run() {
                    try {
                        int len = doc.getLength();
                        result[0] = new char[len + 1];
                        doc.getText(0, len).getChars(0, len, result[0], 0);
                        length[0] = len;
                    }
                    catch (BadLocationException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            });
        }
        result[0][length[0]] = 10;
        CharBuffer charBuffer = CharBuffer.wrap(result[0], 0, length[0]);
        this.tokens = TokenHierarchy.create((CharSequence)charBuffer, (boolean)true, (Language)JavaTokenId.language(), null, null);
        return charBuffer;
    }

    private static StyledDocument getDocument(EditorCookie ec) {
        return ec == null ? null : ec.getDocument();
    }

    private class DocumentStream
    extends OutputStream {
        private static final int BUF_SIZ = 2048;
        private final StyledDocument doc;
        private byte[] data;
        private int pos;

        public DocumentStream(StyledDocument doc) {
            assert (doc != null);
            this.doc = doc;
            this.data = new byte[2048];
            this.pos = 0;
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.ensureSize(len);
            System.arraycopy(b, off, this.data, this.pos, len);
            this.pos += len;
        }

        public synchronized void write(byte[] b) throws IOException {
            this.ensureSize(b.length);
            System.arraycopy(b, 0, this.data, this.pos, b.length);
            this.pos += b.length;
        }

        public synchronized void write(int b) throws IOException {
            this.ensureSize(1);
            this.data[this.pos++] = (byte)(b & 0xFF);
        }

        private void ensureSize(int delta) {
            int requiredLength = this.pos + delta;
            if (this.data.length < requiredLength) {
                int newSize;
                for (newSize = this.data.length + 2048; newSize < requiredLength; newSize += 2048) {
                }
                byte[] newData = new byte[newSize];
                System.arraycopy(this.data, 0, newData, 0, this.pos);
                this.data = newData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            try {
                NbDocument.runAtomic((StyledDocument)this.doc, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            DocumentStream.this.doc.remove(0, DocumentStream.this.doc.getLength());
                            DocumentStream.this.doc.insertString(0, new String(DocumentStream.this.data, 0, DocumentStream.this.pos, FileEncodingQuery.getEncoding((FileObject)SourceFileObject.this.file).name()), null);
                        }
                        catch (BadLocationException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        catch (UnsupportedEncodingException ee) {
                            ErrorManager.getDefault().notify((Throwable)ee);
                        }
                    }
                });
            }
            finally {
                SourceFileObject sourceFileObject = SourceFileObject.this;
                synchronized (sourceFileObject) {
                    SourceFileObject.this.text = null;
                }
            }
        }
    }

    private class LckStream
    extends OutputStream {
        private final OutputStream delegate;
        private final FileLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LckStream(FileObject fo) throws IOException {
            assert (fo != null);
            this.lock = fo.lock();
            try {
                this.delegate = fo.getOutputStream(this.lock);
            }
            finally {
                if (this.delegate == null) {
                    this.lock.releaseLock();
                }
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.lock.releaseLock();
                SourceFileObject sourceFileObject = SourceFileObject.this;
                synchronized (sourceFileObject) {
                    SourceFileObject.this.text = null;
                }
            }
        }
    }
}

