/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.pretty.CharBuffer;
import org.netbeans.modules.java.source.pretty.DanglingElseChecker;
import org.netbeans.modules.java.source.pretty.WidthEstimator;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VeryPretty
extends JCTree.Visitor {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    private static final String REPLACEMENT = "%[a-z]*%";
    private final CodeStyle cs;
    private final CharBuffer out;
    private final Name.Table names;
    private final CommentHandler commentHandler;
    private final Symtab symbols;
    private final Types types;
    private final TreeInfo treeinfo;
    private final WidthEstimator widthEstimator;
    private final DanglingElseChecker danglingElseChecker;
    public Name enclClassName;
    private int prec;
    private Comment pendingAppendComment = null;
    private JCTree lastCommentCheck = null;

    public VeryPretty(Context context) {
        this(context, CodeStyle.getDefault(null));
    }

    public VeryPretty(Context context, CodeStyle cs) {
        this.cs = cs;
        this.out = new CharBuffer(cs.getRightMargin());
        this.names = Name.Table.instance((Context)context);
        this.enclClassName = this.names.empty;
        this.commentHandler = CommentHandlerService.instance(context);
        this.symbols = Symtab.instance(context);
        this.types = Types.instance(context);
        this.treeinfo = TreeInfo.instance((Context)context);
        this.widthEstimator = new WidthEstimator(context);
        this.danglingElseChecker = new DanglingElseChecker();
        this.prec = -1;
    }

    public String toString() {
        return this.out.toString();
    }

    public void toLeftMargin() {
        this.out.toLeftMargin();
    }

    public void reset(int margin) {
        this.out.setLength(0);
        this.out.leftMargin = margin;
    }

    public int indent() {
        int old = this.out.leftMargin;
        this.out.leftMargin = old + this.cs.getIndentSize();
        return old;
    }

    public void undent(int old) {
        this.out.leftMargin = old;
    }

    public void newline() {
        if (this.pendingAppendComment != null) {
            this.printComment(this.pendingAppendComment, true);
            this.pendingAppendComment = null;
        }
        this.out.nlTerm();
    }

    public void blankline() {
        this.out.blanklines(1);
    }

    public int setPrec(int prec) {
        int old = this.prec;
        this.prec = prec;
        return old;
    }

    public final void print(String s) {
        if (s == null) {
            return;
        }
        this.out.append(s);
    }

    public final void print(Name n) {
        this.out.appendUtf8((byte[])n.table.names, n.index, n.len);
    }

    public void print(JCTree t) {
        CommentSet comment = this.commentHandler.getComments(t);
        this.printPrecedingComments(comment);
        this.toLeftMargin();
        t.accept(this);
        this.printTrailingComments(comment);
    }

    public void printPackage(JCTree.JCExpression pid) {
        if (pid != null) {
            this.blankLines(this.cs.getBlankLinesBeforePackage());
            this.print("package ");
            this.printExpr(pid);
            this.print(';');
            this.blankLines(this.cs.getBlankLinesAfterPackage());
        }
    }

    public String getMethodHeader(MethodTree t, String s) {
        JCTree.JCMethodDecl tree = (JCTree.JCMethodDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, "%annotations");
        this.printFlags(tree.mods.flags);
        s = this.replace(s, "%flags%");
        if (tree.name == this.names.init) {
            this.print(this.enclClassName);
            s = this.replace(s, "%name%");
        } else {
            if (tree.typarams != null) {
                this.printTypeParameters(tree.typarams);
                this.needSpace();
                s = this.replace(s, "%typeparameters%");
            }
            this.print(tree.restype, tree.sym != null && tree.sym.type != null ? tree.sym.type.getReturnType() : null);
            s = this.replace(s, "%type%");
            this.out.clear();
            this.print(tree.name);
            s = this.replace(s, "%name%");
        }
        this.print('(');
        this.wrapTrees(tree.params, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
        this.print(')');
        s = this.replace(s, "%parameters%");
        if (tree.thrown.nonEmpty()) {
            this.print(" throws ");
            this.wrapTrees(tree.thrown, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
            s = this.replace(s, "%throws%");
        }
        return s.replaceAll(REPLACEMENT, "");
    }

    public String getClassHeader(ClassTree t, String s) {
        long flags;
        JCTree.JCClassDecl tree = (JCTree.JCClassDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, "%annotations");
        long l = flags = tree.sym != null ? tree.sym.flags() : tree.mods.flags;
        if ((flags & 0x4000L) != 0L) {
            this.printFlags(flags & 0xFFFFFFFFFFFFFDE7L);
        } else {
            this.printFlags(flags & 0xFFFFFFFFFFFFF9FFL);
        }
        s = this.replace(s, "%flags%");
        if ((flags & 0x200L) != 0L) {
            this.print("interface ");
            this.print(tree.name);
            s = this.replace(s, "%name%");
            this.printTypeParameters(tree.typarams);
            s = this.replace(s, "%typeparameters%");
            if (tree.implementing.nonEmpty()) {
                this.print(" extends ");
                this.wrapTrees(tree.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                s = this.replace(s, "%extends%");
            }
        } else {
            if ((flags & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((flags & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(tree.name);
            s = this.replace(s, "%name%");
            this.printTypeParameters(tree.typarams);
            s = this.replace(s, "%typeparameters%");
            if (tree.extending != null) {
                this.print(" extends ");
                this.print(tree.extending, tree.sym != null ? this.types.supertype(tree.sym.type) : null);
                s = this.replace(s, "%extends%");
            }
            if (tree.implementing.nonEmpty()) {
                this.print(" implements ");
                this.wrapTrees(tree.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                s = this.replace(s, "%implements%");
            }
        }
        return s.replaceAll(REPLACEMENT, "");
    }

    public String getVariableHeader(VariableTree t, String s) {
        JCTree.JCVariableDecl tree = (JCTree.JCVariableDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, "%annotations");
        this.printFlags(tree.mods.flags);
        s = this.replace(s, "%flags%");
        Type type = tree.type != null ? tree.type : tree.vartype.type;
        this.print(tree.vartype, type);
        s = this.replace(s, "%type%");
        this.needSpace();
        this.print(tree.name);
        s = this.replace(s, "%name%");
        return s.replaceAll(REPLACEMENT, "");
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        this.printPrecedingComments(tree);
        this.printPackage(tree.pid);
        boolean hasImports = false;
        List<JCTree> l = tree.defs;
        while (l.nonEmpty() && ((JCTree)l.head).tag == 2) {
            if (!hasImports) {
                this.blankLines(this.cs.getBlankLinesBeforeImports());
                hasImports = true;
            }
            this.printStat((JCTree)l.head);
            this.newline();
            l = l.tail;
        }
        if (hasImports) {
            this.blankLines(this.cs.getBlankLinesAfterImports());
        }
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head);
            this.newline();
            l = l.tail;
        }
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        this.print("import ");
        if (tree.staticImport) {
            this.print("static ");
        }
        this.print(this.fullName(tree.qualid));
        this.print(';');
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        int old;
        long flags;
        Name enclClassNamePrev = this.enclClassName;
        this.enclClassName = tree.name;
        this.blankLines(this.cs.getBlankLinesBeforeClass());
        this.toLeftMargin();
        this.printAnnotations(tree.mods.annotations);
        long l = flags = tree.sym != null ? tree.sym.flags() : tree.mods.flags;
        if ((flags & 0x4000L) != 0L) {
            this.printFlags(flags & 0xFFFFFFFFFFFFFDE7L);
        } else {
            this.printFlags(flags & 0xFFFFFFFFFFFFF9FFL);
        }
        if ((flags & 0x200L) != 0L || (flags & 0x2000L) != 0L) {
            if ((flags & 0x2000L) != 0L) {
                this.print('@');
            }
            this.print("interface ");
            this.print(tree.name);
            this.printTypeParameters(tree.typarams);
            if (tree.implementing.nonEmpty()) {
                this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                this.wrapTrees(tree.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            }
        } else {
            if ((flags & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((flags & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(tree.name);
            this.printTypeParameters(tree.typarams);
            if (tree.extending != null) {
                this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                this.print(tree.extending, tree.sym != null ? this.types.supertype(tree.sym.type) : null);
            }
            if (tree.implementing.nonEmpty()) {
                this.wrap("implements ", this.cs.wrapExtendsImplementsKeyword());
                this.wrapTrees(tree.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            }
        }
        int bcol = old = this.cs.indentTopLevelClassMembers() ? this.indent() : this.out.leftMargin;
        switch (this.cs.getClassDeclBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(old);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.cs.getIndentSize() >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                bcol = this.out.leftMargin;
                this.toColExactly(bcol);
            }
        }
        if (this.cs.spaceBeforeClassDeclLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        if (tree.defs.nonEmpty()) {
            this.blankLines(this.cs.getBlankLinesAfterClassHeader());
            if ((tree.mods.flags & 0x4000L) != 0L) {
                boolean first = true;
                boolean hasNonEnumerator = false;
                List<JCTree> l2 = tree.defs;
                while (l2.nonEmpty()) {
                    if (this.isEnumerator((JCTree)l2.head)) {
                        if (first) {
                            this.toColExactly(this.out.leftMargin);
                            first = false;
                        } else {
                            this.print(this.cs.spaceBeforeComma() ? " ," : ",");
                            switch (this.cs.wrapEnumConstants()) {
                                case WRAP_IF_LONG: {
                                    int rm = this.cs.getRightMargin();
                                    if (this.widthEstimator.estimateWidth((JCTree)l2.head, rm - this.out.col) + this.out.col + 1 <= rm) {
                                        if (!this.cs.spaceAfterComma()) break;
                                        this.print(' ');
                                        break;
                                    }
                                }
                                case WRAP_ALWAYS: {
                                    this.toColExactly(this.out.leftMargin);
                                    break;
                                }
                                case WRAP_NEVER: {
                                    if (!this.cs.spaceAfterComma()) break;
                                    this.print(' ');
                                }
                            }
                        }
                        this.printStat((JCTree)l2.head);
                    } else if (!this.isSynthetic((JCTree)l2.head)) {
                        hasNonEnumerator = true;
                    }
                    l2 = l2.tail;
                }
                if (hasNonEnumerator) {
                    this.print(";");
                    this.newline();
                }
            }
            List<JCTree> l3 = tree.defs;
            while (l3.nonEmpty()) {
                JCTree t = (JCTree)l3.head;
                if (!this.isEnumerator(t) && !this.isSynthetic(t)) {
                    this.toColExactly(this.out.leftMargin);
                    this.printStat(t);
                    this.newline();
                }
                l3 = l3.tail;
            }
        }
        this.toColExactly(bcol);
        this.undent(old);
        this.print('}');
        this.blankLines(this.cs.getBlankLinesAfterClass());
        this.enclClassName = enclClassNamePrev;
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if ((tree.mods.flags & 0x1000L) == 0L && tree.name != this.names.init || this.enclClassName != null) {
            Name enclClassNamePrev = this.enclClassName;
            this.enclClassName = null;
            this.blankLines(this.cs.getBlankLinesBeforeMethods());
            this.toLeftMargin();
            this.printAnnotations(tree.mods.annotations);
            this.printFlags(tree.mods.flags);
            if (tree.name == this.names.init) {
                this.print(enclClassNamePrev);
            } else {
                if (tree.typarams != null) {
                    this.printTypeParameters(tree.typarams);
                    this.needSpace();
                }
                this.print(tree.restype, tree.sym != null && tree.sym.type != null ? tree.sym.type.getReturnType() : null);
                this.needSpace();
                this.print(tree.name);
            }
            this.print(this.cs.spaceBeforeMethodDeclParen() ? " (" : "(");
            if (this.cs.spaceWithinMethodDeclParens()) {
                this.print(' ');
            }
            this.wrapTrees(tree.params, this.cs.wrapMethodParams(), this.cs.alignMultilineMethodParams() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            if (this.cs.spaceWithinMethodDeclParens()) {
                this.needSpace();
            }
            this.print(')');
            if (tree.thrown.nonEmpty()) {
                this.wrap("throws ", this.cs.wrapThrowsKeyword());
                this.wrapTrees(tree.thrown, this.cs.wrapThrowsList(), this.cs.alignMultilineThrows() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            }
            if (tree.body != null) {
                boolean constructor = tree.name == this.names.init;
                List<JCTree.JCStatement> stats = tree.body.stats;
                JCTree head = (JCTree)stats.head;
                if (head instanceof JCTree.JCExpressionStatement) {
                    head = ((JCTree.JCExpressionStatement)head).expr;
                }
                if (constructor && head instanceof JCTree.JCMethodInvocation) {
                    JCTree.JCMethodInvocation ap = (JCTree.JCMethodInvocation)head;
                    if (ap.args.isEmpty() && ap.meth instanceof JCTree.JCIdent) {
                        Name n;
                        JCTree.JCIdent id = (JCTree.JCIdent)ap.meth;
                        Name name = n = id.sym == null ? id.name : id.sym.name;
                        if (n == this.names.init) {
                            stats = stats.tail;
                        }
                    }
                }
                this.printBlock(stats, this.cs.getMethodDeclBracePlacement(), this.cs.spaceBeforeMethodDeclLeftBrace());
            } else {
                this.print(';');
            }
            this.blankLines(this.cs.getBlankLinesAfterMethods());
            this.enclClassName = enclClassNamePrev;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        if ((tree.mods.flags & 0x4000L) != 0L) {
            this.print(tree.name);
        } else {
            Type type;
            if (this.enclClassName != null && this.enclClassName != this.names.empty) {
                this.blankLines(this.cs.getBlankLinesBeforeFields());
                this.toLeftMargin();
            }
            this.printAnnotations(tree.mods.annotations);
            this.printFlags(tree.mods.flags);
            Type type2 = type = tree.type != null ? tree.type : tree.vartype.type;
            if ((tree.mods.flags & 0x400000000L) != 0L) {
                this.printExpr(((JCTree.JCArrayTypeTree)tree.vartype).elemtype);
                this.print("...");
            } else {
                this.print(tree.vartype, type);
            }
            this.needSpace();
            this.print(tree.name);
            if (tree.init != null) {
                if (this.cs.spaceAroundAssignOps()) {
                    this.print(' ');
                }
                this.print('=');
                int rm = this.cs.getRightMargin();
                switch (this.cs.wrapAssignOps()) {
                    case WRAP_IF_LONG: {
                        if (this.widthEstimator.estimateWidth(tree.init, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                            if (!this.cs.spaceAroundAssignOps()) break;
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                        break;
                    }
                    case WRAP_NEVER: {
                        if (!this.cs.spaceAroundAssignOps()) break;
                        this.print(' ');
                    }
                }
                this.printNoParenExpr(tree.init);
            }
            if (this.prec == -1) {
                this.print(';');
            }
            if (this.enclClassName != null && this.enclClassName != this.names.empty) {
                this.blankLines(this.cs.getBlankLinesAfterFields());
            }
        }
    }

    @Override
    public void visitSkip(JCTree.JCSkip tree) {
        this.print(';');
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.printFlags(tree.flags, false);
        this.printBlock(tree.stats, this.cs.getOtherBracePlacement(), (tree.flags & 8L) != 0L ? this.cs.spaceBeforeStaticInitLeftBrace() : false);
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        boolean prevblock;
        this.print("do");
        if (this.cs.spaceBeforeDoLeftBrace()) {
            this.print(' ');
        }
        this.printIndentedStat(tree.body, this.cs.redundantDoWhileBraces(), this.cs.spaceBeforeDoLeftBrace(), this.cs.wrapDoWhileStatement());
        boolean bl = prevblock = tree.body.getKind() == Tree.Kind.BLOCK || this.cs.redundantDoWhileBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (this.cs.placeWhileOnNewLine() || !prevblock) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeWhile()) {
            this.needSpace();
        }
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " );" : ");");
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " )" : ")");
        this.printIndentedStat(tree.body, this.cs.redundantWhileBraces(), this.cs.spaceBeforeWhileLeftBrace(), this.cs.wrapWhileStatement());
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        int col = this.out.col;
        if (tree.init.nonEmpty()) {
            if (((JCTree.JCStatement)tree.init.head).tag == 5) {
                this.printNoParenExpr((JCTree)tree.init.head);
                List l = tree.init.tail;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl vdef = (JCTree.JCVariableDecl)l.head;
                    this.print(", " + vdef.name + " = ");
                    this.printNoParenExpr(vdef.init);
                    l = l.tail;
                }
            } else {
                this.printExprs(tree.init);
            }
        }
        String sep = this.cs.spaceBeforeSemi() ? " ;" : ";";
        this.print(sep);
        if (tree.cond != null) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.cond, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.toColExactly(this.cs.alignMultilineFor() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printNoParenExpr(tree.cond);
        }
        this.print(sep);
        if (tree.step.nonEmpty()) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.step, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.toColExactly(this.cs.alignMultilineFor() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printExprs(tree.step);
        }
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(tree.body, this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        this.toColExactly(this.cs.absoluteLabelIndent() ? 0 : this.out.leftMargin);
        this.print(tree.label);
        this.print(':');
        int old = this.out.leftMargin;
        this.out.leftMargin += this.cs.getLabelIndent();
        this.toColExactly(this.out.leftMargin);
        this.printStat(tree.body);
        this.undent(old);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.print("switch");
        this.print(this.cs.spaceBeforeSwitchParen() ? " (" : "(");
        if (this.cs.spaceWithinSwitchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.selector);
        this.print(this.cs.spaceWithinSwitchParens() ? " )" : ")");
        int bcol = this.out.leftMargin;
        switch (this.cs.getOtherBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(bcol);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.cs.getIndentSize() >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.cs.getIndentSize());
            }
        }
        if (this.cs.spaceBeforeSwitchLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        if (tree.cases.nonEmpty()) {
            this.newline();
            this.printStats(tree.cases);
            this.toColExactly(bcol);
        }
        this.print('}');
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        int old = this.cs.indentCasesFromSwitch() ? this.indent() : this.out.leftMargin;
        this.toLeftMargin();
        if (tree.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printNoParenExpr(tree.pat);
        }
        this.print(':');
        this.newline();
        this.indent();
        this.printStats(tree.stats);
        this.undent(old);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        this.print("synchronized");
        this.print(this.cs.spaceBeforeSynchronizedParen() ? " (" : "(");
        if (this.cs.spaceWithinSynchronizedParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.lock);
        this.print(this.cs.spaceWithinSynchronizedParens() ? " )" : ")");
        this.printBlock(tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeSynchronizedLeftBrace());
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        this.print("try");
        this.printBlock(tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeTryLeftBrace());
        List<JCTree.JCCatch> l = tree.catchers;
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head);
            l = l.tail;
        }
        if (tree.finalizer != null) {
            if (this.cs.placeFinallyOnNewLine()) {
                this.newline();
                this.toLeftMargin();
            } else if (this.cs.spaceBeforeFinally()) {
                this.needSpace();
            }
            this.print("finally");
            this.printBlock(tree.finalizer, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeFinallyLeftBrace());
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        if (this.cs.placeCatchOnNewLine()) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeCatch()) {
            this.needSpace();
        }
        this.print("catch");
        this.print(this.cs.spaceBeforeCatchParen() ? " (" : "(");
        if (this.cs.spaceWithinCatchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.param);
        this.print(this.cs.spaceWithinCatchParens() ? " )" : ")");
        this.printBlock(tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeCatchLeftBrace());
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        int rm;
        this.printExpr(tree.cond, 3 - 1);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                rm = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(tree.truepart, rm - this.out.col) + this.out.col + 1 <= rm) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? "? " : "?");
        this.printExpr(tree.truepart, 3);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                rm = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(tree.falsepart, rm - this.out.col) + this.out.col + 1 <= rm) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? ": " : ":");
        this.printExpr(tree.falsepart, 3);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        boolean prevblock;
        this.print("if");
        this.print(this.cs.spaceBeforeIfParen() ? " (" : "(");
        if (this.cs.spaceWithinIfParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinIfParens() ? " )" : ")");
        boolean bl = prevblock = tree.thenpart.getKind() == Tree.Kind.BLOCK || this.cs.redundantIfBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (tree.elsepart != null && this.danglingElseChecker.hasDanglingElse(tree.thenpart)) {
            this.printBlock(tree.thenpart, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeIfLeftBrace());
            prevblock = true;
        } else {
            this.printIndentedStat(tree.thenpart, this.cs.redundantIfBraces(), this.cs.spaceBeforeIfLeftBrace(), this.cs.wrapIfStatement());
        }
        if (tree.elsepart != null) {
            if (this.cs.placeElseOnNewLine() || !prevblock) {
                this.newline();
                this.toLeftMargin();
            } else if (this.cs.spaceBeforeElse()) {
                this.needSpace();
            }
            this.print("else");
            if (tree.elsepart.getKind() == Tree.Kind.IF && this.cs.specialElseIf()) {
                this.needSpace();
                this.printStat(tree.elsepart);
            } else {
                this.printIndentedStat(tree.elsepart, this.cs.redundantIfBraces(), this.cs.spaceBeforeElseLeftBrace(), this.cs.wrapIfStatement());
            }
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.printNoParenExpr(tree.expr);
        if (this.prec == -1) {
            this.print(';');
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        this.print("break");
        if (tree.label != null) {
            this.needSpace();
            this.print(tree.label);
        }
        this.print(';');
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        this.print("continue");
        if (tree.label != null) {
            this.needSpace();
            this.print(tree.label);
        }
        this.print(';');
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        this.print("return");
        if (tree.expr != null) {
            this.needSpace();
            this.printNoParenExpr(tree.expr);
        }
        this.print(';');
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        this.print("throw ");
        this.printNoParenExpr(tree.expr);
        this.print(';');
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        this.print("assert ");
        this.printExpr(tree.cond);
        if (tree.detail != null) {
            this.print(this.cs.spaceBeforeColon() ? " :" : ":");
            switch (this.cs.wrapAssert()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.detail, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterColon()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterColon()) break;
                    this.print(' ');
                }
            }
            this.printExpr(tree.detail);
        }
        this.print(';');
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        int prevPrec = this.prec;
        this.prec = 15;
        if (tree.meth.tag == 34) {
            JCTree.JCFieldAccess left = (JCTree.JCFieldAccess)tree.meth;
            this.printExpr(left.selected);
            this.print('.');
            if (left.selected.tag == 26) {
                switch (this.cs.wrapChainedMethodCalls()) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        int estWidth = left.name.length();
                        if (tree.typeargs.nonEmpty()) {
                            estWidth += this.widthEstimator.estimateWidth(tree.typeargs, rm - this.out.col - estWidth) + 2;
                        }
                        if ((estWidth += this.widthEstimator.estimateWidth(tree.args, rm - this.out.col - estWidth) + 2) + this.out.col <= rm) break;
                    }
                    case WRAP_ALWAYS: {
                        this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                }
            }
            if (tree.typeargs.nonEmpty()) {
                this.printTypeArguments(tree.typeargs);
            }
            this.print(left.name);
        } else {
            if (tree.typeargs.nonEmpty()) {
                this.printTypeArguments(tree.typeargs);
            }
            this.printExpr(tree.meth);
        }
        this.prec = prevPrec;
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens()) {
            this.print(' ');
        }
        this.wrapTrees(tree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() ? " )" : ")");
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.encl != null) {
            this.printExpr(tree.encl);
            this.print('.');
        }
        this.print("new ");
        if (tree.typeargs.nonEmpty()) {
            this.print("<");
            this.printExprs(tree.typeargs);
            this.print(">");
        }
        if (tree.encl == null) {
            this.print(tree.clazz, tree.clazz.type);
        } else if (tree.clazz.type != null) {
            this.print(tree.clazz.type.tsym.name);
        } else {
            this.print(tree.clazz);
        }
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens()) {
            this.print(' ');
        }
        this.wrapTrees(tree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() ? " )" : ")");
        if (tree.def != null) {
            Name enclClassNamePrev = this.enclClassName;
            this.enclClassName = null;
            this.printBlock(tree.def.defs, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeClassDeclLeftBrace());
            this.enclClassName = enclClassNamePrev;
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        if (tree.elemtype != null) {
            this.print("new ");
            int n = tree.elems != null ? 1 : 0;
            JCTree.JCExpression elemtype = tree.elemtype;
            while (elemtype.tag == 38) {
                ++n;
                elemtype = ((JCTree.JCArrayTypeTree)elemtype).elemtype;
            }
            this.printExpr(elemtype);
            List<JCTree.JCExpression> l = tree.dims;
            while (l.nonEmpty()) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ " : "[");
                this.printNoParenExpr((JCTree)l.head);
                this.print(this.cs.spaceWithinArrayInitBrackets() ? " ]" : "]");
                --n;
                l = l.tail;
            }
            while (--n >= 0) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ ]" : "[]");
            }
        }
        if (tree.elems != null) {
            if (this.cs.spaceBeforeArrayInitLeftBrace()) {
                this.needSpace();
            }
            this.print('{');
            if (this.cs.spaceWithinBraces()) {
                this.print(' ');
            }
            this.wrapTrees(tree.elems, this.cs.wrapArrayInit(), this.cs.alignMultilineArrayInit() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            this.print(this.cs.spaceWithinBraces() ? " }" : "}");
        }
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        this.print('(');
        if (this.cs.spaceWithinParens()) {
            this.print(' ');
        }
        this.printExpr(tree.expr);
        this.print(this.cs.spaceWithinParens() ? " )" : ")");
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        int col = this.out.col;
        this.printExpr(tree.lhs, 1 + 1);
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print('=');
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundAssignOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.cs.alignMultilineAssignment() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundAssignOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, 1);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        int col = this.out.col;
        this.printExpr(tree.lhs, 2 + 1);
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print(this.treeinfo.operatorName(tree.tag - 17));
        this.print('=');
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundAssignOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.cs.alignMultilineAssignment() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundAssignOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, 2);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        int ownprec = TreeInfo.opPrec((int)tree.tag);
        Name opname = this.treeinfo.operatorName(tree.tag);
        if (tree.tag <= 51) {
            if (this.cs.spaceAroundUnaryOps()) {
                this.needSpace();
                this.print(opname);
                this.print(' ');
            } else {
                this.print(opname);
            }
            this.printExpr(tree.arg, ownprec);
        } else {
            this.printExpr(tree.arg, ownprec);
            if (this.cs.spaceAroundUnaryOps()) {
                this.print(' ');
                this.print(opname);
                this.print(' ');
            } else {
                this.print(opname);
            }
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        int ownprec = TreeInfo.opPrec((int)tree.tag);
        Name opname = this.treeinfo.operatorName(tree.tag);
        int col = this.out.col;
        this.printExpr(tree.lhs, ownprec);
        if (this.cs.spaceAroundBinaryOps()) {
            this.print(' ');
        }
        this.print(opname);
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapBinaryOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundBinaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.cs.alignMultilineBinaryOp() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundBinaryOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, ownprec + 1);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.print(this.cs.spaceWithinTypeCastParens() ? "( " : "(");
        this.print(tree.clazz, tree.clazz.type);
        this.print(this.cs.spaceWithinTypeCastParens() ? " )" : ")");
        if (this.cs.spaceAfterTypeCast()) {
            this.needSpace();
        }
        this.printExpr(tree.expr, 14);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.printExpr(tree.expr, 10);
        this.print(" instanceof ");
        this.print(tree.clazz, tree.clazz.type);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.printExpr(tree.indexed, 15);
        this.print('[');
        this.printExpr(tree.index);
        this.print(']');
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        if (tree.sym instanceof Symbol.ClassSymbol) {
            this.print(null, tree.type);
        } else {
            this.printExpr(tree.selected, 15);
            this.print('.');
            this.print(tree.sym == null ? tree.name : tree.sym.name);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        if (tree.sym instanceof Symbol.ClassSymbol) {
            this.print(null, tree.type);
        } else {
            Name n;
            Name name = n = tree.sym == null ? tree.name : tree.sym.name;
            if (n == this.names.init) {
                this.print(tree.name);
            } else {
                this.print(n);
            }
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        switch (tree.typetag) {
            case 4: {
                this.print(tree.value.toString());
                break;
            }
            case 5: {
                this.print(tree.value.toString() + "L");
                break;
            }
            case 6: {
                this.print(tree.value.toString() + "F");
                break;
            }
            case 7: {
                this.print(tree.value.toString());
                break;
            }
            case 2: {
                this.print("'" + Convert.quote(String.valueOf((char)((Number)tree.value).intValue())) + "'");
                break;
            }
            case 10: {
                this.print("\"" + Convert.quote((String)tree.value) + "\"");
                break;
            }
            case 8: {
                this.print(tree.getValue().toString());
                break;
            }
            case 17: {
                this.print("null");
                break;
            }
            default: {
                this.print(tree.value.toString());
            }
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        this.print(this.symbols.typeOfTag[tree.typetag].tsym.name);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        this.printExpr(tree.elemtype);
        this.print("[]");
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        this.printExpr(tree.clazz);
        this.print('<');
        this.printExprs(tree.arguments);
        this.print('>');
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        this.print(tree.name);
        if (tree.bounds.nonEmpty()) {
            this.print(" extends ");
            this.printExprs(tree.bounds, " & ");
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        this.print("" + tree.kind);
        if (tree.kind != BoundKind.UNBOUND) {
            this.printExpr(tree.inner);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers tree) {
        this.printAnnotations(tree.annotations);
        this.printFlags(tree.flags);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        this.print("@");
        this.printExpr(tree.annotationType);
        if (tree.args.nonEmpty()) {
            this.print(this.cs.spaceBeforeAnnotationParen() ? " (" : "(");
            if (this.cs.spaceWithinAnnotationParens()) {
                this.print(' ');
            }
            this.printExprs(tree.args);
            this.print(this.cs.spaceWithinAnnotationParens() ? " )" : ")");
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        this.printExpr(tree.getVariable());
        String sep = this.cs.spaceBeforeColon() ? " :" : ":";
        this.print(this.cs.spaceAfterColon() ? sep + " " : sep);
        this.printExpr(tree.getExpression());
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(tree.getStatement(), this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        this.print("(let " + tree.defs + " in " + tree.expr + ")");
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        this.print("(ERROR)");
    }

    @Override
    public void visitTree(JCTree tree) {
        this.print("(UNKNOWN: " + tree + ")");
        this.newline();
    }

    private void print(char c) {
        this.out.append(c);
    }

    private void needSpace() {
        this.out.needSpace();
    }

    private void blankLines(int n) {
        this.out.blanklines(n);
    }

    private void toColExactly(int n) {
        if (n < this.out.col) {
            this.newline();
        }
        this.out.toCol(n);
    }

    private void printQualified(Symbol t) {
        if (t.owner != null && t.owner.name.len > 0 && !(t.type instanceof Type.TypeVar) && !(t.owner instanceof Symbol.MethodSymbol)) {
            if (t.owner instanceof Symbol.PackageSymbol) {
                this.printAllQualified(t.owner);
            } else {
                this.printQualified(t.owner);
            }
            this.print('.');
        }
        this.print(t.name);
    }

    private void printAllQualified(Symbol t) {
        if (t.owner != null && t.owner.name.len > 0) {
            this.printAllQualified(t.owner);
            this.print('.');
        }
        this.print(t.name);
    }

    private void print(JCTree t, Type ty) {
        if (ty == null || ty == Type.noType) {
            this.print(t);
        } else {
            List<Type> typarams;
            int arrCnt = 0;
            while (ty instanceof Type.ArrayType) {
                ty = ((Type.ArrayType)ty).elemtype;
                ++arrCnt;
            }
            this.printQualified(ty.tsym);
            if (ty instanceof Type.ClassType && (typarams = ((Type.ClassType)ty).typarams_field) != null && typarams.nonEmpty()) {
                this.print('<');
                while (typarams.nonEmpty()) {
                    this.print(null, (Type)typarams.head);
                    if (typarams.tail.nonEmpty()) {
                        if (this.cs.spaceBeforeComma()) {
                            this.print(' ');
                        }
                        this.print(this.cs.spaceAfterComma() ? ", " : ",");
                    }
                    typarams = typarams.tail;
                }
                this.print('>');
            }
            while (--arrCnt >= 0) {
                this.print("[]");
            }
        }
    }

    private void printAnnotations(List<JCTree.JCAnnotation> annotations) {
        while (annotations.nonEmpty()) {
            this.printNoParenExpr((JCTree)annotations.head);
            if (annotations.tail != null && annotations.tail.nonEmpty()) {
                switch (this.cs.wrapAnnotations()) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        if (this.widthEstimator.estimateWidth((JCTree)annotations.tail.head, rm - this.out.col) + this.out.col + 1 <= rm) {
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.toColExactly(this.out.leftMargin);
                        break;
                    }
                    case WRAP_NEVER: {
                        this.print(' ');
                    }
                }
            } else {
                this.toColExactly(this.out.leftMargin);
            }
            annotations = annotations.tail;
        }
    }

    private void printFlags(long flags) {
        this.printFlags(flags, true);
    }

    private void printFlags(long flags, boolean addSpace) {
        this.print(TreeInfo.flagNames(flags));
        if ((flags & 0xFFFL) != 0L) {
            if (this.cs.placeNewLineAfterModifiers()) {
                this.toColExactly(this.out.leftMargin);
            } else if (addSpace) {
                this.needSpace();
            }
        }
    }

    private void printExpr(JCTree tree) {
        this.printExpr(tree, 0);
    }

    private void printNoParenExpr(JCTree tree) {
        while (tree instanceof JCTree.JCParens) {
            tree = ((JCTree.JCParens)tree).expr;
        }
        this.printExpr(tree, 0);
    }

    private void printExpr(JCTree tree, int prec) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            int prevPrec = this.prec;
            this.prec = prec;
            tree.accept(this);
            this.prec = prevPrec;
        }
    }

    private <T extends JCTree> void printExprs(List<T> trees) {
        String sep = this.cs.spaceBeforeComma() ? " ," : ",";
        this.printExprs(trees, this.cs.spaceAfterComma() ? sep + " " : sep);
    }

    private <T extends JCTree> void printExprs(List<T> trees, String sep) {
        if (trees.nonEmpty()) {
            this.printNoParenExpr((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                this.print(sep);
                this.printNoParenExpr((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    private void printStat(JCTree tree) {
        if (tree == null) {
            this.print(';');
        } else {
            CommentSet comment = this.commentHandler.getComments(tree);
            this.printPrecedingComments(comment);
            this.printExpr(tree, -1);
            int tag = tree.tag;
            if (26 <= tag && tag <= 90) {
                this.print(';');
            }
            this.printTrailingComments(comment);
        }
    }

    private void printIndentedStat(JCTree tree, CodeStyle.BracesGenerationStyle redundantBraces, boolean spaceBeforeLeftBrace, CodeStyle.WrapStyle wrapStat) {
        switch (redundantBraces) {
            case GENERATE: {
                this.printBlock(tree, this.cs.getOtherBracePlacement(), spaceBeforeLeftBrace);
                return;
            }
            case ELIMINATE: {
                List<JCTree.JCStatement> t;
                while (tree instanceof JCTree.JCBlock && !(t = ((JCTree.JCBlock)tree).stats).isEmpty() && !t.tail.nonEmpty() && !(t.head instanceof JCTree.JCVariableDecl)) {
                    this.printPrecedingComments(tree);
                    tree = (JCTree)t.head;
                }
            }
            case LEAVE_ALONE: {
                if (tree instanceof JCTree.JCBlock) {
                    this.printBlock(tree, this.cs.getOtherBracePlacement(), spaceBeforeLeftBrace);
                    return;
                }
                int old = this.indent();
                switch (wrapStat) {
                    case WRAP_NEVER: {
                        if (spaceBeforeLeftBrace) {
                            this.needSpace();
                        }
                        this.printStat(tree);
                        this.undent(old);
                        return;
                    }
                    case WRAP_IF_LONG: {
                        int oldhm = this.out.harden();
                        int oldc = this.out.col;
                        int oldu = this.out.used;
                        int oldm = this.out.leftMargin;
                        try {
                            if (spaceBeforeLeftBrace) {
                                this.needSpace();
                            }
                            this.printStat(tree);
                            this.undent(old);
                            this.out.restore(oldhm);
                            return;
                        }
                        catch (Throwable t) {
                            this.out.restore(oldhm);
                            this.out.col = oldc;
                            this.out.used = oldu;
                            this.out.leftMargin = oldm;
                        }
                    }
                    case WRAP_ALWAYS: {
                        if (this.out.col > 0) {
                            this.newline();
                        }
                        this.toLeftMargin();
                        this.printStat(tree);
                        this.undent(old);
                    }
                }
            }
        }
    }

    private <T extends JCTree> void printStats(List<T> trees) {
        List<Object> l = trees;
        while (l.nonEmpty()) {
            JCTree t = (JCTree)l.head;
            if (!this.isSynthetic(t)) {
                this.toColExactly(this.out.leftMargin);
                this.printStat(t);
            }
            l = l.tail;
        }
    }

    private void printBlock(JCTree t, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace) {
        List<JCTree> stats = t instanceof JCTree.JCBlock ? ((JCTree.JCBlock)t).stats : List.of(t);
        this.printBlock(stats, bracePlacement, spaceBeforeLeftBrace);
    }

    private void printBlock(List<? extends JCTree> stats, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace) {
        int old;
        int bcol = old = this.indent();
        switch (bracePlacement) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(old);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.cs.getIndentSize() >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                bcol = this.out.leftMargin;
                this.toColExactly(bcol);
            }
        }
        if (spaceBeforeLeftBrace) {
            this.needSpace();
        }
        this.print('{');
        if (stats.nonEmpty()) {
            this.newline();
            this.printStats(stats);
        }
        this.toColExactly(bcol);
        this.undent(old);
        this.print('}');
    }

    private void printTypeParameters(List<JCTree.JCTypeParameter> trees) {
        if (trees.nonEmpty()) {
            this.print('<');
            this.printExprs(trees);
            this.print('>');
        }
    }

    private void printTypeArguments(List<? extends JCTree.JCExpression> typeargs) {
        if (typeargs.nonEmpty()) {
            this.print('<');
            this.printExprs(typeargs);
            this.print('>');
        }
    }

    private void printPrecedingComments(CommentSet commentSet) {
        if (!commentSet.hasComments()) {
            return;
        }
        for (Comment c : commentSet.getPrecedingComments()) {
            this.printComment(c, false);
        }
    }

    private void printTrailingComments(CommentSet commentSet) {
        if (!commentSet.hasComments()) {
            return;
        }
        for (Comment c : commentSet.getTrailingComments()) {
            this.printComment(c, true);
        }
    }

    private void printPrecedingComments(JCTree tree) {
        if (tree == this.lastCommentCheck) {
            return;
        }
        this.lastCommentCheck = tree;
        if (this.pendingAppendComment != null) {
            this.printComment(this.pendingAppendComment, true);
            this.pendingAppendComment = null;
        }
        if (this.commentHandler != null) {
            CommentSet pc = this.commentHandler.getComments(tree);
            this.printPrecedingComments(pc);
        }
    }

    private void printComment(Comment comment, boolean appendOnly) {
        String body = comment.getText();
        int col = comment.indent();
        int stpos = -1;
        int endpos = 0;
        CommentLine root = null;
        CommentLine tail = null;
        int limit = body.length();
        block9: for (int i = 0; i < limit; ++i) {
            char c = body.charAt(i);
            switch (c) {
                default: {
                    if (stpos < 0) {
                        stpos = i;
                    }
                    endpos = i + 1;
                    continue block9;
                }
                case '\t': {
                    if (stpos >= 0) continue block9;
                    col = col + 8 & 0xFFFFFFF8;
                    continue block9;
                }
                case ' ': 
                case '*': 
                case '/': {
                    if (stpos >= 0) continue block9;
                    ++col;
                    continue block9;
                }
                case '\n': {
                    int tlen;
                    int n = tlen = stpos < 0 ? 0 : i - stpos;
                    if (tlen > 0 || root != null) {
                        CommentLine cl = new CommentLine(col, stpos, tlen, body);
                        if (tail == null) {
                            root = cl;
                        } else {
                            tail.next = cl;
                        }
                        tail = cl;
                    }
                    stpos = -1;
                    col = 0;
                }
            }
        }
        if (stpos >= 0 && stpos < limit) {
            CommentLine cl = new CommentLine(col, stpos, endpos - stpos, body);
            if (tail == null) {
                root = cl;
            } else {
                tail.next = cl;
            }
        }
        if (root == null) {
            return;
        }
        int minStartColumn = 99999;
        CommentLine cl = root;
        while (cl != null) {
            if (cl.length > 0 && cl.startColumn < minStartColumn) {
                minStartColumn = cl.startColumn;
            }
            cl = cl.next;
        }
        cl = root;
        while (cl != null) {
            if (cl.length > 0) {
                cl.startColumn -= minStartColumn;
            }
            cl = cl.next;
        }
        boolean docComment = comment.isDocComment();
        int style = docComment ? 0 : (root.next == null ? 1 : 0);
        boolean start = true;
        int leftMargin = this.out.leftMargin;
        if (appendOnly) {
            return;
        }
        switch (style) {
            case 0: {
                this.out.toColExactly(leftMargin);
                this.out.append(docComment ? "/**" : "/*");
                CommentLine cl2 = root;
                while (cl2 != null) {
                    this.out.toColExactly(leftMargin + 1);
                    this.out.append("*");
                    cl2.print(leftMargin + 3);
                    this.out.nlTerm();
                    cl2 = cl2.next;
                }
                this.out.toColExactly(leftMargin + 1);
                this.out.append("*/");
                this.out.nlTerm();
                break;
            }
            case 1: {
                CommentLine cl3 = root;
                while (cl3 != null) {
                    this.out.toColExactly(leftMargin);
                    this.out.append(start && docComment ? "//*" : "//");
                    start = false;
                    cl3.print(leftMargin + 3);
                    this.out.nlTerm();
                    cl3 = cl3.next;
                }
                break;
            }
        }
        this.out.nlTerm();
        this.out.toLeftMargin();
    }

    private void wrap(String s, CodeStyle.WrapStyle wrapStyle) {
        switch (wrapStyle) {
            case WRAP_IF_LONG: {
                if (s.length() + this.out.col + 1 <= this.cs.getRightMargin()) {
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                this.print(' ');
            }
        }
        this.print(s);
    }

    private <T extends JCTree> void wrapTrees(List<T> trees, CodeStyle.WrapStyle wrapStyle, int wrapIndent) {
        boolean first = true;
        List<Object> l = trees;
        while (l.nonEmpty()) {
            if (!first) {
                this.print(this.cs.spaceBeforeComma() ? " ," : ",");
                switch (wrapStyle) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        if (this.widthEstimator.estimateWidth((JCTree)l.head, rm - this.out.col) + this.out.col + 1 <= rm) {
                            if (!this.cs.spaceAfterComma()) break;
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.toColExactly(wrapIndent);
                        break;
                    }
                    case WRAP_NEVER: {
                        if (!this.cs.spaceAfterComma()) break;
                        this.print(' ');
                    }
                }
            }
            this.printNoParenExpr((JCTree)l.head);
            first = false;
            l = l.tail;
        }
    }

    private Name fullName(JCTree tree) {
        switch (tree.tag) {
            case 35: {
                return ((JCTree.JCIdent)tree).name;
            }
            case 34: {
                JCTree.JCFieldAccess sel = (JCTree.JCFieldAccess)tree;
                Name sname = this.fullName(sel.selected);
                return sname != null && sname.len > 0 ? sname.append('.', sel.name) : sel.name;
            }
        }
        return null;
    }

    private boolean isSynthetic(JCTree tree) {
        return Tree.Kind.METHOD == tree.getKind() && (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) != 0L;
    }

    private boolean isEnumerator(JCTree tree) {
        return tree.tag == 5 && (((JCTree.JCVariableDecl)tree).mods.flags & 0x4000L) != 0L;
    }

    private String replace(String a, String b) {
        a = a.replace(b, this.out.toString());
        this.out.clear();
        return a;
    }

    private class CommentLine {
        private int startColumn;
        private int startPos;
        private int length;
        private String body;
        CommentLine next;

        CommentLine(int sc, int sp, int l, String b) {
            this.length = l;
            if (this.length == 0) {
                this.startColumn = 0;
                this.startPos = 0;
            } else {
                this.startColumn = sc;
                this.startPos = sp;
            }
            this.body = b;
        }

        public void print(int col) {
            if (this.length > 0) {
                VeryPretty.this.out.toCol(col);
                int limit = this.startPos + this.length;
                for (int i = this.startPos; i < limit; ++i) {
                    VeryPretty.this.out.append(this.body.charAt(i));
                }
            }
        }
    }
}

