/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.ComputeDiff;
import org.netbeans.modules.java.source.save.Difference;
import org.netbeans.modules.java.source.save.EstimatorFactory;
import org.netbeans.modules.java.source.save.ListMatcher;
import org.netbeans.modules.java.source.save.Measure;
import org.netbeans.modules.java.source.save.PositionEstimator;
import org.netbeans.modules.java.source.save.TokenUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CasualDiff {
    protected ListBuffer<Diff> diffs;
    protected CommentHandler comments;
    protected JCTree.JCCompilationUnit oldTopLevel;
    private WorkingCopy workingCopy;
    private TokenSequence<JavaTokenId> tokenSequence;
    private String origText;
    private VeryPretty printer;
    private Context context;
    private Map<Integer, String> diffInfo = new HashMap<Integer, String>();
    private Name origClassName = null;
    boolean anonClass = false;
    private static final EnumSet<Tree.Kind> compAssign = EnumSet.of(Tree.Kind.MULTIPLY_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    private static final EnumSet<Tree.Kind> binaries = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR});
    private static final EnumSet<Tree.Kind> unaries = EnumSet.of(Tree.Kind.POSTFIX_INCREMENT, new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT});
    private static boolean logDiffs = false;

    public CasualDiff() {
    }

    protected CasualDiff(Context context, WorkingCopy workingCopy) {
        this.diffs = new ListBuffer();
        this.comments = CommentHandlerService.instance(context);
        this.workingCopy = workingCopy;
        this.tokenSequence = workingCopy.getTokenHierarchy().tokenSequence();
        this.origText = workingCopy.getText();
        this.context = context;
        this.printer = new VeryPretty(context);
    }

    public List<Diff> getDiffs() {
        return this.diffs.toList();
    }

    public static List<Diff> diff(Context context, WorkingCopy copy, JCTree oldTree, JCTree newTree) {
        CasualDiff td = new CasualDiff(context, copy);
        td.diffTree(oldTree, newTree, new int[]{-1, -1});
        String resultSrc = td.printer.toString();
        td.makeListMatch(td.workingCopy.getText(), resultSrc);
        JavaSourceAccessor.INSTANCE.getCommandEnvironment(td.workingCopy).setResult(td.diffInfo, "user-info");
        return td.getDiffs();
    }

    private void append(Diff diff) {
        for (Diff d : this.diffs) {
            if (!d.equals(diff)) continue;
            return;
        }
        this.diffs.append(diff);
    }

    public int endPos(JCTree t) {
        return TreeInfo.getEndPos((JCTree)t, (Map)((Object)this.oldTopLevel.endPositions));
    }

    private int endPos(List<? extends JCTree> trees) {
        int result = -1;
        if (trees.nonEmpty()) {
            result = this.endPos((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                result = this.endPos((JCTree)l.head);
                l = l.tail;
            }
        }
        return result;
    }

    private int endPos(java.util.List<? extends JCTree> trees) {
        if (trees.isEmpty()) {
            return -1;
        }
        return this.endPos(trees.get(trees.size() - 1));
    }

    protected void diffTopLevel(JCTree.JCCompilationUnit oldT, JCTree.JCCompilationUnit newT) {
        int localPointer = 0;
        this.oldTopLevel = oldT;
        localPointer = this.diffPackageStatement(oldT, newT, localPointer);
        PositionEstimator est = EstimatorFactory.imports(oldT.getImports(), newT.getImports(), this.workingCopy);
        localPointer = this.diffListImports(oldT.getImports(), newT.getImports(), localPointer, est, Measure.DEFAULT, this.printer);
        est = EstimatorFactory.toplevel(oldT.getTypeDecls(), newT.getTypeDecls(), this.workingCopy);
        localPointer = this.diffListImports(oldT.getTypeDecls(), newT.getTypeDecls(), localPointer, est, Measure.MEMBER, this.printer);
        this.printer.print(this.origText.substring(localPointer));
    }

    private ChangeKind getChangeKind(Tree oldT, Tree newT) {
        if (oldT == newT) {
            return ChangeKind.NOCHANGE;
        }
        if (oldT != null && newT != null) {
            return ChangeKind.MODIFY;
        }
        if (oldT != null) {
            return ChangeKind.DELETE;
        }
        return ChangeKind.INSERT;
    }

    private int diffPackageStatement(JCTree.JCCompilationUnit oldT, JCTree.JCCompilationUnit newT, int localPointer) {
        ChangeKind change = this.getChangeKind(oldT.pid, newT.pid);
        switch (change) {
            case NOCHANGE: {
                break;
            }
            case INSERT: {
                this.printer.printPackage(newT.pid);
                break;
            }
            case DELETE: {
                TokenUtilities.movePrevious(this.tokenSequence, oldT.pid.getStartPosition());
                this.copyTo(localPointer, this.tokenSequence.offset());
                TokenUtilities.moveNext(this.tokenSequence, this.endPos(oldT.pid));
                localPointer = this.tokenSequence.offset() + 1;
                break;
            }
            case MODIFY: {
                this.copyTo(localPointer, CasualDiff.getOldPos(oldT.pid));
                localPointer = this.endPos(oldT.pid);
                this.printer.print(newT.pid);
                this.diffInfo.put(CasualDiff.getOldPos(oldT.pid), "Update package statement");
            }
        }
        return localPointer;
    }

    protected int diffImport(JCTree.JCImport oldT, JCTree.JCImport newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] qualBounds = this.getBounds((JCTree)oldT.getQualifiedIdentifier());
        this.copyTo(localPointer, qualBounds[0]);
        localPointer = this.diffTree((JCTree)oldT.getQualifiedIdentifier(), (JCTree)newT.getQualifiedIdentifier(), qualBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffClassDef(JCTree.JCClassDecl oldT, JCTree.JCClassDecl newT, int[] bounds) {
        int localPointer;
        int insertHint = localPointer = bounds[0];
        if (!this.anonClass) {
            PositionEstimator estimator;
            this.tokenSequence.move(oldT.pos);
            this.tokenSequence.moveNext();
            this.tokenSequence.moveNext();
            insertHint = TokenUtilities.moveNext(this.tokenSequence, this.tokenSequence.offset());
            localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, insertHint);
                this.printer.print(newT.name);
                this.diffInfo.put(insertHint, "Change class name");
                localPointer = insertHint += oldT.name.length();
                this.origClassName = oldT.name;
            } else {
                int n = localPointer;
                localPointer = insertHint += oldT.name.length();
                this.copyTo(n, localPointer);
            }
            if (oldT.typarams.nonEmpty() && newT.typarams.nonEmpty()) {
                int n = localPointer;
                localPointer = ((JCTree.JCTypeParameter)oldT.typarams.head).pos;
                this.copyTo(n, localPointer);
            }
            localPointer = this.diffParameterList(oldT.typarams, newT.typarams, oldT.typarams.isEmpty() && newT.typarams.nonEmpty(), localPointer, this.printer);
            if (oldT.typarams.nonEmpty()) {
                insertHint = this.endPos(oldT.typarams.last());
                TokenUtilities.moveFwdToToken(this.tokenSequence, insertHint, JavaTokenId.GT);
                insertHint = this.tokenSequence.offset() + JavaTokenId.GT.fixedText().length();
            }
            switch (this.getChangeKind(oldT.extending, newT.extending)) {
                case NOCHANGE: {
                    insertHint = oldT.extending != null ? this.endPos(oldT.extending) : insertHint;
                    int n = localPointer;
                    localPointer = insertHint;
                    this.copyTo(n, localPointer);
                    break;
                }
                case MODIFY: {
                    this.copyTo(localPointer, CasualDiff.getOldPos(oldT.extending));
                    localPointer = this.diffTree(oldT.extending, newT.extending, this.getBounds(oldT.extending));
                    break;
                }
                case INSERT: {
                    this.copyTo(localPointer, insertHint);
                    this.printer.print(" extends ");
                    this.printer.print(newT.extending);
                    localPointer = insertHint;
                    break;
                }
                case DELETE: {
                    this.copyTo(localPointer, insertHint);
                    localPointer = this.endPos(oldT.extending);
                }
            }
            if (oldT.implementing.isEmpty()) {
                if (oldT.extending != null) {
                    insertHint = this.endPos(oldT.extending);
                }
            } else {
                insertHint = oldT.implementing.iterator().next().getStartPosition();
            }
            long flags = oldT.sym != null ? oldT.sym.flags() : oldT.mods.flags;
            PositionEstimator positionEstimator = estimator = (flags & 0x200L) == 0L ? EstimatorFactory.implementz(oldT.getImplementsClause(), newT.getImplementsClause(), this.workingCopy) : EstimatorFactory.extendz(oldT.getImplementsClause(), newT.getImplementsClause(), this.workingCopy);
            if (!newT.implementing.isEmpty()) {
                this.copyTo(localPointer, insertHint);
            }
            localPointer = this.diffList2(oldT.implementing, newT.implementing, insertHint, estimator);
            insertHint = this.endPos(oldT) - 1;
            insertHint = this.filterHidden(oldT.defs).isEmpty() ? this.endPos(oldT) - 1 : this.filterHidden(oldT.defs).get(0).getStartPosition();
            this.tokenSequence.move(insertHint);
            this.tokenSequence.moveNext();
            insertHint = TokenUtilities.moveBackToToken(this.tokenSequence, insertHint, JavaTokenId.LBRACE) + 1;
        } else {
            insertHint = TokenUtilities.moveFwdToToken(this.tokenSequence, CasualDiff.getOldPos(oldT), JavaTokenId.LBRACE);
            this.tokenSequence.moveNext();
            insertHint = this.tokenSequence.offset();
        }
        int old = this.printer.indent();
        Name origName = this.printer.enclClassName;
        this.printer.enclClassName = newT.getSimpleName();
        PositionEstimator est = EstimatorFactory.members(this.filterHidden(oldT.defs), this.filterHidden(newT.defs), this.workingCopy);
        if (localPointer < insertHint) {
            this.copyTo(localPointer, insertHint);
        }
        if ((localPointer = this.diffListImports(this.filterHidden(oldT.defs), this.filterHidden(newT.defs), insertHint, est, Measure.MEMBER, this.printer)) != -1) {
            this.copyTo(localPointer, bounds[1]);
        }
        this.printer.enclClassName = origName;
        this.origClassName = null;
        this.printer.undent(old);
        return bounds[1];
    }

    private boolean hasModifiers(JCTree.JCModifiers mods) {
        return mods != null && (!mods.getFlags().isEmpty() || !((List)mods.getAnnotations()).isEmpty());
    }

    protected int diffMethodDef(JCTree.JCMethodDecl oldT, JCTree.JCMethodDecl newT, int[] bounds) {
        int pos;
        int localPointer = bounds[0];
        if (!this.matchModifiers(oldT.mods, newT.mods)) {
            if (this.hasModifiers(newT.mods)) {
                localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            } else {
                int oldPos = CasualDiff.getOldPos(oldT.mods);
                this.copyTo(localPointer, oldPos);
                int n = localPointer = oldT.restype != null ? CasualDiff.getOldPos(oldT.restype) : oldT.pos;
            }
        }
        int n = oldT.typarams.isEmpty() ? (oldT.restype != null ? CasualDiff.getOldPos(oldT.restype) : oldT.pos) : (pos = CasualDiff.getOldPos((JCTree)oldT.typarams.head));
        if (!this.listsMatch(oldT.typarams, newT.typarams)) {
            if (newT.typarams.nonEmpty()) {
                this.copyTo(localPointer, pos);
            } else if (this.hasModifiers(oldT.mods)) {
                this.copyTo(localPointer, this.endPos(oldT.mods));
            }
            localPointer = this.diffParameterList(oldT.typarams, newT.typarams, oldT.typarams.isEmpty() || newT.typarams.isEmpty(), pos, this.printer);
        }
        if (oldT.restype != null) {
            int[] restypeBounds = this.getBounds(oldT.restype);
            this.copyTo(localPointer, restypeBounds[0]);
            int n2 = localPointer = this.diffTree(oldT.restype, newT.restype, restypeBounds);
            localPointer = restypeBounds[1];
            this.copyTo(n2, localPointer);
        }
        int posHint = oldT.typarams.isEmpty() ? (oldT.restype != null ? oldT.restype.getStartPosition() : oldT.getStartPosition()) : oldT.typarams.iterator().next().getStartPosition();
        if (!oldT.sym.isConstructor() || this.origClassName != null) {
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, oldT.pos);
                if (oldT.sym.isConstructor() && this.origClassName != null) {
                    this.printer.print(newT.name);
                    localPointer = oldT.pos + this.origClassName.length();
                } else {
                    this.printer.print(newT.name);
                    this.diffInfo.put(oldT.pos, "Rename method " + oldT.name);
                    localPointer = oldT.pos + oldT.name.length();
                }
            } else {
                int n3 = localPointer;
                localPointer = oldT.pos + oldT.name.length();
                this.copyTo(n3, localPointer);
            }
        }
        if (oldT.params.isEmpty()) {
            int startOffset = oldT.restype != null ? oldT.restype.getStartPosition() : oldT.getStartPosition();
            TokenUtilities.moveFwdToToken(this.tokenSequence, startOffset, JavaTokenId.RPAREN);
            posHint = this.tokenSequence.offset();
        } else {
            posHint = oldT.params.iterator().next().getStartPosition();
        }
        if (!this.listsMatch(oldT.params, newT.params)) {
            this.copyTo(localPointer, posHint);
            int old = this.printer.setPrec(0);
            localPointer = this.diffParameterList(oldT.params, newT.params, false, posHint, this.printer);
            this.printer.setPrec(old);
        }
        if (localPointer < posHint) {
            int n4 = localPointer;
            localPointer = posHint;
            this.copyTo(n4, localPointer);
        }
        if (oldT.thrown.isEmpty()) {
            posHint = (oldT.body == null ? this.endPos(oldT) : oldT.body.pos) - 1;
            this.tokenSequence.move(posHint);
            this.tokenSequence.moveNext();
            if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                ++posHint;
            }
        } else {
            posHint = oldT.thrown.iterator().next().getStartPosition();
        }
        int n5 = localPointer;
        localPointer = posHint;
        this.copyTo(n5, localPointer);
        PositionEstimator est = EstimatorFactory.throwz(oldT.getThrows(), newT.getThrows(), this.workingCopy);
        localPointer = this.diffList2(oldT.thrown, newT.thrown, posHint, est);
        if (newT.body == null && oldT.body != null) {
            localPointer = this.endPos(oldT.body);
            this.printer.print(";");
        } else if (oldT.body != null && newT.body != null) {
            int[] bodyBounds = this.getBounds(oldT.body);
            this.copyTo(localPointer, bodyBounds[0]);
            localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffVarDef(JCTree.JCVariableDecl oldT, JCTree.JCVariableDecl newT, int[] bounds) {
        int localPointer = bounds[0];
        if ((oldT.mods.flags & 0x4000L) != 0L) {
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, oldT.pos);
                this.printer.print(newT.name);
                this.diffInfo.put(oldT.pos, "Rename enum constant " + oldT.name);
                localPointer = oldT.pos + oldT.name.length();
            }
            return localPointer;
        }
        if (!this.matchModifiers(oldT.mods, newT.mods)) {
            if (this.hasModifiers(newT.mods)) {
                localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            } else {
                int oldPos = CasualDiff.getOldPos(oldT.mods);
                this.copyTo(localPointer, oldPos);
                localPointer = CasualDiff.getOldPos(oldT.vartype);
            }
        }
        int[] vartypeBounds = this.getBounds(oldT.vartype);
        this.copyTo(localPointer, vartypeBounds[0]);
        localPointer = this.diffTree(oldT.vartype, newT.vartype, vartypeBounds);
        if (this.nameChanged(oldT.name, newT.name)) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, "Rename variable " + oldT.name);
            localPointer = oldT.pos + oldT.name.length();
        }
        if (newT.init != null && oldT.init != null) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT.init);
            this.copyTo(n, localPointer);
            localPointer = this.diffTree(oldT.init, newT.init, new int[]{localPointer, this.endPos(oldT.init)});
        } else {
            if (oldT.init != null && newT.init == null) {
                int pos = CasualDiff.getOldPos(oldT.init);
                this.tokenSequence.move(pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int to = this.tokenSequence.offset();
                this.copyTo(localPointer, to);
                localPointer = this.endPos(oldT.init);
            }
            if (oldT.init == null && newT.init != null) {
                int n = localPointer;
                localPointer = this.endPos(oldT.init);
                this.copyTo(n, localPointer);
                this.printer.print(newT.init);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBlock(JCTree.JCBlock oldT, JCTree.JCBlock newT, int[] blockBounds) {
        int localPointer = blockBounds[0];
        if (oldT.flags != newT.flags) {
            // empty if block
        }
        if (oldT.stats.head != null && ((JCTree.JCStatement)oldT.stats.head).pos == oldT.pos) {
            oldT.stats = oldT.stats.tail;
        }
        if (newT.stats.head != null && ((JCTree.JCStatement)newT.stats.head).pos == oldT.pos) {
            newT.stats = newT.stats.tail;
        }
        PositionEstimator est = EstimatorFactory.statements(oldT.getStatements(), newT.getStatements(), this.workingCopy);
        this.copyTo(localPointer, oldT.pos + 1);
        int old = this.printer.indent();
        Name oldEnclosing = this.printer.enclClassName;
        this.printer.enclClassName = null;
        localPointer = this.diffListImports(oldT.stats, newT.stats, oldT.pos + 1, est, Measure.DEFAULT, this.printer);
        if (localPointer < this.endPos(oldT)) {
            int n = localPointer;
            localPointer = this.endPos(oldT);
            this.copyTo(n, localPointer);
        }
        this.printer.enclClassName = oldEnclosing;
        this.printer.undent(old);
        return localPointer;
    }

    protected int diffDoLoop(JCTree.JCDoWhileLoop oldT, JCTree.JCDoWhileLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffWhileLoop(JCTree.JCWhileLoop oldT, JCTree.JCWhileLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condPos = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condPos[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condPos);
        int[] bodyPos = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyPos[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyPos);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffForLoop(JCTree.JCForLoop oldT, JCTree.JCForLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        localPointer = CasualDiff.getOldPos((JCTree)oldT.init.head);
        this.copyTo(bounds[0], localPointer);
        int n = localPointer = this.diffParameterList(oldT.init, newT.init, false, localPointer, this.printer);
        localPointer = CasualDiff.getOldPos(oldT.cond);
        this.copyTo(n, localPointer);
        localPointer = this.diffTree(oldT.cond, newT.cond, this.getBounds(oldT.cond));
        if (oldT.step.nonEmpty()) {
            int n2 = localPointer;
            localPointer = CasualDiff.getOldPos((JCTree)oldT.step.head);
            this.copyTo(n2, localPointer);
        } else {
            int stepListHint = oldT.cond != null ? this.endPos(oldT.cond) + 1 : -2;
            int n3 = localPointer;
            localPointer = stepListHint;
            this.copyTo(n3, localPointer);
        }
        localPointer = this.diffParameterList(oldT.step, newT.step, false, localPointer, this.printer);
        this.copyTo(localPointer, CasualDiff.getOldPos(oldT.body));
        localPointer = this.diffTree(oldT.body, newT.body, this.getBounds(oldT.body));
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffForeachLoop(JCTree.JCEnhancedForLoop oldT, JCTree.JCEnhancedForLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] varBounds = this.getBounds(oldT.var);
        this.copyTo(localPointer, varBounds[0]);
        localPointer = this.diffTree(oldT.var, newT.var, varBounds);
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffLabelled(JCTree.JCLabeledStatement oldT, JCTree.JCLabeledStatement newT, int[] bounds) {
        int localPointer = bounds[0];
        if (this.nameChanged(oldT.label, newT.label)) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT);
            this.copyTo(n, localPointer);
            this.printer.print(newT.label);
            localPointer += oldT.label.length();
        }
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSwitch(JCTree.JCSwitch oldT, JCTree.JCSwitch newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] selectorBounds = this.getBounds(oldT.selector);
        this.copyTo(localPointer, selectorBounds[0]);
        localPointer = this.diffTree(oldT.selector, newT.selector, selectorBounds);
        int castListHint = oldT.cases.size() > 0 ? ((JCTree.JCCase)oldT.cases.head).pos : -2;
        PositionEstimator est = EstimatorFactory.deprecated(oldT.getCases(), newT.getCases(), this.workingCopy);
        this.copyTo(localPointer, castListHint);
        int[] pos = this.diffList(oldT.cases, newT.cases, castListHint, est, Measure.DEFAULT, this.printer);
        this.copyTo(pos[1], bounds[1]);
        return bounds[1];
    }

    protected int diffCase(JCTree.JCCase oldT, JCTree.JCCase newT, int[] bounds) {
        VeryPretty localPrinter;
        PositionEstimator est;
        int pos;
        int[] stmtPos;
        int localPointer = bounds[0];
        if (oldT.pat != null) {
            int[] patBounds = this.getBounds(oldT.pat);
            this.copyTo(localPointer, patBounds[0]);
            localPointer = this.diffTree(oldT.pat, newT.pat, patBounds);
        }
        if (localPointer < (stmtPos = this.diffList(oldT.stats, newT.stats, pos = ((JCTree.JCStatement)oldT.stats.head).pos, est = EstimatorFactory.deprecated(oldT.getStatements(), newT.getStatements(), this.workingCopy), Measure.DEFAULT, localPrinter = new VeryPretty(this.context)))[0]) {
            this.copyTo(localPointer, stmtPos[0]);
        }
        this.printer.print(localPrinter.toString());
        this.copyTo(stmtPos[1], bounds[1]);
        return bounds[1];
    }

    protected int diffSynchronized(JCTree.JCSynchronized oldT, JCTree.JCSynchronized newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lockBounds = this.getBounds(oldT.lock);
        this.copyTo(localPointer, lockBounds[0]);
        localPointer = this.diffTree(oldT.lock, newT.lock, lockBounds);
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTry(JCTree.JCTry oldT, JCTree.JCTry newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] bodyPos = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyPos[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyPos);
        int pos = oldT.catchers.head != null ? CasualDiff.getOldPos((JCTree)oldT.catchers.head) : oldT.body.endpos + 1;
        VeryPretty locPrint = new VeryPretty(this.context);
        PositionEstimator est = EstimatorFactory.deprecated(oldT.getCatches(), newT.getCatches(), this.workingCopy);
        int[] retPos = this.diffList(oldT.catchers, newT.catchers, pos, est, Measure.DEFAULT, locPrint);
        if (localPointer < retPos[0]) {
            this.copyTo(localPointer, retPos[0]);
        }
        this.printer.print(locPrint.toString());
        int n = localPointer = oldT.catchers.head != null ? this.endPos(oldT.catchers) : pos;
        if (oldT.finalizer != null) {
            int[] finalBounds = this.getBounds(oldT.finalizer);
            this.copyTo(localPointer, finalBounds[0]);
            localPointer = this.diffTree(oldT.finalizer, newT.finalizer, finalBounds);
            this.copyTo(localPointer, bounds[1]);
        } else if (retPos[1] < bounds[1]) {
            this.copyTo(localPointer, bounds[1]);
        }
        return bounds[1];
    }

    protected int diffCatch(JCTree.JCCatch oldT, JCTree.JCCatch newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] paramBounds = this.getBounds(oldT.param);
        this.copyTo(localPointer, paramBounds[0]);
        localPointer = this.diffTree(oldT.param, newT.param, paramBounds);
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffConditional(JCTree.JCConditional oldT, JCTree.JCConditional newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
        int[] trueBounds = this.getBounds(oldT.truepart);
        this.copyTo(localPointer, trueBounds[0]);
        localPointer = this.diffTree(oldT.truepart, newT.truepart, trueBounds);
        int[] falseBounds = this.getBounds(oldT.falsepart);
        this.copyTo(localPointer, falseBounds[0]);
        localPointer = this.diffTree(oldT.falsepart, newT.falsepart, falseBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffIf(JCTree.JCIf oldT, JCTree.JCIf newT, int[] bounds) {
        int localPointer = bounds[0];
        if (!(oldT.elsepart == null && newT.elsepart != null || oldT.elsepart != null && newT.elsepart == null)) {
            int[] condBounds = this.getBounds(oldT.cond);
            this.copyTo(localPointer, condBounds[0]);
            localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
            int[] thenpartBounds = this.getBounds(oldT.thenpart);
            this.copyTo(localPointer, thenpartBounds[0]);
            localPointer = this.diffTree(oldT.thenpart, newT.thenpart, thenpartBounds);
            if (oldT.elsepart != null) {
                thenpartBounds = new int[]{CasualDiff.getOldPos(oldT.elsepart), this.endPos(oldT.elsepart)};
                this.copyTo(localPointer, thenpartBounds[0]);
                localPointer = this.diffTree(oldT.elsepart, newT.elsepart, thenpartBounds);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffExec(JCTree.JCExpressionStatement oldT, JCTree.JCExpressionStatement newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBreak(JCTree.JCBreak oldT, JCTree.JCBreak newT, int[] bounds) {
        int localPointer = bounds[0];
        if (this.nameChanged(oldT.label, newT.label)) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT);
            this.copyTo(n, localPointer);
            this.printer.print("break ");
            this.printer.print(newT.label);
            localPointer += 6 + oldT.label.length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffContinue(JCTree.JCContinue oldT, JCTree.JCContinue newT, int[] bounds) {
        int localPointer = bounds[0];
        if (this.nameChanged(oldT.label, newT.label)) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT);
            this.copyTo(n, localPointer);
            this.printer.print("continue ");
            this.printer.print(newT.label);
            localPointer += 9 + oldT.label.length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffReturn(JCTree.JCReturn oldT, JCTree.JCReturn newT, int[] bounds) {
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(bounds[0], exprBounds[0]);
        int localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffThrow(JCTree.JCThrow oldT, JCTree.JCThrow newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssert(JCTree.JCAssert oldT, JCTree.JCAssert newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
        int[] detailBounds = this.getBounds(oldT.detail);
        this.copyTo(localPointer, detailBounds[0]);
        localPointer = this.diffTree(oldT.detail, newT.detail, detailBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffApply(JCTree.JCMethodInvocation oldT, JCTree.JCMethodInvocation newT, int[] bounds) {
        int localPointer = bounds[0];
        this.diffParameterList(oldT.typeargs, newT.typeargs, false, localPointer, this.printer);
        int[] methBounds = this.getBounds(oldT.meth);
        localPointer = this.diffTree(oldT.meth, newT.meth, methBounds);
        if (!this.listsMatch(oldT.args, newT.args)) {
            if (oldT.args.nonEmpty()) {
                int n = localPointer;
                localPointer = CasualDiff.getOldPos((JCTree)oldT.args.head);
                this.copyTo(n, localPointer);
            } else {
                int rParen = TokenUtilities.moveFwdToToken(this.tokenSequence, CasualDiff.getOldPos(oldT.meth), JavaTokenId.RPAREN);
                int n = localPointer;
                localPointer = rParen;
                this.copyTo(n, localPointer);
            }
            localPointer = this.diffParameterList(oldT.args, newT.args, false, localPointer, this.printer);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffNewClass(JCTree.JCNewClass oldT, JCTree.JCNewClass newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.encl != null) {
            int[] enclBounds = this.getBounds(oldT.encl);
            localPointer = this.diffTree(oldT.encl, newT.encl, enclBounds);
        }
        this.diffParameterList(oldT.typeargs, newT.typeargs, false, localPointer, this.printer);
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        if (oldT.args.nonEmpty()) {
            int n = localPointer;
            localPointer = ((JCTree.JCExpression)oldT.args.head).pos;
            this.copyTo(n, localPointer);
        } else {
            TokenUtilities.moveFwdToToken(this.tokenSequence, oldT.pos, JavaTokenId.LPAREN);
            this.tokenSequence.moveNext();
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldT.args, newT.args, false, localPointer, this.printer);
        if (oldT.def != null) {
            this.copyTo(localPointer, CasualDiff.getOldPos(oldT.def));
            if (newT.def != null) {
                this.anonClass = true;
                localPointer = this.diffTree(oldT.def, newT.def, this.getBounds(oldT.def));
                this.anonClass = false;
            } else {
                localPointer = this.endPos(oldT.def);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffNewArray(JCTree.JCNewArray oldT, JCTree.JCNewArray newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.elemtype != null) {
            int[] elemtypeBounds = this.getBounds(oldT.elemtype);
            this.copyTo(localPointer, elemtypeBounds[0]);
            localPointer = this.diffTree(oldT.elemtype, newT.elemtype, elemtypeBounds);
        }
        if (oldT.elems != null && oldT.elems.head != null) {
            this.copyTo(localPointer, CasualDiff.getOldPos((JCTree)oldT.elems.head));
            localPointer = this.diffParameterList(oldT.elems, newT.elems, false, CasualDiff.getOldPos((JCTree)oldT.elems.head), this.printer);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffParens(JCTree.JCParens oldT, JCTree.JCParens newT, int[] bounds) {
        int localPointer = bounds[0];
        this.copyTo(localPointer, CasualDiff.getOldPos(oldT.expr));
        localPointer = this.diffTree(oldT.expr, newT.expr, this.getBounds(oldT.expr));
        return localPointer;
    }

    protected int diffAssign(JCTree.JCAssign oldT, JCTree.JCAssign newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, newT.lhs, lhsBounds);
        int[] rhsBounds = this.getBounds(oldT.rhs);
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssignop(JCTree.JCAssignOp oldT, JCTree.JCAssignOp newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, newT.lhs, lhsBounds);
        if (oldT.tag != newT.tag) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(this.getAssignementOperator(newT));
            localPointer = oldT.pos + this.getAssignementOperator(oldT).length();
        }
        int[] rhsBounds = this.getBounds(oldT.rhs);
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    String getAssignementOperator(Tree t) {
        switch (t.getKind()) {
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case DIVIDE_ASSIGNMENT: {
                return "/=";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
        }
        throw new IllegalArgumentException("Illegal kind " + (Object)((Object)t.getKind()));
    }

    protected int diffUnary(JCTree.JCUnary oldT, JCTree.JCUnary newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] argBounds = this.getBounds(oldT.arg);
        this.copyTo(localPointer, argBounds[0]);
        localPointer = this.diffTree(oldT.arg, newT.arg, argBounds);
        if (oldT.tag != newT.tag) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(this.operatorName(newT.tag));
            localPointer = oldT.pos + this.operatorName(oldT.tag).length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBinary(JCTree.JCBinary oldT, JCTree.JCBinary newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, newT.lhs, lhsBounds);
        if (oldT.tag != newT.tag) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(this.operatorName(newT.tag));
            localPointer = oldT.pos + this.operatorName(oldT.tag).toString().length();
        }
        int[] rhsBounds = this.getBounds(oldT.rhs);
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    private String operatorName(int tag) {
        return new Pretty(null, false).operatorName(tag);
    }

    protected int diffTypeCast(JCTree.JCTypeCast oldT, JCTree.JCTypeCast newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeTest(JCTree.JCInstanceOf oldT, JCTree.JCInstanceOf newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffIndexed(JCTree.JCArrayAccess oldT, JCTree.JCArrayAccess newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] indexedBounds = this.getBounds(oldT.indexed);
        this.copyTo(localPointer, indexedBounds[0]);
        localPointer = this.diffTree(oldT.indexed, newT.indexed, indexedBounds);
        int[] indexBounds = this.getBounds(oldT.index);
        this.copyTo(localPointer, indexBounds[0]);
        localPointer = this.diffTree(oldT.index, newT.index, indexBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSelect(JCTree.JCFieldAccess oldT, JCTree.JCFieldAccess newT, int[] bounds) {
        int localPointer = bounds[0];
        this.copyTo(localPointer, CasualDiff.getOldPos(oldT.selected));
        localPointer = this.diffTree(oldT.selected, newT.selected, this.getBounds(oldT.selected));
        if (this.nameChanged(oldT.name, newT.name)) {
            this.copyTo(localPointer, this.endPos(oldT.selected));
            this.printer.print(".");
            this.printer.print(newT.name);
            this.diffInfo.put(this.endPos(oldT.selected) + 1, "Update reference to " + oldT.name);
            localPointer = this.endPos(oldT.selected) + 1 + oldT.name.length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffIdent(JCTree.JCIdent oldT, JCTree.JCIdent newT, int lastPrinted) {
        if (this.nameChanged(oldT.name, newT.name)) {
            this.copyTo(lastPrinted, oldT.pos);
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, "Update reference to " + oldT.name);
            return this.endPos(oldT);
        }
        return lastPrinted;
    }

    protected int diffLiteral(JCTree.JCLiteral oldT, JCTree.JCLiteral newT, int[] bounds) {
        if (oldT.typetag != newT.typetag || !oldT.value.equals(newT.value)) {
            int localPointer = bounds[0];
            int[] literalBounds = this.getBounds(oldT);
            this.copyTo(localPointer, literalBounds[0]);
            this.printer.print(newT);
            this.copyTo(literalBounds[1], bounds[1]);
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffTypeIdent(JCTree.JCPrimitiveTypeTree oldT, JCTree.JCPrimitiveTypeTree newT, int[] bounds) {
        if (oldT.typetag != newT.typetag) {
            this.printer.print(newT);
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffTypeArray(JCTree.JCArrayTypeTree oldT, JCTree.JCArrayTypeTree newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] elemtypeBounds = this.getBounds(oldT.elemtype);
        localPointer = this.diffTree(oldT.elemtype, newT.elemtype, elemtypeBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeApply(JCTree.JCTypeApply oldT, JCTree.JCTypeApply newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        if (!this.listsMatch(oldT.arguments, newT.arguments)) {
            int pos;
            int n = pos = oldT.arguments.nonEmpty() ? CasualDiff.getOldPos((JCTree)oldT.arguments.head) : this.endPos(oldT.clazz);
            if (newT.arguments.nonEmpty()) {
                this.copyTo(localPointer, pos);
            }
            localPointer = this.diffParameterList(oldT.arguments, newT.arguments, oldT.arguments.isEmpty() || newT.arguments.isEmpty(), pos, this.printer);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeParameter(JCTree.JCTypeParameter oldT, JCTree.JCTypeParameter newT, int[] bounds) {
        int localPointer = bounds[0];
        this.copyTo(localPointer, CasualDiff.getOldPos(oldT));
        if (this.nameChanged(oldT.name, newT.name)) {
            this.printer.print(newT.name);
            localPointer += oldT.name.length();
        }
        if (!this.listsMatch(oldT.bounds, newT.bounds)) {
            int pos;
            PositionEstimator est = EstimatorFactory.implementz(oldT.getBounds(), newT.getBounds(), this.workingCopy);
            int n = pos = oldT.bounds.nonEmpty() ? CasualDiff.getOldPos((JCTree)oldT.bounds.head) : -1;
            if (pos > -1) {
                this.copyTo(localPointer, pos);
                localPointer = this.diffList2(oldT.bounds, newT.bounds, pos, est);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffWildcard(JCTree.JCWildcard oldT, JCTree.JCWildcard newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.kind != newT.kind) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(((BoundKind)((Object)newT.kind)).toString());
            localPointer = oldT.pos + ((BoundKind)((Object)oldT.kind)).toString().length();
        }
        int[] innerBounds = this.getBounds(oldT.inner);
        this.copyTo(localPointer, innerBounds[0]);
        localPointer = this.diffTree(oldT.inner, newT.inner, innerBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeBoundKind(JCTree.TypeBoundKind oldT, JCTree.TypeBoundKind newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.kind != newT.kind) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.kind.toString());
            localPointer = oldT.pos + oldT.kind.toString().length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAnnotation(JCTree.JCAnnotation oldT, JCTree.JCAnnotation newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] annotationBounds = this.getBounds(oldT.annotationType);
        this.copyTo(localPointer, annotationBounds[0]);
        localPointer = this.diffTree(oldT.annotationType, newT.annotationType, annotationBounds);
        if (oldT.args.nonEmpty()) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos((JCTree)oldT.args.head);
            this.copyTo(n, localPointer);
        } else {
            int n = localPointer;
            localPointer = this.endPos(oldT) - 1;
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldT.args, newT.args, false, localPointer, this.printer);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffModifiers(JCTree.JCModifiers oldT, JCTree.JCModifiers newT, JCTree parent, int lastPrinted) {
        int oldPos;
        int localPointer = lastPrinted;
        if (oldT == newT) {
            return localPointer;
        }
        int result = this.endPos(oldT.annotations);
        int n = oldPos = oldT.pos != -1 ? CasualDiff.getOldPos(oldT) : CasualDiff.getOldPos(parent);
        if (this.listsMatch(oldT.annotations, newT.annotations)) {
            int n2 = localPointer;
            localPointer = oldPos;
            this.copyTo(n2, localPointer);
            if (result > 0) {
                int n3 = localPointer;
                localPointer = result;
                this.copyTo(n3, localPointer);
            }
        } else {
            this.copyTo(localPointer, oldPos);
            PositionEstimator est = EstimatorFactory.annotations(oldT.getAnnotations(), newT.getAnnotations(), this.workingCopy);
            int[] res = this.diffList(oldT.annotations, newT.annotations, oldPos, est, Measure.DEFAULT, this.printer);
            localPointer = res[1];
        }
        if (oldT.flags != newT.flags) {
            int endPos = this.endPos(oldT);
            if (endPos > 0) {
                this.printer.print(newT.toString().trim());
                localPointer = endPos;
            } else {
                this.printer.print(newT.toString());
            }
        }
        if (this.endPos(oldT) > 0) {
            int n4 = localPointer;
            localPointer = this.endPos(oldT);
            this.copyTo(n4, localPointer);
        }
        return localPointer;
    }

    protected void diffLetExpr(JCTree.LetExpr oldT, JCTree.LetExpr newT) {
    }

    protected void diffErroneous(JCTree.JCErroneous oldT, JCTree.JCErroneous newT) {
    }

    protected int diffFieldGroup(FieldGroupTree oldT, FieldGroupTree newT, int[] bounds) {
        if (!this.listsMatch(oldT.getVariables(), newT.getVariables())) {
            this.copyTo(bounds[0], oldT.getStartPosition());
            return this.diffParameterList(oldT.getVariables(), newT.getVariables(), false, oldT.getStartPosition(), this.printer);
        }
        return oldT.endPos();
    }

    protected boolean listContains(java.util.List<? extends JCTree> list, JCTree tree) {
        for (JCTree jCTree : list) {
            if (!this.treesMatch(jCTree, tree)) continue;
            return true;
        }
        return false;
    }

    protected boolean treesMatch(JCTree t1, JCTree t2) {
        return this.treesMatch(t1, t2, true);
    }

    public boolean treesMatch(JCTree t1, JCTree t2, boolean deepMatch) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.tag != t2.tag) {
            return false;
        }
        if (!deepMatch) {
            return true;
        }
        switch (t1.tag) {
            case 1: {
                return ((JCTree.JCCompilationUnit)t1).sourcefile.equals(((JCTree.JCCompilationUnit)t2).sourcefile);
            }
            case 2: {
                return this.matchImport((JCTree.JCImport)t1, (JCTree.JCImport)t2);
            }
            case 3: {
                return ((JCTree.JCClassDecl)t1).sym == ((JCTree.JCClassDecl)t2).sym;
            }
            case 4: {
                return ((JCTree.JCMethodDecl)t1).sym == ((JCTree.JCMethodDecl)t2).sym;
            }
            case 5: {
                return ((JCTree.JCVariableDecl)t1).sym == ((JCTree.JCVariableDecl)t2).sym;
            }
            case 6: {
                return true;
            }
            case 7: {
                return this.matchBlock((JCTree.JCBlock)t1, (JCTree.JCBlock)t2);
            }
            case 8: {
                return this.matchDoLoop((JCTree.JCDoWhileLoop)t1, (JCTree.JCDoWhileLoop)t2);
            }
            case 9: {
                return this.matchWhileLoop((JCTree.JCWhileLoop)t1, (JCTree.JCWhileLoop)t2);
            }
            case 10: {
                return this.matchForLoop((JCTree.JCForLoop)t1, (JCTree.JCForLoop)t2);
            }
            case 11: {
                return this.matchForeachLoop((JCTree.JCEnhancedForLoop)t1, (JCTree.JCEnhancedForLoop)t2);
            }
            case 12: {
                return this.matchLabelled((JCTree.JCLabeledStatement)t1, (JCTree.JCLabeledStatement)t2);
            }
            case 13: {
                return this.matchSwitch((JCTree.JCSwitch)t1, (JCTree.JCSwitch)t2);
            }
            case 14: {
                return this.matchCase((JCTree.JCCase)t1, (JCTree.JCCase)t2);
            }
            case 15: {
                return this.matchSynchronized((JCTree.JCSynchronized)t1, (JCTree.JCSynchronized)t2);
            }
            case 16: {
                return this.matchTry((JCTree.JCTry)t1, (JCTree.JCTry)t2);
            }
            case 17: {
                return this.matchCatch((JCTree.JCCatch)t1, (JCTree.JCCatch)t2);
            }
            case 18: {
                return this.matchConditional((JCTree.JCConditional)t1, (JCTree.JCConditional)t2);
            }
            case 19: {
                return this.matchIf((JCTree.JCIf)t1, (JCTree.JCIf)t2);
            }
            case 20: {
                return this.treesMatch(((JCTree.JCExpressionStatement)t1).expr, ((JCTree.JCExpressionStatement)t2).expr);
            }
            case 21: {
                return this.matchBreak((JCTree.JCBreak)t1, (JCTree.JCBreak)t2);
            }
            case 22: {
                return this.matchContinue((JCTree.JCContinue)t1, (JCTree.JCContinue)t2);
            }
            case 23: {
                return this.treesMatch(((JCTree.JCReturn)t1).expr, ((JCTree.JCReturn)t2).expr);
            }
            case 24: {
                return this.treesMatch(((JCTree.JCThrow)t1).expr, ((JCTree.JCThrow)t2).expr);
            }
            case 25: {
                return this.matchAssert((JCTree.JCAssert)t1, (JCTree.JCAssert)t2);
            }
            case 26: {
                return this.matchApply((JCTree.JCMethodInvocation)t1, (JCTree.JCMethodInvocation)t2);
            }
            case 27: {
                if (((JCTree.JCNewClass)t2).def != null) {
                    ((JCTree.JCNewClass)t2).def.sym = null;
                }
                return this.matchNewClass((JCTree.JCNewClass)t1, (JCTree.JCNewClass)t2);
            }
            case 28: {
                return this.matchNewArray((JCTree.JCNewArray)t1, (JCTree.JCNewArray)t2);
            }
            case 29: {
                return this.treesMatch(((JCTree.JCParens)t1).expr, ((JCTree.JCParens)t2).expr);
            }
            case 30: {
                return this.matchAssign((JCTree.JCAssign)t1, (JCTree.JCAssign)t2);
            }
            case 31: {
                return this.matchTypeCast((JCTree.JCTypeCast)t1, (JCTree.JCTypeCast)t2);
            }
            case 32: {
                return this.matchTypeTest((JCTree.JCInstanceOf)t1, (JCTree.JCInstanceOf)t2);
            }
            case 33: {
                return this.matchIndexed((JCTree.JCArrayAccess)t1, (JCTree.JCArrayAccess)t2);
            }
            case 34: {
                return this.matchSelect((JCTree.JCFieldAccess)t1, (JCTree.JCFieldAccess)t2);
            }
            case 35: {
                return ((JCTree.JCIdent)t1).getName().contentEquals(((JCTree.JCIdent)t2).getName());
            }
            case 36: {
                return this.matchLiteral((JCTree.JCLiteral)t1, (JCTree.JCLiteral)t2);
            }
            case 37: {
                return ((JCTree.JCPrimitiveTypeTree)t1).typetag == ((JCTree.JCPrimitiveTypeTree)t2).typetag;
            }
            case 38: {
                return this.treesMatch(((JCTree.JCArrayTypeTree)t1).elemtype, ((JCTree.JCArrayTypeTree)t2).elemtype);
            }
            case 39: {
                return this.matchTypeApply((JCTree.JCTypeApply)t1, (JCTree.JCTypeApply)t2);
            }
            case 40: {
                return this.matchTypeParameter((JCTree.JCTypeParameter)t1, (JCTree.JCTypeParameter)t2);
            }
            case 41: {
                return this.matchWildcard((JCTree.JCWildcard)t1, (JCTree.JCWildcard)t2);
            }
            case 42: {
                return ((JCTree.TypeBoundKind)t1).kind == ((JCTree.TypeBoundKind)t2).kind;
            }
            case 43: {
                return this.matchAnnotation((JCTree.JCAnnotation)t1, (JCTree.JCAnnotation)t2);
            }
            case 91: {
                return this.matchLetExpr((JCTree.LetExpr)t1, (JCTree.LetExpr)t2);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return this.matchUnary((JCTree.JCUnary)t1, (JCTree.JCUnary)t2);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.matchBinary((JCTree.JCBinary)t1, (JCTree.JCBinary)t2);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.matchAssignop((JCTree.JCAssignOp)t1, (JCTree.JCAssignOp)t2);
            }
        }
        String msg = t1.getKind().toString() + " " + t1.getClass().getName();
        throw new AssertionError((Object)msg);
    }

    protected boolean nameChanged(Name oldName, Name newName) {
        byte[] arr2;
        if (oldName == newName) {
            return false;
        }
        byte[] arr1 = oldName.toUtf();
        int len = arr1.length;
        if (len != (arr2 = newName.toUtf()).length) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return true;
        }
        return false;
    }

    private JCTree safeNext(Iterator<? extends JCTree> iter) {
        return iter.hasNext() ? iter.next() : null;
    }

    protected int diffList2(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, int initialPos, PositionEstimator estimator) {
        if (oldList == newList) {
            return initialPos;
        }
        assert (oldList != null && newList != null);
        int lastOldPos = initialPos;
        ListMatcher<? extends JCTree> matcher = ListMatcher.instance(oldList, newList);
        if (!matcher.match()) {
            return initialPos;
        }
        Iterator<? extends JCTree> oldIter = oldList.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] result = matcher.getTransformedResult();
        ListMatcher.Separator s = matcher.separatorInstance();
        s.compute();
        int[][] matrix = estimator.getMatrix();
        int testPos = initialPos;
        int i = 0;
        block6: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<? extends JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            testPos += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree oldT = oldIter.next();
                    ++i;
                    this.copyTo(lastOldPos, CasualDiff.getOldPos(oldT));
                    if (this.treesMatch(oldT, (JCTree)item.element, false)) {
                        lastOldPos = this.diffTree(oldT, (JCTree)item.element, this.getBounds(oldT));
                        continue block6;
                    }
                    this.printer.print((JCTree)item.element);
                    lastOldPos = this.endPos(oldT);
                    continue block6;
                }
                case INSERT: {
                    String tail;
                    String prec = s.head(j) ? estimator.head() : (s.prev(j) ? estimator.sep() : null);
                    String string = tail = s.next(j) ? estimator.sep() : null;
                    if (estimator.getIndentString() != null && !estimator.getIndentString().equals(" ")) {
                        prec = prec + estimator.getIndentString();
                    }
                    this.copyTo(lastOldPos, testPos);
                    this.printer.print(prec);
                    this.printer.print((JCTree)item.element);
                    this.printer.print(tail);
                    continue block6;
                }
                case DELETE: {
                    int delta = 0;
                    if (i == 0 && matrix[i + 1][2] != -1 && matrix[i + 1][2] == matrix[i + 1][3]) {
                        ++delta;
                    }
                    int startOffset = this.toOff(s.head(j) || s.prev(j) ? matrix[i][1] : matrix[i][2 + delta]);
                    int endOffset = this.toOff(s.tail(j) || s.next(j) ? matrix[i + 1][2] : matrix[i][4]);
                    assert (startOffset != -1 && endOffset != -1) : "Invalid offset!";
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            testPos += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    lastOldPos = i == 0 && !newList.isEmpty() ? endOffset : this.endPos((JCTree)item.element);
                    JCTree oldT = oldIter.next();
                    ++i;
                    continue block6;
                }
                case NOCHANGE: {
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            testPos += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree oldT = oldIter.next();
                    ++i;
                    int n = lastOldPos;
                    lastOldPos = this.endPos(oldT);
                    this.copyTo(n, lastOldPos);
                }
            }
        }
        return lastOldPos;
    }

    private int toOff(int tokenIndex) {
        if (tokenIndex == -1) {
            return -1;
        }
        this.tokenSequence.moveIndex(tokenIndex);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    private int diffParameterList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, boolean printParen, int pos, VeryPretty buf) {
        assert (oldList != null && newList != null);
        if (oldList == newList || ((Object)oldList).equals(newList)) {
            return pos;
        }
        if (newList.isEmpty()) {
            int endPos = this.endPos(oldList);
            if (printParen) {
                this.tokenSequence.move(endPos);
                TokenUtilities.moveFwdToToken(this.tokenSequence, endPos, JavaTokenId.GT);
                this.tokenSequence.moveNext();
                endPos = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token())) {
                    buf.print(" ");
                }
            }
            return endPos;
        }
        ListMatcher<? extends JCTree> matcher = ListMatcher.instance(oldList, newList);
        if (!matcher.match()) {
            return pos;
        }
        ListMatcher.ResultItem<? extends JCTree>[] result = matcher.getResult();
        if (printParen && oldList.isEmpty()) {
            buf.print(JavaTokenId.LT.fixedText());
        }
        JCTree lastDeleted = null;
        int index = 0;
        block5: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<? extends JCTree> item = result[j];
            switch (item.operation) {
                case INSERT: {
                    if (index++ > 0) {
                        buf.print(",");
                    }
                    if (lastDeleted != null && this.treesMatch(lastDeleted, (JCTree)item.element, false)) {
                        VeryPretty mainPrint = this.printer;
                        this.printer = buf;
                        this.diffTree(lastDeleted, (JCTree)item.element, this.getBounds(lastDeleted));
                        this.printer = mainPrint;
                    } else {
                        buf.print((JCTree)item.element);
                    }
                    lastDeleted = null;
                    continue block5;
                }
                case DELETE: {
                    lastDeleted = (JCTree)item.element;
                    continue block5;
                }
                case NOCHANGE: {
                    if (index++ > 0) {
                        buf.print(",");
                    }
                    int[] bounds = this.getBounds((JCTree)item.element);
                    this.tokenSequence.move(bounds[0]);
                    TokenUtilities.movePrevious(this.tokenSequence, bounds[0]);
                    this.tokenSequence.moveNext();
                    int start = this.tokenSequence.offset();
                    TokenUtilities.moveNext(this.tokenSequence, bounds[1]);
                    int end = this.tokenSequence.offset();
                    this.copyTo(start, end, buf);
                    lastDeleted = null;
                    continue block5;
                }
            }
        }
        if (printParen && oldList.isEmpty()) {
            buf.print(JavaTokenId.GT.fixedText());
            buf.print(" ");
        }
        return oldList.isEmpty() ? pos : this.endPos(oldList);
    }

    private int[] diffList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, int initialPos, PositionEstimator estimator, Measure measure, VeryPretty printer) {
        int[] ret = new int[]{-1, -1};
        if (oldList == newList) {
            return ret;
        }
        assert (oldList != null && newList != null);
        ListMatcher<? extends JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return ret;
        }
        JCTree lastdel = null;
        ListMatcher.ResultItem<? extends JCTree>[] result = matcher.getResult();
        int posHint = initialPos;
        int i = 0;
        block6: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<? extends JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    continue block6;
                }
                case INSERT: {
                    int pos = estimator.getInsertPos(i);
                    String head = "";
                    String tail = "";
                    if (pos < 0 && oldList.isEmpty() && i == 0) {
                        pos = initialPos;
                        StringBuilder aHead = new StringBuilder();
                        StringBuilder aTail = new StringBuilder();
                        pos = estimator.prepare(initialPos, aHead, aTail);
                        if (j + 1 == result.length) {
                            tail = aTail.toString();
                        }
                        head = aHead.toString();
                        posHint = pos;
                        if (ret[0] < 0) {
                            ret[0] = posHint;
                        }
                        if (ret[1] < 0) {
                            ret[1] = posHint;
                        }
                    } else {
                        if (ret[0] < 0) {
                            ret[0] = posHint;
                        }
                        if (ret[1] < 0) {
                            ret[1] = posHint;
                        }
                    }
                    int oldPos = ((JCTree)item.element).getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos((JCTree)item.element) : ((JCTree)item.element).pos;
                    boolean found = false;
                    if (oldPos > 0) {
                        for (JCTree jCTree : oldList) {
                            int oldNodePos = jCTree.getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos(jCTree) : jCTree.pos;
                            if (oldPos != oldNodePos) continue;
                            found = true;
                            VeryPretty oldPrinter = this.printer;
                            int old = oldPrinter.indent();
                            this.printer = new VeryPretty(this.context);
                            this.printer.reset(old);
                            int index = oldList.indexOf(jCTree);
                            int[] poss = estimator.getPositions(index);
                            this.diffTree(jCTree, (JCTree)item.element, poss);
                            printer.print(this.printer.toString());
                            this.printer = oldPrinter;
                            this.printer.undent(old);
                            break;
                        }
                    }
                    if (found) continue block6;
                    if (lastdel != null && this.treesMatch((JCTree)item.element, lastdel, false)) {
                        VeryPretty oldPrinter = this.printer;
                        int n = oldPrinter.indent();
                        this.printer = new VeryPretty(this.context);
                        this.printer.reset(n);
                        int index = oldList.indexOf(lastdel);
                        int[] poss = estimator.getPositions(index);
                        this.diffTree(lastdel, (JCTree)item.element, poss);
                        printer.print(this.printer.toString());
                        this.printer = oldPrinter;
                        this.printer.undent(n);
                        continue block6;
                    }
                    if (j == 0 && !oldList.isEmpty()) {
                        posHint = estimator.getPositions(0)[0];
                    }
                    printer.print(head);
                    printer.print((JCTree)item.element);
                    printer.newline();
                    continue block6;
                }
                case DELETE: {
                    int[] pos = estimator.getPositions(i);
                    lastdel = oldList.get(i);
                    if (ret[0] < 0) {
                        ret[0] = pos[0];
                    }
                    ++i;
                    ret[1] = pos[1];
                    posHint = pos[1];
                    continue block6;
                }
                case NOCHANGE: {
                    int[] pos = estimator.getPositions(i);
                    if (ret[0] < 0) {
                        ret[0] = pos[0];
                    }
                    this.copyTo(pos[0], pos[1], printer);
                    ret[1] = pos[1];
                    ++i;
                    continue block6;
                }
            }
        }
        if (!oldList.isEmpty()) {
            Iterator<? extends JCTree> it = oldList.iterator();
            i = 0;
            while (it.hasNext()) {
                ++i;
                it.next();
            }
            int[] pos = estimator.getPositions(i);
            ret[1] = pos[1];
        }
        return ret;
    }

    private java.util.List<JCTree> filterHidden(java.util.List<JCTree> list) {
        ArrayList<JCTree> result = new ArrayList<JCTree>();
        ArrayList<JCTree.JCVariableDecl> fieldGroup = new ArrayList<JCTree.JCVariableDecl>();
        for (JCTree tree : list) {
            if (Tree.Kind.METHOD == tree.getKind()) {
                if ((((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) != 0L) {
                    continue;
                }
            } else if (Tree.Kind.VARIABLE == tree.getKind()) {
                JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)tree;
                if (this.isCommaSeparated(var)) {
                    fieldGroup.add(var);
                    continue;
                }
            } else if (Tree.Kind.BLOCK == tree.getKind()) {
                JCTree.JCBlock block = (JCTree.JCBlock)tree;
                if (block.stats.isEmpty() && block.pos == -1 && block.flags == 0L) continue;
            }
            if (!fieldGroup.isEmpty()) {
                result.add(new FieldGroupTree(fieldGroup, this));
                fieldGroup = new ArrayList();
            }
            result.add(tree);
        }
        if (!fieldGroup.isEmpty()) {
            result.add(new FieldGroupTree(fieldGroup, this));
        }
        return result;
    }

    private int diffListImports(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, int localPointer, PositionEstimator estimator, Measure measure, VeryPretty printer) {
        if (oldList == newList || ((Object)oldList).equals(newList)) {
            return localPointer;
        }
        assert (oldList != null && newList != null);
        ListMatcher<? extends JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return localPointer;
        }
        JCTree lastdel = null;
        ListMatcher.ResultItem<? extends JCTree>[] result = matcher.getResult();
        if (oldList.isEmpty() && !newList.isEmpty()) {
            StringBuilder aHead = new StringBuilder();
            StringBuilder aTail = new StringBuilder();
            int pos = estimator.prepare(localPointer, aHead, aTail);
            this.copyTo(localPointer, pos, printer);
            printer.print(aHead.toString());
            for (JCTree jCTree : newList) {
                if (LineInsertionType.BEFORE == estimator.lineInsertType()) {
                    printer.newline();
                }
                printer.print(jCTree);
                if (LineInsertionType.AFTER != estimator.lineInsertType()) continue;
                printer.newline();
            }
            printer.print(aTail.toString());
            return pos;
        }
        if (newList.isEmpty() && !oldList.isEmpty()) {
            int[] removalBounds = estimator.sectionRemovalBounds(null);
            this.copyTo(localPointer, removalBounds[0]);
            return removalBounds[1];
        }
        int i = 0;
        int insertPos = estimator.getInsertPos(0);
        if (insertPos > localPointer) {
            int n = localPointer;
            localPointer = estimator.getInsertPos(0);
            this.copyTo(n, localPointer, printer);
        } else {
            insertPos = localPointer;
        }
        block7: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<? extends JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    int[] nArray = estimator.getPositions(i);
                    this.copyTo(localPointer, nArray[0], printer);
                    VeryPretty oldPrinter = this.printer;
                    this.printer = printer;
                    localPointer = this.diffTree(oldList.get(i), (JCTree)item.element, nArray);
                    this.printer = oldPrinter;
                    ++i;
                    continue block7;
                }
                case INSERT: {
                    int n = estimator.getInsertPos(i);
                    int oldPos = ((JCTree)item.element).getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos((JCTree)item.element) : ((JCTree)item.element).pos;
                    boolean found = false;
                    if (oldPos > 0) {
                        for (JCTree jCTree : oldList) {
                            int oldNodePos = jCTree.getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos(jCTree) : jCTree.pos;
                            if (oldPos != oldNodePos) continue;
                            found = true;
                            VeryPretty oldPrinter = this.printer;
                            int old = oldPrinter.indent();
                            this.printer = new VeryPretty(this.context);
                            this.printer.reset(old);
                            int index = oldList.indexOf(jCTree);
                            int[] poss = estimator.getPositions(index);
                            this.diffTree(jCTree, (JCTree)item.element, poss);
                            printer.print(this.printer.toString());
                            this.printer = oldPrinter;
                            this.printer.undent(old);
                            break;
                        }
                    }
                    if (found) continue block7;
                    if (lastdel != null && this.treesMatch((JCTree)item.element, lastdel, false)) {
                        VeryPretty oldPrinter = this.printer;
                        int n2 = oldPrinter.indent();
                        this.printer = new VeryPretty(this.context);
                        this.printer.reset(n2);
                        int index = oldList.indexOf(lastdel);
                        int[] poss = estimator.getPositions(index);
                        this.diffTree(lastdel, (JCTree)item.element, poss);
                        printer.print(this.printer.toString());
                        this.printer = oldPrinter;
                        this.printer.undent(n2);
                        continue block7;
                    }
                    if (LineInsertionType.BEFORE == estimator.lineInsertType()) {
                        printer.newline();
                    }
                    printer.print((JCTree)item.element);
                    if (LineInsertionType.AFTER != estimator.lineInsertType()) continue block7;
                    printer.newline();
                    continue block7;
                }
                case DELETE: {
                    int[] nArray = estimator.getPositions(i);
                    if (localPointer < nArray[0]) {
                        this.copyTo(localPointer, nArray[0], printer);
                    }
                    lastdel = oldList.get(i);
                    ++i;
                    localPointer = nArray[1];
                    continue block7;
                }
                case NOCHANGE: {
                    int[] nArray = estimator.getPositions(i);
                    if (nArray[0] > localPointer && i != 0) {
                        this.copyTo(localPointer, nArray[0], printer);
                    }
                    localPointer = nArray[1];
                    this.copyTo(nArray[0], localPointer, printer);
                    lastdel = null;
                    ++i;
                    continue block7;
                }
            }
        }
        return localPointer;
    }

    protected void diffPrecedingComments(JCTree oldT, JCTree newT) {
        CommentSet cs = this.comments.getComments(newT);
        if (!cs.hasChanges()) {
            return;
        }
        java.util.List<Comment> oldComments = this.comments.getComments(oldT).getPrecedingComments();
        java.util.List<Comment> newComments = cs.getPrecedingComments();
        this.diffCommentLists(oldT, newT, oldComments, newComments, false);
    }

    protected void diffTrailingComments(JCTree oldT, JCTree newT) {
        CommentSet cs = this.comments.getComments(newT);
        if (!cs.hasChanges()) {
            return;
        }
        java.util.List<Comment> oldComments = this.comments.getComments(oldT).getTrailingComments();
        java.util.List<Comment> newComments = cs.getTrailingComments();
        this.diffCommentLists(oldT, newT, oldComments, newComments, true);
    }

    private void diffCommentLists(JCTree oldT, JCTree newT, java.util.List<Comment> oldList, java.util.List<Comment> newList, boolean trailing) {
        int lastPos = CasualDiff.getOldPos(oldT);
        Iterator<Comment> oldIter = oldList.iterator();
        Iterator<Comment> newIter = newList.iterator();
        Comment oldC = this.safeNext(oldIter);
        Comment newC = this.safeNext(newIter);
        while (oldC != null && newC != null) {
            lastPos = oldC.pos();
            if (this.commentsMatch(oldC, newC)) {
                oldC = this.safeNext(oldIter);
                newC = this.safeNext(newIter);
                continue;
            }
            if (!this.listContains(newList, oldC)) {
                if (!this.listContains(oldList, newC)) {
                    this.append(Diff.modify(oldT, newT, oldC, newC));
                    oldC = this.safeNext(oldIter);
                    newC = this.safeNext(newIter);
                    continue;
                }
                this.append(Diff.delete(oldT, newT, oldC));
                oldC = this.safeNext(oldIter);
                continue;
            }
            this.append(Diff.insert(lastPos, oldT, newT, newC, trailing));
            newC = this.safeNext(newIter);
        }
        while (oldC != null) {
            this.append(Diff.delete(oldT, newT, oldC));
            oldC = this.safeNext(oldIter);
        }
        while (newC != null) {
            this.append(Diff.insert(lastPos, oldT, newT, newC, trailing));
            lastPos += newC.endPos() - newC.pos();
            newC = this.safeNext(oldIter);
        }
    }

    private Comment safeNext(Iterator<Comment> iter) {
        return iter.hasNext() ? iter.next() : null;
    }

    private boolean commentsMatch(Comment oldC, Comment newC) {
        if (oldC == null && newC == null) {
            return true;
        }
        if (oldC == null || newC == null) {
            return false;
        }
        return oldC.equals(newC);
    }

    private boolean listContains(java.util.List<Comment> list, Comment comment) {
        for (Comment c : list) {
            if (!c.equals(comment)) continue;
            return true;
        }
        return false;
    }

    private static JCTree leftMostTree(JCTree tree) {
        switch (tree.tag) {
            case 26: {
                return CasualDiff.leftMostTree(((JCTree.JCMethodInvocation)tree).meth);
            }
            case 30: {
                return CasualDiff.leftMostTree(((JCTree.JCAssign)tree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return CasualDiff.leftMostTree(((JCTree.JCAssignOp)tree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return CasualDiff.leftMostTree(((JCTree.JCBinary)tree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl node = (JCTree.JCClassDecl)tree;
                if (node.mods.pos == -1) break;
                return node.mods;
            }
            case 18: {
                return CasualDiff.leftMostTree(((JCTree.JCConditional)tree).cond);
            }
            case 20: {
                return CasualDiff.leftMostTree(((JCTree.JCExpressionStatement)tree).expr);
            }
            case 33: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayAccess)tree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl node = (JCTree.JCMethodDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods;
                }
                if (node.restype != null) {
                    return CasualDiff.leftMostTree(node.restype);
                }
                return node;
            }
            case 34: {
                return CasualDiff.leftMostTree(((JCTree.JCFieldAccess)tree).selected);
            }
            case 39: {
                return CasualDiff.leftMostTree(((JCTree.JCTypeApply)tree).clazz);
            }
            case 38: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayTypeTree)tree).elemtype);
            }
            case 32: {
                return CasualDiff.leftMostTree(((JCTree.JCInstanceOf)tree).expr);
            }
            case 52: 
            case 53: {
                return CasualDiff.leftMostTree(((JCTree.JCUnary)tree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods;
                }
                return CasualDiff.leftMostTree(node.vartype);
            }
            case 1: {
                JCTree.JCCompilationUnit node = (JCTree.JCCompilationUnit)tree;
                assert (node.defs.size() > 0);
                return node.pid != null ? node.pid : (JCTree)node.defs.head;
            }
        }
        return tree;
    }

    private static int getOldPos(JCTree oldT) {
        return TreeInfo.getStartPos(oldT);
    }

    protected int diffTree(JCTree oldT, JCTree newT, int[] elementBounds) {
        if (oldT == null && newT != null) {
            throw new IllegalArgumentException("Null is not allowed in parameters.");
        }
        if (oldT == newT) {
            return elementBounds[0];
        }
        this.diffPrecedingComments(oldT, newT);
        int retVal = -1;
        if (!(oldT.tag == newT.tag || compAssign.contains((Object)oldT.getKind()) && compAssign.contains((Object)newT.getKind()) || binaries.contains((Object)oldT.getKind()) && binaries.contains((Object)newT.getKind()) || unaries.contains((Object)oldT.getKind()) && unaries.contains((Object)newT.getKind()))) {
            this.printer.print(newT);
            return this.endPos(oldT);
        }
        switch (oldT.tag) {
            case 1: {
                this.diffTopLevel((JCTree.JCCompilationUnit)oldT, (JCTree.JCCompilationUnit)newT);
                break;
            }
            case 2: {
                retVal = this.diffImport((JCTree.JCImport)oldT, (JCTree.JCImport)newT, elementBounds);
                break;
            }
            case 3: {
                retVal = this.diffClassDef((JCTree.JCClassDecl)oldT, (JCTree.JCClassDecl)newT, elementBounds);
                break;
            }
            case 4: {
                retVal = this.diffMethodDef((JCTree.JCMethodDecl)oldT, (JCTree.JCMethodDecl)newT, elementBounds);
                break;
            }
            case 5: {
                return this.diffVarDef((JCTree.JCVariableDecl)oldT, (JCTree.JCVariableDecl)newT, elementBounds);
            }
            case 6: {
                break;
            }
            case 7: {
                retVal = this.diffBlock((JCTree.JCBlock)oldT, (JCTree.JCBlock)newT, elementBounds);
                break;
            }
            case 8: {
                retVal = this.diffDoLoop((JCTree.JCDoWhileLoop)oldT, (JCTree.JCDoWhileLoop)newT, elementBounds);
                break;
            }
            case 9: {
                retVal = this.diffWhileLoop((JCTree.JCWhileLoop)oldT, (JCTree.JCWhileLoop)newT, elementBounds);
                break;
            }
            case 10: {
                retVal = this.diffForLoop((JCTree.JCForLoop)oldT, (JCTree.JCForLoop)newT, elementBounds);
                break;
            }
            case 11: {
                retVal = this.diffForeachLoop((JCTree.JCEnhancedForLoop)oldT, (JCTree.JCEnhancedForLoop)newT, elementBounds);
                break;
            }
            case 12: {
                retVal = this.diffLabelled((JCTree.JCLabeledStatement)oldT, (JCTree.JCLabeledStatement)newT, elementBounds);
                break;
            }
            case 13: {
                retVal = this.diffSwitch((JCTree.JCSwitch)oldT, (JCTree.JCSwitch)newT, elementBounds);
                break;
            }
            case 14: {
                retVal = this.diffCase((JCTree.JCCase)oldT, (JCTree.JCCase)newT, elementBounds);
                break;
            }
            case 15: {
                retVal = this.diffSynchronized((JCTree.JCSynchronized)oldT, (JCTree.JCSynchronized)newT, elementBounds);
                break;
            }
            case 16: {
                retVal = this.diffTry((JCTree.JCTry)oldT, (JCTree.JCTry)newT, elementBounds);
                break;
            }
            case 17: {
                retVal = this.diffCatch((JCTree.JCCatch)oldT, (JCTree.JCCatch)newT, elementBounds);
                break;
            }
            case 18: {
                retVal = this.diffConditional((JCTree.JCConditional)oldT, (JCTree.JCConditional)newT, elementBounds);
                break;
            }
            case 19: {
                retVal = this.diffIf((JCTree.JCIf)oldT, (JCTree.JCIf)newT, elementBounds);
                break;
            }
            case 20: {
                retVal = this.diffExec((JCTree.JCExpressionStatement)oldT, (JCTree.JCExpressionStatement)newT, elementBounds);
                break;
            }
            case 21: {
                retVal = this.diffBreak((JCTree.JCBreak)oldT, (JCTree.JCBreak)newT, elementBounds);
                break;
            }
            case 22: {
                retVal = this.diffContinue((JCTree.JCContinue)oldT, (JCTree.JCContinue)newT, elementBounds);
                break;
            }
            case 23: {
                retVal = this.diffReturn((JCTree.JCReturn)oldT, (JCTree.JCReturn)newT, elementBounds);
                break;
            }
            case 24: {
                retVal = this.diffThrow((JCTree.JCThrow)oldT, (JCTree.JCThrow)newT, elementBounds);
                break;
            }
            case 25: {
                retVal = this.diffAssert((JCTree.JCAssert)oldT, (JCTree.JCAssert)newT, elementBounds);
                break;
            }
            case 26: {
                retVal = this.diffApply((JCTree.JCMethodInvocation)oldT, (JCTree.JCMethodInvocation)newT, elementBounds);
                break;
            }
            case 27: {
                retVal = this.diffNewClass((JCTree.JCNewClass)oldT, (JCTree.JCNewClass)newT, elementBounds);
                break;
            }
            case 28: {
                retVal = this.diffNewArray((JCTree.JCNewArray)oldT, (JCTree.JCNewArray)newT, elementBounds);
                break;
            }
            case 29: {
                retVal = this.diffParens((JCTree.JCParens)oldT, (JCTree.JCParens)newT, elementBounds);
                break;
            }
            case 30: {
                retVal = this.diffAssign((JCTree.JCAssign)oldT, (JCTree.JCAssign)newT, elementBounds);
                break;
            }
            case 31: {
                retVal = this.diffTypeCast((JCTree.JCTypeCast)oldT, (JCTree.JCTypeCast)newT, elementBounds);
                break;
            }
            case 32: {
                retVal = this.diffTypeTest((JCTree.JCInstanceOf)oldT, (JCTree.JCInstanceOf)newT, elementBounds);
                break;
            }
            case 33: {
                retVal = this.diffIndexed((JCTree.JCArrayAccess)oldT, (JCTree.JCArrayAccess)newT, elementBounds);
                break;
            }
            case 34: {
                retVal = this.diffSelect((JCTree.JCFieldAccess)oldT, (JCTree.JCFieldAccess)newT, elementBounds);
                break;
            }
            case 35: {
                retVal = this.diffIdent((JCTree.JCIdent)oldT, (JCTree.JCIdent)newT, elementBounds[0]);
                break;
            }
            case 36: {
                retVal = this.diffLiteral((JCTree.JCLiteral)oldT, (JCTree.JCLiteral)newT, elementBounds);
                break;
            }
            case 37: {
                retVal = this.diffTypeIdent((JCTree.JCPrimitiveTypeTree)oldT, (JCTree.JCPrimitiveTypeTree)newT, elementBounds);
                break;
            }
            case 38: {
                retVal = this.diffTypeArray((JCTree.JCArrayTypeTree)oldT, (JCTree.JCArrayTypeTree)newT, elementBounds);
                break;
            }
            case 39: {
                retVal = this.diffTypeApply((JCTree.JCTypeApply)oldT, (JCTree.JCTypeApply)newT, elementBounds);
                break;
            }
            case 40: {
                retVal = this.diffTypeParameter((JCTree.JCTypeParameter)oldT, (JCTree.JCTypeParameter)newT, elementBounds);
                break;
            }
            case 41: {
                retVal = this.diffWildcard((JCTree.JCWildcard)oldT, (JCTree.JCWildcard)newT, elementBounds);
                break;
            }
            case 42: {
                retVal = this.diffTypeBoundKind((JCTree.TypeBoundKind)oldT, (JCTree.TypeBoundKind)newT, elementBounds);
                break;
            }
            case 43: {
                retVal = this.diffAnnotation((JCTree.JCAnnotation)oldT, (JCTree.JCAnnotation)newT, elementBounds);
                break;
            }
            case 91: {
                this.diffLetExpr((JCTree.LetExpr)oldT, (JCTree.LetExpr)newT);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                retVal = this.diffUnary((JCTree.JCUnary)oldT, (JCTree.JCUnary)newT, elementBounds);
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                retVal = this.diffBinary((JCTree.JCBinary)oldT, (JCTree.JCBinary)newT, elementBounds);
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                retVal = this.diffAssignop((JCTree.JCAssignOp)oldT, (JCTree.JCAssignOp)newT, elementBounds);
                break;
            }
            case 45: {
                this.diffErroneous((JCTree.JCErroneous)oldT, (JCTree.JCErroneous)newT);
                break;
            }
            default: {
                if (oldT.getKind() == Tree.Kind.OTHER) {
                    if (!(oldT instanceof FieldGroupTree)) break;
                    return this.diffFieldGroup((FieldGroupTree)oldT, (FieldGroupTree)newT, elementBounds);
                }
                String msg = "Diff not implemented: " + oldT.getKind().toString() + " " + oldT.getClass().getName();
                throw new AssertionError((Object)msg);
            }
        }
        this.diffTrailingComments(oldT, newT);
        return retVal;
    }

    protected boolean listsMatch(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList) {
        if (oldList == newList) {
            return true;
        }
        int n = oldList.size();
        if (newList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.treesMatch(oldList.get(i), newList.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchImport(JCTree.JCImport t1, JCTree.JCImport t2) {
        return t1.staticImport == t2.staticImport && this.treesMatch(t1.qualid, t2.qualid);
    }

    private boolean matchBlock(JCTree.JCBlock t1, JCTree.JCBlock t2) {
        return t1.flags == t2.flags && this.listsMatch(t1.stats, t2.stats);
    }

    private boolean matchDoLoop(JCTree.JCDoWhileLoop t1, JCTree.JCDoWhileLoop t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchWhileLoop(JCTree.JCWhileLoop t1, JCTree.JCWhileLoop t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchForLoop(JCTree.JCForLoop t1, JCTree.JCForLoop t2) {
        return this.listsMatch(t1.init, t2.init) && this.treesMatch(t1.cond, t2.cond) && this.listsMatch(t1.step, t2.step) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchForeachLoop(JCTree.JCEnhancedForLoop t1, JCTree.JCEnhancedForLoop t2) {
        return this.treesMatch(t1.var, t2.var) && this.treesMatch(t1.expr, t2.expr) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchLabelled(JCTree.JCLabeledStatement t1, JCTree.JCLabeledStatement t2) {
        return t1.label == t2.label && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchSwitch(JCTree.JCSwitch t1, JCTree.JCSwitch t2) {
        return this.treesMatch(t1.selector, t2.selector) && this.listsMatch(t1.cases, t2.cases);
    }

    private boolean matchCase(JCTree.JCCase t1, JCTree.JCCase t2) {
        return this.treesMatch(t1.pat, t2.pat) && this.listsMatch(t1.stats, t2.stats);
    }

    private boolean matchSynchronized(JCTree.JCSynchronized t1, JCTree.JCSynchronized t2) {
        return this.treesMatch(t1.lock, t2.lock) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchTry(JCTree.JCTry t1, JCTree.JCTry t2) {
        return this.treesMatch(t1.finalizer, t2.finalizer) && this.listsMatch(t1.catchers, t2.catchers) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchCatch(JCTree.JCCatch t1, JCTree.JCCatch t2) {
        return this.treesMatch(t1.param, t2.param) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchConditional(JCTree.JCConditional t1, JCTree.JCConditional t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.truepart, t2.truepart) && this.treesMatch(t1.falsepart, t2.falsepart);
    }

    private boolean matchIf(JCTree.JCIf t1, JCTree.JCIf t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.thenpart, t2.thenpart) && this.treesMatch(t1.elsepart, t2.elsepart);
    }

    private boolean matchBreak(JCTree.JCBreak t1, JCTree.JCBreak t2) {
        return t1.label == t2.label && this.treesMatch(t1.target, t2.target);
    }

    private boolean matchContinue(JCTree.JCContinue t1, JCTree.JCContinue t2) {
        return t1.label == t2.label && this.treesMatch(t1.target, t2.target);
    }

    private boolean matchAssert(JCTree.JCAssert t1, JCTree.JCAssert t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.detail, t2.detail);
    }

    private boolean matchApply(JCTree.JCMethodInvocation t1, JCTree.JCMethodInvocation t2) {
        return t1.varargsElement == t2.varargsElement && this.listsMatch(t1.typeargs, t2.typeargs) && this.treesMatch(t1.meth, t2.meth) && this.listsMatch(t1.args, t2.args);
    }

    private boolean matchNewClass(JCTree.JCNewClass t1, JCTree.JCNewClass t2) {
        return t1.constructor == t2.constructor && this.treesMatch(t1.getIdentifier(), t2.getIdentifier()) && this.listsMatch(t1.typeargs, t2.typeargs) && this.listsMatch(t1.args, t2.args) && t1.varargsElement == t2.varargsElement && this.treesMatch(t1.def, t2.def);
    }

    private boolean matchNewArray(JCTree.JCNewArray t1, JCTree.JCNewArray t2) {
        return this.treesMatch(t1.elemtype, t2.elemtype) && this.listsMatch(t1.dims, t2.dims) && this.listsMatch(t1.elems, t2.elems);
    }

    private boolean matchAssign(JCTree.JCAssign t1, JCTree.JCAssign t2) {
        return this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchAssignop(JCTree.JCAssignOp t1, JCTree.JCAssignOp t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchUnary(JCTree.JCUnary t1, JCTree.JCUnary t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.arg, t2.arg);
    }

    private boolean matchBinary(JCTree.JCBinary t1, JCTree.JCBinary t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchTypeCast(JCTree.JCTypeCast t1, JCTree.JCTypeCast t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean matchTypeTest(JCTree.JCInstanceOf t1, JCTree.JCInstanceOf t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean matchIndexed(JCTree.JCArrayAccess t1, JCTree.JCArrayAccess t2) {
        return this.treesMatch(t1.indexed, t2.indexed) && this.treesMatch(t1.index, t2.index);
    }

    private boolean matchSelect(JCTree.JCFieldAccess t1, JCTree.JCFieldAccess t2) {
        return this.treesMatch(t1.selected, t2.selected) && t1.sym == t2.sym;
    }

    private boolean matchLiteral(JCTree.JCLiteral t1, JCTree.JCLiteral t2) {
        return t1.typetag == t2.typetag && t1.value == t2.value;
    }

    private boolean matchTypeApply(JCTree.JCTypeApply t1, JCTree.JCTypeApply t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.listsMatch(t1.arguments, t2.arguments);
    }

    private boolean matchTypeParameter(JCTree.JCTypeParameter t1, JCTree.JCTypeParameter t2) {
        return t1.name == t2.name && this.listsMatch(t1.bounds, t2.bounds);
    }

    private boolean matchWildcard(JCTree.JCWildcard t1, JCTree.JCWildcard t2) {
        return t1.kind == t2.kind && this.treesMatch(t1.inner, t2.inner);
    }

    private boolean matchAnnotation(JCTree.JCAnnotation t1, JCTree.JCAnnotation t2) {
        return this.treesMatch(t1.annotationType, t2.annotationType) && this.listsMatch(t1.args, t2.args);
    }

    private boolean matchModifiers(JCTree.JCModifiers t1, JCTree.JCModifiers t2) {
        return t1.flags == t2.flags && this.listsMatch(t1.annotations, t2.annotations);
    }

    private boolean matchLetExpr(JCTree.LetExpr t1, JCTree.LetExpr t2) {
        return this.listsMatch(t1.defs, t2.defs) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean isCommaSeparated(JCTree.JCVariableDecl oldT) {
        if (CasualDiff.getOldPos(oldT) <= 0 || oldT.pos <= 0) {
            return false;
        }
        this.tokenSequence.move(oldT.pos);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
            return true;
        }
        if (oldT.getInitializer() != null && (oldT.mods.flags & 0x4000L) == 0L) {
            this.tokenSequence.move(this.endPos(oldT.getInitializer()));
        } else {
            this.tokenSequence.move(oldT.pos);
            this.tokenSequence.moveNext();
        }
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        return JavaTokenId.COMMA == this.tokenSequence.token().id();
    }

    private int[] getBounds(JCTree tree) {
        return new int[]{CasualDiff.getOldPos(tree), this.endPos(tree)};
    }

    private void copyTo(int from, int to) {
        this.copyTo(from, to, this.printer);
    }

    private void copyTo(int from, int to, VeryPretty loc) {
        if (from == to) {
            return;
        }
        if (from > to || from < 0 || to < 0) {
            throw new IllegalArgumentException("Illegal values: from = " + from + "; to = " + to + ".");
        }
        if (to > this.origText.length()) {
            System.err.println("-----\n" + this.origText + "-----\n");
            throw new IllegalArgumentException("Copying to " + to + " is greater then its size (" + this.origText.length() + ").");
        }
        loc.print(this.origText.substring(from, to));
    }

    private java.util.List<Line> getLines(String text) {
        char[] chars = text.toCharArray();
        ArrayList<Line> list = new ArrayList<Line>();
        int pointer = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            list.add(new Line(new String(chars, pointer, i - pointer + 1), pointer, i + 1));
            pointer = i + 1;
        }
        if (pointer < chars.length) {
            list.add(new Line(new String(chars, pointer, chars.length - pointer), pointer, chars.length));
        }
        return list;
    }

    public java.util.List<Diff> makeListMatch(String text1, String text2) {
        java.util.List<Line> list1 = this.getLines(text1);
        java.util.List<Line> list2 = this.getLines(text2);
        Object[] lines1 = list1.toArray(new Line[list1.size()]);
        Object[] lines2 = list2.toArray(new Line[list2.size()]);
        java.util.List diffs = new ComputeDiff(lines1, lines2).diff();
        for (Object o : diffs) {
            int i;
            StringBuilder builder;
            char type;
            Difference diff = (Difference)o;
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            String from = this.toString(delStart, delEnd);
            String to = this.toString(addStart, addEnd);
            char c = delEnd != -1 && addEnd != -1 ? (char)'c' : (type = delEnd == -1 ? (char)'a' : 'd');
            if (logDiffs) {
                System.out.println(from + type + to);
                if (delEnd != -1) {
                    this.printLines(delStart, delEnd, "<", (Line[])lines1);
                    if (addEnd != -1) {
                        System.out.println("---");
                    }
                }
                if (addEnd != -1) {
                    this.printLines(addStart, addEnd, ">", (Line[])lines2);
                }
            }
            if (type == 'a') {
                builder = new StringBuilder();
                for (i = addStart; i <= addEnd; ++i) {
                    builder.append(((Line)lines2[i]).data);
                }
                this.append(Diff.insert(delEnd == -1 ? (delStart < lines1.length ? ((Line)lines1[delStart]).start : ((Line)lines1[lines1.length - 1]).end) : ((Line)lines1[delEnd]).end, builder.toString()));
                continue;
            }
            if (type == 'd') {
                this.append(Diff.delete(((Line)lines1[delStart]).start, ((Line)lines1[delEnd]).end));
                continue;
            }
            builder = new StringBuilder();
            for (i = delStart; i <= delEnd; ++i) {
                builder.append(((Line)lines1[i]).data);
            }
            String match1 = builder.toString();
            builder = new StringBuilder();
            for (int i2 = addStart; i2 <= addEnd; ++i2) {
                builder.append(((Line)lines2[i2]).data);
            }
            String match2 = builder.toString();
            this.makeTokenListMatch(match1, match2, ((Line)lines1[delStart]).start);
        }
        return null;
    }

    public java.util.List<Diff> makeTokenListMatch(String text1, String text2, int currentPos) {
        String data;
        if (logDiffs) {
            System.out.println("----- token match for change -");
        }
        TokenSequence seq1 = TokenHierarchy.create((CharSequence)text1, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
        TokenSequence seq2 = TokenHierarchy.create((CharSequence)text2, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
        ArrayList<Line> list1 = new ArrayList<Line>();
        ArrayList<Line> list2 = new ArrayList<Line>();
        while (seq1.moveNext()) {
            data = ((Object)seq1.token().text()).toString();
            list1.add(new Line(data, seq1.offset(), seq1.offset() + data.length()));
        }
        while (seq2.moveNext()) {
            data = ((Object)seq2.token().text()).toString();
            list2.add(new Line(data, seq2.offset(), seq2.offset() + data.length()));
        }
        Object[] lines1 = list1.toArray(new Line[list1.size()]);
        Object[] lines2 = list2.toArray(new Line[list2.size()]);
        java.util.List diffs = new ComputeDiff(lines1, lines2).diff();
        for (Object o : diffs) {
            int i;
            StringBuilder builder;
            char type;
            Difference diff = (Difference)o;
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            String from = this.toString(delStart, delEnd);
            String to = this.toString(addStart, addEnd);
            char c = delEnd != -1 && addEnd != -1 ? (char)'c' : (type = delEnd == -1 ? (char)'a' : 'd');
            if (logDiffs) {
                System.out.println(from + type + to);
                if (delEnd != -1) {
                    this.printTokens(delStart, delEnd, "<", (Line[])lines1);
                    if (addEnd != -1) {
                        System.out.println("---");
                    }
                }
                if (addEnd != -1) {
                    this.printTokens(addStart, addEnd, ">", (Line[])lines2);
                }
            }
            if (type == 'a') {
                builder = new StringBuilder();
                for (i = addStart; i <= addEnd; ++i) {
                    builder.append(((Line)lines2[i]).data);
                }
                this.append(Diff.insert(currentPos + (delEnd == -1 ? (delStart < lines1.length ? ((Line)lines1[delStart]).start : ((Line)lines1[lines1.length - 1]).end) : ((Line)lines1[delEnd]).end), builder.toString()));
                continue;
            }
            if (type == 'd') {
                this.append(Diff.delete(currentPos + ((Line)lines1[delStart]).start, currentPos + ((Line)lines1[delEnd]).end));
                continue;
            }
            builder = new StringBuilder();
            this.append(Diff.delete(currentPos + ((Line)lines1[delStart]).start, currentPos + ((Line)lines1[delEnd]).end));
            for (i = addStart; i <= addEnd; ++i) {
                builder.append(((Line)lines2[i]).data);
            }
            this.append(Diff.insert(currentPos + (delEnd == -1 ? ((Line)lines1[delStart]).start : ((Line)lines1[delEnd]).end), builder.toString()));
        }
        if (logDiffs) {
            System.out.println("----- end token match -");
        }
        return null;
    }

    protected String toString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        buf.append(end == -1 ? start : 1 + start);
        if (end != -1 && start != end) {
            buf.append(",").append(1 + end);
        }
        return buf.toString();
    }

    private void printLines(int start, int end, String ind, Line[] lines) {
        for (int lnum = start; lnum <= end; ++lnum) {
            System.out.print(ind + " " + lines[lnum]);
        }
    }

    private void printTokens(int start, int end, String ind, Line[] lines) {
        for (int lnum = start; lnum <= end; ++lnum) {
            System.out.println(ind + " '" + lines[lnum] + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeKind {
        INSERT,
        DELETE,
        MODIFY,
        NOCHANGE;

    }

    public static class Diff {
        protected DiffTypes type;
        int pos;
        int endOffset;
        protected JCTree oldTree;
        protected JCTree newTree;
        protected Comment oldComment;
        protected Comment newComment;
        private String text;
        boolean trailing;

        static Diff delete(JCTree oldTree, JCTree newTree, Comment oldC) {
            return new Diff(DiffTypes.DELETE_COMMENT, oldC.pos(), oldTree, newTree, oldC, null, false);
        }

        static Diff insert(int pos, JCTree oldTree, JCTree newTree, Comment newC, boolean trailing) {
            return new Diff(DiffTypes.INSERT_COMMENT, pos, oldTree, newTree, null, newC, trailing);
        }

        static Diff modify(JCTree oldTree, JCTree newTree, Comment oldC, Comment newC) {
            return new Diff(DiffTypes.MODIFY_COMMENT, oldC.pos(), oldTree, newTree, oldC, newC, false);
        }

        static Diff insert(int pos, String text) {
            return new Diff(DiffTypes.INSERT, pos, -1, text);
        }

        static Diff delete(int startOffset, int endOffset) {
            return new Diff(DiffTypes.DELETE, startOffset, endOffset, null);
        }

        Diff(DiffTypes type, int pos, int endOffset, String text) {
            this.type = type;
            this.pos = pos;
            this.endOffset = endOffset;
            this.text = text;
        }

        Diff(DiffTypes type, int pos, JCTree oldTree, JCTree newTree, Comment oldComment, Comment newComment, boolean trailing) {
            this(type, pos, -1, null);
            assert (pos >= 0) : "invalid source offset";
            this.oldTree = oldTree;
            this.newTree = newTree;
            this.oldComment = oldComment;
            this.newComment = newComment;
            this.trailing = trailing;
        }

        public JCTree getOld() {
            return this.oldTree;
        }

        public JCTree getNew() {
            return this.newTree;
        }

        public int getPos() {
            return this.pos;
        }

        public int getEnd() {
            return this.endOffset;
        }

        public String getText() {
            return this.text;
        }

        public Comment getOldComment() {
            return this.oldComment;
        }

        public Comment getNewComment() {
            return this.newComment;
        }

        public boolean isTrailingComment() {
            return this.trailing;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Diff)) {
                return false;
            }
            Diff d2 = (Diff)obj;
            return this.type != d2.type && this.pos != d2.pos && this.oldTree != d2.oldTree && this.newTree != d2.newTree && this.oldComment != d2.oldComment && this.newComment != d2.newComment && this.trailing != d2.trailing;
        }

        public int hashCode() {
            return this.type.hashCode() + this.pos + (this.oldTree != null ? this.oldTree.hashCode() : 0) + (this.newTree != null ? this.newTree.hashCode() : 0) + (this.oldComment != null ? this.oldComment.hashCode() : 0) + (this.newComment != null ? this.newComment.hashCode() : 0) + Boolean.valueOf(this.trailing).hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("tree (");
            sb.append(this.type.toString());
            sb.append(") pos=");
            sb.append(this.pos);
            if (this.trailing) {
                sb.append(" trailing comment");
            }
            sb.append("\n");
            if (this.type == DiffTypes.DELETE || this.type == DiffTypes.INSERT || this.type == DiffTypes.MODIFY) {
                this.addDiffString(sb, this.oldTree, this.newTree);
            } else {
                this.addDiffString(sb, this.oldComment, this.newComment);
            }
            return sb.toString();
        }

        private void addDiffString(StringBuffer sb, Object o1, Object o2) {
            if (o1 != null) {
                sb.append("< ");
                sb.append(o1.toString());
                sb.append(o2 != null ? "\n---\n> " : "\n");
            } else {
                sb.append("> ");
            }
            if (o2 != null) {
                sb.append(o2.toString());
                sb.append('\n');
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffTypes {
        MODIFY("modify"),
        INSERT("insert"),
        DELETE("delete"),
        MODIFY_COMMENT("modify_comment"),
        INSERT_COMMENT("insert_comment"),
        DELETE_COMMENT("delete_comment");

        public final String name;

        private DiffTypes(String name) {
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldGroupTree
    extends JCTree
    implements Tree {
        java.util.List<JCTree.JCVariableDecl> vars;
        CasualDiff diff;

        public FieldGroupTree(java.util.List<JCTree.JCVariableDecl> vars, CasualDiff diff) {
            super(0);
            this.vars = vars;
            this.diff = diff;
            this.pos = CasualDiff.getOldPos(vars.get(0));
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.OTHER;
        }

        public java.util.List<JCTree.JCVariableDecl> getVariables() {
            return this.vars;
        }

        public int endPos() {
            return this.diff.endPos(this.vars.get(this.vars.size() - 1));
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> arg0, D arg1) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void accept(JCTree.Visitor arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof FieldGroupTree) {
                return ((Object)this.vars).equals(((FieldGroupTree)arg0).getVariables());
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.vars).hashCode();
        }
    }

    private static class Line {
        String data;
        int end;
        int start;

        Line(String data, int start, int end) {
            this.start = start;
            this.end = end;
            this.data = data;
        }

        public String toString() {
            return this.data.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Line) {
                return this.data.equals(((Line)o).data);
            }
            return false;
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineInsertionType {
        BEFORE,
        AFTER,
        NONE;

    }
}

