/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.ExternalModificationException;
import org.netbeans.modules.java.source.engine.ReadOnlyFilesException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.query.Query;
import org.netbeans.modules.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.save.SourceBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Commit
extends Query<Void, Object> {
    boolean displayedError = false;
    Context context;
    Symtab symtab;
    Types types;
    int lastMargin;
    private EngineEnvironment ee;
    private static final int POSITION_OFFSET = 1;
    private ArrayList<String> readOnlyFiles = new ArrayList();
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");
    private WorkingCopy workingCopy;

    public Commit() {
    }

    public Commit(WorkingCopy workingCopy) {
        this();
        this.workingCopy = workingCopy;
    }

    public boolean isEnabled(QueryEnvironment env) {
        return env.getUndoList().getOld(env.getRootNode()) != null;
    }

    @Override
    public void attach(QueryEnvironment env) {
        super.attach(env);
        this.ee = (EngineEnvironment)env;
        this.context = this.ee.getContext();
        this.symtab = this.ee.getSymbolTable();
        this.types = Types.instance(this.context);
    }

    @Override
    public void apply() {
        throw new AssertionError((Object)"use commit() instead");
    }

    public void commit() throws IOException {
        if (this.getOriginalRoot() != this.getRootNode()) {
            this.apply(this.getRootNode());
            if (this.readOnlyFiles.size() > 0) {
                this.throwReadOnlyFilesException();
            }
        }
    }

    private void throwReadOnlyFilesException() throws IOException {
        StringBuffer sb = new StringBuffer();
        for (String s : this.readOnlyFiles) {
            sb.append(s);
            sb.append('\n');
        }
        throw new ReadOnlyFilesException(sb.toString());
    }

    private RootTree getOriginalRoot() {
        RootTree oldRoot;
        RootTree root = (RootTree)this.getRootNode();
        while ((oldRoot = this.env.getUndoList().getOld(root)) != null) {
            root = oldRoot;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Object p) {
        JCTree.JCCompilationUnit topLevel = (JCTree.JCCompilationUnit)node;
        if (!this.isModified(topLevel)) {
            return null;
        }
        SourceRewriter out = null;
        String srcFile = topLevel.sourcefile.toString();
        boolean shouldSave = true;
        try {
            out = ((EngineEnvironment)this.env).getSourceRewriter(node.getSourceFile());
        }
        catch (FileNotFoundException e) {
            logger.warning("couldn't open original file: " + srcFile);
            return null;
        }
        catch (ExternalModificationException e) {
            this.note("source file modified: " + srcFile);
            return null;
        }
        catch (IOException e) {
            logger.warning("couldn't write to original file: " + srcFile);
            this.readOnlyFiles.add(srcFile);
            return null;
        }
        logger.fine("original file: " + srcFile);
        try {
            this.commit(topLevel, out);
        }
        catch (IOException e) {
            this.logError(e, topLevel);
            this.displayedError = true;
            shouldSave = false;
        }
        catch (Throwable err) {
            this.error(err);
        }
        finally {
            block22: {
                if (out != null) {
                    try {
                        out.close(shouldSave);
                    }
                    catch (IOException e) {
                        if (this.displayedError) break block22;
                        this.logError(e, topLevel);
                    }
                }
            }
        }
        return null;
    }

    private void logError(IOException e, JCTree.JCCompilationUnit topLevel) {
        Throwable err = e.getCause() == null ? e : e.getCause();
        err.printStackTrace();
        String msg = "Error writing " + Commit.getSourceFileName(topLevel) + ": " + err;
        try {
            logger.severe(msg);
            msg = null;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (msg != null) {
            this.error(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CompilationUnitTree unit, SourceRewriter out) throws IOException, BadLocationException {
        JCTree.JCCompilationUnit topLevel = (JCTree.JCCompilationUnit)unit;
        CharArrayReader in = null;
        try {
            CasualDiff.Diff d;
            SourceBuffer srcBuffer = new SourceBuffer(topLevel.sourcefile);
            in = new SourceReader(srcBuffer.getChars());
            JCTree.JCCompilationUnit oldTL = (JCTree.JCCompilationUnit)this.getOriginalTree(topLevel);
            List<CasualDiff.Diff> diffs = CasualDiff.diff(this.context, this.workingCopy, oldTL, topLevel);
            VeryPretty pretty = new VeryPretty(this.context);
            List<JCTree> defs = oldTL.defs;
            while (diffs.nonEmpty() && (defs.head == null || ((CasualDiff.Diff)diffs.head).pos < ((JCTree)defs.head).pos || ((CasualDiff.Diff)diffs.head).oldTree instanceof JCTree.JCCompilationUnit)) {
                d = (CasualDiff.Diff)diffs.head;
                if (d.type != CasualDiff.DiffTypes.INSERT_COMMENT && d.type != CasualDiff.DiffTypes.MODIFY_COMMENT && d.type != CasualDiff.DiffTypes.DELETE_COMMENT) break;
                this.applyCommentDiff(d, (SourceReader)in, out, pretty, oldTL, srcBuffer);
                diffs = diffs.tail;
            }
            while (diffs.nonEmpty()) {
                pretty.reset(0);
                d = (CasualDiff.Diff)diffs.head;
                switch (d.type) {
                    case INSERT: {
                        out.copyTo((SourceReader)in, d.getPos());
                        out.writeTo(d.getText());
                        break;
                    }
                    case DELETE: {
                        out.copyTo((SourceReader)in, d.getPos());
                        out.skipThrough((SourceReader)in, d.getEnd());
                        break;
                    }
                    case INSERT_COMMENT: 
                    case MODIFY_COMMENT: 
                    case DELETE_COMMENT: {
                        this.applyCommentDiff(d, (SourceReader)in, out, pretty, oldTL, srcBuffer);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown CasualDiff type: " + (Object)((Object)d.type)));
                    }
                }
                diffs = diffs.tail;
            }
            out.copyRest((SourceReader)in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void applyCommentDiff(CasualDiff.Diff d, SourceReader in, SourceRewriter out, VeryPretty pretty, JCTree.JCCompilationUnit oldTL, SourceBuffer srcBuffer) throws IOException, BadLocationException {
        int pos = d.oldComment != null ? d.oldComment.pos() : this.getOldPos(d.oldTree);
        int endPos = d.oldComment != null ? d.oldComment.endPos() : this.getOldEndPos(d.oldTree, oldTL, srcBuffer);
        out.copyTo(in, pos);
        if (d.type == CasualDiff.DiffTypes.INSERT_COMMENT) {
            out.writeTo(d.newComment.getText());
        } else if (d.type == CasualDiff.DiffTypes.MODIFY_COMMENT) {
            out.skipThrough(in, endPos);
            out.writeTo(d.newComment.getText());
        } else if (d.type == CasualDiff.DiffTypes.DELETE_COMMENT) {
            out.skipThrough(in, endPos);
        }
    }

    static String getSourceFileName(JCTree.JCCompilationUnit topLevel) {
        JCTree.JCClassDecl mainClass = Commit.getMainClassDef(topLevel);
        return mainClass.sym.fullname.toString().replace('.', File.separatorChar) + ".java";
    }

    static JCTree.JCClassDecl getMainClassDef(JCTree.JCCompilationUnit topLevel) {
        List<JCTree> defs = topLevel.defs;
        JCTree.JCClassDecl topClass = null;
        while (defs.nonEmpty()) {
            if (((JCTree)defs.head).tag == 3) {
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)defs.head;
                if ((tree.mods.flags & 1L) != 0L) {
                    return tree;
                }
                topClass = tree;
            }
            defs = defs.tail;
        }
        return topClass;
    }

    int getOldEndPos(JCTree oldT, JCTree.JCCompilationUnit oldTL, SourceBuffer srcbuf) {
        if (oldT == null || oldTL == null) {
            return -2;
        }
        int pos = TreeInfo.getEndPos((JCTree)oldT, (Map)((Object)oldTL.endPositions));
        assert (pos != -2);
        if (oldT.tag == 5 && srcbuf.src[pos - 1] == ';') {
            --pos;
        }
        return pos;
    }

    void setIndent(VeryPretty pretty, int oldStartPos, SourceBuffer srcBuffer) {
        if (oldStartPos != -2) {
            int lineNo = srcBuffer.getLineNumber(oldStartPos);
            char[] line = srcBuffer.getLine(lineNo);
            this.lastMargin = this.getMargin(line);
        }
        pretty.reset(this.lastMargin);
    }

    CompilationUnitTree getOriginalTree(CompilationUnitTree t) {
        RootTree oldRoot = this.getOriginalRoot();
        for (CompilationUnitTree unit : oldRoot.getCompilationUnits()) {
            if (unit.getSourceFile() != t.getSourceFile()) continue;
            return unit;
        }
        return t;
    }

    private int getOldPos(JCTree oldT) {
        return TreeInfo.getStartPos(oldT);
    }

    private int getMargin(char[] line) {
        char c;
        int margin = 0;
        for (int i = 0; i < line.length && ((c = line[i]) == ' ' || c == '\t'); ++i) {
            margin = this.calculateColumn(margin, c);
        }
        return margin;
    }

    private int calculateColumn(int curCol, char ch) {
        if (ch == '\f' || ch == '\n') {
            return 1;
        }
        if (ch == '\t') {
            return (curCol - 1) / 8 * 8 + 8 + 1;
        }
        return curCol + 1;
    }

    public boolean isModified(JCTree.JCCompilationUnit tree) {
        return this.getOriginalTree(tree) != tree;
    }
}

