/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.save.TokenUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PositionEstimator {
    final List<? extends Tree> oldL;
    final List<? extends Tree> newL;
    final WorkingCopy copy;
    boolean initialized;
    final TokenSequence<JavaTokenId> seq;
    int[][] matrix;
    static final EnumSet<JavaTokenId> nonRelevant = EnumSet.of(JavaTokenId.LINE_COMMENT, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.WHITESPACE);

    PositionEstimator(List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
        this.oldL = oldL;
        this.newL = newL;
        this.copy = copy;
        this.seq = copy != null ? copy.getTokenHierarchy().tokenSequence() : null;
        this.initialized = false;
    }

    protected abstract void initialize();

    public abstract int getInsertPos(int var1);

    public abstract int[] getPositions(int var1);

    abstract int prepare(int var1, StringBuilder var2, StringBuilder var3);

    public abstract int[] sectionRemovalBounds(StringBuilder var1);

    public CasualDiff.LineInsertionType lineInsertType() {
        return CasualDiff.LineInsertionType.NONE;
    }

    public abstract String head();

    public abstract String sep();

    public abstract String getIndentString();

    public int[][] getMatrix() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.matrix;
    }

    public void tablePrint(int[][] matrix, TokenSequence seq) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                int item = matrix[i][j];
                String s = "(nothing)";
                if (item > -1) {
                    seq.moveIndex(item);
                    seq.moveNext();
                    s = "'" + seq.token().text();
                }
                s = s + "'                                           ";
                System.err.print(item + "\t");
            }
            System.err.println("");
        }
    }

    public static JavaTokenId moveToSrcRelevant(TokenSequence<JavaTokenId> seq, Direction dir) {
        return PositionEstimator.moveToDifferentThan(seq, dir, nonRelevant);
    }

    private static JavaTokenId moveToDifferentThan(TokenSequence<JavaTokenId> seq, Direction dir, EnumSet<JavaTokenId> set) {
        boolean notBound = false;
        switch (dir) {
            case BACKWARD: {
                while ((notBound = seq.movePrevious()) && set.contains(seq.token().id())) {
                }
                break;
            }
            case FORWARD: {
                while ((notBound = seq.moveNext()) && set.contains(seq.token().id())) {
                }
                break;
            }
        }
        return notBound ? (JavaTokenId)seq.token().id() : null;
    }

    private static int goAfterFirstNewLine(TokenSequence<JavaTokenId> seq) {
        if (seq.token() == null) {
            seq.movePrevious();
        }
        int base = seq.offset();
        seq.movePrevious();
        while (seq.moveNext() && nonRelevant.contains(seq.token().id())) {
            switch ((JavaTokenId)seq.token().id()) {
                case LINE_COMMENT: {
                    seq.moveNext();
                    return seq.offset();
                }
                case WHITESPACE: {
                    char[] c = ((Object)seq.token().text()).toString().toCharArray();
                    int index = 0;
                    while (index < c.length) {
                        if (c[index++] != '\n') continue;
                        return base + index;
                    }
                    break;
                }
            }
        }
        return base;
    }

    private static int goAfterLastNewLine(TokenSequence<JavaTokenId> seq) {
        int base = seq.offset();
        seq.movePrevious();
        while (seq.moveNext() && nonRelevant.contains(seq.token().id())) {
        }
        while (seq.movePrevious() && nonRelevant.contains(seq.token().id())) {
            switch ((JavaTokenId)seq.token().id()) {
                case LINE_COMMENT: {
                    seq.moveNext();
                    return seq.offset();
                }
                case WHITESPACE: {
                    char[] c = ((Object)seq.token().text()).toString().toCharArray();
                    int i = c.length;
                    while (i > 0) {
                        if (c[--i] != '\n') continue;
                        return seq.offset() + i + 1;
                    }
                    break;
                }
            }
        }
        if ((seq.index() == 0 || seq.moveNext()) && nonRelevant.contains(seq.token().id())) {
            return seq.offset();
        }
        return base;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnnotationsEstimator
    extends PositionEstimator {
        public AnnotationsEstimator(List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
            super(oldL, newL, copy);
        }

        @Override
        public void initialize() {
            int size = this.oldL.size();
            this.matrix = new int[size + 1][5];
            this.matrix[size] = new int[]{-1, -1, -1, -1, -1};
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            int i = 0;
            for (Tree item : this.oldL) {
                int treeStart = (int)positions.getStartPosition(compilationUnit, item);
                int treeEnd = (int)positions.getEndPosition(compilationUnit, item);
                if (treeEnd < 0) continue;
                this.seq.move(treeStart);
                int startIndex = this.seq.index();
                AnnotationsEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
                this.seq.moveNext();
                int veryBeg = this.seq.index();
                this.seq.move(treeEnd);
                this.matrix[i++] = new int[]{veryBeg, veryBeg, veryBeg, startIndex, this.seq.index()};
                if (i != size) continue;
                this.seq.move(treeEnd);
                this.matrix[i][2] = this.seq.index();
            }
        }

        @Override
        public int getInsertPos(int index) {
            int tokenIndex;
            if (!this.initialized) {
                this.initialize();
            }
            if ((tokenIndex = this.matrix[index][2]) == -1) {
                return -1;
            }
            this.seq.moveIndex(tokenIndex);
            this.seq.moveNext();
            int off = PositionEstimator.goAfterLastNewLine((TokenSequence<JavaTokenId>)this.seq);
            return off;
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            int begin = this.getInsertPos(index);
            if (this.matrix[index][4] != -1) {
                this.seq.moveIndex(this.matrix[index][4]);
                this.seq.moveNext();
            }
            int end = PositionEstimator.goAfterFirstNewLine((TokenSequence<JavaTokenId>)this.seq);
            return new int[]{begin, end};
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public int prepare(int startPos, StringBuilder aHead, StringBuilder aTail) {
            return startPos;
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder replacement) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseEstimator
    extends PositionEstimator {
        JavaTokenId precToken;
        private ArrayList<String> separatorList;

        private BaseEstimator(JavaTokenId precToken, List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
            super(oldL, newL, copy);
            this.precToken = precToken;
        }

        @Override
        public String head() {
            return " " + this.precToken.fixedText() + " ";
        }

        @Override
        public String sep() {
            return ", ";
        }

        @Override
        public void initialize() {
            this.separatorList = new ArrayList(this.oldL.size());
            boolean first = true;
            int size = this.oldL.size();
            this.matrix = new int[size + 1][5];
            this.matrix[size] = new int[]{-1, -1, -1, -1, -1};
            TokenSequence seq = this.copy.getTokenHierarchy().tokenSequence();
            int i = 0;
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            for (Tree item : this.oldL) {
                String separatedText = "";
                int treeStart = (int)positions.getStartPosition(compilationUnit, item);
                int treeEnd = (int)positions.getEndPosition(compilationUnit, item);
                seq.move(treeStart);
                int startIndex = seq.index();
                int beforer = -1;
                if (first) {
                    while (seq.movePrevious() && seq.token().id() != this.precToken) {
                    }
                    int throwsIndex = seq.index();
                    beforer = throwsIndex + 1;
                    BaseEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)seq, Direction.BACKWARD);
                    seq.moveNext();
                    int beg = seq.index();
                    seq.move(treeEnd);
                    this.matrix[i++] = new int[]{beg, throwsIndex, beforer, startIndex, seq.index()};
                    first = false;
                } else {
                    int afterPrevious = this.matrix[i - 1][4];
                    while (seq.movePrevious() && seq.token().id() != JavaTokenId.COMMA) {
                        if (seq.token().id() == JavaTokenId.WHITESPACE) {
                            separatedText = seq.token().text() + separatedText;
                            continue;
                        }
                        if (seq.token().id() != JavaTokenId.LINE_COMMENT) continue;
                        separatedText = '\n' + separatedText;
                    }
                    this.separatorList.add(separatedText);
                    int separator = seq.index();
                    int afterSeparator = separator + 1;
                    if (afterPrevious == separator) {
                        afterPrevious = -1;
                    }
                    seq.move(treeEnd);
                    this.matrix[i++] = new int[]{afterPrevious, separator, afterSeparator, startIndex, seq.index()};
                }
                if (i == size) {
                    BaseEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)seq, Direction.FORWARD);
                    this.matrix[i][2] = seq.index();
                }
                seq.move(treeEnd);
            }
            this.initialized = true;
        }

        @Override
        public String getIndentString() {
            if (!this.initialized) {
                this.initialize();
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String item : this.separatorList) {
                Integer count;
                String s = item;
                if (s.lastIndexOf("\n") > -1) {
                    s = s.substring(item.lastIndexOf("\n"));
                }
                if ((count = (Integer)map.get(s)) != null) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    map.put(s, n);
                    continue;
                }
                map.put(s, 1);
            }
            int max = -1;
            String s = null;
            for (String item : map.keySet()) {
                if ((Integer)map.get(item) <= max) continue;
                s = item;
                max = (Integer)map.get(item);
            }
            return s;
        }

        @Override
        public int getInsertPos(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int[] getPositions(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int prepare(int startPos, StringBuilder aHead, StringBuilder aTail) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder replacement) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeprecatedEstimator
    extends PositionEstimator {
        public DeprecatedEstimator(List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
            super(oldL, newL, copy);
        }

        @Override
        public void initialize() {
            int size = this.oldL.size();
            this.matrix = new int[size + 1][5];
            this.matrix[size] = new int[]{-1, -1, -1, -1, -1};
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            int i = 0;
            for (Tree item : this.oldL) {
                int treeStart = (int)positions.getStartPosition(compilationUnit, item);
                int treeEnd = (int)positions.getEndPosition(compilationUnit, item);
                if (treeEnd < 0) {
                    if (Tree.Kind.BLOCK != item.getKind()) continue;
                    if (i > 0) {
                        this.seq.moveIndex(this.matrix[i - 1][4]);
                        this.seq.moveNext();
                        TokenUtilities.moveFwdToToken((TokenSequence<JavaTokenId>)this.seq, this.seq.offset(), JavaTokenId.SEMICOLON);
                        treeStart = this.seq.offset();
                        treeEnd = treeStart + 1;
                    }
                }
                this.seq.move(treeStart);
                this.seq.moveNext();
                int startIndex = this.seq.index();
                DeprecatedEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
                this.seq.moveNext();
                int veryBeg = this.seq.index();
                this.seq.move(treeEnd);
                this.matrix[i++] = new int[]{veryBeg, veryBeg, veryBeg, startIndex, this.seq.index()};
                if (i != size) continue;
                this.seq.move(treeEnd);
                this.matrix[i][2] = this.seq.index();
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int index) {
            int tokenIndex;
            if (!this.initialized) {
                this.initialize();
            }
            if ((tokenIndex = this.matrix[index][2]) == -1) {
                return -1;
            }
            this.seq.moveIndex(tokenIndex);
            this.seq.moveNext();
            return PositionEstimator.goAfterFirstNewLine((TokenSequence<JavaTokenId>)this.seq);
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            int begin = this.getInsertPos(index);
            if (this.matrix[index][4] != -1) {
                this.seq.moveIndex(this.matrix[index][4]);
                this.seq.moveNext();
            }
            int end = PositionEstimator.goAfterFirstNewLine((TokenSequence<JavaTokenId>)this.seq);
            return new int[]{begin, end};
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public int prepare(int startPos, StringBuilder aHead, StringBuilder aTail) {
            this.seq.move(startPos);
            this.seq.moveNext();
            DeprecatedEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
            while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id())) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    int newlineInToken = ((Object)this.seq.token().text()).toString().indexOf(10);
                    if (newlineInToken <= -1) continue;
                    return this.seq.offset() + newlineInToken + 1;
                }
                if (JavaTokenId.LINE_COMMENT != this.seq.token().id()) continue;
                return this.seq.offset() + this.seq.token().text().length();
            }
            return startPos;
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder replacement) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtendsEstimator
    extends BaseEstimator {
        ExtendsEstimator(List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
            super(JavaTokenId.EXTENDS, oldL, newL, copy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImplementsEstimator
    extends BaseEstimator {
        ImplementsEstimator(List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
            super(JavaTokenId.IMPLEMENTS, oldL, newL, copy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImportsEstimator
    extends PositionEstimator {
        List<int[]> data;

        public ImportsEstimator(List<? extends ImportTree> oldL, List<? extends ImportTree> newL, WorkingCopy copy) {
            super(oldL, newL, copy);
        }

        @Override
        public void initialize() {
            int size = this.oldL.size();
            this.data = new ArrayList<int[]>(size);
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            for (Tree item : this.oldL) {
                int indexOf;
                Token token;
                int treeStart = (int)positions.getStartPosition(compilationUnit, item);
                int treeEnd = (int)positions.getEndPosition(compilationUnit, item);
                this.seq.move(treeStart);
                this.seq.moveNext();
                int wideStart = PositionEstimator.goAfterLastNewLine((TokenSequence<JavaTokenId>)this.seq);
                this.seq.move(treeStart);
                this.seq.moveNext();
                if (null != ImportsEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int previousEnd = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    int localResult = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            indexOf = ((Object)token.text()).toString().indexOf(10);
                            if (indexOf <= 0) break;
                            localResult = this.seq.offset() + indexOf + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            previousEnd = this.seq.offset() + token.text().length();
                        }
                    }
                    if (localResult > 0) {
                        previousEnd = localResult;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                this.seq.move(treeEnd);
                int wideEnd = treeEnd;
                while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                    if (JavaTokenId.WHITESPACE == token.id()) {
                        indexOf = ((Object)token.text()).toString().indexOf(10);
                        if (indexOf > -1) {
                            wideEnd = this.seq.offset() + indexOf + 1;
                            continue;
                        }
                        wideEnd = this.seq.offset();
                        continue;
                    }
                    if (JavaTokenId.LINE_COMMENT == token.id()) {
                        wideEnd = this.seq.offset() + token.text().length();
                        break;
                    }
                    if (JavaTokenId.JAVADOC_COMMENT != token.id()) continue;
                }
                if (wideEnd < treeEnd) {
                    wideEnd = treeEnd;
                }
                this.data.add(new int[]{wideStart, wideEnd, previousEnd});
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            return index == this.data.size() ? this.data.get(index - 1)[2] : this.data.get(index)[0];
        }

        @Override
        public int prepare(int startPos, StringBuilder aHead, StringBuilder aTail) {
            if (!this.initialized) {
                this.initialize();
            }
            CompilationUnitTree cut = this.copy.getCompilationUnit();
            int resultPos = 0;
            if (!cut.getTypeDecls().isEmpty()) {
                Tree t = cut.getTypeDecls().get(0);
                SourcePositions positions = this.copy.getTrees().getSourcePositions();
                int typeDeclStart = (int)positions.getStartPosition(cut, t);
                this.seq.move(typeDeclStart);
                if (null != ImportsEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    resultPos = this.seq.offset() + this.seq.token().length();
                } else {
                    aTail.append('\n');
                    return 0;
                }
            }
            int counter = 0;
            while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id()) && counter < 3) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    String white = ((Object)this.seq.token().text()).toString();
                    int index = 0;
                    int pos = 0;
                    while ((pos = white.indexOf(10, pos)) > -1) {
                        ++pos;
                        if (++counter >= 3) continue;
                        index = pos;
                    }
                    resultPos += index;
                    continue;
                }
                if (JavaTokenId.LINE_COMMENT == this.seq.token().id()) {
                    ++counter;
                    resultPos += ((Object)this.seq.token().text()).toString().length();
                    continue;
                }
                if (JavaTokenId.BLOCK_COMMENT != this.seq.token().id() && JavaTokenId.JAVADOC_COMMENT != this.seq.token().id()) continue;
            }
            if (counter < 3) {
                if (counter == 0) {
                    aHead.append("\n\n");
                } else if (counter == 1) {
                    aHead.append('\n');
                }
                aTail.append('\n');
            }
            return resultPos;
        }

        @Override
        public int[] getPositions(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(index);
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public String head() {
            throw new UnsupportedOperationException("Not applicable for imports!");
        }

        @Override
        public String sep() {
            throw new UnsupportedOperationException("Not applicable for imports!");
        }

        @Override
        public String getIndentString() {
            throw new UnsupportedOperationException("Not applicable for imports!");
        }

        public String toString() {
            String result = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] pos = this.data.get(i);
                String s = this.copy.getText().substring(pos[0], pos[1]);
                result = result + "\"" + s + "\"\n";
            }
            return result;
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder replacement) {
            int indexOf;
            Token token;
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            int sectionStart = (int)positions.getStartPosition(compilationUnit, (Tree)this.oldL.get(0));
            int sectionEnd = (int)positions.getEndPosition(compilationUnit, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(sectionStart);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    sectionStart = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                indexOf = ((Object)token.text()).toString().indexOf(10);
                if (indexOf > -1) {
                    sectionStart = this.seq.offset() + indexOf + 1;
                    continue;
                }
                sectionStart = this.seq.offset();
            }
            this.seq.move(sectionEnd);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    sectionEnd = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    sectionEnd = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                indexOf = ((Object)token.text()).toString().indexOf(10);
                if (indexOf > -1) {
                    sectionEnd = this.seq.offset() + indexOf + 1;
                    continue;
                }
                sectionEnd += this.seq.offset() + token.text().length();
            }
            return new int[]{sectionStart, sectionEnd};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MembersEstimator
    extends PositionEstimator {
        private List<int[]> data;

        public MembersEstimator(List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
            super(oldL, newL, copy);
        }

        @Override
        public void initialize() {
            int size = this.oldL.size();
            this.data = new ArrayList<int[]>(size);
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            for (Tree item : this.oldL) {
                int indexOf;
                Token token;
                int treeStart = (int)positions.getStartPosition(compilationUnit, item);
                int treeEnd = (int)positions.getEndPosition(compilationUnit, item);
                if (item instanceof CasualDiff.FieldGroupTree) {
                    treeEnd = ((CasualDiff.FieldGroupTree)item).endPos();
                }
                this.seq.move(treeStart);
                this.seq.moveNext();
                if (null != MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                this.seq.move(treeStart);
                this.seq.moveNext();
                if (null != MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int previousEnd = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    int localResult = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            indexOf = ((Object)token.text()).toString().indexOf(10);
                            if (indexOf <= -1) break;
                            localResult = this.seq.offset() + indexOf + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            previousEnd = this.seq.offset() + token.text().length();
                        }
                    }
                    if (localResult > 0) {
                        previousEnd = localResult;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                this.seq.move(treeEnd);
                int wideEnd = treeEnd;
                while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                    if (JavaTokenId.WHITESPACE == token.id()) {
                        indexOf = ((Object)token.text()).toString().indexOf(10);
                        wideEnd = indexOf > -1 ? this.seq.offset() + indexOf + 1 : this.seq.offset();
                    } else {
                        if (JavaTokenId.LINE_COMMENT == token.id()) {
                            wideEnd = this.seq.offset() + token.text().length();
                            break;
                        }
                        if (JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                    }
                    if (wideEnd <= treeEnd) continue;
                }
                if (wideEnd < treeEnd) {
                    wideEnd = treeEnd;
                }
                this.data.add(new int[]{previousEnd, wideEnd, previousEnd});
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            return index == this.data.size() ? this.data.get(index - 1)[2] : this.data.get(index)[0];
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder replacement) {
            int indexOf;
            Token token;
            if (!this.initialized) {
                this.initialize();
            }
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            int sectionStart = (int)positions.getStartPosition(compilationUnit, (Tree)this.oldL.get(0));
            int sectionEnd = (int)positions.getEndPosition(compilationUnit, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(sectionStart);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    sectionStart = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                indexOf = ((Object)token.text()).toString().indexOf(10);
                if (indexOf > -1) {
                    sectionStart = this.seq.offset() + indexOf + 1;
                    continue;
                }
                sectionStart = this.seq.offset();
            }
            this.seq.move(sectionEnd);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    sectionEnd = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    sectionEnd = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                indexOf = ((Object)token.text()).toString().lastIndexOf(10);
                if (indexOf > -1) {
                    sectionEnd = this.seq.offset() + indexOf + 1;
                    continue;
                }
                sectionEnd += this.seq.offset() + token.text().length();
            }
            return new int[]{sectionStart, sectionEnd};
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(index);
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public int prepare(int startPos, StringBuilder aHead, StringBuilder aTail) {
            this.seq.move(startPos);
            this.seq.moveNext();
            MembersEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD);
            while (this.seq.moveNext() && nonRelevant.contains(this.seq.token().id())) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    int newlineInToken = ((Object)this.seq.token().text()).toString().indexOf(10);
                    if (newlineInToken <= -1) continue;
                    return this.seq.offset() + newlineInToken + 1;
                }
                if (JavaTokenId.LINE_COMMENT != this.seq.token().id()) continue;
                return this.seq.offset() + this.seq.token().text().length();
            }
            return startPos;
        }

        public String toString() {
            if (!this.initialized) {
                this.initialize();
            }
            String result = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] pos = this.data.get(i);
                String s = this.copy.getText().substring(pos[0], pos[1]);
                result = result + "[" + s + "]";
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThrowsEstimator
    extends BaseEstimator {
        ThrowsEstimator(List<? extends ExpressionTree> oldL, List<? extends ExpressionTree> newL, WorkingCopy copy) {
            super(JavaTokenId.THROWS, oldL, newL, copy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TopLevelEstimator
    extends PositionEstimator {
        private List<int[]> data;

        public TopLevelEstimator(List<? extends Tree> oldL, List<? extends Tree> newL, WorkingCopy copy) {
            super(oldL, newL, copy);
        }

        @Override
        public void initialize() {
            int size = this.oldL.size();
            this.data = new ArrayList<int[]>(size);
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            for (Tree item : this.oldL) {
                int indexOf;
                Token token;
                int treeStart = (int)positions.getStartPosition(compilationUnit, item);
                int treeEnd = (int)positions.getEndPosition(compilationUnit, item);
                this.seq.move(treeStart);
                this.seq.moveNext();
                if (null != TopLevelEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                this.seq.move(treeStart);
                this.seq.moveNext();
                if (null != TopLevelEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)this.seq, Direction.BACKWARD)) {
                    this.seq.moveNext();
                }
                int previousEnd = this.seq.offset();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    int localResult = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            int indexOf2 = ((Object)token.text()).toString().indexOf(10);
                            if (indexOf2 <= -1) break;
                            localResult = this.seq.offset() + indexOf2 + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            previousEnd = this.seq.offset() + token.text().length();
                            break;
                        }
                        case JAVADOC_COMMENT: {
                            previousEnd = this.seq.offset();
                        }
                    }
                    if (localResult > 0) {
                        previousEnd = localResult;
                        break;
                    }
                    if (this.seq.moveNext()) continue;
                    break;
                }
                int wideStart = previousEnd;
                this.seq.move(treeStart);
                this.seq.moveNext();
                this.seq.movePrevious();
                while (nonRelevant.contains((token = this.seq.token()).id())) {
                    int localResult = -1;
                    switch ((JavaTokenId)token.id()) {
                        case WHITESPACE: {
                            indexOf = ((Object)token.text()).toString().lastIndexOf(10);
                            if (indexOf <= -1) break;
                            localResult = this.seq.offset() + indexOf + 1;
                            break;
                        }
                        case LINE_COMMENT: {
                            localResult = this.seq.offset() + token.text().length();
                            break;
                        }
                        case JAVADOC_COMMENT: 
                        case BLOCK_COMMENT: {
                            wideStart = this.seq.offset();
                        }
                    }
                    if (wideStart > previousEnd) break;
                    if (localResult > 0) {
                        wideStart = localResult;
                    }
                    if (this.seq.movePrevious()) continue;
                    break;
                }
                this.seq.move(treeEnd);
                int wideEnd = treeEnd;
                while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                    if (JavaTokenId.WHITESPACE == token.id()) {
                        indexOf = ((Object)token.text()).toString().indexOf(10);
                        wideEnd = indexOf > -1 ? this.seq.offset() + indexOf + 1 : this.seq.offset();
                    } else {
                        if (JavaTokenId.LINE_COMMENT == token.id()) {
                            wideEnd = this.seq.offset() + token.text().length();
                            break;
                        }
                        if (JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                    }
                    if (wideEnd <= treeEnd) continue;
                }
                if (wideEnd < treeEnd) {
                    wideEnd = treeEnd;
                }
                this.data.add(new int[]{wideStart, wideEnd, previousEnd});
            }
            this.initialized = true;
        }

        @Override
        public int getInsertPos(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.data.isEmpty()) {
                return -1;
            }
            return index == this.data.size() ? this.data.get(index - 1)[2] : this.data.get(index)[0];
        }

        @Override
        public int[] sectionRemovalBounds(StringBuilder replacement) {
            int indexOf;
            Token token;
            if (!this.initialized) {
                this.initialize();
            }
            assert (!this.oldL.isEmpty() && this.newL.isEmpty());
            SourcePositions positions = this.copy.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
            int sectionStart = (int)positions.getStartPosition(compilationUnit, (Tree)this.oldL.get(0));
            int sectionEnd = (int)positions.getEndPosition(compilationUnit, (Tree)this.oldL.get(this.oldL.size() - 1));
            this.seq.move(sectionStart);
            this.seq.moveNext();
            while (this.seq.movePrevious() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    this.seq.moveNext();
                    sectionStart = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                indexOf = ((Object)token.text()).toString().indexOf(10);
                if (indexOf > -1) {
                    sectionStart = this.seq.offset() + indexOf + 1;
                    continue;
                }
                sectionStart = this.seq.offset();
            }
            this.seq.move(sectionEnd);
            this.seq.movePrevious();
            while (this.seq.moveNext() && nonRelevant.contains((token = this.seq.token()).id())) {
                if (JavaTokenId.LINE_COMMENT == token.id()) {
                    sectionEnd = this.seq.offset();
                    if (!this.seq.moveNext()) break;
                    sectionEnd = this.seq.offset();
                    break;
                }
                if (JavaTokenId.BLOCK_COMMENT == token.id() || JavaTokenId.JAVADOC_COMMENT == token.id()) break;
                if (JavaTokenId.WHITESPACE != token.id()) continue;
                indexOf = ((Object)token.text()).toString().lastIndexOf(10);
                if (indexOf > -1) {
                    sectionEnd = this.seq.offset() + indexOf + 1;
                    continue;
                }
                sectionEnd += this.seq.offset() + token.text().length();
            }
            return new int[]{sectionStart, sectionEnd};
        }

        @Override
        public String head() {
            return "";
        }

        @Override
        public String sep() {
            return "";
        }

        @Override
        public String getIndentString() {
            return "";
        }

        @Override
        public int[] getPositions(int index) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.data.get(index);
        }

        @Override
        public CasualDiff.LineInsertionType lineInsertType() {
            return CasualDiff.LineInsertionType.AFTER;
        }

        @Override
        public int prepare(int startPos, StringBuilder aHead, StringBuilder aTail) {
            this.seq.moveEnd();
            if (this.seq.movePrevious()) {
                if (JavaTokenId.WHITESPACE == this.seq.token().id()) {
                    int firstNewLineIndex = -1;
                    String tokenText = ((Object)this.seq.token().text()).toString();
                    firstNewLineIndex = tokenText.indexOf(10);
                    if (firstNewLineIndex > -1) {
                        if (tokenText.lastIndexOf(10) == firstNewLineIndex) {
                            aHead.append('\n');
                        }
                    } else {
                        aHead.append("\n\n");
                    }
                } else if (JavaTokenId.LINE_COMMENT != this.seq.token().id()) {
                    aHead.append("\n\n");
                }
                return this.seq.offset() + this.seq.token().text().length();
            }
            return startPos;
        }

        public String toString() {
            if (!this.initialized) {
                this.initialize();
            }
            String result = "";
            for (int i = 0; i < this.data.size(); ++i) {
                int[] pos = this.data.get(i);
                String s = this.copy.getText().substring(pos[0], pos[1]);
                result = result + "[" + s + "]";
            }
            return result;
        }
    }
}

