/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.BitSet;
import javax.tools.JavaFileObject;

public class SourceBuffer
implements CharSequence {
    public char[] src;
    LineMap lineMap;
    int maxLines;

    public SourceBuffer(char[] src, int length) {
        this.src = src;
        this.lineMap = new LineMap(src, src.length);
        this.maxLines = this.lineMap.getLineNumber(src.length - 1);
    }

    public SourceBuffer(String path) throws IOException {
        this(new FileReader(path));
    }

    public SourceBuffer(InputStream input) throws IOException {
        this(new InputStreamReader(input));
    }

    public SourceBuffer(InputStream input, String encoding) throws IOException {
        this(new InputStreamReader(input, encoding));
    }

    public SourceBuffer(Reader input) throws IOException {
        this.src = SourceBuffer.readInFile(input);
        this.lineMap = new LineMap(this.src, this.src.length);
        this.maxLines = this.lineMap.getLineNumber(this.src.length - 1);
    }

    public SourceBuffer(JavaFileObject sourceFile) throws IOException {
        String s = ((Object)sourceFile.getCharContent(true)).toString();
        this.src = s.toCharArray();
        this.lineMap = new LineMap(this.src, this.src.length);
        this.maxLines = this.lineMap.getLineNumber(this.src.length - 1);
    }

    private static char[] readInFile(Reader in) throws IOException {
        int n;
        CharArrayWriter out = new CharArrayWriter(4096);
        char[] buf = new char[4096];
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
        }
        in.close();
        out.write(0);
        return out.toCharArray();
    }

    public char[] getChars() {
        char[] buf = new char[this.src.length];
        System.arraycopy(this.src, 0, buf, 0, this.src.length);
        return buf;
    }

    public char[] getChars(int start, int end) {
        int len = end - start;
        char[] buf = new char[len];
        System.arraycopy(this.src, start, buf, 0, len);
        return buf;
    }

    public String getString(int start, int end) {
        return new String(this.src, start, end - start);
    }

    public char[] getLine(int line) {
        if (line <= 0 || line > this.maxLines) {
            throw new IndexOutOfBoundsException("line out of range: " + line);
        }
        int start = this.lineMap.getStartPosition(line);
        int end = (line + 1 >= this.maxLines ? this.src.length : this.lineMap.getStartPosition(line + 1)) - 1;
        if (this.src[end] == '\n') {
            --end;
        }
        if (this.src[end] == '\r') {
            --end;
        }
        return this.getChars(start, end + 1);
    }

    public int getLineNumber(int pos) {
        return this.lineMap.getLineNumber(pos);
    }

    public int getColumnNumber(int pos) {
        return this.lineMap.getColumnNumber(pos);
    }

    public int getPosition(int line, int column) {
        return this.lineMap.getPosition(line, column);
    }

    public int getStartPosition(int line) {
        return this.lineMap.getStartPosition(line);
    }

    public int length() {
        return this.src.length - 1;
    }

    public char charAt(int index) {
        return this.src[index];
    }

    public CharSequence subSequence(int start, int end) {
        return this.getString(start, end);
    }

    public String toString() {
        return new String(this.src, 0, this.length());
    }

    static class LineMap {
        private int[] startPosition;
        private BitSet tabMap;
        public static final int FIRSTLINE = 1;
        public static final int FIRSTCOLUMN = 1;
        public static final int TabInc = 8;
        private static final char SCANNER_SENTINEL = '\u0000';
        private int lastPosition = 0;
        private int lastLine = 1;

        protected LineMap(char[] src, int max) {
            if (src[max - 1] == '\u0000') {
                --max;
            }
            this.tabMap = new BitSet(max);
            int c = 0;
            int i = 0;
            int[] linebuf = new int[max];
            block0: while (i < max) {
                linebuf[c++] = i;
                do {
                    char ch;
                    if ((ch = src[i]) == '\r' || ch == '\n') {
                        if (ch == '\r' && i + 1 < max && src[i + 1] == '\n') {
                            i += 2;
                            continue block0;
                        }
                        ++i;
                        continue block0;
                    }
                    if (ch != '\t') continue;
                    this.setTabPosition(i);
                } while (++i < max);
            }
            this.startPosition = new int[c];
            System.arraycopy(linebuf, 0, this.startPosition, 0, c);
        }

        public int getStartPosition(int line) {
            return this.startPosition[line - 1];
        }

        public int getPosition(int line, int column) {
            int pos = this.startPosition[line - 1];
            --column;
            int col = 0;
            while (col < column) {
                if (this.tabMap.get(++pos)) {
                    col = col / 8 * 8 + 8;
                    continue;
                }
                ++col;
            }
            return pos;
        }

        public int getLineNumber(int pos) {
            if (pos == this.lastPosition) {
                return this.lastLine;
            }
            this.lastPosition = pos;
            int low = 0;
            int high = this.startPosition.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int midVal = this.startPosition[mid];
                if (midVal < pos) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > pos) {
                    high = mid - 1;
                    continue;
                }
                this.lastLine = mid + 1;
                return this.lastLine;
            }
            this.lastLine = low;
            return this.lastLine;
        }

        public int getColumnNumber(int pos) {
            int lineStart = this.startPosition[this.getLineNumber(pos) - 1];
            int column = 0;
            for (int bp = lineStart; bp < pos; ++bp) {
                if (this.tabMap.get(bp)) {
                    column = column / 8 * 8 + 8;
                    continue;
                }
                ++column;
            }
            return column + 1;
        }

        protected void setTabPosition(int offset) {
            this.tabMap.set(offset);
        }
    }
}

