/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebuildOraculum {
    private static final String DEPRECATED = "DEPRECATED";
    private static Map<JavaSource, RebuildOraculum> source2Oraculum = new WeakHashMap<JavaSource, RebuildOraculum>();
    private FileObject file;
    private Map<ElementHandle, Collection<String>> members;
    private static final Pattern ANONYMOUS = Pattern.compile("\\$[0-9]");

    public static RebuildOraculum get(FileObject file) {
        JavaSource js = JavaSource.forFileObject(file);
        RebuildOraculum res = source2Oraculum.get(js);
        if (res == null) {
            res = new RebuildOraculum(file);
            source2Oraculum.put(js, res);
        }
        return res;
    }

    private RebuildOraculum(FileObject file) {
        TimesCollector.getDefault().reportReference(file, RebuildOraculum.class.getName(), "RebuildOraculum", (Object)this);
        this.file = file;
    }

    private Map<ElementHandle, Collection<String>> getMembers() {
        if (this.members != null) {
            return this.members;
        }
        return new HashMap<ElementHandle, Collection<String>>();
    }

    private static String convertToSourceName(String binaryName) {
        int index = (binaryName = binaryName.replace('.', '/')).lastIndexOf(47);
        if (index < 0) {
            index = 0;
        }
        if ((index = binaryName.indexOf(index, 36)) > 0) {
            binaryName = binaryName.substring(0, index);
        }
        return binaryName + ".java";
    }

    public List<File> findFilesToRebuild(File root, FileObject file, ClasspathInfo cpInfo, Map<ElementHandle, Collection<String>> currentMembers, Collection<String> possiblyRemovedClasses) {
        Logger.getLogger(RebuildOraculum.class.getName()).log(Level.FINE, "members={0}", this.getMembers());
        Logger.getLogger(RebuildOraculum.class.getName()).log(Level.FINE, "currentMembers={0}", currentMembers);
        HashSet<String> removedClasses = new HashSet<String>(possiblyRemovedClasses);
        HashMap<ElementHandle, Collection<String>> added = new HashMap<ElementHandle, Collection<String>>(currentMembers);
        for (ElementHandle h : this.getMembers().keySet()) {
            added.remove(h);
        }
        HashMap<ElementHandle, Collection<String>> removed = new HashMap<ElementHandle, Collection<String>>(this.getMembers());
        for (ElementHandle h : currentMembers.keySet()) {
            removed.remove(h);
            if (!h.getKind().isClass() && !h.getKind().isInterface()) continue;
            removedClasses.remove(h.getBinaryName());
        }
        HashMap<ElementHandle, Collection<String>> changedElements = new HashMap<ElementHandle, Collection<String>>(this.getMembers());
        Iterator it = changedElements.keySet().iterator();
        while (it.hasNext()) {
            ElementHandle h = (ElementHandle)it.next();
            Collection original = (Collection)changedElements.get(h);
            Collection<String> current = currentMembers.get(h);
            if (original != null && current != null && !((Object)original).equals(current)) continue;
            it.remove();
        }
        this.members = currentMembers;
        ArrayList<ElementHandle<TypeElement>> classes = new ArrayList<ElementHandle<TypeElement>>();
        if (!(added.isEmpty() && removed.isEmpty() && changedElements.isEmpty())) {
            for (ElementHandle h : currentMembers.keySet()) {
                if (!h.getKind().isClass() && !h.getKind().isInterface()) continue;
                classes.add(h);
            }
        }
        for (String s : removedClasses) {
            if (ANONYMOUS.matcher(s).find()) continue;
            classes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, s));
        }
        if (classes.isEmpty()) {
            return Collections.emptyList();
        }
        ClassIndex ci = cpInfo.getClassIndex();
        return RebuildOraculum.findAllDependent(root, file, ci, classes);
    }

    public static List<File> findAllDependent(File root, FileObject file, ClassIndex ci, Collection<ElementHandle<TypeElement>> classes) {
        HashSet<ElementHandle<TypeElement>> orig;
        HashSet<ElementHandle<TypeElement>> toParse = new HashSet<ElementHandle<TypeElement>>(classes);
        long start = System.currentTimeMillis();
        boolean changed = true;
        while (changed) {
            orig = new HashSet<ElementHandle<TypeElement>>(toParse);
            for (ElementHandle elementHandle : orig) {
                toParse.addAll(ci.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
            }
            changed = !((Object)orig).equals(toParse);
        }
        orig = new HashSet<ElementHandle<TypeElement>>(toParse);
        for (ElementHandle elementHandle : orig) {
            toParse.addAll(ci.getElements(elementHandle, EnumSet.complementOf(EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS)), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        }
        toParse.removeAll(classes);
        if (file != null) {
            TimesCollector.getDefault().reportTime(file, "deps-handles", "Deps - Handles", System.currentTimeMillis() - start);
            TimesCollector.getDefault().reportTime(file, "deps-handles-#", "Deps - Handles #", (long)toParse.size());
        }
        long cur = System.currentTimeMillis();
        HashSet<File> files = new HashSet<File>();
        for (ElementHandle elementHandle : toParse) {
            String sourceName = RebuildOraculum.convertToSourceName(elementHandle.getBinaryName());
            File source = new File(root, sourceName);
            if (!source.canRead()) continue;
            files.add(source);
        }
        files.remove(null);
        if (file != null) {
            TimesCollector.getDefault().reportTime(file, "deps-files", "Deps - Files", System.currentTimeMillis() - cur);
            TimesCollector.getDefault().reportTime(file, "deps-files-#", "Deps - Files #", (long)files.size());
        }
        return new ArrayList<File>(files);
    }

    public boolean isInitialized() {
        return this.members != null;
    }

    private static Collection<String> getExtendedModifiers(Elements elements, Element el) {
        HashSet<String> result = new HashSet<String>();
        for (Modifier m : el.getModifiers()) {
            result.add(m.name());
        }
        if (elements.isDeprecated(el)) {
            result.add(DEPRECATED);
        }
        return result;
    }

    public static Map<ElementHandle, Collection<String>> sortOut(Elements elements, Iterable<? extends TypeElement> topLevelElements) {
        HashMap<ElementHandle, Collection<String>> types = new HashMap<ElementHandle, Collection<String>>();
        LinkedList<TypeElement> toHandle = new LinkedList<TypeElement>();
        for (TypeElement typeElement : topLevelElements) {
            toHandle.offer(typeElement);
        }
        while (!toHandle.isEmpty()) {
            TypeElement te = (TypeElement)toHandle.poll();
            types.put(ElementHandle.create(te), RebuildOraculum.getExtendedModifiers(elements, te));
            for (Element element : te.getEnclosedElements()) {
                switch (element.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        toHandle.offer((TypeElement)element);
                        break;
                    }
                    case METHOD: 
                    case FIELD: 
                    case ENUM_CONSTANT: {
                        types.put(ElementHandle.create(element), RebuildOraculum.getExtendedModifiers(elements, element));
                    }
                }
            }
        }
        return types;
    }

    public void initialize(Map<ElementHandle, Collection<String>> members) {
        Logger.getLogger(RebuildOraculum.class.getName()).log(Level.FINE, "initializing members={0}", members);
        if (this.members == null) {
            this.members = members;
        }
    }
}

