/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexFactory;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexImplListener;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassIndexImpl {
    public final List<WeakReference<ClassIndexImplListener>> listeners = Collections.synchronizedList(new ArrayList());
    public static ClassIndexFactory FACTORY;

    public abstract <T> void search(String var1, Set<UsageType> var2, ResultConvertor<T> var3, Set<? super T> var4);

    public abstract <T> void getDeclaredTypes(String var1, ClassIndex.NameKind var2, ResultConvertor<T> var3, Set<? super T> var4);

    public abstract void getPackageNames(String var1, boolean var2, Set<String> var3);

    public abstract FileObject[] getSourceRoots();

    public abstract BinaryAnalyser getBinaryAnalyser();

    public abstract SourceAnalyser getSourceAnalyser();

    public abstract void setDirty(JavaSource var1);

    protected abstract void close() throws IOException;

    public void addClassIndexImplListener(ClassIndexImplListener listener) {
        assert (listener != null);
        this.listeners.add(new Ref(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassIndexImplListener(ClassIndexImplListener listener) {
        assert (listener != null);
        List<WeakReference<ClassIndexImplListener>> list = this.listeners;
        synchronized (list) {
            Iterator<WeakReference<ClassIndexImplListener>> it = this.listeners.iterator();
            while (it.hasNext()) {
                WeakReference<ClassIndexImplListener> lr = it.next();
                ClassIndexImplListener l = (ClassIndexImplListener)lr.get();
                if (listener != l) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typesEvent(ClassIndexImplEvent added, ClassIndexImplEvent removed, ClassIndexImplEvent changed) {
        WeakReference[] _listeners;
        List<WeakReference<ClassIndexImplListener>> list = this.listeners;
        synchronized (list) {
            _listeners = this.listeners.toArray(new WeakReference[this.listeners.size()]);
        }
        for (WeakReference lr : _listeners) {
            ClassIndexImplListener l = (ClassIndexImplListener)lr.get();
            if (l == null) continue;
            if (added != null) {
                l.typesAdded(added);
            }
            if (removed != null) {
                l.typesRemoved(removed);
            }
            if (changed == null) continue;
            l.typesChanged(changed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Ref
    extends WeakReference<ClassIndexImplListener>
    implements Runnable {
        public Ref(ClassIndexImplListener listener) {
            super(listener, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            ClassIndexImpl.this.listeners.remove(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UsageType {
        SUPER_CLASS(0),
        SUPER_INTERFACE(1),
        FIELD_REFERENCE(2),
        METHOD_REFERENCE(3),
        TYPE_REFERENCE(4);

        private int offset;

        private UsageType(int offset) {
            this.offset = offset;
        }

        int getOffset() {
            return this.offset;
        }
    }
}

