/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocumentUtil {
    private static final String ROOT_NAME = "/";
    private static final String FIELD_RESOURCE_NAME = "resName";
    private static final String FIELD_BINARY_NAME = "binaryName";
    private static final String FIELD_PACKAGE_NAME = "packageName";
    private static final String FIELD_TIME_STAMP = "timeStamp";
    private static final String FIELD_REFERENCES = "references";
    private static final String FIELD_SIMPLE_NAME = "simpleName";
    private static final String FIELD_CASE_INSENSITIVE_NAME = "ciName";
    private static final char NO = '-';
    private static final char YES = '+';
    private static final char WILDCARD = '?';
    private static final char PKG_SEPARATOR = '.';
    private static final char EK_CLASS = 'C';
    private static final char EK_INTERFACE = 'I';
    private static final char EK_ENUM = 'E';
    private static final char EK_ANNOTATION = 'A';
    private static final int SIZE = ClassIndexImpl.UsageType.values().length;
    private static final char[] MASK_ANY_USAGE = new char[SIZE];

    private DocumentUtil() {
    }

    public static String getBinaryName(Document doc) {
        return DocumentUtil.getBinaryName(doc, null);
    }

    public static String getBinaryName(Document doc, ElementKind[] kind) {
        assert (doc != null);
        Field pkgField = doc.getField(FIELD_PACKAGE_NAME);
        Field snField = doc.getField(FIELD_BINARY_NAME);
        if (snField == null) {
            return null;
        }
        String tmp = snField.stringValue();
        String snName = tmp.substring(0, tmp.length() - 1);
        if (kind != null) {
            assert (kind.length == 1);
            kind[0] = DocumentUtil.decodeKind(tmp.charAt(tmp.length() - 1));
        }
        if (pkgField == null) {
            return snName;
        }
        String pkg = pkgField.stringValue();
        if (pkg.length() == 0) {
            return snName;
        }
        return pkg + '.' + snName;
    }

    public static String getSimpleBinaryName(Document doc) {
        assert (doc != null);
        Field field = doc.getField(FIELD_BINARY_NAME);
        if (field == null) {
            return null;
        }
        return field.stringValue();
    }

    public static String getPackageName(Document doc) {
        assert (doc != null);
        Field field = doc.getField(FIELD_PACKAGE_NAME);
        return field == null ? null : field.stringValue();
    }

    static String getRefereneType(Document doc, String className) {
        assert (doc != null);
        assert (className != null);
        Field[] fields = doc.getFields(FIELD_REFERENCES);
        assert (fields != null);
        for (Field field : fields) {
            String rawUsage = field.stringValue();
            int rawUsageLen = rawUsage.length();
            assert (rawUsageLen > SIZE);
            int index = rawUsageLen - SIZE;
            String usageName = rawUsage.substring(0, index);
            String map = rawUsage.substring(index);
            if (!className.equals(usageName)) continue;
            return map;
        }
        return null;
    }

    public static List<String> getReferences(Document doc) {
        assert (doc != null);
        Field[] fields = doc.getFields(FIELD_REFERENCES);
        assert (fields != null);
        ArrayList<String> result = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            result.add(field.stringValue());
        }
        return result;
    }

    public static long getTimeStamp(Document doc) throws ParseException {
        assert (doc != null);
        Field field = doc.getField(FIELD_TIME_STAMP);
        assert (field != null);
        String data = field.stringValue();
        assert (data != null);
        return DateTools.stringToTime(data);
    }

    public static Query binaryNameQuery(String resourceName) {
        String sName;
        String pkgName;
        BooleanQuery query = new BooleanQuery();
        int index = resourceName.lastIndexOf(46);
        if (index < 0) {
            pkgName = "";
            sName = resourceName;
        } else {
            pkgName = resourceName.substring(0, index);
            sName = resourceName.substring(index + 1);
        }
        sName = sName + '?';
        query.add(new TermQuery(new Term(FIELD_PACKAGE_NAME, pkgName)), BooleanClause.Occur.MUST);
        query.add(new WildcardQuery(new Term(FIELD_BINARY_NAME, sName)), BooleanClause.Occur.MUST);
        return query;
    }

    public static Query binaryContentNameQuery(String resourceName) {
        String sName;
        String pkgName;
        int index = resourceName.lastIndexOf(46);
        if (index < 0) {
            pkgName = "";
            sName = resourceName;
        } else {
            pkgName = resourceName.substring(0, index);
            sName = resourceName.substring(index + 1);
        }
        BooleanQuery query = new BooleanQuery();
        BooleanQuery subQuery = new BooleanQuery();
        subQuery.add(new WildcardQuery(new Term(FIELD_BINARY_NAME, sName + '?')), BooleanClause.Occur.SHOULD);
        subQuery.add(new PrefixQuery(new Term(FIELD_BINARY_NAME, sName + '$')), BooleanClause.Occur.SHOULD);
        query.add(new TermQuery(new Term(FIELD_PACKAGE_NAME, pkgName)), BooleanClause.Occur.MUST);
        query.add(subQuery, BooleanClause.Occur.MUST);
        return query;
    }

    public static Term rootDocumentTerm() {
        return new Term(FIELD_RESOURCE_NAME, ROOT_NAME);
    }

    public static Term simpleBinaryNameTerm(String resourceFileName) {
        assert (resourceFileName != null);
        return new Term(FIELD_BINARY_NAME, resourceFileName);
    }

    public static Term packageNameTerm(String packageName) {
        assert (packageName != null);
        return new Term(FIELD_PACKAGE_NAME, packageName);
    }

    public static Term referencesTerm(String resourceName, Set<ClassIndexImpl.UsageType> usageType) {
        assert (resourceName != null);
        if (usageType != null) {
            resourceName = DocumentUtil.encodeUsage(resourceName, usageType, '?').toString();
        } else {
            StringBuilder sb = new StringBuilder(resourceName);
            sb.append(MASK_ANY_USAGE);
            resourceName = sb.toString();
        }
        return new Term(FIELD_REFERENCES, resourceName);
    }

    public static Term simpleNameTerm(String resourceSimpleName) {
        assert (resourceSimpleName != null);
        return new Term(FIELD_SIMPLE_NAME, resourceSimpleName);
    }

    public static Term caseInsensitiveNameTerm(String caseInsensitiveName) {
        assert (caseInsensitiveName != null);
        return new Term(FIELD_CASE_INSENSITIVE_NAME, caseInsensitiveName);
    }

    public static Document createDocument(String binaryName, long timeStamp, List<String> references) {
        String pkgName;
        String fileName;
        assert (binaryName != null);
        assert (references != null);
        int index = binaryName.lastIndexOf(46);
        if (index < 0) {
            fileName = binaryName;
            pkgName = "";
        } else {
            fileName = binaryName.substring(index + 1);
            pkgName = binaryName.substring(0, index);
        }
        index = fileName.lastIndexOf(36);
        String simpleName = index < 0 ? fileName.substring(0, fileName.length() - 1) : fileName.substring(index + 1, fileName.length() - 1);
        String caseInsensitiveName = simpleName.toLowerCase();
        Document doc = new Document();
        Field field = new Field(FIELD_BINARY_NAME, fileName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(field);
        field = new Field(FIELD_PACKAGE_NAME, pkgName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(field);
        field = new Field(FIELD_TIME_STAMP, DateTools.timeToString(timeStamp, DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO);
        doc.add(field);
        field = new Field(FIELD_SIMPLE_NAME, simpleName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(field);
        field = new Field(FIELD_CASE_INSENSITIVE_NAME, caseInsensitiveName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(field);
        for (String reference : references) {
            field = new Field(FIELD_REFERENCES, reference, Field.Store.YES, Field.Index.UN_TOKENIZED);
            doc.add(field);
        }
        return doc;
    }

    public static Document createRootTimeStampDocument(long timeStamp) {
        Document doc = new Document();
        Field field = new Field(FIELD_RESOURCE_NAME, ROOT_NAME, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(field);
        field = new Field(FIELD_TIME_STAMP, DateTools.timeToString(timeStamp, DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO);
        doc.add(field);
        return doc;
    }

    public static StringBuilder createUsage(String className) {
        Set<ClassIndexImpl.UsageType> EMPTY = Collections.emptySet();
        return DocumentUtil.encodeUsage(className, EMPTY, '-');
    }

    public static void addUsage(StringBuilder rawUsage, ClassIndexImpl.UsageType type) {
        assert (rawUsage != null);
        assert (type != null);
        int rawUsageLen = rawUsage.length();
        int startIndex = rawUsageLen - SIZE;
        rawUsage.setCharAt(startIndex + type.getOffset(), '+');
    }

    public static String encodeUsage(String className, Set<ClassIndexImpl.UsageType> usageTypes) {
        return DocumentUtil.encodeUsage(className, usageTypes, '-').toString();
    }

    private static StringBuilder encodeUsage(String className, Set<ClassIndexImpl.UsageType> usageTypes, char fill) {
        assert (className != null);
        assert (usageTypes != null);
        StringBuilder builder = new StringBuilder();
        builder.append(className);
        char[] map = new char[SIZE];
        Arrays.fill(map, fill);
        for (ClassIndexImpl.UsageType usageType : usageTypes) {
            int offset = usageType.getOffset();
            assert (offset >= 0 && offset < SIZE);
            map[offset] = 43;
        }
        builder.append(map);
        return builder;
    }

    public static String encodeUsage(String className, String usageMap) {
        assert (className != null);
        assert (usageMap != null);
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append(usageMap);
        return sb.toString();
    }

    public static String decodeUsage(String rawUsage, Set<ClassIndexImpl.UsageType> usageTypes) {
        assert (rawUsage != null);
        assert (usageTypes != null);
        assert (usageTypes.isEmpty());
        int rawUsageLen = rawUsage.length();
        assert (rawUsageLen > SIZE);
        int index = rawUsageLen - SIZE;
        String className = rawUsage.substring(0, index);
        String map = rawUsage.substring(index);
        for (ClassIndexImpl.UsageType usageType : ClassIndexImpl.UsageType.values()) {
            if (map.charAt(usageType.getOffset()) != '+') continue;
            usageTypes.add(usageType);
        }
        return className;
    }

    public static ElementKind decodeKind(char kind) {
        switch (kind) {
            case 'C': {
                return ElementKind.CLASS;
            }
            case 'I': {
                return ElementKind.INTERFACE;
            }
            case 'E': {
                return ElementKind.ENUM;
            }
            case 'A': {
                return ElementKind.ANNOTATION_TYPE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static char encodeKind(ElementKind kind) {
        switch (kind) {
            case CLASS: {
                return 'C';
            }
            case INTERFACE: {
                return 'I';
            }
            case ENUM: {
                return 'E';
            }
            case ANNOTATION_TYPE: {
                return 'A';
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        Arrays.fill(MASK_ANY_USAGE, '?');
    }
}

