/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.netbeans.modules.java.source.usages.Index;
import org.openide.filesystems.FileUtil;

public class NBLockFactory
extends SimpleFSLockFactory {
    private static final String LOCK_DIR = "var" + File.separatorChar + "lock";
    private static File lockDir;

    public NBLockFactory() throws IOException {
        super(NBLockFactory.getLockDir());
    }

    public static void clearLocks() {
        File lockDir = NBLockFactory.getLockDir();
        File[] children = lockDir.listFiles();
        if (children != null) {
            for (File child : children) {
                child.delete();
            }
        }
    }

    private static synchronized File getLockDir() {
        if (lockDir == null) {
            String nbUserDirProp = Index.getNbUserDir();
            assert (nbUserDirProp != null);
            File userDir = new File(nbUserDirProp);
            lockDir = FileUtil.normalizeFile((File)new File(userDir, LOCK_DIR));
            if (!lockDir.exists()) {
                lockDir.mkdirs();
                assert (lockDir.isDirectory() && lockDir.canRead() && lockDir.canWrite());
            }
        }
        return lockDir;
    }
}

