/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.LuceneIndex;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentClassIndex
extends ClassIndexImpl {
    private final Index index;
    private final URL root;
    private final boolean isSource;
    private WeakReference<JavaSource> dirty;
    private static final Logger LOGGER = Logger.getLogger(PersistentClassIndex.class.getName());

    private PersistentClassIndex(URL root, File cacheRoot, boolean source) throws IOException, IllegalArgumentException {
        assert (root != null);
        this.root = root;
        this.index = LuceneIndex.create(cacheRoot);
        this.isSource = source;
    }

    @Override
    public BinaryAnalyser getBinaryAnalyser() {
        return new BinaryAnalyser(this.index);
    }

    @Override
    public SourceAnalyser getSourceAnalyser() {
        return new SourceAnalyser(this.index);
    }

    @Override
    public FileObject[] getSourceRoots() {
        FileObject[] rootFos;
        if (this.isSource) {
            FileObject[] fileObjectArray;
            FileObject rootFo = URLMapper.findFileObject((URL)this.root);
            if (rootFo == null) {
                fileObjectArray = new FileObject[]{};
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = rootFo;
            }
            rootFos = fileObjectArray;
        } else {
            rootFos = SourceForBinaryQuery.findSourceRoots((URL)this.root).getRoots();
        }
        return rootFos;
    }

    public static ClassIndexImpl create(URL root, File cacheRoot, boolean indexNow) throws IOException, IllegalArgumentException {
        return new PersistentClassIndex(root, cacheRoot, indexNow);
    }

    @Override
    public <T> void search(final String binaryName, final Set<ClassIndexImpl.UsageType> usageType, final ResultConvertor<T> convertor, final Set<? super T> result) {
        this.updateDirty();
        if (BinaryAnalyser.OBJECT.equals(binaryName)) {
            this.getDeclaredTypes("", ClassIndex.NameKind.PREFIX, convertor, result);
            return;
        }
        try {
            ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PersistentClassIndex.this.usages(binaryName, usageType, convertor, result);
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    @Override
    public <T> void getDeclaredTypes(final String simpleName, final ClassIndex.NameKind kind, final ResultConvertor<T> convertor, final Set<? super T> result) {
        this.updateDirty();
        try {
            ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PersistentClassIndex.this.index.getDeclaredTypes(simpleName, kind, convertor, result);
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    @Override
    public void getPackageNames(final String prefix, final boolean directOnly, final Set<String> result) {
        try {
            ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PersistentClassIndex.this.index.getPackageNames(prefix, directOnly, result);
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    @Override
    public synchronized void setDirty(JavaSource js) {
        if (js == null) {
            this.dirty = null;
        } else if (this.dirty == null || this.dirty.get() != js) {
            this.dirty = new WeakReference<JavaSource>(js);
        }
    }

    public String toString() {
        return "CompromiseUQ[" + this.root.toExternalForm() + "]";
    }

    @Override
    protected final void close() throws IOException {
        this.index.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDirty() {
        JavaSource js;
        WeakReference<JavaSource> jsRef;
        PersistentClassIndex persistentClassIndex = this;
        synchronized (persistentClassIndex) {
            jsRef = this.dirty;
        }
        if (jsRef != null && (js = (JavaSource)jsRef.get()) != null) {
            long startTime = System.currentTimeMillis();
            if (JavaSourceAccessor.INSTANCE.isDispatchThread()) {
                try {
                    ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            CompilationInfo compilationInfo = JavaSourceAccessor.INSTANCE.getCurrentCompilationInfo(js, JavaSource.Phase.RESOLVED);
                            if (compilationInfo != null) {
                                SourceAnalyser sa = PersistentClassIndex.this.getSourceAnalyser();
                                long st = System.currentTimeMillis();
                                sa.analyseUnitAndStore(compilationInfo.getCompilationUnit(), JavaSourceAccessor.INSTANCE.getJavacTask(compilationInfo));
                                long et = System.currentTimeMillis();
                            }
                            return null;
                        }
                    });
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                try {
                    js.runUserActionTask(new CancellableTask<CompilationController>(){

                        @Override
                        public void run(final CompilationController controller) {
                            try {
                                ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                                    @Override
                                    public Void run() throws IOException {
                                        controller.toPhase(JavaSource.Phase.RESOLVED);
                                        SourceAnalyser sa = PersistentClassIndex.this.getSourceAnalyser();
                                        long st = System.currentTimeMillis();
                                        sa.analyseUnitAndStore(controller.getCompilationUnit(), JavaSourceAccessor.INSTANCE.getJavacTask(controller));
                                        long et = System.currentTimeMillis();
                                        return null;
                                    }
                                });
                            }
                            catch (IOException ioe) {
                                Exceptions.printStackTrace((Throwable)ioe);
                            }
                        }

                        @Override
                        public void cancel() {
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            PersistentClassIndex ioe = this;
            synchronized (ioe) {
                this.dirty = null;
            }
            long endTime = System.currentTimeMillis();
            LOGGER.fine("PersistentClassIndex.updateDirty took: " + (endTime - startTime) + " ms");
        }
    }

    private <T> void usages(String binaryName, Set<ClassIndexImpl.UsageType> usageType, ResultConvertor<T> convertor, Set<? super T> result) {
        List<String> classInternalNames = this.getUsagesFQN(binaryName, usageType, Index.BooleanOperator.OR);
        for (String classInternalName : classInternalNames) {
            T value = convertor.convert(ElementKind.OTHER, classInternalName);
            if (value == null) continue;
            result.add(value);
        }
    }

    private List<String> getUsagesFQN(String binaryName, Set<ClassIndexImpl.UsageType> mask, Index.BooleanOperator operator) {
        List<String> result = null;
        try {
            result = this.index.getUsagesFQN(binaryName, mask, operator);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }
}

