/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ErrorType;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.tasklist.CompilerSettings;
import org.netbeans.modules.java.source.tasklist.ErrorAnnotator;
import org.netbeans.modules.java.source.tasklist.JavaTaskProvider;
import org.netbeans.modules.java.source.tasklist.RebuildOraculum;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.netbeans.modules.java.source.usages.SymbolDumper;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUpdater
implements PropertyChangeListener,
FileChangeListener {
    private static final Logger LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
    private static final Set<String> ignoredDirectories = RepositoryUpdater.parseSet("org.netbeans.javacore.ignoreDirectories", "SCCS CVS .svn");
    private static final boolean noscan = Boolean.getBoolean("netbeans.javacore.noscan");
    private static final boolean PERF_TEST = Boolean.getBoolean("perf.refactoring.test");
    private static final String PACKAGE_INFO = "package-info.java";
    static final String GOING_TO_RECOMPILE = "Going to recompile: {0}";
    static final String CONTAINS_TASKLIST_DATA = "containsTasklistData";
    static final String CONTAINS_TASKLIST_DEPENDENCY_DATA = "containsTasklistDependencyData";
    static final String DIRTY_ROOT = "dirty";
    static final String SOURCE_LEVEL_ROOT = "sourceLevel";
    static final String EXTRA_COMPILER_OPTIONS = "extraCompilerOptions";
    static final String CLASSPATH_ATTRIBUTE = "classPath";
    static int DELAY = Utilities.isWindows() ? 2000 : 1000;
    private static RepositoryUpdater instance;
    private final GlobalSourcePath cpImpl;
    private final ClassPath cp;
    private final ClassPath ucp;
    private final ClassPath binCp;
    private Set<URL> scannedRoots;
    private Set<URL> scannedBinaries;
    private Map<URL, List<URL>> deps;
    private Delay delay;
    private Work currentWork;
    private boolean dirty;
    private int noSubmited;
    private volatile boolean notInitialized = true;
    private Map<ClassPath, URL> classPath2Root;
    private final Map<URL, JavaFileFilterImplementation> filters = Collections.synchronizedMap(new HashMap());
    private final FilterListener filterListener = new FilterListener();
    private final Map<URL, Collection<File>> url2Recompile = new HashMap<URL, Collection<File>>();
    private boolean recompileScheduled;
    static Callback CALLBACK;
    private static final int MAX_DUMPS = 255;

    private RepositoryUpdater() {
        this.scannedRoots = Collections.synchronizedSet(new HashSet());
        this.scannedBinaries = Collections.synchronizedSet(new HashSet());
        this.deps = Collections.synchronizedMap(new HashMap());
        this.delay = new Delay();
        this.cpImpl = GlobalSourcePath.getDefault();
        this.cp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getSourcePath());
        this.ucp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getUnknownSourcePath());
        this.binCp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getBinaryPath());
        this.classPath2Root = Collections.synchronizedMap(new WeakHashMap());
        this.open();
    }

    public ClassPath getScannedSources() {
        return this.cp;
    }

    public ClassPath getScannedBinaries() {
        return this.binCp;
    }

    public Map<URL, List<URL>> getDependencies() {
        return new HashMap<URL, List<URL>>(this.deps);
    }

    private synchronized void open() throws IllegalStateException {
        if (this.notInitialized) {
            try {
                this.cpImpl.setExcludesListener(this);
                this.cp.addPropertyChangeListener((PropertyChangeListener)this);
                this.registerFileSystemListener();
                this.submitBatch();
                this.notInitialized = false;
            }
            catch (TooManyListenersException e) {
                throw new IllegalStateException();
            }
        }
    }

    public void close() {
        try {
            this.cpImpl.setExcludesListener(null);
            this.cp.removePropertyChangeListener((PropertyChangeListener)this);
            this.unregisterFileSystemListener();
            this.delay.cancel();
        }
        catch (TooManyListenersException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOGGER.log(Level.FINER, "propertyChange from ClassPath: evt={0}, property name={1}", new Object[]{evt, evt.getPropertyName()});
        if ("roots".equals(evt.getPropertyName())) {
            if (evt.getSource() == this.cp) {
                this.submitBatch();
            } else if (TasklistSettings.isTasklistEnabled()) {
                ClassPath changedCp = (ClassPath)evt.getSource();
                assert (changedCp != null);
                LOGGER.log(Level.FINER, "modified roots changedCp={0}", changedCp);
                URL root = this.classPath2Root.get(changedCp);
                if (root != null) {
                    this.scheduleCompilation(root, root, true);
                }
            }
            return;
        }
        if ("includes".equals(evt.getPropertyName()) && (evt.getSource() == this.cpImpl || evt.getSource() == this.cp)) {
            ClassPath changedCp = (ClassPath)evt.getNewValue();
            assert (changedCp != null);
            LOGGER.log(Level.FINER, "changedCp={0}", changedCp);
            for (ClassPath.Entry e : changedCp.entries()) {
                URL root = e.getURL();
                this.scheduleCompilation(root, root, true);
            }
            return;
        }
    }

    private synchronized void submitBatch() {
        if (this.currentWork == null) {
            this.currentWork = Work.batch();
            this.submit(this.currentWork);
        } else {
            this.dirty = true;
        }
    }

    public synchronized boolean isScanInProgress() {
        return this.notInitialized || this.noSubmited > 0;
    }

    public synchronized void waitScanFinished() throws InterruptedException {
        while (this.isScanInProgress()) {
            this.wait();
        }
    }

    private synchronized boolean isDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        this.currentWork = null;
        return false;
    }

    private synchronized void resetDirty() {
        this.dirty = false;
        this.currentWork = null;
    }

    public void fileRenamed(FileRenameEvent fe) {
        org.openide.filesystems.FileObject fo = fe.getFile();
        try {
            URL root;
            if ((RepositoryUpdater.isJava(fo) || fo.isFolder()) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    File parentFile;
                    String originalName = fe.getName();
                    String originalExt = fe.getExt();
                    if (originalExt.length() > 0) {
                        originalName = originalName + '.' + originalExt;
                    }
                    if ((parentFile = FileUtil.toFile((org.openide.filesystems.FileObject)fo.getParent())) != null) {
                        URL original = new File(parentFile, originalName).toURI().toURL();
                        this.submit(Work.delete(original, root2, fo.isFolder()));
                        this.delay.post(Work.compile(fo, root2));
                    }
                }
            } else if (RepositoryUpdater.isBinary(fo) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                File parentFile;
                String originalName = fe.getName();
                String originalExt = fe.getExt();
                if (originalExt.length() > 0) {
                    originalName = originalName + '.' + originalExt;
                }
                if ((parentFile = FileUtil.toFile((org.openide.filesystems.FileObject)fo.getParent())) != null) {
                    URL original = new File(parentFile, originalName).toURI().toURL();
                    this.submit(Work.binary(original, root, fo.isFolder()));
                    this.submit(Work.binary(fo, root));
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
        org.openide.filesystems.FileObject fo = fe.getFile();
        try {
            URL root = this.getOwningSourceRoot(fo);
            if (root != null && VisibilityQuery.getDefault().isVisible(fo)) {
                this.scheduleCompilation(fo, root);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileDeleted(FileEvent fe) {
        org.openide.filesystems.FileObject fo = fe.getFile();
        boolean isFolder = fo.isFolder();
        try {
            URL root;
            if ((RepositoryUpdater.isJava(fo) || isFolder) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    RepositoryUpdater.markRootTasklistDirty(root2);
                    this.submit(Work.delete(fo, root2, isFolder));
                    if (TasklistSettings.isTasklistEnabled()) {
                        ErrorAnnotator an;
                        Set<URL> toRefresh = TaskCache.getDefault().dumpErrors(root2, fo.getURL(), FileUtil.toFile((org.openide.filesystems.FileObject)fo), Collections.emptyList());
                        if (TasklistSettings.isBadgesEnabled() && (an = ErrorAnnotator.getAnnotator()) != null) {
                            an.updateInError(toRefresh);
                        }
                    }
                }
            } else if ((RepositoryUpdater.isBinary(fo) || isFolder) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                this.submit(Work.binary(fo, root));
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileDataCreated(FileEvent fe) {
        org.openide.filesystems.FileObject fo = fe.getFile();
        try {
            URL root;
            if (RepositoryUpdater.isJava(fo) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    RepositoryUpdater.markRootTasklistDirty(root2);
                    this.postCompilation(fo, root2);
                    if (TasklistSettings.isTasklistEnabled() && TasklistSettings.isDependencyTrackingEnabled()) {
                        LinkedList<File> toReparse = new LinkedList<File>();
                        for (URL u : TaskCache.getDefault().getAllFilesInError(root2)) {
                            toReparse.add(new File(u.toURI()));
                        }
                        this.assureRecompiled(root2, toReparse);
                    }
                }
            } else if (RepositoryUpdater.isBinary(fo) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                this.submit(Work.binary(fo, root));
            }
        }
        catch (URISyntaxException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileChanged(FileEvent fe) {
        org.openide.filesystems.FileObject fo = fe.getFile();
        try {
            URL root;
            if (RepositoryUpdater.isJava(fo) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    RepositoryUpdater.markRootTasklistDirty(root2);
                    this.postCompilation(fo, root2, WorkType.COMPILE_WITH_DEPENDENCIES);
                }
            } else if (RepositoryUpdater.isBinary(fo) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                this.submit(Work.binary(fo, root));
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public final void scheduleCompilation(org.openide.filesystems.FileObject fo, org.openide.filesystems.FileObject root) throws IOException {
        URL foURL = fo.getURL();
        URL rootURL = root.getURL();
        assert ("file".equals(foURL.getProtocol()) && "file".equals(rootURL.getProtocol()));
        this.scheduleCompilation(foURL, rootURL, fo.isFolder());
    }

    private final void scheduleCompilation(org.openide.filesystems.FileObject fo, URL root) throws IOException {
        this.scheduleCompilation(fo.getURL(), root, fo.isFolder());
    }

    private final void scheduleCompilation(URL file, URL root, boolean isFolder) {
        this.submit(Work.compile(file, root, isFolder));
    }

    private final void postCompilation(org.openide.filesystems.FileObject file, URL root) throws FileStateInvalidException {
        this.delay.post(Work.compile(file, root));
    }

    private final void postCompilation(org.openide.filesystems.FileObject file, URL root, WorkType type) throws FileStateInvalidException {
        this.delay.post(Work.compile(file, root, type));
    }

    public final CountDownLatch scheduleCompilationAndWait(org.openide.filesystems.FileObject folder, org.openide.filesystems.FileObject root) throws IOException {
        CountDownLatch[] latch = new CountDownLatch[1];
        this.submit(Work.compile(folder, root.getURL(), latch));
        this.open();
        return latch[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(Work work) {
        if (!noscan) {
            RepositoryUpdater repositoryUpdater = this;
            synchronized (repositoryUpdater) {
                ++this.noSubmited;
            }
            CompileWorker cw = new CompileWorker(work);
            JavaSourceAccessor.INSTANCE.runSpecialTask(cw, work.getType() == WorkType.RECOMPILE ? JavaSource.Priority.LOW : JavaSource.Priority.MAX);
        }
    }

    private void registerFileSystemListener() {
        File[] roots = File.listRoots();
        HashSet<FileSystem> fss = new HashSet<FileSystem>();
        for (File root : roots) {
            org.openide.filesystems.FileObject fo = FileUtil.toFileObject((File)root);
            if (fo == null) continue;
            try {
                FileSystem fs = fo.getFileSystem();
                if (fss.contains(fs)) continue;
                fs.addFileChangeListener((FileChangeListener)this);
                fss.add(fs);
            }
            catch (FileStateInvalidException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void unregisterFileSystemListener() {
        File[] roots = File.listRoots();
        HashSet<FileSystem> fss = new HashSet<FileSystem>();
        for (File root : roots) {
            org.openide.filesystems.FileObject fo = FileUtil.toFileObject((File)root);
            if (fo == null) continue;
            try {
                FileSystem fs = fo.getFileSystem();
                if (fss.contains(fs)) continue;
                fs.removeFileChangeListener((FileChangeListener)this);
                fss.add(fs);
            }
            catch (FileStateInvalidException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private URL getOwningSourceRoot(org.openide.filesystems.FileObject fo) {
        if (fo == null) {
            return null;
        }
        ArrayList<URL> clone = new ArrayList<URL>(this.scannedRoots);
        for (URL root : clone) {
            org.openide.filesystems.FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null || !FileUtil.isParentOf((org.openide.filesystems.FileObject)rootFo, (org.openide.filesystems.FileObject)fo)) continue;
            return root;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getOwningBinaryRoot(org.openide.filesystems.FileObject fo) {
        if (fo == null) {
            return null;
        }
        try {
            Set<URL> set = this.scannedBinaries;
            synchronized (set) {
                URL foURL = fo.getURL();
                for (URL root : this.scannedBinaries) {
                    String foPath;
                    String filePath;
                    URL fileURL = FileUtil.getArchiveFile((URL)root);
                    boolean archive = true;
                    if (fileURL == null) {
                        fileURL = root;
                        archive = false;
                    }
                    if ((filePath = fileURL.getPath()).equals(foPath = foURL.getPath())) {
                        return root;
                    }
                    if (archive || !foPath.startsWith(filePath)) continue;
                    return root;
                }
            }
        }
        catch (FileStateInvalidException fsi) {
            Exceptions.printStackTrace((Throwable)fsi);
        }
        return null;
    }

    public void rebuildAll(boolean forceClean) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Rebuild All Called", new Exception());
        }
        LinkedList<URL> toRebuild = new LinkedList<URL>();
        for (org.openide.filesystems.FileObject file : this.getScannedSources().getRoots()) {
            try {
                toRebuild.add(file.getURL());
            }
            catch (FileStateInvalidException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        this.submit(Work.filterChange(toRebuild, forceClean));
    }

    private synchronized void assureRecompiled(URL root, Collection<File> files) {
        Collection<File> storedFiles = this.url2Recompile.get(root);
        if (storedFiles == null) {
            storedFiles = new LinkedHashSet<File>();
            this.url2Recompile.put(root, storedFiles);
        }
        storedFiles.addAll(files);
        if (!this.recompileScheduled) {
            this.submit(Work.recompile());
            this.recompileScheduled = true;
        }
    }

    private static void markRootTasklistDirty(URL root) throws IOException {
        if (TasklistSettings.isTasklistEnabled() && TasklistSettings.isDependencyTrackingEnabled()) {
            RepositoryUpdater.ensureAttributeValue(root, DIRTY_ROOT, "true", false);
        } else {
            RepositoryUpdater.ensureAttributeValue(root, CONTAINS_TASKLIST_DEPENDENCY_DATA, null, false);
            if (!TasklistSettings.isTasklistEnabled()) {
                RepositoryUpdater.ensureAttributeValue(root, CONTAINS_TASKLIST_DATA, null, false);
            }
        }
    }

    static boolean ensureAttributeValue(URL root, String attributeName, String attributeValue, boolean markDirty) throws IOException {
        Properties p = RepositoryUpdater.loadProperties(root);
        String current = p.getProperty(attributeName);
        if (attributeValue != null && attributeValue.equals(current) || attributeValue == null && current == null) {
            return false;
        }
        if (attributeValue != null) {
            p.setProperty(attributeName, attributeValue);
        } else {
            p.remove(attributeName);
        }
        if (markDirty) {
            p.setProperty(DIRTY_ROOT, "true");
        }
        RepositoryUpdater.storeProperties(root, p);
        return true;
    }

    static void setAttribute(URL root, String attributeName, String attributeValue) throws IOException {
        Properties p = RepositoryUpdater.loadProperties(root);
        if (attributeValue != null) {
            p.setProperty(attributeName, attributeValue);
        } else {
            p.remove(attributeName);
        }
        RepositoryUpdater.storeProperties(root, p);
    }

    static String getAttribute(URL root, String attributeName, String defaultValue) throws IOException {
        Properties p = RepositoryUpdater.loadProperties(root);
        return p.getProperty(attributeName, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL root) throws IOException {
        File f = RepositoryUpdater.getAttributeFile(root);
        Properties result = new Properties();
        if (!f.exists()) {
            return result;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        try {
            result.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(URL root, Properties p) throws IOException {
        File f = RepositoryUpdater.getAttributeFile(root);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        try {
            p.store(out, "");
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static File getAttributeFile(URL root) throws IOException {
        File dirtyFile = Index.getClassFolder(root);
        return new File(dirtyFile.getParentFile(), "attributes.properties");
    }

    private static boolean isJava(org.openide.filesystems.FileObject fo) {
        if (fo.isFolder()) {
            return false;
        }
        if ("java".equals(fo.getExt().toLowerCase())) {
            return true;
        }
        return "text/x-java".equals(fo.getMIMEType());
    }

    private static boolean isBinary(org.openide.filesystems.FileObject fo) {
        if (fo.isFolder()) {
            return false;
        }
        String ext = fo.getExt().toLowerCase();
        return "class".equals(ext) || "jar".equals(ext) || "zip".equals(ext);
    }

    private static String classPathToString(ClasspathInfo info) throws FileStateInvalidException {
        ClassPath bootPath = ClasspathInfoAccessor.INSTANCE.getCachedClassPath(info, ClasspathInfo.PathKind.BOOT);
        ClassPath compilePath = ClasspathInfoAccessor.INSTANCE.getCachedClassPath(info, ClasspathInfo.PathKind.COMPILE);
        ClassPath sourcePath = ClasspathInfoAccessor.INSTANCE.getCachedClassPath(info, ClasspathInfo.PathKind.SOURCE);
        StringBuilder sb = new StringBuilder();
        for (org.openide.filesystems.FileObject f : bootPath.getRoots()) {
            sb.append(f.getURL().toExternalForm());
            sb.append(':');
        }
        for (org.openide.filesystems.FileObject f : compilePath.getRoots()) {
            sb.append(f.getURL().toExternalForm());
            sb.append(':');
        }
        for (org.openide.filesystems.FileObject f : sourcePath.getRoots()) {
            sb.append(f.getURL().toExternalForm());
            sb.append(':');
        }
        return sb.toString();
    }

    public void verifySourceLevel(URL root, String sourceLevel) throws IOException {
        String existingSourceLevel = RepositoryUpdater.getAttribute(root, SOURCE_LEVEL_ROOT, null);
        if (sourceLevel != null && existingSourceLevel != null && !sourceLevel.equals(existingSourceLevel)) {
            LOGGER.log(Level.FINE, "source level change detected (provided={1}, existing={2}), refreshing whole source root ({0})", new Object[]{root.toExternalForm(), sourceLevel, existingSourceLevel});
            this.submit(Work.filterChange(Collections.singletonList(root), true));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitWorkStarted() throws InterruptedException {
        boolean waited = false;
        Delay delay = this.delay;
        synchronized (delay) {
            while (!this.delay.tasks.isEmpty()) {
                waited = true;
                this.delay.wait();
            }
        }
        return waited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<URL> batchCompile(LinkedList<Pair> toCompile, org.openide.filesystems.FileObject rootFo, ClasspathInfo cpInfo, SourceAnalyser sa, Set<URI> dirtyFiles, Set<File> compiledFiles, AtomicBoolean canceled, Set<? super ElementHandle<TypeElement>> added) throws IOException {
        assert (toCompile != null);
        assert (rootFo != null);
        assert (cpInfo != null);
        FileObject active = null;
        File activeFile = null;
        Pair activePair = null;
        JavaFileManager fileManager = ClasspathInfoAccessor.INSTANCE.getFileManager(cpInfo);
        CompilerListener listener = new CompilerListener();
        HashSet<URL> toRefresh = new HashSet<URL>();
        LowMemoryNotifier.getDefault().addLowMemoryListener(listener);
        try {
            JavacTaskImpl jt = null;
            try {
                LinkedList<Pair> bigFiles = new LinkedList<Pair>();
                boolean state = false;
                boolean isBigFile = false;
                String sourceLevel = SourceLevelQuery.getSourceLevel((org.openide.filesystems.FileObject)rootFo);
                while (!toCompile.isEmpty() || !bigFiles.isEmpty() || active != null) {
                    if (canceled != null && canceled.getAndSet(false)) {
                        HashSet<URL> hashSet = toRefresh;
                        return hashSet;
                    }
                    try {
                        if (listener.lowMemory.getAndSet(false)) {
                            if (jt != null) {
                                jt.finish();
                            }
                            jt = null;
                            listener.cleanDiagnostics();
                            if (state) break;
                            state = true;
                            System.gc();
                            continue;
                        }
                        if (active == null) {
                            if (!toCompile.isEmpty()) {
                                activePair = toCompile.remove(0);
                                active = activePair.jfo;
                                activeFile = activePair.file;
                                isBigFile = false;
                            } else {
                                activePair = (Pair)bigFiles.remove(0);
                                active = activePair.jfo;
                                activeFile = activePair.file;
                                isBigFile = true;
                            }
                            if (CALLBACK != null) {
                                CALLBACK.willCompile((JavaFileObject)active);
                            }
                        }
                        if (jt == null) {
                            jt = JavaSourceAccessor.INSTANCE.createJavacTask(cpInfo, listener, sourceLevel);
                            jt.setTaskListener(listener);
                            LOGGER.fine("Created new JavacTask for: " + FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)rootFo));
                        }
                        Iterable trees = jt.parse(new JavaFileObject[]{active});
                        if (listener.lowMemory.getAndSet(false)) {
                            jt.finish();
                            jt = null;
                            listener.cleanDiagnostics();
                            trees = null;
                            if (state) {
                                if (isBigFile) break;
                                bigFiles.add(activePair);
                                active = null;
                                state = false;
                            } else {
                                state = true;
                            }
                            System.gc();
                            continue;
                        }
                        Iterable types = jt.enterTrees(trees);
                        RepositoryUpdater.dumpClasses(listener.getEnteredTypes(), fileManager, rootFo.getURL().toExternalForm(), dirtyFiles, Types.instance(jt.getContext()), Name.Table.instance((Context)jt.getContext()));
                        if (listener.lowMemory.getAndSet(false)) {
                            jt.finish();
                            jt = null;
                            listener.cleanDiagnostics();
                            trees = null;
                            types = null;
                            if (state) {
                                if (isBigFile) break;
                                bigFiles.add(activePair);
                                active = null;
                                state = false;
                            } else {
                                state = true;
                            }
                            System.gc();
                            continue;
                        }
                        final JavaCompiler jc = JavaCompiler.instance(jt.getContext());
                        FileObject finalActive = active;
                        JavacTaskImpl.Filter f = new JavacTaskImpl.Filter((JavaFileObject)finalActive){
                            final /* synthetic */ JavaFileObject val$finalActive;
                            {
                                this.val$finalActive = javaFileObject;
                            }

                            public void process(Env<AttrContext> env) {
                                block2: {
                                    try {
                                        jc.attribute(env);
                                    }
                                    catch (Throwable t) {
                                        if (!this.val$finalActive.toUri().getPath().contains("org/openide/loaders/OpenSupport.java")) break block2;
                                        Exceptions.printStackTrace((Throwable)t);
                                    }
                                }
                            }
                        };
                        f.run((ListBuffer)((Object)jc.todo), types);
                        RepositoryUpdater.dumpClasses(listener.getEnteredTypes(), fileManager, rootFo.getURL().toExternalForm(), dirtyFiles, Types.instance(jt.getContext()), Name.Table.instance((Context)jt.getContext()));
                        if (listener.lowMemory.getAndSet(false)) {
                            jt.finish();
                            jt = null;
                            listener.cleanDiagnostics();
                            trees = null;
                            types = null;
                            if (state) {
                                if (isBigFile) break;
                                bigFiles.add(activePair);
                                active = null;
                                state = false;
                            } else {
                                state = true;
                            }
                            System.gc();
                            continue;
                        }
                        if (sa != null) {
                            sa.analyse(trees, jt, ClasspathInfoAccessor.INSTANCE.getFileManager(cpInfo), (JavaFileObject)active, added);
                        }
                        ArrayList<Diagnostic> diag = new ArrayList<Diagnostic>();
                        URI u = active.toUri();
                        for (Diagnostic d : listener.errors) {
                            if (!active.equals(d.getSource())) continue;
                            diag.add(d);
                        }
                        for (Diagnostic d : listener.warnings) {
                            if (!active.equals(d.getSource())) continue;
                            diag.add(d);
                        }
                        if (TasklistSettings.isTasklistEnabled()) {
                            toRefresh.addAll(TaskCache.getDefault().dumpErrors(rootFo.getURL(), u.toURL(), activeFile, diag));
                        }
                        Log.instance((Context)jt.getContext()).nerrors = 0;
                        if (compiledFiles != null) {
                            compiledFiles.add(activeFile);
                        }
                        active = null;
                        activeFile = null;
                        activePair = null;
                        state = false;
                    }
                    catch (CouplingAbort a) {
                        RepositoryUpdater.couplingAbort(a, active);
                        if (jt != null) {
                            jt.finish();
                        }
                        jt = null;
                        listener.cleanDiagnostics();
                        state = false;
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        if (jt != null) {
                            jt.finish();
                        }
                        URI activeURI = active.toUri();
                        jt = null;
                        active = null;
                        listener.cleanDiagnostics();
                        if (t instanceof Abort) continue;
                        ClassPath bootPath = cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                        ClassPath classPath = cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
                        ClassPath sourcePath = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                        t = Exceptions.attachMessage((Throwable)t, (String)String.format("Root: %s File: %s Bootpath: %s Classpath: %s Sourcepath: %s", FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)rootFo), activeURI.toString(), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString()));
                        Exceptions.printStackTrace((Throwable)t);
                    }
                }
                if (state) {
                    LOGGER.warning("Not enough memory to compile folder: " + FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)rootFo));
                }
            }
            finally {
                if (jt != null) {
                    jt.finish();
                }
            }
        }
        finally {
            LowMemoryNotifier.getDefault().removeLowMemoryListener(listener);
        }
        return toRefresh;
    }

    private static void dumpClasses(List<? extends Symbol.ClassSymbol> entered, JavaFileManager fileManager, String currentRoot, Set<URI> dirtyFiles, Types javacTypes, Name.Table nameTable) throws IOException {
        for (Symbol.ClassSymbol classSymbol : entered) {
            JavaFileObject source = classSymbol.sourcefile;
            RepositoryUpdater.dumpTopLevel(classSymbol, fileManager, source, currentRoot, dirtyFiles, javacTypes, nameTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpTopLevel(Symbol.ClassSymbol classSym, JavaFileManager fileManager, JavaFileObject source, String currentRootURL, Set<URI> dirtyFiles, Types types, Name.Table nameTable) throws IOException {
        assert (source != null);
        if (classSym.getSimpleName() != nameTable.error) {
            URI uri = source.toUri();
            if (dirtyFiles != null && !uri.toURL().toExternalForm().startsWith(currentRootURL)) {
                dirtyFiles.add(uri);
            }
            String sourceName = fileManager.inferBinaryName(StandardLocation.SOURCE_PATH, source);
            StringBuilder classNameBuilder = new StringBuilder();
            ClassFileUtil.encodeClassName(classSym, classNameBuilder, '.');
            String binaryName = classNameBuilder.toString();
            HashSet<String> rsList = null;
            if (!sourceName.equals(binaryName)) {
                rsList = new HashSet<String>();
            }
            JavaFileObject fobj = fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, binaryName, JavaFileObject.Kind.CLASS, source);
            if (classSym.asType() instanceof ErrorType && ((FileObjects.FileBase)fobj).getFile().exists()) {
                return;
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter(fobj.openOutputStream()));
            try {
                SymbolDumper.dump(out, types, classSym, null);
            }
            finally {
                out.close();
            }
            if (rsList != null) {
                rsList.add(binaryName);
            }
            List enclosedElements = classSym.getEnclosedElements();
            for (Symbol ee : enclosedElements) {
                if (!ee.getKind().isClass() && !ee.getKind().isInterface()) continue;
                RepositoryUpdater.dumpClass((Symbol.ClassSymbol)ee, fileManager, source, types, nameTable, rsList);
            }
            if (rsList != null) {
                int index = sourceName.lastIndexOf(46);
                String pkg = index == -1 ? "" : sourceName.substring(0, index);
                String rsName = (index == -1 ? sourceName : sourceName.substring(index + 1)) + '.' + "rs";
                FileObject fo = fileManager.getFileForOutput(StandardLocation.CLASS_OUTPUT, pkg, rsName, source);
                assert (fo != null);
                PrintWriter rsOut = new PrintWriter(fo.openWriter());
                try {
                    for (String sig : rsList) {
                        rsOut.println(sig);
                    }
                }
                finally {
                    rsOut.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpClass(Symbol.ClassSymbol classSym, JavaFileManager fileManager, JavaFileObject source, Types types, Name.Table nameTable, Set<? super String> rsList) throws IOException {
        if (classSym.getSimpleName() != nameTable.error) {
            StringBuilder classNameBuilder = new StringBuilder();
            ClassFileUtil.encodeClassName(classSym, classNameBuilder, '.');
            String binaryName = classNameBuilder.toString();
            JavaFileObject fobj = fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, binaryName, JavaFileObject.Kind.CLASS, source);
            PrintWriter out = new PrintWriter(new OutputStreamWriter(fobj.openOutputStream()));
            try {
                SymbolDumper.dump(out, types, classSym, null);
            }
            finally {
                out.close();
            }
            if (rsList != null) {
                rsList.add(binaryName);
            }
            List enclosedElements = classSym.getEnclosedElements();
            for (Symbol ee : enclosedElements) {
                if (!ee.getKind().isClass() && !ee.getKind().isInterface()) continue;
                RepositoryUpdater.dumpClass((Symbol.ClassSymbol)ee, fileManager, source, types, nameTable, rsList);
            }
        }
    }

    private static Set<String> parseSet(String propertyName, String defaultValue) {
        StringTokenizer st = new StringTokenizer(System.getProperty(propertyName, defaultValue), " \t\n\r\f,-:+!");
        HashSet<String> result = new HashSet<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static Map<String, List<File>> getAllClassFiles(File root, String offset, boolean recursive) {
        int len;
        assert (root != null);
        HashMap<String, List<File>> result = new HashMap<String, List<File>>();
        String rootName = root.getAbsolutePath();
        if (rootName.charAt((len = rootName.length()) - 1) != File.separatorChar) {
            ++len;
        }
        File folder = root;
        if (!(offset.length() <= 0 || (folder = new File(folder, offset)).exists() && folder.isDirectory())) {
            return result;
        }
        RepositoryUpdater.getAllClassFilesImpl(folder, root, len, result, recursive);
        return result;
    }

    private static void gatherResources(File root, File f, int oi, Map<String, List<File>> result) {
        String path = f.getAbsolutePath();
        int extIndex = path.lastIndexOf(46);
        if (extIndex + 1 + "rs".length() == path.length() && path.endsWith("rs")) {
            List<File> files = result.get(path = path.substring(oi, extIndex));
            if (files == null) {
                files = new LinkedList<File>();
                result.put(path, files);
            }
            files.add(0, f);
            try {
                RepositoryUpdater.readRSFile(f, root, files);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        } else if (extIndex + 1 + "sig".length() == path.length() && path.endsWith("sig")) {
            int index = path.indexOf(36, oi);
            List<File> files = result.get(path = index == -1 ? path.substring(oi, extIndex) : path.substring(oi, index));
            if (files == null) {
                files = new LinkedList<File>();
                result.put(path, files);
            }
            files.add(f);
        }
    }

    private static void getAllClassFilesImpl(File folder, File root, int oi, Map<String, List<File>> result, boolean recursive) {
        File[] content = folder.listFiles();
        if (content == null) {
            LOGGER.info("IO error while listing folder: " + folder.getAbsolutePath() + " isDirectory: " + folder.isDirectory() + " canRead: " + folder.canRead());
            return;
        }
        for (File f : content) {
            if (f.isDirectory() && recursive) {
                RepositoryUpdater.getAllClassFilesImpl(f, root, oi, result, recursive);
                continue;
            }
            RepositoryUpdater.gatherResources(root, f, oi, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readRSFile(File f, File root, List<? super File> files) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(f));
        try {
            String binaryName;
            while ((binaryName = in.readLine()) != null) {
                File sf = new File(root, FileObjects.convertPackage2Folder(binaryName) + '.' + "sig");
                files.add(sf);
            }
        }
        finally {
            in.close();
        }
    }

    private static ClassPath.Entry getClassPathEntry(ClassPath cp, URL root) {
        assert (cp != null);
        assert (root != null);
        for (ClassPath.Entry e : cp.entries()) {
            if (!root.equals(e.getURL())) continue;
            return e;
        }
        return null;
    }

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void couplingAbort(CouplingAbort a, JavaFileObject source) {
        String dumpDir = System.getProperty("netbeans.user") + "/var/log/";
        JavaFileObject classSource = a.getClassFile();
        String uri = classSource != null ? classSource.toUri().toASCIIString() : "<unknown>";
        String origName = classSource != null ? classSource.getName() : "unknown";
        File f = new File(dumpDir + origName + ".dump");
        boolean dumpSucceeded = false;
        for (int i = 1; i < 255 && f.exists(); ++i) {
            f = new File(dumpDir + origName + '_' + i + ".dump");
        }
        if (!f.exists()) {
            try {
                FileOutputStream os = new FileOutputStream(f);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                try {
                    writer.println(String.format("Coupling error: class file %s, source file %s", uri, source.toUri().toASCIIString()));
                    writer.println("----- Sig file content: -------------------------------------------");
                    if (classSource == null) {
                        writer.println("no content");
                    } else if (classSource.getName().toLowerCase().endsWith(".sig")) {
                        writer.println(classSource.getCharContent(true));
                    } else {
                        writer.println("not a sig file");
                    }
                    writer.println("----- Source file content: ----------------------------------------");
                    writer.println(source.getCharContent(true));
                    writer.println("----- Tree: -------------------------------------------------------");
                    writer.println(a.getTree().toString());
                    writer.println("----- Coupling Error: ---------------------------------------------");
                    a.printStackTrace(writer);
                }
                finally {
                    writer.close();
                    dumpSucceeded = true;
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Error when writing coupling dump file!", ioe);
            }
        }
        if (dumpSucceeded) {
            LOGGER.log(Level.SEVERE, "Coupling error: class file {0}, source file {1}", new Object[]{uri, source.toUri().toASCIIString()});
        } else {
            LOGGER.log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + dumpDir + "' and " + "clean all *.dump files in that directory.");
        }
    }

    static /* synthetic */ ClassPath access$1000(RepositoryUpdater x0) {
        return x0.cp;
    }

    static /* synthetic */ ClassPath access$1100(RepositoryUpdater x0) {
        return x0.ucp;
    }

    static /* synthetic */ ClassPath access$1200(RepositoryUpdater x0) {
        return x0.binCp;
    }

    static /* synthetic */ Map access$1400(RepositoryUpdater x0) {
        return x0.deps;
    }

    static /* synthetic */ void access$1500(RepositoryUpdater x0) {
        x0.resetDirty();
    }

    static /* synthetic */ boolean access$1800(RepositoryUpdater x0) {
        return x0.isDirty();
    }

    static /* synthetic */ void access$2300(RepositoryUpdater x0, URL x1, Collection x2) {
        x0.assureRecompiled(x1, x2);
    }

    static /* synthetic */ int access$2610(RepositoryUpdater x0) {
        return x0.noSubmited--;
    }

    static /* synthetic */ int access$2600(RepositoryUpdater x0) {
        return x0.noSubmited;
    }

    static {
        CALLBACK = null;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType;

        static {
            $SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType = new int[WorkType.values().length];
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.FILTER_CHANGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.COMPILE_BATCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.COMPILE_CONT.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.COMPILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.DELETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.UPDATE_BINARY.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.COMPILE_WITH_DEPENDENCIES.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$java$source$usages$RepositoryUpdater$WorkType[WorkType.RECOMPILE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static interface Callback {
        public void willCompile(JavaFileObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompileWorker
    implements CancellableTask<CompilationInfo> {
        private Work work;
        private List<URL> state;
        private Set<URL> oldRoots;
        private Set<URL> oldBinaries;
        private Set<URL> newBinaries;
        private ProgressHandle handle;
        private final Set<URI> dirtyCrossFiles;
        private final Set<URL> ignoreExcludes;
        private final AtomicBoolean canceled;
        private BinaryAnalyser activeBinaryAnalyzer;

        public CompileWorker(Work work) {
            assert (work != null);
            this.work = work;
            this.canceled = new AtomicBoolean(false);
            this.dirtyCrossFiles = new HashSet<URI>();
            this.ignoreExcludes = new HashSet<URL>();
        }

        @Override
        public void cancel() {
            this.canceled.set(true);
        }

        @Override
        public void run(CompilationInfo nullInfo) throws IOException {
            ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Void run() throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 30[CASE]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }

        private void findDependencies(URL rootURL, Stack<URL> cycleDetector, Map<URL, List<URL>> depGraph, Set<URL> binaries, boolean useInitialState) {
            if (useInitialState && RepositoryUpdater.this.scannedRoots.contains(rootURL)) {
                this.oldRoots.remove(rootURL);
                return;
            }
            if (depGraph.containsKey(rootURL)) {
                return;
            }
            org.openide.filesystems.FileObject rootFo = URLMapper.findFileObject((URL)rootURL);
            if (rootFo == null) {
                return;
            }
            cycleDetector.push(rootURL);
            ClassPath bootPath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/boot");
            ClassPath compilePath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/compile");
            ClassPath[] pathsToResolve = new ClassPath[]{bootPath, compilePath};
            LinkedList<URL> deps = new LinkedList<URL>();
            for (int i = 0; i < pathsToResolve.length; ++i) {
                ClassPath pathToResolve = pathsToResolve[i];
                if (pathToResolve == null) continue;
                for (ClassPath.Entry entry : pathToResolve.entries()) {
                    URL url = entry.getURL();
                    URL[] sourceRoots = RepositoryUpdater.this.cpImpl.getSourceRootForBinaryRoot(url, pathToResolve, false);
                    if (sourceRoots != null) {
                        for (URL sourceRoot : sourceRoots) {
                            if (sourceRoot.equals(rootURL)) {
                                this.ignoreExcludes.add(rootURL);
                                continue;
                            }
                            if (cycleDetector.contains(sourceRoot)) continue;
                            deps.add(sourceRoot);
                            this.findDependencies(sourceRoot, cycleDetector, depGraph, binaries, useInitialState);
                        }
                        continue;
                    }
                    if (!useInitialState) continue;
                    if (!RepositoryUpdater.this.scannedBinaries.contains(url)) {
                        binaries.add(url);
                    }
                    this.oldBinaries.remove(url);
                }
            }
            depGraph.put(rootURL, deps);
            cycleDetector.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean scanRoots() {
            URL rootURL;
            Iterator<URL> it = this.newBinaries.iterator();
            while (it.hasNext()) {
                if (this.canceled.getAndSet(false)) {
                    return false;
                }
                rootURL = it.next();
                try {
                    it.remove();
                    ClassIndexImpl ci = ClassIndexManager.getDefault().createUsagesQuery(rootURL, false);
                    RepositoryUpdater.this.scannedBinaries.add(rootURL);
                    long startT = System.currentTimeMillis();
                    BinaryAnalyser ba = ci.getBinaryAnalyser();
                    boolean finished = true;
                    try {
                        finished = ba.start(rootURL, this.handle, this.canceled);
                    }
                    finally {
                        if (!finished) {
                            this.activeBinaryAnalyzer = ba;
                            return false;
                        }
                        ba.finish();
                    }
                    long endT = System.currentTimeMillis();
                    if (!PERF_TEST) continue;
                    try {
                        Class<?> c = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                        Method m = c.getMethod("reportScanOfFile", String.class, Long.class);
                        m.invoke(c.newInstance(), rootURL.toExternalForm(), new Long(endT - startT));
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Exceptions.attachMessage((Throwable)e, (String)("While scanning: " + rootURL));
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            it = this.state.listIterator(this.state.size());
            while (it.hasPrevious()) {
                if (this.canceled.getAndSet(false)) {
                    return false;
                }
                try {
                    rootURL = (URL)it.previous();
                    it.remove();
                    if (this.oldRoots.remove(rootURL) || RepositoryUpdater.this.scannedRoots.contains(rootURL)) continue;
                    long startT = System.currentTimeMillis();
                    this.updateFolder(rootURL, rootURL, false, this.handle);
                    long endT = System.currentTimeMillis();
                    if (!PERF_TEST) continue;
                    try {
                        Class<?> c = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                        Method m = c.getMethod("reportScanOfFile", String.class, Long.class);
                        m.invoke(c.newInstance(), rootURL.toExternalForm(), new Long(endT - startT));
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseFiles(URL root, boolean isInitialCompilation, Iterable<File> children, boolean clean, ProgressHandle handle, JavaFileFilterImplementation filter, Map<String, List<File>> resources, Set<File> compiledFiles) throws IOException {
            Object message;
            ClasspathInfo cpInfo;
            org.openide.filesystems.FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null) {
                return;
            }
            if (!rootFo.isFolder()) {
                LOGGER.warning("Source root has to be a folder: " + FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)rootFo));
                return;
            }
            File rootFile = FileUtil.toFile((org.openide.filesystems.FileObject)rootFo);
            ClassPath sourcePath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/source");
            ClassPath bootPath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/boot");
            ClassPath compilePath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/compile");
            ClassPath.Entry entry = null;
            if (!this.ignoreExcludes.contains(root)) {
                entry = RepositoryUpdater.getClassPathEntry(sourcePath, root);
                cpInfo = ClasspathInfoAccessor.INSTANCE.create(bootPath, compilePath, sourcePath, filter, true, false);
            } else {
                cpInfo = ClasspathInfoAccessor.INSTANCE.create(bootPath, compilePath, sourcePath, filter, true, true);
            }
            if (isInitialCompilation) {
                clean |= RepositoryUpdater.getAttribute(root, RepositoryUpdater.DIRTY_ROOT, null) != null;
                String sourceLevel = SourceLevelQuery.getSourceLevel((org.openide.filesystems.FileObject)rootFo);
                clean |= RepositoryUpdater.ensureAttributeValue(root, RepositoryUpdater.SOURCE_LEVEL_ROOT, sourceLevel, true);
                String extraCompilerOptions = CompilerSettings.getCommandLine();
                if (extraCompilerOptions.length() == 0) {
                    extraCompilerOptions = null;
                }
                clean |= RepositoryUpdater.ensureAttributeValue(root, RepositoryUpdater.EXTRA_COMPILER_OPTIONS, extraCompilerOptions, true);
                if (TasklistSettings.isTasklistEnabled()) {
                    clean |= RepositoryUpdater.ensureAttributeValue(root, RepositoryUpdater.CLASSPATH_ATTRIBUTE, RepositoryUpdater.classPathToString(ClasspathInfo.create(bootPath, compilePath, sourcePath)), true);
                    if (TasklistSettings.isDependencyTrackingEnabled()) {
                        clean |= RepositoryUpdater.ensureAttributeValue(root, RepositoryUpdater.CONTAINS_TASKLIST_DATA, "true", true);
                        clean |= RepositoryUpdater.ensureAttributeValue(root, RepositoryUpdater.CONTAINS_TASKLIST_DEPENDENCY_DATA, "true", true);
                    }
                } else {
                    RepositoryUpdater.ensureAttributeValue(root, RepositoryUpdater.CONTAINS_TASKLIST_DATA, null, false);
                    RepositoryUpdater.ensureAttributeValue(root, RepositoryUpdater.CONTAINS_TASKLIST_DEPENDENCY_DATA, null, false);
                }
            }
            LinkedList<Pair> toCompile = new LinkedList<Pair>();
            File classCache = Index.getClassFolder(rootFile);
            ClassIndexImpl uqImpl = ClassIndexManager.getDefault().createUsagesQuery(root, true);
            assert (uqImpl != null);
            SourceAnalyser sa = uqImpl.getSourceAnalyser();
            assert (sa != null);
            boolean invalidIndex = isInitialCompilation && !sa.isValid();
            HashSet<File> rs = new HashSet<File>();
            Charset encoding = FileEncodingQuery.getEncoding((org.openide.filesystems.FileObject)rootFo);
            HashSet<ElementHandle> removed = isInitialCompilation ? null : new HashSet<ElementHandle>();
            HashSet added = isInitialCompilation ? null : new HashSet();
            HashSet<URL> errorBadgesToRefresh = new HashSet<URL>();
            for (File file : children) {
                String offset = FileObjects.getRelativePath(rootFile, file);
                if (entry == null || entry.includes(offset.replace(File.separatorChar, '/'))) {
                    List<File> files;
                    if (invalidIndex || clean || this.dirtyCrossFiles.remove(file.toURI())) {
                        toCompile.add(new Pair(FileObjects.fileFileObject(file, rootFile, filter, encoding), file));
                        continue;
                    }
                    int index = offset.lastIndexOf(46);
                    if (index > -1) {
                        offset = offset.substring(0, index);
                    }
                    if ((files = resources.remove(offset)) == null) {
                        toCompile.add(new Pair(FileObjects.fileFileObject(file, rootFile, filter, encoding), file));
                        continue;
                    }
                    boolean rsf = files.get(0).getName().endsWith("rs");
                    if (files.get(0).lastModified() < file.lastModified()) {
                        toCompile.add(new Pair(FileObjects.fileFileObject(file, rootFile, filter, encoding), file));
                        for (File toDelete : files) {
                            toDelete.delete();
                            if (rsf) {
                                rsf = false;
                                continue;
                            }
                            String className = FileObjects.getBinaryName(toDelete, classCache);
                            sa.delete(className);
                            if (removed == null) continue;
                            removed.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, className));
                        }
                        continue;
                    }
                    if (!rsf) continue;
                    files.remove(0);
                    rs.addAll(files);
                    continue;
                }
                if (!TasklistSettings.isTasklistEnabled()) continue;
                errorBadgesToRefresh.addAll(TaskCache.getDefault().dumpErrors(root, file.toURL(), file, Collections.emptyList()));
            }
            for (List list : resources.values()) {
                for (File toDelete : list) {
                    if (rs.contains(toDelete)) continue;
                    toDelete.delete();
                    if (!toDelete.getName().endsWith("sig")) continue;
                    String className = FileObjects.getBinaryName(toDelete, classCache);
                    sa.delete(className);
                    if (removed == null) continue;
                    removed.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, className));
                }
            }
            if (!toCompile.isEmpty()) {
                if (handle != null) {
                    message = String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_BackgroundCompile"), rootFile.getAbsolutePath());
                    handle.setDisplayName((String)message);
                }
                errorBadgesToRefresh.addAll(RepositoryUpdater.batchCompile(toCompile, rootFo, cpInfo, sa, this.dirtyCrossFiles, compiledFiles, compiledFiles != null ? this.canceled : null, added));
            }
            sa.store();
            message = RepositoryUpdater.this;
            synchronized (message) {
                if (RepositoryUpdater.this.url2Recompile.get(root) == null) {
                    RepositoryUpdater.setAttribute(root, RepositoryUpdater.DIRTY_ROOT, null);
                }
            }
            if (TasklistSettings.isTasklistEnabled()) {
                ErrorAnnotator an;
                if (TasklistSettings.isBadgesEnabled() && !errorBadgesToRefresh.isEmpty() && (an = ErrorAnnotator.getAnnotator()) != null) {
                    an.updateInError(errorBadgesToRefresh);
                }
                JavaTaskProvider.refresh(rootFo);
            }
            if (added != null) {
                assert (removed != null);
                HashSet _at = new HashSet(added);
                HashSet hashSet = new HashSet(removed);
                _at.removeAll(removed);
                hashSet.removeAll(added);
                added.retainAll(removed);
                uqImpl.typesEvent(_at.isEmpty() ? null : new ClassIndexImplEvent(uqImpl, _at), hashSet.isEmpty() ? null : new ClassIndexImplEvent(uqImpl, hashSet), added.isEmpty() ? null : new ClassIndexImplEvent(uqImpl, added));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFolder(URL folder, URL root, boolean clean, ProgressHandle handle) throws IOException {
            org.openide.filesystems.FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null) {
                return;
            }
            if (!rootFo.isFolder()) {
                LOGGER.warning("Source root has to be a folder: " + FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)rootFo));
                return;
            }
            ClassPath sourcePath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/source");
            ClassPath bootPath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/boot");
            ClassPath compilePath = ClassPath.getClassPath((org.openide.filesystems.FileObject)rootFo, (String)"classpath/compile");
            if (!RepositoryUpdater.this.classPath2Root.containsKey(bootPath)) {
                bootPath.addPropertyChangeListener((PropertyChangeListener)RepositoryUpdater.this);
                RepositoryUpdater.this.classPath2Root.put(bootPath, root);
            }
            if (!RepositoryUpdater.this.classPath2Root.containsKey(compilePath)) {
                compilePath.addPropertyChangeListener((PropertyChangeListener)RepositoryUpdater.this);
                RepositoryUpdater.this.classPath2Root.put(compilePath, root);
            }
            boolean isInitialCompilation = folder.equals(root);
            if (sourcePath == null || bootPath == null || compilePath == null) {
                LOGGER.warning("Ignoring root with no ClassPath: " + FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)rootFo));
                return;
            }
            try {
                JavaFileFilterImplementation filter;
                File folderFile;
                File rootFile = FileUtil.toFile((org.openide.filesystems.FileObject)rootFo);
                if (rootFile == null) {
                    return;
                }
                File file = folderFile = isInitialCompilation ? rootFile : FileUtil.normalizeFile((File)new File(URI.create(folder.toExternalForm())));
                if (handle != null) {
                    String message = String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Scannig"), rootFile.getAbsolutePath());
                    handle.setDisplayName(message);
                }
                if ((filter = (JavaFileFilterImplementation)RepositoryUpdater.this.filters.get(root)) == null && (filter = JavaFileFilterQuery.getFilter(rootFo)) != null) {
                    if (!RepositoryUpdater.this.filters.values().contains(filter)) {
                        filter.addChangeListener((ChangeListener)RepositoryUpdater.this.filterListener);
                    }
                    RepositoryUpdater.this.filters.put(root, filter);
                }
                File classCache = Index.getClassFolder(rootFile);
                Map<String, List<File>> resources = RepositoryUpdater.getAllClassFiles(classCache, FileObjects.getRelativePath(rootFile, folderFile), true);
                LazyFileList children = new LazyFileList(folderFile);
                this.parseFiles(root, isInitialCompilation, children, clean, handle, filter, resources, null);
            }
            finally {
                if (!clean && isInitialCompilation) {
                    RepositoryUpdater.this.scannedRoots.add(root);
                }
            }
        }

        private Collection<File> updateFile(URL file, URL root) throws IOException {
            LinkedHashSet<File> result = new LinkedHashSet<File>();
            org.openide.filesystems.FileObject fo = URLMapper.findFileObject((URL)file);
            if (fo == null) {
                return result;
            }
            assert ("file".equals(root.getProtocol())) : "Unexpected protocol of URL: " + root;
            ClassIndexImpl uqImpl = ClassIndexManager.getDefault().createUsagesQuery(root, true);
            if (uqImpl != null) {
                uqImpl.setDirty(null);
                JavaFileFilterImplementation filter = JavaFileFilterQuery.getFilter(fo);
                ClasspathInfo cpInfo = ClasspathInfoAccessor.INSTANCE.create(fo, filter, true, false);
                File rootFile = FileUtil.normalizeFile((File)new File(URI.create(root.toExternalForm())));
                File fileFile = FileUtil.toFile((org.openide.filesystems.FileObject)fo);
                File classCache = Index.getClassFolder(rootFile);
                Map<String, List<File>> resources = RepositoryUpdater.getAllClassFiles(classCache, FileObjects.getRelativePath(rootFile, fileFile.getParentFile()), false);
                String offset = FileObjects.getRelativePath(rootFile, fileFile);
                int index = offset.lastIndexOf(46);
                if (index > -1) {
                    offset = offset.substring(0, index);
                }
                List<File> files = resources.remove(offset);
                SourceAnalyser sa = uqImpl.getSourceAnalyser();
                assert (sa != null);
                HashSet<String> classNamesToDelete = new HashSet<String>();
                HashSet added = new HashSet();
                HashSet<ElementHandle> removed = new HashSet<ElementHandle>();
                if (files != null) {
                    for (File toDelete : files) {
                        toDelete.delete();
                        if (!toDelete.getName().endsWith("sig")) continue;
                        String className = FileObjects.getBinaryName(toDelete, classCache);
                        classNamesToDelete.add(className);
                        removed.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, className));
                    }
                } else {
                    classNamesToDelete.add(FileObjects.convertFolder2Package(offset, '/'));
                }
                ClassPath.Entry entry = RepositoryUpdater.getClassPathEntry(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), root);
                if (entry == null || entry.includes(fo)) {
                    String sourceLevel = SourceLevelQuery.getSourceLevel((org.openide.filesystems.FileObject)fo);
                    CompilerListener listener = new CompilerListener();
                    JavaFileManager fm = ClasspathInfoAccessor.INSTANCE.getFileManager(cpInfo);
                    JavaFileObject active = FileObjects.fileFileObject(fileFile, rootFile, filter, FileEncodingQuery.getEncoding((org.openide.filesystems.FileObject)fo));
                    JavacTaskImpl jt = JavaSourceAccessor.INSTANCE.createJavacTask(cpInfo, listener, sourceLevel);
                    jt.setTaskListener(listener);
                    Iterable trees = jt.parse(new JavaFileObject[]{active});
                    Iterable<? extends Element> classes = jt.enter();
                    Map<ElementHandle, Collection<String>> members = RebuildOraculum.sortOut(jt.getElements(), classes);
                    result.addAll(RebuildOraculum.get(fo).findFilesToRebuild(rootFile, fo, cpInfo, members, classNamesToDelete));
                    jt.analyze();
                    RepositoryUpdater.dumpClasses(listener.getEnteredTypes(), fm, root.toExternalForm(), null, Types.instance(jt.getContext()), Name.Table.instance((Context)jt.getContext()));
                    sa.analyse(trees, jt, fm, active, added);
                    for (String s : classNamesToDelete) {
                        sa.delete(s);
                    }
                    ArrayList<Diagnostic> diag = new ArrayList<Diagnostic>();
                    URI u = active.toUri();
                    for (Diagnostic d : listener.errors) {
                        if (active != d.getSource()) continue;
                        diag.add(d);
                    }
                    for (Diagnostic d : listener.warnings) {
                        if (active != d.getSource()) continue;
                        diag.add(d);
                    }
                    if (TasklistSettings.isTasklistEnabled()) {
                        ErrorAnnotator an;
                        Set<URL> toRefresh = TaskCache.getDefault().dumpErrors(root, file, fileFile, diag);
                        if (TasklistSettings.isBadgesEnabled() && (an = ErrorAnnotator.getAnnotator()) != null) {
                            an.updateInError(toRefresh);
                        }
                        JavaTaskProvider.refresh(fo);
                    }
                    Log.instance((Context)jt.getContext()).nerrors = 0;
                    listener.cleanDiagnostics();
                } else {
                    for (String s : classNamesToDelete) {
                        sa.delete(s);
                    }
                }
                sa.store();
                HashSet _at = new HashSet(added);
                HashSet _rt = new HashSet(removed);
                _at.removeAll(removed);
                _rt.removeAll(added);
                added.retainAll(removed);
                uqImpl.typesEvent(_at.isEmpty() ? null : new ClassIndexImplEvent(uqImpl, _at), _rt.isEmpty() ? null : new ClassIndexImplEvent(uqImpl, _rt), added.isEmpty() ? null : new ClassIndexImplEvent(uqImpl, added));
            }
            return result;
        }

        private List<File> delete(URL file, URL root, boolean folder) throws IOException {
            List<File> toReparse = null;
            assert ("file".equals(root.getProtocol())) : "Unexpected protocol of URL: " + root;
            File rootFile = FileUtil.normalizeFile((File)new File(URI.create(root.toExternalForm())));
            assert ("file".equals(file.getProtocol())) : "Unexpected protocol of URL: " + file;
            File fileFile = FileUtil.normalizeFile((File)new File(URI.create(file.toExternalForm())));
            String offset = FileObjects.getRelativePath(rootFile, fileFile);
            assert (offset != null && offset.length() > 0) : String.format("File %s not under root %s ", fileFile.getAbsolutePath(), rootFile.getAbsolutePath());
            File classCache = Index.getClassFolder(rootFile);
            File[] affectedFiles = null;
            if (folder) {
                File container = new File(classCache, offset);
                affectedFiles = container.listFiles();
            } else {
                int slashIndex = offset.lastIndexOf(File.separatorChar);
                int dotIndex = offset.lastIndexOf(46);
                File container = slashIndex == -1 ? classCache : new File(classCache, offset.substring(0, slashIndex));
                String name = offset.substring(slashIndex + 1, dotIndex);
                String[] patterns = new String[]{name + '.', name + '$'};
                File[] content = container.listFiles();
                if (content != null) {
                    ArrayList<File> result = new ArrayList<File>(content.length);
                    for (File f : content) {
                        String fname = f.getName();
                        if (!fname.startsWith(patterns[0]) && !fname.startsWith(patterns[1])) continue;
                        result.add(f);
                    }
                    affectedFiles = result.toArray(new File[result.size()]);
                }
            }
            if (affectedFiles != null && affectedFiles.length > 0) {
                HashSet<ElementHandle> removed = new HashSet<ElementHandle>();
                ClassIndexImpl uqImpl = ClassIndexManager.getDefault().createUsagesQuery(root, true);
                assert (uqImpl != null);
                SourceAnalyser sa = uqImpl.getSourceAnalyser();
                assert (sa != null);
                ArrayList<String> classNames = new ArrayList<String>();
                for (File f : affectedFiles) {
                    if (f.getName().endsWith("rs")) {
                        LinkedList rsFiles = new LinkedList();
                        RepositoryUpdater.readRSFile(f, classCache, rsFiles);
                        for (File rsf : rsFiles) {
                            String className = FileObjects.getBinaryName(rsf, classCache);
                            classNames.add(className);
                            removed.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, className));
                            rsf.delete();
                        }
                    } else {
                        String className = FileObjects.getBinaryName(f, classCache);
                        classNames.add(className);
                        removed.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, className));
                    }
                    f.delete();
                }
                ArrayList<ElementHandle<TypeElement>> classes = new ArrayList<ElementHandle<TypeElement>>();
                for (String s : classNames) {
                    classes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, s));
                }
                org.openide.filesystems.FileObject rootFO = FileUtil.toFileObject((File)rootFile);
                JavaFileFilterImplementation filter = JavaFileFilterQuery.getFilter(rootFO);
                ClasspathInfo cpInfo = ClasspathInfoAccessor.INSTANCE.create(rootFO, filter, true, false);
                toReparse = RebuildOraculum.findAllDependent(rootFile, rootFO, cpInfo.getClassIndex(), classes);
                for (String s : classNames) {
                    sa.delete(s);
                }
                sa.store();
                uqImpl.typesEvent(null, new ClassIndexImplEvent(uqImpl, removed), null);
            }
            return toReparse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBinary(URL file, URL root) throws IOException {
            CachingArchiveProvider.getDefault().clearArchive(root);
            File cacheFolder = Index.getClassFolder(root);
            FileObjects.deleteRecursively(cacheFolder);
            BinaryAnalyser ba = ClassIndexManager.getDefault().createUsagesQuery(root, false).getBinaryAnalyser();
            try {
                boolean finished = ba.start(root, this.handle, new AtomicBoolean(false));
                while (!finished) {
                    finished = ba.resume();
                }
            }
            finally {
                ba.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recompile() throws IOException {
            HashMap<URL, Collection> toRecompile = new HashMap<URL, Collection>();
            LinkedList<URL> handledRoots = new LinkedList<URL>();
            RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
            synchronized (repositoryUpdater) {
                toRecompile.putAll(RepositoryUpdater.this.url2Recompile);
                RepositoryUpdater.this.url2Recompile.clear();
                RepositoryUpdater.this.recompileScheduled = false;
            }
            Logger.getLogger(RepositoryUpdater.class.getName()).log(Level.FINE, RepositoryUpdater.GOING_TO_RECOMPILE, toRecompile);
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)"Refreshing Workspace");
            handle.start();
            Iterator it = toRecompile.keySet().iterator();
            while (it.hasNext()) {
                URL root = (URL)it.next();
                handledRoots.add(root);
                org.openide.filesystems.FileObject rootFO = URLMapper.findFileObject((URL)root);
                long start = System.currentTimeMillis();
                JavaFileFilterImplementation filter = JavaFileFilterQuery.getFilter(rootFO);
                File cacheRoot = Index.getClassFolder(root);
                Collection files = (Collection)toRecompile.get(root);
                long cur = System.currentTimeMillis();
                HashSet<File> compiledFiles = new HashSet<File>();
                HashMap<String, List<File>> resources = new HashMap<String, List<File>>();
                File rootFile = FileUtil.toFile((org.openide.filesystems.FileObject)rootFO);
                String rootName = cacheRoot.getAbsolutePath();
                int len = rootName.length();
                if (rootName.charAt(len - 1) != File.separatorChar) {
                    ++len;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "going to compute resources");
                    LOGGER.log(Level.FINE, "files={0}", files);
                }
                for (File toProcess : files) {
                    String relative = FileObjects.stripExtension(FileObjects.getRelativePath(rootFile, toProcess));
                    LOGGER.log(Level.FINE, "relative={0}", relative);
                    File f = new File(cacheRoot, relative + '.' + "rs");
                    LOGGER.log(Level.FINE, "f={0}, exists={1}", new Object[]{f.getAbsolutePath(), f.exists()});
                    if (f.exists()) {
                        RepositoryUpdater.gatherResources(cacheRoot, f, len, resources);
                        continue;
                    }
                    f = new File(cacheRoot, relative + '.' + "sig");
                    LOGGER.log(Level.FINE, "f={0}, exists={1}", new Object[]{f.getAbsolutePath(), f.exists()});
                    if (!f.exists()) continue;
                    RepositoryUpdater.gatherResources(cacheRoot, f, len, resources);
                    File folder = f.getParentFile();
                    File[] children = folder.listFiles();
                    if (children == null) {
                        LOGGER.info("IO error while listing folder: " + folder.getAbsolutePath() + " isDirectory: " + folder.isDirectory() + " canRead: " + folder.canRead());
                        continue;
                    }
                    String prefix = FileObjects.stripExtension(f.getName()) + "$";
                    for (File child : children) {
                        if (!child.getName().startsWith(prefix)) continue;
                        RepositoryUpdater.gatherResources(cacheRoot, child, len, resources);
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "resources={0}", resources);
                }
                this.parseFiles(root, false, files, true, handle, filter, resources, compiledFiles);
                files.removeAll(compiledFiles);
                if (!files.isEmpty()) {
                    toRecompile.put(root, files);
                    break;
                }
                it.remove();
                TimesCollector.getDefault().reportTime(rootFO, "deps-reparse", "Deps - Reparse", System.currentTimeMillis() - cur);
                TimesCollector.getDefault().reportTime(rootFO, "deps-total", "Deps - Total", System.currentTimeMillis() - start);
            }
            if (!toRecompile.isEmpty()) {
                RepositoryUpdater repositoryUpdater2 = RepositoryUpdater.this;
                synchronized (repositoryUpdater2) {
                    for (URL root : toRecompile.keySet()) {
                        LinkedHashSet storedFiles = (LinkedHashSet)RepositoryUpdater.this.url2Recompile.get(root);
                        if (storedFiles == null) {
                            storedFiles = new LinkedHashSet();
                            RepositoryUpdater.this.url2Recompile.put(root, storedFiles);
                        }
                        storedFiles.addAll((Collection)toRecompile.get(root));
                    }
                    if (!RepositoryUpdater.this.recompileScheduled) {
                        RepositoryUpdater.this.submit(Work.recompile());
                        RepositoryUpdater.this.recompileScheduled = true;
                    }
                }
            }
            handle.finish();
        }

        static /* synthetic */ Work access$100(CompileWorker x0) {
            return x0.work;
        }

        static /* synthetic */ void access$200(CompileWorker x0, URL x1, Stack x2, Map x3, Set x4, boolean x5) {
            x0.findDependencies(x1, x2, x3, x4, x5);
        }

        static /* synthetic */ List access$302(CompileWorker x0, List x1) {
            x0.state = x1;
            return x0.state;
        }

        static /* synthetic */ List access$300(CompileWorker x0) {
            return x0.state;
        }

        static /* synthetic */ void access$400(CompileWorker x0, URL x1, URL x2, boolean x3, ProgressHandle x4) throws IOException {
            x0.updateFolder(x1, x2, x3, x4);
        }

        static /* synthetic */ ProgressHandle access$500(CompileWorker x0) {
            return x0.handle;
        }

        static /* synthetic */ ProgressHandle access$502(CompileWorker x0, ProgressHandle x1) {
            x0.handle = x1;
            return x0.handle;
        }

        static /* synthetic */ Set access$602(CompileWorker x0, Set x1) {
            x0.oldRoots = x1;
            return x0.oldRoots;
        }

        static /* synthetic */ Set access$802(CompileWorker x0, Set x1) {
            x0.oldBinaries = x1;
            return x0.oldBinaries;
        }

        static /* synthetic */ Set access$1302(CompileWorker x0, Set x1) {
            x0.newBinaries = x1;
            return x0.newBinaries;
        }

        static /* synthetic */ Set access$800(CompileWorker x0) {
            return x0.oldBinaries;
        }

        static /* synthetic */ Set access$1300(CompileWorker x0) {
            return x0.newBinaries;
        }

        static /* synthetic */ BinaryAnalyser access$1600(CompileWorker x0) {
            return x0.activeBinaryAnalyzer;
        }

        static /* synthetic */ BinaryAnalyser access$1602(CompileWorker x0, BinaryAnalyser x1) {
            x0.activeBinaryAnalyzer = x1;
            return x0.activeBinaryAnalyzer;
        }

        static /* synthetic */ Work access$102(CompileWorker x0, Work x1) {
            x0.work = x1;
            return x0.work;
        }

        static /* synthetic */ boolean access$1700(CompileWorker x0) {
            return x0.scanRoots();
        }

        static /* synthetic */ Set access$600(CompileWorker x0) {
            return x0.oldRoots;
        }

        static /* synthetic */ Collection access$2100(CompileWorker x0, URL x1, URL x2) throws IOException {
            return x0.updateFile(x1, x2);
        }

        static /* synthetic */ List access$2200(CompileWorker x0, URL x1, URL x2, boolean x3) throws IOException {
            return x0.delete(x1, x2, x3);
        }

        static /* synthetic */ void access$2400(CompileWorker x0, URL x1, URL x2) throws IOException {
            x0.updateBinary(x1, x2);
        }

        static /* synthetic */ void access$2500(CompileWorker x0) throws IOException {
            x0.recompile();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerListener
    implements DiagnosticListener<JavaFileObject>,
    LowMemoryListener,
    TaskListener {
        final List<Diagnostic> errors = new LinkedList<Diagnostic>();
        final List<Diagnostic> warnings = new LinkedList<Diagnostic>();
        final List<Symbol.ClassSymbol> justEntered = new LinkedList<Symbol.ClassSymbol>();
        final AtomicBoolean lowMemory = new AtomicBoolean();

        private CompilerListener() {
        }

        void cleanDiagnostics() {
            if (!this.errors.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Diagnostic msg : this.errors) {
                        LOGGER.fine(msg.toString());
                    }
                }
                this.errors.clear();
            }
            if (!this.warnings.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Diagnostic msg : this.warnings) {
                        LOGGER.fine(msg.toString());
                    }
                }
                this.warnings.clear();
            }
            this.justEntered.clear();
        }

        List<? extends Symbol.ClassSymbol> getEnteredTypes() {
            ArrayList<Symbol.ClassSymbol> result = new ArrayList<Symbol.ClassSymbol>(this.justEntered);
            this.justEntered.clear();
            return result;
        }

        @Override
        public void report(Diagnostic diagnosticMessage) {
            Diagnostic.Kind kind = diagnosticMessage.getKind();
            if (kind == Diagnostic.Kind.ERROR) {
                this.errors.add(diagnosticMessage);
            } else if (kind == Diagnostic.Kind.WARNING || kind == Diagnostic.Kind.MANDATORY_WARNING) {
                this.warnings.add(diagnosticMessage);
            }
        }

        @Override
        public void started(TaskEvent event) {
        }

        @Override
        public void finished(TaskEvent event) {
            if (event.getKind() == TaskEvent.Kind.ENTER) {
                CompilationUnitTree unit = event.getCompilationUnit();
                for (Tree tree : unit.getTypeDecls()) {
                    Symbol.ClassSymbol sym;
                    if (!(tree instanceof JCTree.JCClassDecl) || (sym = ((JCTree.JCClassDecl)tree).sym) == null) continue;
                    if (sym.sourcefile == null) {
                        sym.sourcefile = event.getSourceFile();
                    }
                    if (sym.sourcefile instanceof FileObjects.ZipFileBase) continue;
                    this.justEntered.add(sym);
                }
            }
        }

        @Override
        public void lowMemory(LowMemoryEvent event) {
            this.lowMemory.set(true);
        }
    }

    private final class Delay {
        private final Timer timer = new Timer();
        private final List<Work> tasks = new LinkedList<Work>();

        public synchronized void post(Work work) {
            assert (work != null);
            this.tasks.add(work);
            this.timer.schedule((TimerTask)new DelayTask(work), DELAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Work[] toCancel;
            Delay delay = this;
            synchronized (delay) {
                toCancel = this.tasks.toArray(new Work[this.tasks.size()]);
            }
            for (Work w : toCancel) {
                if (w.workType == WorkType.COMPILE) {
                    w = new SingleRootWork(WorkType.DELETE, ((SingleRootWork)w).file, ((SingleRootWork)w).root, ((SingleRootWork)w).isFolder, w.latch);
                }
                CompileWorker cw = new CompileWorker(w);
                try {
                    cw.run(null);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }

        private class DelayTask
        extends TimerTask {
            final Work work;

            public DelayTask(Work work) {
                this.work = work;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RepositoryUpdater.this.submit(this.work);
                Delay delay = Delay.this;
                synchronized (delay) {
                    Delay.this.tasks.remove(this.work);
                    Delay.this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                boolean retValue = super.cancel();
                if (retValue) {
                    Delay delay = Delay.this;
                    synchronized (delay) {
                        Delay.this.tasks.remove(this.work);
                        Delay.this.notifyAll();
                    }
                }
                return retValue;
            }
        }
    }

    private class FilterListener
    implements ChangeListener {
        private FilterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent event) {
            Object source = event.getSource();
            if (source instanceof JavaFileFilterImplementation) {
                LinkedList<URL> dirtyRoots = new LinkedList<URL>();
                Map map = RepositoryUpdater.this.filters;
                synchronized (map) {
                    for (Map.Entry e : RepositoryUpdater.this.filters.entrySet()) {
                        if (e.getValue() != source) continue;
                        dirtyRoots.add((URL)e.getKey());
                    }
                }
                RepositoryUpdater.this.submit(Work.filterChange(dirtyRoots, true));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LazyFileList
    implements Iterable<File> {
        private File root;

        public LazyFileList(File root) {
            assert (root != null);
            this.root = root;
        }

        @Override
        public Iterator<File> iterator() {
            if (!this.root.exists()) {
                return Collections.emptySet().iterator();
            }
            return new It(this.root);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class It
        implements Iterator<File> {
            private final List<File> toDo = new LinkedList<File>();

            public It(File root) {
                this.toDo.addAll(Arrays.asList(root.listFiles()));
            }

            @Override
            public boolean hasNext() {
                while (!this.toDo.isEmpty()) {
                    File f = this.toDo.remove(0);
                    String name = f.getName();
                    if (f.isDirectory() && !ignoredDirectories.contains(name) && Utilities.isJavaIdentifier((String)name)) {
                        File[] content = f.listFiles();
                        int j = 0;
                        for (int i = 0; i < content.length; ++i) {
                            f = content[i];
                            if (f.isFile()) {
                                this.toDo.add(j++, f);
                                continue;
                            }
                            this.toDo.add(f);
                        }
                        continue;
                    }
                    if (!name.endsWith(".java") || RepositoryUpdater.PACKAGE_INFO.equals(name) || f.length() <= 0L) continue;
                    this.toDo.add(0, f);
                    return true;
                }
                return false;
            }

            @Override
            public File next() {
                return this.toDo.remove(0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiRootsWork
    extends Work {
        private List<URL> roots;
        private boolean forceClean;

        public MultiRootsWork(WorkType type, List<URL> roots, boolean forceClean, CountDownLatch latch) {
            super(type, latch);
            this.roots = roots;
            this.forceClean = forceClean;
        }

        public List<URL> getRoots() {
            return this.roots;
        }

        public boolean getForceClean() {
            return this.forceClean;
        }
    }

    private static class Pair {
        private JavaFileObject jfo;
        private File file;

        public Pair(JavaFileObject jfo, File file) {
            this.jfo = jfo;
            this.file = file;
        }
    }

    private static class RecompileWork
    extends Work {
        public RecompileWork(CountDownLatch latch) {
            super(WorkType.RECOMPILE, latch);
        }
    }

    private static class SingleRootWork
    extends Work {
        private URL file;
        private URL root;
        private boolean isFolder;

        public SingleRootWork(WorkType type, URL file, URL root, boolean isFolder, CountDownLatch latch) {
            super(type, latch);
            this.file = file;
            this.root = root;
            this.isFolder = isFolder;
        }

        public URL getFile() {
            return this.file;
        }

        public URL getRoot() {
            return this.root;
        }

        public boolean isFolder() {
            return this.isFolder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Work {
        private final WorkType workType;
        private final CountDownLatch latch;

        protected Work(WorkType workType, CountDownLatch latch) {
            assert (workType != null);
            this.workType = workType;
            this.latch = latch;
        }

        public WorkType getType() {
            return this.workType;
        }

        public void finished() {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public static Work batch() {
            return new Work(WorkType.COMPILE_BATCH, null);
        }

        public static Work compile(org.openide.filesystems.FileObject file, URL root) throws FileStateInvalidException {
            return Work.compile(file.getURL(), root, file.isFolder());
        }

        public static Work compile(org.openide.filesystems.FileObject file, URL root, WorkType type) throws FileStateInvalidException {
            return Work.compile(file.getURL(), root, file.isFolder(), type);
        }

        public static Work compile(URL file, URL root, boolean isFolder) {
            assert (file != null && root != null);
            return new SingleRootWork(WorkType.COMPILE, file, root, isFolder, null);
        }

        public static Work compile(URL file, URL root, boolean isFolder, WorkType type) {
            assert (file != null && root != null);
            return new SingleRootWork(type, file, root, isFolder, null);
        }

        public static Work compile(org.openide.filesystems.FileObject file, URL root, CountDownLatch[] latch) throws FileStateInvalidException {
            assert (file != null && root != null);
            assert (latch != null && latch.length == 1 && latch[0] == null);
            latch[0] = new CountDownLatch(1);
            return new SingleRootWork(WorkType.COMPILE, file.getURL(), root, file.isFolder(), latch[0]);
        }

        public static Work delete(org.openide.filesystems.FileObject file, URL root, boolean isFolder) throws FileStateInvalidException {
            return Work.delete(file.getURL(), root, file.isFolder());
        }

        public static Work delete(URL file, URL root, boolean isFolder) {
            assert (file != null && root != null);
            return new SingleRootWork(WorkType.DELETE, file, root, isFolder, null);
        }

        public static Work binary(org.openide.filesystems.FileObject file, URL root) throws FileStateInvalidException {
            return Work.binary(file.getURL(), root, file.isFolder());
        }

        public static Work binary(URL file, URL root, boolean isFolder) {
            assert (file != null && root != null);
            return new SingleRootWork(WorkType.UPDATE_BINARY, file, root, isFolder, null);
        }

        public static Work filterChange(List<URL> roots, boolean forceClean) {
            assert (roots != null);
            return new MultiRootsWork(WorkType.FILTER_CHANGED, roots, forceClean, null);
        }

        public static Work recompile() {
            return new RecompileWork(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WorkType {
        COMPILE_BATCH,
        COMPILE_CONT,
        COMPILE,
        DELETE,
        UPDATE_BINARY,
        FILTER_CHANGED,
        COMPILE_WITH_DEPENDENCIES,
        RECOMPILE;

    }
}

