/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javadoc.JavadocClassReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolClassReader
extends JavadocClassReader {
    private Symtab syms;
    private Name.Table table;
    private Types types;
    private JavacTypes jTypes;
    private Log logger;
    private Source source;
    private char[] buffer;
    private int currentBufferIndex;
    private boolean readingClassSignature = false;
    private boolean readingEnclMethod = false;
    private List<Type> missingTypeVariables = List.nil();
    private List<Type> foundTypeVariables = List.nil();

    public static void preRegister(final Context context, final boolean loadDocEnv) {
        context.put(classReaderKey, new Context.Factory<ClassReader>(){

            public ClassReader make() {
                return new SymbolClassReader(context, loadDocEnv);
            }
        });
    }

    protected SymbolClassReader(Context context, boolean loadDocEnv) {
        super(context, loadDocEnv);
        this.syms = Symtab.instance(context);
        this.table = Name.Table.instance((Context)context);
        this.types = Types.instance(context);
        this.jTypes = JavacTypes.instance(context);
        this.logger = Log.instance(context);
        this.source = Source.instance(context);
        this.buffer = new char[127];
    }

    private void addCharToBuffer(char c) {
        if (this.currentBufferIndex >= this.buffer.length) {
            char[] newBuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.currentBufferIndex++] = c;
    }

    private void clearBuffer() {
        this.currentBufferIndex = 0;
    }

    private int bufferLength() {
        return this.currentBufferIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillIn(Symbol.ClassSymbol c) {
        Symbol oldCurrentOwner = this.currentOwner;
        try {
            this.fillInImpl(c);
        }
        finally {
            this.currentOwner = oldCurrentOwner;
        }
    }

    private boolean isSignatureFile(JavaFileObject jfo) {
        if (jfo instanceof FileObjects.Base) {
            return ((FileObjects.Base)jfo).getExt().equals("sig");
        }
        return jfo.toUri().toString().endsWith(".sig");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInImpl(Symbol.ClassSymbol c) {
        if (c.classfile == null || c.classfile.getKind() != JavaFileObject.Kind.CLASS || !this.isSignatureFile(c.classfile)) {
            super.fillIn(c);
            return;
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(c.classfile.openInputStream(), "UTF-8"));
            try {
                int magic = r.read();
                if (magic != 71) {
                    throw new IOException("Wrong signature file: " + c.classfile.toUri());
                }
                this.fillInFromSig(c, r);
                if (!this.missingTypeVariables.isEmpty() && !this.foundTypeVariables.isEmpty()) {
                    List<Type> missing = this.missingTypeVariables;
                    List<Type> found = this.foundTypeVariables;
                    this.missingTypeVariables = List.nil();
                    this.foundTypeVariables = List.nil();
                    Type.ClassType ct = (Type.ClassType)this.currentOwner.type;
                    ct.supertype_field = this.types.subst(ct.supertype_field, missing, found);
                    ct.interfaces_field = this.types.subst(ct.interfaces_field, missing, found);
                } else if (this.missingTypeVariables.isEmpty() != this.foundTypeVariables.isEmpty()) {
                    Name name = ((Type)this.missingTypeVariables.head).tsym.name;
                    throw this.badClassFile("undecl.type.var", new Object[]{name});
                }
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                this.missingTypeVariables = List.nil();
                this.foundTypeVariables = List.nil();
            }
        }
        catch (IOException e) {
            throw new Symbol.CompletionFailure((Symbol)c, e.getMessage()).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInFromSig(Symbol.ClassSymbol c, Reader r) throws IOException {
        Symbol s;
        long flags;
        Type.ClassType ct = (Type.ClassType)c.type;
        c.members_field = new Scope(c);
        this.currentOwner = c;
        this.typevars = this.typevars.dup(this.currentOwner);
        if (ct.getEnclosingType().tag == 10) {
            this.enterTypevars(ct.getEnclosingType());
        }
        c.flags_field = flags = this.readFlags(r) | 0x8000000000L;
        int read = r.read();
        this.readingClassSignature = true;
        try {
            List<Object> typevarsList;
            if (read == 60) {
                typevarsList = this.readTypeParamsWithName(r, c);
                read = r.read();
            } else {
                typevarsList = List.nil();
            }
            for (Type.TypeVar tvar : typevarsList) {
                this.typevars.enter(tvar.tsym);
            }
            ct.typarams_field = typevarsList;
            assert (read == 78) : read;
            Name name = this.readPlainNameIntoTable(r);
            if (name != c.flatname) {
                throw this.badClassFile("class.file.wrong.class", new Object[]{name});
            }
            read = r.read();
            if (read != 59) {
                this.readEnclosingMethodAttr(r, c, read);
            }
            ct.supertype_field = (read = r.read()) != 59 ? this.readType(r, read) : Type.noType;
            if (ct.supertype_field.getClass() == Type.class && !ct.supertype_field.isPrimitive()) {
                System.err.println("PROBLEM");
                System.err.println("c=" + c.flatname.toString());
            }
            List<Type> superInterfaces = List.nil();
            while ((read = r.read()) != 59) {
                superInterfaces = superInterfaces.prepend(this.readType(r, read));
            }
            ct.interfaces_field = superInterfaces.reverse();
        }
        finally {
            this.readingClassSignature = false;
        }
        while ((read = r.read()) != 59) {
            assert (read == 78);
            String innerClassName = this.readPlainName(r);
            Symbol.ClassSymbol innerClass = this.enterClass(this.findName(innerClassName), c);
            this.markInnerClassOwner(c, innerClass, this.readFlags(r));
        }
        read = r.read();
        assert (read == 10 || read == -1) : c.classfile + ", char: " + (char)read + read;
        while ((s = this.readMember(r)) != null) {
            this.enterMember(c, s);
        }
        this.attachAnnotations(c, r);
        this.typevars = this.typevars.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readEnclosingMethodAttr(Reader r, Symbol.ClassSymbol self, int read) throws IOException {
        this.readingEnclMethod = true;
        try {
            assert (read == 78) : read;
            if (self.owner.kind == true) {
                self.owner.members().remove(self);
            }
            Symbol.ClassSymbol c = this.enterClass(this.readPlainNameIntoTable(r));
            Symbol m = null;
            read = r.read();
            if (read == 78) {
                Name methodName = this.readPlainNameIntoTable(r);
                read = r.read();
                assert (read == 40) : read;
                List<Type> paramsTypes = List.nil();
                while ((read = r.read()) != 41) {
                    paramsTypes = paramsTypes.prepend(this.readType(r, read));
                }
                paramsTypes = paramsTypes.reverse();
                read = r.read();
                assert (read == 40) : read;
                List<Type> throwsTypes = List.nil();
                while ((read = r.read()) != 41) {
                    throwsTypes = throwsTypes.prepend(this.readType(r, read));
                }
                throwsTypes = throwsTypes.reverse();
                Type returnType = this.readType(r, r.read());
                assert ((read = r.read()) == 59) : read;
                Type.MethodType methodType = new Type.MethodType(paramsTypes, returnType, throwsTypes, this.syms.methodClass);
                m = this.findMethod(methodName, methodType, c.members_field, self.flags());
                if (methodName != null && methodType != null && m == null) {
                    throw this.badClassFile("bad.enclosing.method", new Object[]{self});
                }
            }
            self.name = this.simpleBinaryName(self.flatname, c.flatname);
            self.owner = m != null ? m : c;
            self.fullname = self.name.len == 0 ? null : Symbol.ClassSymbol.formFullName(self.name, self.owner);
            if (m != null) {
                ((Type.ClassType)self.type).setEnclosingType(((Symbol.MethodSymbol)m).type);
            } else if ((self.flags_field & 8L) == 0L) {
                ((Type.ClassType)self.type).setEnclosingType(c.type);
            } else {
                ((Type.ClassType)self.type).setEnclosingType(Type.noType);
            }
            this.enterTypevars(self);
            if (!this.missingTypeVariables.isEmpty()) {
                ListBuffer<Type> typeVars = new ListBuffer<Type>();
                for (Type typevar : this.missingTypeVariables) {
                    typeVars.append(this.findTypeVar(typevar.tsym.name));
                }
                this.foundTypeVariables = typeVars.toList();
            } else {
                this.foundTypeVariables = List.nil();
            }
        }
        finally {
            this.readingEnclMethod = false;
        }
    }

    private Symbol.MethodSymbol findMethod(Name name, Type.MethodType type, Scope scope, long flags) {
        if (name == null || type == null) {
            return null;
        }
        Scope.Entry e = scope.lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 16 && this.isSameBinaryType(e.sym.type.asMethodType(), type)) {
                return (Symbol.MethodSymbol)e.sym;
            }
            e = e.next();
        }
        if (name != this.table.init) {
            return null;
        }
        if ((flags & 0x200L) != 0L) {
            return null;
        }
        if (((List)type.getParameterTypes()).isEmpty()) {
            return null;
        }
        type = new Type.MethodType(((List)type.getParameterTypes()).tail, type.getReturnType(), (List<Type>)type.getThrownTypes(), this.syms.methodClass);
        return this.findMethod(name, type, scope, flags);
    }

    private void markInnerClassOwner(Symbol.ClassSymbol owner, Symbol.ClassSymbol innerClass, long flags) {
        innerClass.complete();
        innerClass.flags_field = flags;
        if ((innerClass.flags_field & 8L) == 0L) {
            ((Type.ClassType)innerClass.type).setEnclosingType(owner.type);
            if (innerClass.erasure_field != null) {
                ((Type.ClassType)innerClass.erasure_field).setEnclosingType(this.types.erasure(owner.type));
            }
        }
        this.enterMember(owner, innerClass);
    }

    private List<Type.TypeVar> readTypeParamsWithName(Reader r, Symbol owner) throws IOException {
        int read;
        List<Type.TypeVar> result = List.nil();
        while ((read = r.read()) != 62) {
            this.clearBuffer();
            this.addCharToBuffer((char)read);
            while ((read = r.read()) != 58) {
                this.addCharToBuffer((char)read);
            }
            Name typeName = this.findName(this.buffer, this.bufferLength());
            Type.TypeVar tvar = null;
            List<Type> last = null;
            List<Type> l = this.missingTypeVariables;
            while (l.nonEmpty()) {
                if (typeName == ((Type)l.head).tsym.name) {
                    tvar = (Type.TypeVar)l.head;
                    if (last != null) {
                        last.tail = l.tail;
                        break;
                    }
                    this.missingTypeVariables = l.tail;
                    break;
                }
                last = l;
                l = l.tail;
            }
            if (tvar == null) {
                tvar = new Type.TypeVar(typeName, owner, this.syms.botType);
            }
            this.typevars.enter(tvar.tsym);
            List<Type> bounds = List.nil();
            while ((read = r.read()) != 59) {
                bounds = bounds.prepend(this.readType(r, read));
            }
            bounds = bounds.reverse();
            this.types.setBounds(tvar, bounds, null);
            result = result.prepend(tvar);
        }
        return result.reverse();
    }

    private java.util.List<? extends TypeMirror> readTypeParams(Reader r) throws IOException {
        int read;
        ArrayList<Type> params = new ArrayList<Type>();
        while ((read = r.read()) != 62) {
            params.add(this.readType(r, read));
        }
        return params;
    }

    private String readPlainName(Reader r) throws IOException {
        int read;
        this.clearBuffer();
        while ((read = r.read()) != 59) {
            this.addCharToBuffer((char)read);
        }
        return new String(this.buffer, 0, this.bufferLength());
    }

    private String readName(Reader r) throws IOException {
        int read = r.read();
        assert (read == 78) : (char)read;
        return this.readPlainName(r);
    }

    private Name readPlainNameIntoTable(Reader r) throws IOException {
        int read;
        this.clearBuffer();
        while ((read = r.read()) != 59) {
            this.addCharToBuffer((char)read);
        }
        return this.findName(this.buffer, this.bufferLength());
    }

    private Name readNameIntoTable(Reader r) throws IOException {
        int read = r.read();
        assert (read == 78) : (char)read;
        return this.readPlainNameIntoTable(r);
    }

    private long readPlainFlags(Reader r) throws IOException {
        return Long.parseLong(this.readPlainName(r), 16);
    }

    private long readFlags(Reader r) throws IOException {
        int read = r.read();
        assert (read == 77);
        return this.readPlainFlags(r);
    }

    private Type readType(Reader r, int read) throws IOException {
        switch (read) {
            case 90: {
                return this.syms.booleanType;
            }
            case 66: {
                return this.syms.byteType;
            }
            case 83: {
                return this.syms.shortType;
            }
            case 73: {
                return this.syms.intType;
            }
            case 74: {
                return this.syms.longType;
            }
            case 67: {
                return this.syms.charType;
            }
            case 70: {
                return this.syms.floatType;
            }
            case 68: {
                return this.syms.doubleType;
            }
            case 86: {
                return this.syms.voidType;
            }
            case 76: {
                return this.readReferenceType(r, null);
            }
            case 91: {
                return (Type)((Object)this.jTypes.getArrayType(this.readType(r, r.read())));
            }
            case 82: {
                return new Type.ErrorType(this.readPlainNameIntoTable(r), this.syms.noSymbol);
            }
            case 81: {
                return this.findTypeVar(this.readPlainNameIntoTable(r));
            }
            case 43: {
                return new Type.WildcardType(this.readType(r, r.read()), BoundKind.EXTENDS, this.syms.boundClass);
            }
            case 45: {
                return new Type.WildcardType(this.readType(r, r.read()), BoundKind.SUPER, this.syms.boundClass);
            }
            case 63: {
                return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
        }
        throw new IllegalArgumentException("Completing: " + ((Symbol.ClassSymbol)this.currentOwner).flatname.toString() + ", read=" + (char)read + ":" + read);
    }

    Type findTypeVar(Name name) {
        Scope.Entry e = this.typevars.lookup(name);
        if (e.scope != null) {
            return e.sym.type;
        }
        if (this.readingClassSignature || this.readingEnclMethod) {
            Type.TypeVar t = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.missingTypeVariables = this.missingTypeVariables.prepend(t);
            return t;
        }
        throw this.badClassFile("undecl.type.var", new Object[]{name});
    }

    private Name findName(CharSequence s) {
        char[] data = ((Object)s).toString().toCharArray();
        return this.findName(data, data.length);
    }

    private Name findName(char[] data, int len) {
        return Name.fromChars((Name.Table)this.table, (char[])data, (int)0, (int)len);
    }

    private Type readReferenceType(Reader r, Type outer) throws IOException {
        java.util.List<? extends TypeMirror> typeParams;
        int read;
        this.clearBuffer();
        while (";<".indexOf(read = r.read()) == -1) {
            this.addCharToBuffer((char)read);
        }
        Name name = this.findName(this.buffer, this.bufferLength());
        Symbol.ClassSymbol symbol = outer != null ? this.enterClass(name, outer.tsym) : this.enterClass(name);
        Symbol oldCurrentOwner = this.currentOwner;
        java.util.List<? extends TypeMirror> list = typeParams = read == 60 ? this.readTypeParams(r) : null;
        Type result = this.source.allowGenerics() && typeParams != null ? new Type.ClassType(outer != null ? outer : Type.noType, List.from(typeParams.toArray(new Type[0])), symbol){
            boolean completed;
            {
                this.completed = false;
            }

            public Type getEnclosingType() {
                if (!this.completed) {
                    this.completed = true;
                    this.tsym.complete();
                    Type enclosingType = this.tsym.type.getEnclosingType();
                    if (enclosingType != Type.noType) {
                        List<Type> typeArgs = super.getEnclosingType().allparams();
                        List<Type> typeParams = enclosingType.allparams();
                        if (typeParams.length() != typeArgs.length()) {
                            super.setEnclosingType(SymbolClassReader.this.types.erasure(enclosingType));
                        } else {
                            super.setEnclosingType(SymbolClassReader.this.types.subst(enclosingType, typeParams, typeArgs));
                        }
                    } else {
                        super.setEnclosingType(Type.noType);
                    }
                }
                return super.getEnclosingType();
            }

            public void setEnclosingType(Type outer) {
                throw new UnsupportedOperationException();
            }
        } : (outer != null ? new Type.ClassType(outer, List.<Type>nil(), symbol) : symbol.erasure(this.types));
        this.currentOwner = oldCurrentOwner;
        if (read == 60) {
            read = r.read();
            if (read == 36) {
                return this.readReferenceType(r, result);
            }
            assert (read == 59) : (char)read;
        }
        return result;
    }

    private Symbol readMember(Reader r) throws IOException {
        int read = r.read();
        if (69 == read) {
            return this.readExecutableMember(r);
        }
        if (65 == read) {
            return this.readField(r);
        }
        if (87 == read) {
            return null;
        }
        if (read == -1) {
            return null;
        }
        throw new IllegalArgumentException("Unknown type: " + read);
    }

    private Symbol readExecutableMember(Reader r) throws IOException {
        long flags = this.readFlags(r);
        this.typevars = this.typevars.dup(this.currentOwner);
        Symbol.MethodSymbol method = new Symbol.MethodSymbol(flags, null, null, this.currentOwner);
        List<Type> typevarsList = null;
        int read = r.read();
        if (read == 60) {
            typevarsList = this.readTypeParamsWithName(r, method);
            read = r.read();
        }
        assert (read == 78) : read;
        method.name = this.readPlainNameIntoTable(r);
        read = r.read();
        assert (read == 40) : read;
        List<Object> params = List.nil();
        List<Type> paramsTypes = List.nil();
        while ((read = r.read()) != 41) {
            assert (read == 77);
            long argFlags = this.readPlainFlags(r);
            Type argType = this.readType(r, r.read());
            Name argName = this.readNameIntoTable(r);
            paramsTypes = paramsTypes.prepend(argType);
            params = params.prepend(new Symbol.VarSymbol(argFlags, argName, argType, null));
        }
        paramsTypes = paramsTypes.reverse();
        params = params.reverse();
        read = r.read();
        assert (read == 40) : read;
        List<Object> throwsTypes = List.nil();
        while ((read = r.read()) != 41) {
            throwsTypes = throwsTypes.prepend(this.readType(r, read));
        }
        Type returnType = this.readType(r, r.read());
        Type methodType = new Type.MethodType(paramsTypes, returnType, throwsTypes.reverse(), this.syms.methodClass);
        if (typevarsList != null) {
            methodType = new Type.ForAll(typevarsList, methodType);
        }
        method.type = methodType;
        method.params = params;
        for (Symbol.VarSymbol varSymbol : params) {
            varSymbol.owner = method;
        }
        this.attachAnnotations(method, r);
        read = r.read();
        if (read != 59) {
            this.annotate.later((Annotate.Annotator)new ClassReader.AnnotationDefaultCompleter((ClassReader)((Object)this), method, this.readAnnotationValue(r, read)));
        }
        this.typevars = this.typevars.leave();
        read = r.read();
        while (read == 32) {
            read = r.read();
        }
        assert (read == 10 || read == -1) : read;
        return method;
    }

    private Symbol readField(Reader r) throws IOException {
        long flags = this.readFlags(r);
        Type type = this.readType(r, r.read());
        Name name = this.readNameIntoTable(r);
        Object constantValue = this.readConstantField(r);
        Symbol.VarSymbol field = new Symbol.VarSymbol(flags, name, type, this.currentOwner);
        field.setData(constantValue);
        this.attachAnnotations(field, r);
        int read = r.read();
        while (read == 32) {
            read = r.read();
        }
        assert (read == 10 || read == -1) : read;
        return field;
    }

    private String readEscapedString(Reader r) throws IOException {
        String value = this.readPlainName(r);
        StringBuffer result = new StringBuffer();
        for (int cntr = 0; cntr < value.length(); ++cntr) {
            char c = value.charAt(cntr);
            if (c == '\\') {
                char next = value.charAt(cntr + 1);
                switch (next) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        result.append((char)Integer.parseInt(value.substring(cntr + 1, cntr + 5), 16));
                        cntr += 4;
                        break;
                    }
                    case 'a': {
                        result.append('@');
                        ++cntr;
                        break;
                    }
                    case 'b': {
                        result.append(';');
                        ++cntr;
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        ++cntr;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported escape: " + next);
                    }
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private Object readConstantField(Reader r) throws IOException {
        Object result = null;
        int read = r.read();
        switch (read) {
            case 90: {
                result = Boolean.parseBoolean(this.readPlainName(r)) ? Integer.valueOf(1) : Integer.valueOf(0);
                break;
            }
            case 66: {
                result = Integer.valueOf(this.readPlainName(r));
                break;
            }
            case 83: {
                result = Integer.valueOf(this.readPlainName(r));
                break;
            }
            case 73: {
                result = Integer.valueOf(this.readPlainName(r));
                break;
            }
            case 74: {
                result = Long.valueOf(this.readPlainName(r));
                break;
            }
            case 67: {
                result = new Integer(Character.valueOf(this.readEscapedString(r).charAt(0)).charValue());
                break;
            }
            case 70: {
                result = Float.valueOf(this.readPlainName(r));
                break;
            }
            case 68: {
                result = Double.valueOf(this.readPlainName(r));
                break;
            }
            case 76: {
                result = this.readEscapedString(r);
                break;
            }
            case 88: {
                read = r.read();
                assert (read == 59);
                break;
            }
            default: {
                throw this.badClassFile("Unknown constant type: " + (char)read, new Object[0]);
            }
        }
        return result;
    }

    private void attachAnnotations(Symbol sym, Reader r) throws IOException {
        List<ClassReader.CompoundAnnotationProxy> annotations = this.readAnnotations(r);
        if (!annotations.isEmpty()) {
            this.annotate.later((Annotate.Annotator)new ClassReader.AnnotationCompleter((ClassReader)((Object)this), sym, annotations));
        }
    }

    private List<ClassReader.CompoundAnnotationProxy> readAnnotations(Reader r) throws IOException {
        int read;
        List<ClassReader.CompoundAnnotationProxy> attributes = List.nil();
        while ((read = r.read()) != 59) {
            attributes = attributes.prepend(this.readAnnotation(r, read));
        }
        return attributes.reverse();
    }

    private ClassReader.CompoundAnnotationProxy readAnnotation(Reader r, int read) throws IOException {
        Type annotationType = this.readType(r, read);
        ListBuffer<Pair<Name, Attribute>> values = new ListBuffer<Pair<Name, Attribute>>();
        while ((read = r.read()) != 59) {
            assert (read == 78);
            Name attributeName = this.readPlainNameIntoTable(r);
            Attribute a = this.readAnnotationValue(r, r.read());
            values = values.append(new Pair<Name, Attribute>(attributeName, a));
        }
        return new ClassReader.CompoundAnnotationProxy(annotationType, values.toList());
    }

    private Attribute readEnum(Reader r) throws IOException {
        Type enumType = this.readType(r, r.read());
        Name constantName = this.readNameIntoTable(r);
        Symbol.VarSymbol constant = null;
        Scope.Entry e = ((Type.ClassType)enumType).tsym.members().lookup(constantName);
        while (e.scope != null) {
            if (e.sym.kind == 4) {
                constant = (Symbol.VarSymbol)e.sym;
                break;
            }
            e = e.next();
        }
        if (constant == null) {
            this.logger.error("unknown.enum.constant", this.currentClassFile, enumType, constant);
            return new Attribute.Error(enumType);
        }
        return new Attribute.Enum(enumType, constant);
    }

    private Attribute readAnnotationValue(Reader r, int read) throws IOException {
        switch (read) {
            case 90: {
                return new Attribute.Constant(this.syms.booleanType, Boolean.parseBoolean(this.readPlainName(r)) ? Integer.valueOf(1) : Integer.valueOf(0));
            }
            case 66: {
                return new Attribute.Constant(this.syms.byteType, Integer.parseInt(this.readPlainName(r)));
            }
            case 83: {
                return new Attribute.Constant(this.syms.shortType, Integer.parseInt(this.readPlainName(r)));
            }
            case 73: {
                return new Attribute.Constant(this.syms.intType, Integer.parseInt(this.readPlainName(r)));
            }
            case 74: {
                return new Attribute.Constant(this.syms.longType, Long.parseLong(this.readPlainName(r)));
            }
            case 67: {
                return new Attribute.Constant(this.syms.charType, Character.valueOf(this.readEscapedString(r).charAt(0)).charValue());
            }
            case 70: {
                return new Attribute.Constant(this.syms.floatType, Float.valueOf(Float.parseFloat(this.readPlainName(r))));
            }
            case 68: {
                return new Attribute.Constant(this.syms.doubleType, Double.parseDouble(this.readPlainName(r)));
            }
            case 76: {
                return new Attribute.Constant(this.syms.stringType, this.readEscapedString(r));
            }
            case 79: {
                return new ClassReader.EnumAttributeProxy(this.readType(r, r.read()), this.readNameIntoTable(r));
            }
            case 80: {
                return this.readAnnotation(r, r.read());
            }
            case 91: {
                ListBuffer<Attribute> items = new ListBuffer<Attribute>();
                while ((read = r.read()) != 59) {
                    items.append(this.readAnnotationValue(r, read));
                }
                return new ClassReader.ArrayAttributeProxy(items.toList());
            }
            case 89: {
                return new Attribute.Class(this.types, this.readType(r, r.read()));
            }
        }
        throw new IllegalStateException("Completing: " + ((Symbol.ClassSymbol)this.currentOwner).flatname.toString() + ", read=" + (char)read + ":" + read);
    }

    protected void includeClassFile(Symbol.PackageSymbol p, JavaFileObject file) {
        super.includeClassFile(p, file);
    }
}

