/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.modules.java.source.util.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iterators {
    private static final String NULL_AS_PARAMETER_MESSAGE = "Iterator(s) passed in as parameter must NOT be null.";

    private Iterators() {
    }

    public static <T> Iterator<T> empty() {
        return new EmptyIterator();
    }

    public static <T> Iterator<T> unmodifiable(Iterator<T> iterator) {
        return new UnmodifiableIterator<T>(iterator);
    }

    public static <T> Iterator<T> chained(Iterator<T> ... iterators) {
        return new ChainedIterator<T>(iterators);
    }

    public static <T> Iterator<T> chained(Collection<Iterator<T>> iterators) {
        return new ChainedIterator(iterators);
    }

    public static <T> Iterator<T> colating(Iterator<? extends T> ... iterators) {
        return new CollatingIterator<T>(iterators);
    }

    public static <T> Iterator<T> colating(Comparator<? super T> comparator, Iterator<? extends T> ... iterators) {
        return new CollatingIterator<T>(comparator, iterators);
    }

    public static <T, P> Iterator<T> translating(Iterator<? extends P> delegate, Factory<? extends T, P> factory) {
        return new TranslatingIterator<T, P>(delegate, factory);
    }

    public static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        return new IteratorIterable<T>(iterator);
    }

    public static <T, P> Iterable<T> translating(Iterable<? extends P> delegate, Factory<? extends T, P> factory) {
        return new TranslatingIterable<T, P>(delegate, factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainedIterator<E>
    implements Iterator<E> {
        protected final List<Iterator<E>> iteratorChain = new ArrayList<Iterator<E>>();
        protected int currentIteratorIndex = 0;
        protected Iterator<E> currentIterator = null;
        protected Iterator<E> lastUsedIterator = null;
        protected boolean isLocked = false;

        public ChainedIterator(Iterator<E> ... iterators) {
            for (Iterator<E> iterator : iterators) {
                if (iterator == null) {
                    throw new IllegalArgumentException(Iterators.NULL_AS_PARAMETER_MESSAGE);
                }
                this.iteratorChain.add(iterator);
            }
        }

        public ChainedIterator(Collection<Iterator<E>> iterators) {
            for (Iterator<E> iterator : iterators) {
                if (iterator == null) {
                    throw new IllegalArgumentException(Iterators.NULL_AS_PARAMETER_MESSAGE);
                }
                this.iteratorChain.add(iterator);
            }
        }

        public int size() {
            return this.iteratorChain.size();
        }

        protected void updateCurrentIterator() {
            if (this.currentIterator == null) {
                this.currentIterator = this.iteratorChain.isEmpty() ? Collections.emptyList().iterator() : this.iteratorChain.get(0);
                this.lastUsedIterator = this.currentIterator;
            }
            while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iteratorChain.size() - 1) {
                ++this.currentIteratorIndex;
                this.currentIterator = this.iteratorChain.get(this.currentIteratorIndex);
            }
        }

        @Override
        public boolean hasNext() {
            this.updateCurrentIterator();
            this.lastUsedIterator = this.currentIterator;
            return this.currentIterator.hasNext();
        }

        @Override
        public E next() {
            this.updateCurrentIterator();
            this.lastUsedIterator = this.currentIterator;
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            this.updateCurrentIterator();
            this.lastUsedIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollatingIterator<E>
    implements Iterator<E> {
        private Comparator<? super E> comparator = null;
        private List<Iterator<? extends E>> iterators = null;
        private List<E> values = null;
        private BitSet valueSet = null;
        private int lastReturned = -1;

        public CollatingIterator(Iterator<? extends E> ... iterators) {
            this.iterators = Arrays.asList(iterators);
        }

        public CollatingIterator(Comparator<? super E> comp, Iterator<? extends E> ... iterators) {
            this.iterators = Arrays.asList(iterators);
            this.comparator = comp;
        }

        @Override
        public boolean hasNext() {
            this.start();
            return this.anyValueSet(this.valueSet) || this.anyHasNext(this.iterators);
        }

        @Override
        public E next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int leastIndex = this.least();
            if (leastIndex == -1) {
                throw new NoSuchElementException();
            }
            E val = this.values.get(leastIndex);
            this.clear(leastIndex);
            this.lastReturned = leastIndex;
            return val;
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException("No value can be removed at present");
            }
            Iterator<E> it = this.iterators.get(this.lastReturned);
            it.remove();
        }

        private void start() {
            if (this.values == null) {
                this.values = new ArrayList(this.iterators.size());
                this.valueSet = new BitSet(this.iterators.size());
                for (int i = 0; i < this.iterators.size(); ++i) {
                    this.values.add(null);
                    this.valueSet.clear(i);
                }
            }
        }

        private boolean set(int i) {
            Iterator<E> it = this.iterators.get(i);
            if (it.hasNext()) {
                this.values.set(i, it.next());
                this.valueSet.set(i);
                return true;
            }
            this.values.set(i, null);
            this.valueSet.clear(i);
            return false;
        }

        private void clear(int i) {
            this.values.set(i, null);
            this.valueSet.clear(i);
        }

        private void checkNotStarted() throws IllegalStateException {
            if (this.values != null) {
                throw new IllegalStateException("Can't do that after next or hasNext has been called.");
            }
        }

        private int least() {
            int leastIndex = -1;
            Object leastObject = null;
            for (int i = 0; i < this.values.size(); ++i) {
                if (!this.valueSet.get(i)) {
                    this.set(i);
                }
                if (!this.valueSet.get(i)) continue;
                if (leastIndex == -1) {
                    leastIndex = i;
                    leastObject = this.values.get(i);
                    continue;
                }
                E curObject = this.values.get(i);
                if (this.comparator.compare(curObject, leastObject) >= 0) continue;
                leastObject = curObject;
                leastIndex = i;
            }
            return leastIndex;
        }

        private boolean anyValueSet(BitSet set) {
            for (int i = 0; i < set.size(); ++i) {
                if (!set.get(i)) continue;
                return true;
            }
            return false;
        }

        private boolean anyHasNext(List<Iterator<? extends E>> iters) {
            for (Iterator<E> it : iters) {
                if (!it.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove elements from emptu iterator");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException("Empty Iterator has no elements");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorIterable<T>
    implements Iterable<T> {
        private Iterator<T> iterator;

        public IteratorIterable(Iterator<T> iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException(Iterators.NULL_AS_PARAMETER_MESSAGE);
            }
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TranslatingIterable<T, P>
    implements Iterable<T> {
        final Iterable<? extends P> delegate;
        final Factory<? extends T, P> factory;

        public TranslatingIterable(Iterable<? extends P> delegate, Factory<? extends T, P> factory) {
            assert (delegate != null);
            assert (factory != null);
            this.delegate = delegate;
            this.factory = factory;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.translating(this.delegate.iterator(), this.factory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TranslatingIterator<T, P>
    implements Iterator<T> {
        private Iterator<? extends P> delegate;
        private Factory<? extends T, P> factory;

        public TranslatingIterator(Iterator<? extends P> delegate, Factory<? extends T, P> factory) {
            if (delegate == null) {
                throw new IllegalArgumentException(Iterators.NULL_AS_PARAMETER_MESSAGE);
            }
            this.delegate = delegate;
            this.factory = factory;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public T next() {
            return this.factory.create(this.delegate.next());
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableIterator<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        public UnmodifiableIterator(Iterator<T> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(Iterators.NULL_AS_PARAMETER_MESSAGE);
            }
            this.delegate = delegate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

