/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowMemoryNotifier {
    private static final float DEFAULT_HEAP_LIMIT = 0.9f;
    private static LowMemoryNotifier instance;
    private final NotificationListener notificationListener = new Listener();
    private final List<LowMemoryListener> listeners = new ArrayList<LowMemoryListener>();
    private MemoryPoolMXBean pool;
    private MemoryPoolMXBean cachedPool;
    private float heapLimit = 0.9f;

    private LowMemoryNotifier() {
    }

    float getHeapLimit() {
        return this.heapLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHeapLimit(float heapLimit) {
        this.heapLimit = heapLimit;
        LowMemoryNotifier lowMemoryNotifier = this;
        synchronized (lowMemoryNotifier) {
            if (this.pool != null) {
                MemoryUsage mu = this.pool.getUsage();
                this.pool.setUsageThreshold((long)((float)mu.getMax() * heapLimit));
            }
        }
    }

    public synchronized void addLowMemoryListener(LowMemoryListener listener) {
        assert (listener != null);
        if (this.pool == null) {
            this.pool = this.initJMX();
        }
        assert (this.pool != null);
        MemoryUsage usage = this.pool.getUsage();
        assert (usage != null) : String.format("Pool %s returned null MemoryUsage, Valid: %s\n", this.pool.getName(), this.pool.isValid() ? Boolean.TRUE : Boolean.FALSE);
        if (usage != null && usage.getUsed() >= this.pool.getUsageThreshold()) {
            listener.lowMemory(new LowMemoryEvent(this, this.pool));
        }
        this.listeners.add(listener);
    }

    public synchronized void removeLowMemoryListener(LowMemoryListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
        if (this.listeners.isEmpty() && this.pool != null) {
            this.finishJMX(this.pool);
            this.pool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLowMemory() {
        MemoryPoolMXBean _pool;
        LowMemoryListener[] _listeners;
        LowMemoryNotifier lowMemoryNotifier = this;
        synchronized (lowMemoryNotifier) {
            _listeners = this.listeners.toArray(new LowMemoryListener[this.listeners.size()]);
            _pool = this.pool;
        }
        if (_listeners.length > 0) {
            assert (_pool != null);
            LowMemoryEvent event = new LowMemoryEvent(this, _pool);
            for (LowMemoryListener l : _listeners) {
                l.lowMemory(event);
            }
        }
    }

    private MemoryPoolMXBean initJMX() {
        List<MemoryPoolMXBean> pools = null;
        if (this.cachedPool == null || !this.cachedPool.isValid()) {
            pools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : pools) {
                if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
                this.cachedPool = pool;
                break;
            }
        }
        assert (this.cachedPool != null) : LowMemoryNotifier.dumpMemoryPoolMXBean(pools);
        if (this.cachedPool != null) {
            MemoryUsage mu = this.cachedPool.getUsage();
            this.cachedPool.setUsageThreshold((long)((float)mu.getMax() * this.heapLimit));
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            ((NotificationEmitter)((Object)mbean)).addNotificationListener(this.notificationListener, null, null);
        }
        return this.cachedPool;
    }

    private void finishJMX(MemoryPoolMXBean pool) {
        assert (pool != null);
        try {
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            ((NotificationEmitter)((Object)mbean)).removeNotificationListener(this.notificationListener);
        }
        catch (ListenerNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        pool.setUsageThreshold(0L);
    }

    private static String dumpMemoryPoolMXBean(List<MemoryPoolMXBean> pools) {
        StringBuilder sb = new StringBuilder();
        for (MemoryPoolMXBean pool : pools) {
            sb.append(String.format("Pool: %s Type: %s TresholdSupported: %s\n", new Object[]{pool.getName(), pool.getType(), pool.isUsageThresholdSupported() ? Boolean.TRUE : Boolean.FALSE}));
        }
        sb.append('\n');
        return sb.toString();
    }

    public static synchronized LowMemoryNotifier getDefault() {
        if (instance == null) {
            instance = new LowMemoryNotifier();
        }
        return instance;
    }

    private class Listener
    implements NotificationListener {
        private Listener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            String notificationType = notification.getType();
            if (notificationType.equals("java.management.memory.threshold.exceeded")) {
                LowMemoryNotifier.this.fireLowMemory();
            }
        }
    }
}

