/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.netbeans.modules.java.ui.FmtAlignmentBraces;
import org.netbeans.modules.java.ui.FmtBlankLines;
import org.netbeans.modules.java.ui.FmtOptions;
import org.netbeans.modules.java.ui.FmtSpaces;
import org.netbeans.modules.java.ui.FmtTabsIndents;
import org.netbeans.modules.java.ui.FmtWrapping;
import org.netbeans.modules.java.ui.FormatingOptionsPanelController;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FormatingOptionsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private FormatingOptionsPanelController fopControler;
    private List<Category> categories = new ArrayList<Category>();
    private boolean loaded = false;
    private JComboBox categoryCombo;
    private JLabel categoryLabel;
    private JPanel categoryPanel;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JPanel optionsPanel;
    private JEditorPane previewPane;
    private JPanel previewPanel;

    public FormatingOptionsPanel(FormatingOptionsPanelController fopControler) {
        this.fopControler = fopControler;
        this.initComponents();
        this.previewPane.setContentType("text/x-java");
        this.previewPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.previewPane.setText("1234567890123456789012345678901234567890");
        this.previewPane.setDoubleBuffered(true);
        this.createCategories();
        DefaultComboBoxModel<Category> model = new DefaultComboBoxModel<Category>();
        for (Category category : this.categories) {
            model.addElement(category);
        }
        this.categoryCombo.setModel(model);
        this.categoryCombo.addActionListener(this);
        this.actionPerformed(new ActionEvent(model, 0, null));
    }

    void load() {
        for (Category category : this.categories) {
            category.update();
        }
        this.loaded = true;
        this.repaintPreview();
    }

    void store() {
        for (Category category : this.categories) {
            category.applyChanges();
        }
        FmtOptions.flush();
        FmtOptions.lastValues = null;
    }

    void cancel() {
        FmtOptions.lastValues = null;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.optionsPanel = new JPanel();
        this.categoryLabel = new JLabel();
        this.categoryCombo = new JComboBox();
        this.categoryPanel = new JPanel();
        this.previewPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setDividerSize(5);
        this.optionsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.optionsPanel.setLayout(new GridBagLayout());
        this.categoryLabel.setLabelFor(this.categoryCombo);
        Mnemonics.setLocalizedText((JLabel)this.categoryLabel, (String)NbBundle.getMessage(FormatingOptionsPanel.class, (String)"LBL_Category"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.optionsPanel.add((Component)this.categoryLabel, gridBagConstraints);
        this.categoryCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.optionsPanel.add((Component)this.categoryCombo, gridBagConstraints);
        this.categoryPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.optionsPanel.add((Component)this.categoryPanel, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.optionsPanel);
        this.previewPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.previewPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setDoubleBuffered(true);
        this.previewPane.setEditable(false);
        this.jScrollPane1.setViewportView(this.previewPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.previewPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.previewPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void createCategories() {
        this.categories.add(FmtTabsIndents.getController());
        this.categories.add(FmtAlignmentBraces.getController());
        this.categories.add(FmtWrapping.getController());
        this.categories.add(FmtBlankLines.getController());
        this.categories.add(FmtSpaces.getController());
        for (Category category : this.categories) {
            category.addPropertyChangeListener(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Category category = (Category)((Object)this.categoryCombo.getSelectedItem());
        this.categoryPanel.setVisible(false);
        this.categoryPanel.removeAll();
        this.categoryPanel.add((Component)category.getComponent(null), "Center");
        this.categoryPanel.setVisible(true);
        if (this.loaded) {
            this.repaintPreview();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.loaded) {
            return;
        }
        this.fopControler.changed();
        this.repaintPreview();
    }

    private void repaintPreview() {
        PreviewPreferences p = new PreviewPreferences();
        for (Category category : this.categories) {
            category.storeTo(p);
        }
        Category category = (Category)((Object)this.categoryCombo.getSelectedItem());
        this.jScrollPane1.setIgnoreRepaint(true);
        category.refreshPreview(this.previewPane, p);
        this.previewPane.setIgnoreRepaint(false);
        this.previewPane.repaint(100L);
        FmtOptions.lastValues = p;
    }

    public static abstract class Category
    extends OptionsPanelController {
        private String displayName;

        public Category(String displayNameKey) {
            this.displayName = NbBundle.getMessage(FormatingOptionsPanel.class, (String)displayNameKey);
        }

        public abstract void storeTo(Preferences var1);

        public abstract void refreshPreview(JEditorPane var1, Preferences var2);

        public String toString() {
            return this.displayName;
        }
    }

    public static class PreviewPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        protected void putSpi(String key, String value) {
            this.map.put(key, value);
        }

        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

