/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Icons {
    private static final String ICON_BASE = "org/netbeans/modules/java/source/resources/icons/";
    private static final String GIF_EXTENSION = ".gif";
    private static final String PNG_EXTENSION = ".png";
    private static final String WAIT = "org/netbeans/modules/java/source/resources/icons/wait.png";

    private Icons() {
    }

    public static Icon getBusyIcon() {
        Image img = Utilities.loadImage((String)WAIT);
        if (img == null) {
            return null;
        }
        return new ImageIcon(img);
    }

    public static Icon getElementIcon(ElementKind elementKind, Collection<Modifier> modifiers) {
        if (modifiers == null) {
            modifiers = Collections.emptyList();
        }
        Image img = null;
        switch (elementKind) {
            case PACKAGE: {
                img = Utilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/package.gif");
                break;
            }
            case ENUM: {
                img = Utilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/enum.png");
                break;
            }
            case ANNOTATION_TYPE: {
                img = Utilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/annotation.png");
                break;
            }
            case CLASS: {
                img = Utilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/class.png");
                break;
            }
            case INTERFACE: {
                img = Utilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/interface.png");
                break;
            }
            case FIELD: {
                img = Utilities.loadImage((String)Icons.getIconName("org/netbeans/modules/java/source/resources/icons/field", PNG_EXTENSION, modifiers));
                break;
            }
            case ENUM_CONSTANT: {
                img = Utilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/constant.png");
                break;
            }
            case CONSTRUCTOR: {
                img = Utilities.loadImage((String)Icons.getIconName("org/netbeans/modules/java/source/resources/icons/constructor", PNG_EXTENSION, modifiers));
                break;
            }
            case STATIC_INIT: {
                img = Utilities.loadImage((String)Icons.getIconName("org/netbeans/modules/java/source/resources/icons/initializer", PNG_EXTENSION, modifiers));
                break;
            }
            case METHOD: {
                img = Utilities.loadImage((String)Icons.getIconName("org/netbeans/modules/java/source/resources/icons/method", PNG_EXTENSION, modifiers));
                break;
            }
            default: {
                img = null;
            }
        }
        return img == null ? null : new ImageIcon(img);
    }

    private static String getIconName(String typeName, String extension, Collection<Modifier> modifiers) {
        StringBuffer fileName = new StringBuffer(typeName);
        if (modifiers.contains((Object)Modifier.STATIC)) {
            fileName.append("Static");
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return fileName.append("Public").append(extension).toString();
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return fileName.append("Protected").append(extension).toString();
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return fileName.append("Private").append(extension).toString();
        }
        return fileName.append("Package").append(extension).toString();
    }
}

