/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaOptionsPanelController
extends OptionsPanelController {
    private static final String TAB_FOLDER = "org.netbeans.modules.java.source/options/";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private List<AdvancedOption> options;
    private JTabbedPane pane;
    private Map<OptionsPanelController, AdvancedOption> controllers2Options;
    private List<OptionsPanelController> controllers;

    public JavaOptionsPanelController() {
        this.readPanels();
    }

    public void update() {
        for (OptionsPanelController c : this.getControllers()) {
            c.update();
        }
    }

    public void applyChanges() {
        for (OptionsPanelController c : this.getControllers()) {
            c.applyChanges();
        }
    }

    public void cancel() {
        for (OptionsPanelController c : this.getControllers()) {
            c.cancel();
        }
    }

    public boolean isValid() {
        for (OptionsPanelController c : this.getControllers()) {
            if (c.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        for (OptionsPanelController c : this.getControllers()) {
            if (!c.isChanged()) continue;
            return true;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public synchronized JComponent getComponent(Lookup masterLookup) {
        if (this.pane == null) {
            this.pane = new JTabbedPane();
            for (OptionsPanelController c : this.getControllers()) {
                this.pane.add(this.controllers2Options.get(c).getDisplayName(), c.getComponent(c.getLookup()));
            }
        }
        return this.pane;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private synchronized Collection<OptionsPanelController> getControllers() {
        if (this.controllers == null) {
            this.controllers2Options = new LinkedHashMap<OptionsPanelController, AdvancedOption>();
            this.controllers = new LinkedList<OptionsPanelController>();
            for (AdvancedOption o : this.options) {
                OptionsPanelController c = o.create();
                this.controllers2Options.put(c, o);
                this.controllers.add(c);
            }
        }
        return this.controllers;
    }

    private void readPanels() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.getRoot().getFileObject(TAB_FOLDER);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fo);
        FolderLookup fl = new FolderLookup((DataObject.Container)dataFolder);
        Lookup lookup = fl.getLookup();
        Lookup.Result result = lookup.lookup(new Lookup.Template(AdvancedOption.class));
        this.options = new LinkedList<AdvancedOption>();
        for (AdvancedOption advancedOption : result.allInstances()) {
            this.options.add(advancedOption);
        }
    }
}

