/*
 * Decompiled with CFR 0.152.
 */
package gjava.runner;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.InputStream;

public class ImageCanvas
extends Canvas {
    private Image image;

    public ImageCanvas(Image image) {
        this.loadImage(image);
    }

    public ImageCanvas(Class resourceClass, String resourceName) {
        try {
            InputStream resource = resourceClass.getResourceAsStream(resourceName);
            byte[] bytes = new byte[resource.available()];
            resource.read(bytes);
            Image image = Toolkit.getDefaultToolkit().createImage(bytes);
            this.loadImage(image);
        }
        catch (Exception ex) {
            System.out.println("ImageCanvas() - Cannot load '" + resourceName + "' with class '" + resourceClass.getName() + "'.");
            ex.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, (ImageObserver)this);
    }

    private void loadImage(Image image) {
        this.image = image;
        MediaTracker tracker = new MediaTracker((Component)this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            System.out.println("Cannot load image");
        }
        this.setSize(image.getWidth(null), image.getHeight(null));
    }
}

