/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class DiffAction
extends NodeAction {
    public DiffAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffActionName");
    }

    static FileObject getFileFromNode(Node node) {
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo == null) {
            Project p = (Project)node.getLookup().lookup(Project.class);
            if (p != null) {
                return p.getProjectDirectory();
            }
            DataObject dobj = (DataObject)node.getCookie(DataObject.class);
            if (dobj instanceof DataShadow) {
                dobj = ((DataShadow)dobj).getOriginal();
            }
            if (dobj != null) {
                fo = dobj.getPrimaryFile();
            }
        }
        return fo;
    }

    public boolean enable(Node[] nodes) {
        if (nodes.length == 2) {
            FileObject fo1 = DiffAction.getFileFromNode(nodes[0]);
            FileObject fo2 = DiffAction.getFileFromNode(nodes[1]);
            if (fo1 != null && fo2 != null && fo1.isData() && fo2.isData()) {
                Diff d = Diff.getDefault();
                return d != null;
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return true;
    }

    public void performAction(Node[] nodes) {
        ArrayList<FileObject> fos = new ArrayList<FileObject>();
        for (int i = 0; i < nodes.length; ++i) {
            FileObject fo = DiffAction.getFileFromNode(nodes[i]);
            if (fo == null) continue;
            fos.add(fo);
        }
        if (fos.size() < 2) {
            return;
        }
        FileObject fo1 = (FileObject)fos.get(0);
        FileObject fo2 = (FileObject)fos.get(1);
        DiffAction.performAction(fo1, fo2);
    }

    public static void performAction(FileObject fo1, FileObject fo2) {
        DiffAction.performAction(fo1, fo2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performAction(FileObject fo1, FileObject fo2, FileObject type) {
        Component tp;
        Diff diff = Diff.getDefault();
        if (diff == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DiffAction.class, (String)"MSG_NoDiffVisualizer")));
            return;
        }
        Reader r1 = null;
        Reader r2 = null;
        try {
            EncodedReaderFactory rf = EncodedReaderFactory.getDefault();
            if (type != null) {
                r1 = rf.getReader(fo1, rf.getEncoding(type), type);
                r2 = rf.getReader(fo2, rf.getEncoding(type), type);
            } else {
                r1 = rf.getReader(fo1, rf.getEncoding(fo1), fo2.getExt());
                r2 = rf.getReader(fo2, rf.getEncoding(fo2), fo1.getExt());
            }
            String mimeType = type != null ? type.getMIMEType() : fo1.getMIMEType();
            final Thread victim = Thread.currentThread();
            Cancellable killer = new Cancellable(){

                public boolean cancel() {
                    victim.interrupt();
                    return true;
                }
            };
            String name = NbBundle.getMessage(DiffAction.class, (String)"BK0001");
            ProgressHandle ph = ProgressHandleFactory.createHandle((String)name, (Cancellable)killer);
            try {
                ph.start();
                tp = diff.createDiff(fo1.getNameExt(), FileUtil.getFileDisplayName((FileObject)fo1), r1, fo2.getNameExt(), FileUtil.getFileDisplayName((FileObject)fo2), r2, mimeType);
            }
            finally {
                ph.finish();
            }
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify((Throwable)ioex);
            return;
        }
        finally {
            try {
                if (r1 != null) {
                    r1.close();
                }
            }
            catch (IOException ioex) {}
            try {
                if (r2 != null) {
                    r2.close();
                }
            }
            catch (IOException ioex) {}
        }
        if (tp != null) {
            final Component ftp = tp;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ftp instanceof TopComponent) {
                        ((TopComponent)ftp).open();
                        ((TopComponent)ftp).requestActive();
                    } else {
                        ftp.setVisible(true);
                        ftp.requestFocusInWindow();
                    }
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffAction.class);
    }
}

