/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.builtin.visualizer.editable.DecoratedEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffViewManager
implements ChangeListener {
    private final EditableDiffView master;
    private final DiffContentPanel leftContentPanel;
    private final DiffContentPanel rightContentPanel;
    private boolean myScrollEvent;
    private int cachedDiffSerial;
    private DecoratedDifference[] decorationsCached = new DecoratedDifference[0];
    private HighLight[] secondHilitesCached = new HighLight[0];
    private HighLight[] firstHilitesCached = new HighLight[0];
    private final ScrollMapCached scrollMap = new ScrollMapCached();

    public DiffViewManager(EditableDiffView master) {
        this.master = master;
        this.leftContentPanel = master.getEditorPane1();
        this.rightContentPanel = master.getEditorPane2();
    }

    void init() {
        this.initScrolling();
    }

    private void initScrolling() {
        this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this);
        this.rightContentPanel.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this);
        this.leftContentPanel.getScrollPane().getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JScrollBar leftScrollBar = this.leftContentPanel.getScrollPane().getVerticalScrollBar();
        JScrollBar rightScrollBar = this.rightContentPanel.getScrollPane().getVerticalScrollBar();
        if (e.getSource() == this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel()) {
            int value = leftScrollBar.getValue();
            this.leftContentPanel.getActionsScrollPane().getVerticalScrollBar().setValue(value);
            if (this.myScrollEvent) {
                return;
            }
            this.myScrollEvent = true;
            rightScrollBar.setValue((int)((double)value / this.getScrollFactor()));
        } else {
            int value = rightScrollBar.getValue();
            this.rightContentPanel.getActionsScrollPane().getVerticalScrollBar().setValue(value);
            if (this.myScrollEvent) {
                return;
            }
            this.myScrollEvent = true;
            this.smartScroll();
        }
        this.master.getMyDivider().repaint();
        this.master.updateCurrentDifference();
        this.myScrollEvent = false;
    }

    public void scroll() {
        this.myScrollEvent = true;
        this.smartScroll();
        this.master.getMyDivider().repaint();
        this.myScrollEvent = false;
    }

    EditableDiffView getMaster() {
        return this.master;
    }

    private void updateDifferences() {
        assert (Thread.holdsLock(this));
        int mds = this.master.getDiffSerial();
        if (mds <= this.cachedDiffSerial) {
            return;
        }
        this.cachedDiffSerial = mds;
        this.computeDecorations();
        this.computeSecondHighlights();
        this.computeFirstHighlights();
    }

    public synchronized DecoratedDifference[] getDecorations() {
        this.updateDifferences();
        return this.decorationsCached;
    }

    public synchronized HighLight[] getSecondHighlights() {
        this.updateDifferences();
        return this.secondHilitesCached;
    }

    public synchronized HighLight[] getFirstHighlights() {
        this.updateDifferences();
        return this.firstHilitesCached;
    }

    private void computeFirstHighlights() {
        ArrayList<HighLight> hilites = new ArrayList<HighLight>();
        Document doc = this.leftContentPanel.getEditorPane().getDocument();
        for (DecoratedDifference dd : this.decorationsCached) {
            Difference diff = dd.getDiff();
            if (dd.getBottomLeft() == -1) continue;
            int start = DiffViewManager.getRowStartFromLineOffset(doc, diff.getFirstStart() - 1);
            if (this.isOneLineChange(diff)) {
                CorrectRowTokenizer firstSt = new CorrectRowTokenizer(diff.getFirstText());
                CorrectRowTokenizer secondSt = new CorrectRowTokenizer(diff.getSecondText());
                for (int i = diff.getSecondStart(); i <= diff.getSecondEnd(); ++i) {
                    String firstRow = firstSt.nextToken();
                    String secondRow = secondSt.nextToken();
                    List<HighLight> rowhilites = this.computeFirstRowHilites(start, firstRow, secondRow);
                    hilites.addAll(rowhilites);
                    start += firstRow.length() + 1;
                }
                continue;
            }
            int end = DiffViewManager.getRowStartFromLineOffset(doc, diff.getFirstEnd());
            if (end == -1) {
                end = doc.getLength();
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            attrs.addAttribute(HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE);
            hilites.add(new HighLight(start, end, attrs));
        }
        this.firstHilitesCached = hilites.toArray(new HighLight[hilites.size()]);
    }

    static int getRowStartFromLineOffset(Document doc, int lineIndex) {
        if (doc instanceof BaseDocument) {
            return Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)doc), (int)lineIndex);
        }
        Element element = doc.getDefaultRootElement();
        Element line = element.getElement(lineIndex);
        return line.getStartOffset();
    }

    private void computeSecondHighlights() {
        ArrayList<HighLight> hilites = new ArrayList<HighLight>();
        Document doc = this.rightContentPanel.getEditorPane().getDocument();
        for (DecoratedDifference dd : this.decorationsCached) {
            Difference diff = dd.getDiff();
            if (dd.getBottomRight() == -1) continue;
            int start = DiffViewManager.getRowStartFromLineOffset(doc, diff.getSecondStart() - 1);
            if (this.isOneLineChange(diff)) {
                CorrectRowTokenizer firstSt = new CorrectRowTokenizer(diff.getFirstText());
                CorrectRowTokenizer secondSt = new CorrectRowTokenizer(diff.getSecondText());
                for (int i = diff.getSecondStart(); i <= diff.getSecondEnd(); ++i) {
                    try {
                        String firstRow = firstSt.nextToken();
                        String secondRow = secondSt.nextToken();
                        List<HighLight> rowhilites = this.computeSecondRowHilites(start, firstRow, secondRow);
                        hilites.addAll(rowhilites);
                        start += secondRow.length() + 1;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            int end = DiffViewManager.getRowStartFromLineOffset(doc, diff.getSecondEnd());
            if (end == -1) {
                end = doc.getLength();
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            attrs.addAttribute(HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE);
            hilites.add(new HighLight(start, end, attrs));
        }
        this.secondHilitesCached = hilites.toArray(new HighLight[hilites.size()]);
    }

    private List<HighLight> computeFirstRowHilites(int rowStart, String left, String right) {
        Difference[] diffs;
        ArrayList<HighLight> hilites = new ArrayList<HighLight>(4);
        String leftRows = this.wordsToRows(left);
        String rightRows = this.wordsToRows(right);
        DiffProvider diffprovider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffprovider == null) {
            return hilites;
        }
        try {
            diffs = diffprovider.computeDiff(new StringReader(leftRows), new StringReader(rightRows));
        }
        catch (IOException e) {
            return hilites;
        }
        for (Difference diff : diffs) {
            if (diff.getType() == 1) continue;
            int start = this.rowOffset(leftRows, diff.getFirstStart());
            int end = this.rowOffset(leftRows, diff.getFirstEnd() + 1);
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            hilites.add(new HighLight(rowStart + start, rowStart + end, attrs));
        }
        return hilites;
    }

    private List<HighLight> computeSecondRowHilites(int rowStart, String left, String right) {
        Difference[] diffs;
        ArrayList<HighLight> hilites = new ArrayList<HighLight>(4);
        String leftRows = this.wordsToRows(left);
        String rightRows = this.wordsToRows(right);
        DiffProvider diffprovider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffprovider == null) {
            return hilites;
        }
        try {
            diffs = diffprovider.computeDiff(new StringReader(leftRows), new StringReader(rightRows));
        }
        catch (IOException e) {
            return hilites;
        }
        for (Difference diff : diffs) {
            if (diff.getType() == 0) continue;
            int start = this.rowOffset(rightRows, diff.getSecondStart());
            int end = this.rowOffset(rightRows, diff.getSecondEnd() + 1);
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            hilites.add(new HighLight(rowStart + start, rowStart + end, attrs));
        }
        return hilites;
    }

    private int rowOffset(String row, int rowIndex) {
        if (rowIndex == 1) {
            return 0;
        }
        int newLines = 0;
        for (int i = 0; i < row.length(); ++i) {
            char c = row.charAt(i);
            if (c != '\n') continue;
            ++newLines;
            if (--rowIndex != 1) continue;
            return i + 1 - newLines;
        }
        return row.length();
    }

    private String wordsToRows(String s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        StringTokenizer st = new StringTokenizer(s, " \t\n[]{};:'\",.<>/?-=_+\\|~!@#$%^&*()", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0) continue;
            sb.append(token);
            sb.append('\n');
        }
        return sb.toString();
    }

    private boolean isOneLineChange(Difference diff) {
        return diff.getType() == 2 && diff.getFirstEnd() - diff.getFirstStart() == diff.getSecondEnd() - diff.getSecondStart();
    }

    private void computeDecorations() {
        Document document = this.master.getEditorPane2().getEditorPane().getDocument();
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.rightContentPanel.getEditorPane());
        if (editorUI == null) {
            return;
        }
        int lineHeight = editorUI.getLineHeight();
        Difference[] diffs = this.master.getDifferences();
        this.decorationsCached = new DecoratedDifference[diffs.length];
        for (int i = 0; i < diffs.length; ++i) {
            Difference difference = diffs[i];
            DecoratedDifference dd = new DecoratedDifference(difference, this.canRollback(document, difference));
            if (difference.getType() == 1) {
                dd.topRight = (difference.getSecondStart() - 1) * lineHeight;
                dd.bottomRight = difference.getSecondEnd() * lineHeight;
                dd.topLeft = difference.getFirstStart() * lineHeight;
                dd.floodFill = true;
            } else if (difference.getType() == 0) {
                dd.topLeft = (difference.getFirstStart() - 1) * lineHeight;
                dd.bottomLeft = difference.getFirstEnd() * lineHeight;
                dd.topRight = difference.getSecondStart() * lineHeight;
                dd.floodFill = true;
            } else {
                dd.topRight = (difference.getSecondStart() - 1) * lineHeight;
                dd.bottomRight = difference.getSecondEnd() * lineHeight;
                dd.topLeft = (difference.getFirstStart() - 1) * lineHeight;
                dd.bottomLeft = difference.getFirstEnd() * lineHeight;
                dd.floodFill = true;
            }
            this.decorationsCached[i] = dd;
        }
    }

    private boolean canRollback(Document doc, Difference diff) {
        int start;
        int end;
        if (!(doc instanceof GuardedDocument)) {
            return true;
        }
        GuardedDocument document = (GuardedDocument)doc;
        if (diff.getType() == 0) {
            start = end = Utilities.getRowStartFromLineOffset((BaseDocument)document, (int)diff.getSecondStart());
        } else {
            start = Utilities.getRowStartFromLineOffset((BaseDocument)document, (int)(diff.getSecondStart() - 1));
            end = Utilities.getRowStartFromLineOffset((BaseDocument)document, (int)diff.getSecondEnd());
        }
        MarkBlockChain mbc = document.getGuardedBlockChain();
        return (mbc.compareBlock(start, end) & 1) == 0;
    }

    private synchronized void smartScroll() {
        DiffContentPanel rightPane = this.master.getEditorPane2();
        DiffContentPanel leftPane = this.master.getEditorPane1();
        int[] map = this.scrollMap.getScrollMap(rightPane.getSize().height, this.master.getDiffSerial());
        int rightOffet = rightPane.getScrollPane().getVerticalScrollBar().getValue();
        if (rightOffet >= map.length) {
            return;
        }
        leftPane.getScrollPane().getVerticalScrollBar().setValue(map[rightOffet]);
    }

    private int computeLeftOffsetToMatchDifference(DifferencePosition differenceMatchStart, int lineHeight, int rightOffset) {
        int valueSecond;
        int value;
        Difference diff = differenceMatchStart.getDiff();
        boolean matchStart = differenceMatchStart.isStart();
        if (matchStart) {
            value = diff.getFirstStart() * lineHeight;
            valueSecond = diff.getSecondStart() * lineHeight;
        } else if (diff.getType() == 1) {
            value = diff.getFirstStart() * lineHeight;
            value -= lineHeight;
            valueSecond = diff.getSecondEnd() * lineHeight;
        } else {
            value = diff.getFirstEnd() * lineHeight;
            if (diff.getType() == 0) {
                value += lineHeight;
                valueSecond = diff.getSecondStart() * lineHeight;
            } else {
                valueSecond = diff.getSecondEnd() * lineHeight;
            }
        }
        int secondOffset = rightOffset - valueSecond;
        value += secondOffset;
        if (diff.getType() == 1) {
            value += lineHeight;
        }
        if (diff.getType() == 0) {
            value -= lineHeight;
        }
        return value;
    }

    private DifferencePosition findDifferenceToMatch(int rightOffset, int rightViewportHeight) {
        boolean matchStart;
        DecoratedDifference[] diffs;
        DecoratedDifference candidate = null;
        for (DecoratedDifference dd : diffs = this.getDecorations()) {
            if (dd.getTopRight() > rightOffset + rightViewportHeight) break;
            if (dd.getBottomRight() == -1 ? dd.getTopRight() <= rightOffset : dd.getBottomRight() <= rightOffset) continue;
            if (candidate != null) {
                if (candidate.getDiff().getType() == 0) {
                    candidate = dd;
                    continue;
                }
                if (candidate.getTopRight() < rightOffset) {
                    candidate = dd;
                    continue;
                }
                if (dd.getTopRight() > rightOffset + rightViewportHeight / 2) continue;
                candidate = dd;
                continue;
            }
            candidate = dd;
        }
        if (candidate == null) {
            return null;
        }
        boolean bl = matchStart = candidate.getTopRight() > rightOffset + rightViewportHeight / 2;
        if (candidate.getDiff().getType() == 0 && candidate.getTopRight() < rightOffset + rightViewportHeight * 4 / 5) {
            matchStart = false;
        }
        if (candidate.getDiff().getType() == 0 && candidate == diffs[diffs.length - 1]) {
            matchStart = false;
        }
        return new DifferencePosition(candidate.getDiff(), matchStart);
    }

    double getScrollFactor() {
        BoundedRangeModel m1 = this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel();
        BoundedRangeModel m2 = this.rightContentPanel.getScrollPane().getVerticalScrollBar().getModel();
        return ((double)m1.getMaximum() - (double)m1.getExtent()) / (double)(m2.getMaximum() - m2.getExtent());
    }

    void editorPainting(DecoratedEditorPane decoratedEditorPane) {
        if (!decoratedEditorPane.isFirst()) {
            JComponent mydivider = this.master.getMyDivider();
            mydivider.paint(mydivider.getGraphics());
        }
    }

    private static class CorrectRowTokenizer {
        private final String s;
        private int idx;

        public CorrectRowTokenizer(String s) {
            this.s = s;
        }

        public String nextToken() {
            String token = null;
            for (int end = this.idx; end < this.s.length(); ++end) {
                if (this.s.charAt(end) != '\n') continue;
                token = this.s.substring(this.idx, end);
                this.idx = end + 1;
                break;
            }
            return token;
        }
    }

    public static class DecoratedDifference {
        private final Difference diff;
        private final boolean canRollback;
        private int topLeft;
        private int bottomLeft = -1;
        private int topRight;
        private int bottomRight = -1;
        private boolean floodFill;

        public DecoratedDifference(Difference difference, boolean canRollback) {
            this.diff = difference;
            this.canRollback = canRollback;
        }

        public boolean canRollback() {
            return this.canRollback;
        }

        public Difference getDiff() {
            return this.diff;
        }

        public int getTopLeft() {
            return this.topLeft;
        }

        public int getBottomLeft() {
            return this.bottomLeft;
        }

        public int getTopRight() {
            return this.topRight;
        }

        public int getBottomRight() {
            return this.bottomRight;
        }

        public boolean isFloodFill() {
            return this.floodFill;
        }
    }

    public static class DifferencePosition {
        private Difference diff;
        private boolean isStart;

        public DifferencePosition(Difference diff, boolean start) {
            this.diff = diff;
            this.isStart = start;
        }

        public Difference getDiff() {
            return this.diff;
        }

        public boolean isStart() {
            return this.isStart;
        }
    }

    public static class HighLight {
        private final int startOffset;
        private final int endOffset;
        private final AttributeSet attrs;

        public HighLight(int startOffset, int endOffset, AttributeSet attrs) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.attrs = attrs;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public AttributeSet getAttrs() {
            return this.attrs;
        }
    }

    private class ScrollMapCached {
        private int rightPanelHeightCached;
        private int[] scrollMapCached;
        private int diffSerialCached;

        private ScrollMapCached() {
        }

        public synchronized int[] getScrollMap(int rightPanelHeight, int diffSerial) {
            if (rightPanelHeight != this.rightPanelHeightCached || this.diffSerialCached != diffSerial || this.scrollMapCached == null) {
                this.diffSerialCached = diffSerial;
                this.rightPanelHeightCached = rightPanelHeight;
                this.scrollMapCached = this.compute();
            }
            return this.scrollMapCached;
        }

        private int[] compute() {
            DiffContentPanel rightPane = DiffViewManager.this.master.getEditorPane2();
            int rightViewportHeight = rightPane.getScrollPane().getViewport().getViewRect().height;
            int rightHeight = rightPane.getEditorPane().getSize().height;
            int[] scrollMap = new int[rightHeight];
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)DiffViewManager.this.leftContentPanel.getEditorPane());
            if (editorUI == null) {
                return scrollMap;
            }
            int lineHeight = editorUI.getLineHeight();
            int lastOffset = 0;
            for (int rightOffset = 0; rightOffset < rightHeight; ++rightOffset) {
                int leftOffset;
                DifferencePosition dpos = DiffViewManager.this.findDifferenceToMatch(rightOffset, rightViewportHeight);
                if (dpos == null) {
                    leftOffset = lastOffset + rightOffset;
                } else {
                    leftOffset = DiffViewManager.this.computeLeftOffsetToMatchDifference(dpos, lineHeight, rightOffset);
                    lastOffset = leftOffset - rightOffset;
                }
                scrollMap[rightOffset] = leftOffset;
            }
            scrollMap = this.smooth(scrollMap);
            return scrollMap;
        }

        private int[] smooth(int[] map) {
            int[] newMap = new int[map.length];
            int leftShift = 0;
            float correction = 0.0f;
            for (int i = 0; i < map.length; ++i) {
                int leftOffset = map[i];
                int requestedShift = leftOffset - i;
                if (requestedShift > leftShift) {
                    if (correction > (float)(requestedShift - leftShift)) {
                        correction = requestedShift - leftShift;
                    }
                    leftShift = (int)((float)leftShift + correction);
                    correction += 0.02f;
                } else if (requestedShift < leftShift) {
                    --leftShift;
                } else {
                    correction = 1.0f;
                }
                newMap[i] = i + leftShift;
            }
            return newMap;
        }
    }
}

