/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.netbeans.modules.diff.builtin.visualizer.GraphicalDiffVisualizer;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffMark;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffSplitPaneDivider;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.diff.builtin.visualizer.editable.NoContentPanel;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.spi.diff.DiffControllerImpl;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditableDiffView
extends DiffControllerImpl
implements DiffView,
DocumentListener,
AncestorListener,
PropertyChangeListener {
    private Stroke boldStroke = new BasicStroke(3.0f);
    private Color colorMissing = new Color(255, 160, 180);
    private Color colorAdded = new Color(180, 255, 180);
    private Color colorChanged = new Color(160, 200, 255);
    private Color colorLines = Color.DARK_GRAY;
    private Color COLOR_READONLY_BG = new Color(240, 240, 240);
    private final Difference[] NO_DIFFERENCES = new Difference[0];
    private DiffContentPanel jEditorPane1;
    private DiffContentPanel jEditorPane2;
    private boolean secondSourceAvailable;
    private boolean firstSourceAvailable;
    private final boolean binaryDiff;
    private JViewport jViewport2;
    final JLabel fileLabel1 = new JLabel();
    final JLabel fileLabel2 = new JLabel();
    final JPanel filePanel1 = new JPanel();
    final JPanel filePanel2 = new JPanel();
    final JSplitPane jSplitPane1 = new JSplitPane();
    private int diffSerial;
    private Difference[] diffs = this.NO_DIFFERENCES;
    private boolean isSetCurrentDifferenceContext = false;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private RequestProcessor.Task refreshDiffTask = RequestProcessor.getDefault().create((Runnable)new RefreshDiffTask());
    private DiffViewManager manager;
    private boolean actionsEnabled;
    private DiffSplitPaneUI spui;
    private EditorCookie.Observable editableCookie;
    private Document editableDocument;
    private UndoRedo.Manager editorUndoRedo;
    private EditableDiffMarkProvider diffMarkprovider;

    public EditableDiffView(final StreamSource ss1, final StreamSource ss2) throws IOException {
        String title2;
        this.initColors();
        String title1 = ss1.getTitle();
        if (title1 == null) {
            title1 = NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoTitle");
        }
        if ((title2 = ss2.getTitle()) == null) {
            title2 = NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoTitle");
        }
        String mimeType1 = ss1.getMIMEType();
        String mimeType2 = ss2.getMIMEType();
        if (mimeType1 == null) {
            mimeType1 = mimeType2;
        }
        if (mimeType2 == null) {
            mimeType2 = mimeType1;
        }
        this.binaryDiff = mimeType1 == null || mimeType2 == null || mimeType1.equals("application/octet-stream") || mimeType2.equals("application/octet-stream");
        this.actionsEnabled = ss2.isEditable();
        this.diffMarkprovider = new EditableDiffMarkProvider();
        this.initComponents();
        this.jSplitPane1.setName(NbBundle.getMessage(EditableDiffView.class, (String)"DiffComponent.title"));
        this.spui = new DiffSplitPaneUI(this.jSplitPane1);
        this.jSplitPane1.setUI(this.spui);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setDividerSize(32);
        this.jSplitPane1.putClientProperty("PersistenceType", "Never");
        this.jSplitPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_DiffPanelA11yName"));
        this.jSplitPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_DiffPanelA11yDesc"));
        this.setSourceTitle(this.fileLabel1, title1);
        this.setSourceTitle(this.fileLabel2, title2);
        final String f1 = mimeType1;
        final String f2 = mimeType2;
        try {
            Runnable awtTask = new Runnable(){

                public void run() {
                    NoContentPanel ncp;
                    Color borderColor = UIManager.getColor("scrollpane_border");
                    if (borderColor == null) {
                        borderColor = UIManager.getColor("controlShadow");
                    }
                    EditableDiffView.this.jSplitPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
                    if (EditableDiffView.this.binaryDiff) {
                        EditableDiffView.this.adjustPreferredSizes();
                        return;
                    }
                    EditableDiffView.this.jEditorPane1.getScrollPane().setBorder(null);
                    EditableDiffView.this.jEditorPane2.getScrollPane().setBorder(null);
                    EditableDiffView.this.jEditorPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
                    EditableDiffView.this.jEditorPane2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
                    EditableDiffView.this.jEditorPane1.getEditorPane().setEditorKit(CloneableEditorSupport.getEditorKit((String)f1));
                    EditableDiffView.this.jEditorPane2.getEditorPane().setEditorKit(CloneableEditorSupport.getEditorKit((String)f2));
                    try {
                        EditableDiffView.this.setSource1(ss1);
                        EditableDiffView.this.setSource2(ss2);
                    }
                    catch (IOException ioex) {
                        ErrorManager.getDefault().notify((Throwable)ioex);
                    }
                    if (!EditableDiffView.this.secondSourceAvailable) {
                        EditableDiffView.this.filePanel2.remove(EditableDiffView.this.jEditorPane2);
                        ncp = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoContent"));
                        ncp.setPreferredSize(new Dimension(((EditableDiffView)EditableDiffView.this).jEditorPane1.getPreferredSize().width, ncp.getPreferredSize().height));
                        EditableDiffView.this.filePanel2.add(ncp);
                        EditableDiffView.this.actionsEnabled = false;
                    }
                    if (!EditableDiffView.this.firstSourceAvailable) {
                        EditableDiffView.this.filePanel1.remove(EditableDiffView.this.jEditorPane1);
                        ncp = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoContent"));
                        ncp.setPreferredSize(new Dimension(((EditableDiffView)EditableDiffView.this).jEditorPane2.getPreferredSize().width, ncp.getPreferredSize().height));
                        EditableDiffView.this.filePanel1.add(ncp);
                        EditableDiffView.this.actionsEnabled = false;
                    }
                    EditableDiffView.this.adjustPreferredSizes();
                    int bgRGB = EditableDiffView.this.jEditorPane2.getEditorPane().getBackground().getRGB() & 0xFFFFFF;
                    if (EditableDiffView.this.jEditorPane2.getEditorPane().isEditable() && bgRGB == 0xFFFFFF && System.getProperty("netbeans.experimental.diff.ReadonlyBg") == null) {
                        EditableDiffView.this.jEditorPane1.getEditorPane().setBackground(EditableDiffView.this.COLOR_READONLY_BG);
                    }
                    if (bgRGB == 0) {
                        EditableDiffView.this.colorLines = Color.WHITE;
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                awtTask.run();
            } else {
                SwingUtilities.invokeAndWait(awtTask);
            }
        }
        catch (InterruptedException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.notify((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.notify((Throwable)e);
        }
        if (this.binaryDiff) {
            return;
        }
        this.jEditorPane2.getEditorPane().putClientProperty("org.netbeans.modules.diff.builtin.visualizer.editable.MarkProvider", (Object)this.diffMarkprovider);
        this.jSplitPane1.addAncestorListener(this);
        this.refreshDiffTask.run();
        this.manager = new DiffViewManager(this);
        this.manager.init();
    }

    private void adjustPreferredSizes() {
        Dimension pf1 = this.fileLabel1.getPreferredSize();
        Dimension pf2 = this.fileLabel2.getPreferredSize();
        if (pf1.width > pf2.width) {
            this.fileLabel2.setPreferredSize(new Dimension(pf1.width, pf2.height));
        } else {
            this.fileLabel1.setPreferredSize(new Dimension(pf2.width, pf1.height));
        }
    }

    public void setLocation(DiffController.DiffPane pane, DiffController.LocationType type, int location) {
        if (type == DiffController.LocationType.DifferenceIndex) {
            this.setDifferenceImpl(location);
        } else if (pane == DiffController.DiffPane.Base) {
            this.setBaseLineNumberImpl(location);
        } else {
            this.setModifiedLineNumberImpl(location);
        }
    }

    private void setModifiedLineNumberImpl(int line) {
    }

    private void setBaseLineNumberImpl(int line) {
        this.initGlobalSizes();
        try {
            int off1 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getEditorPane().getDocument()), (int)line);
            int off2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getEditorPane().getDocument()), (int)line);
            this.jEditorPane1.getEditorPane().setCaretPosition(off1);
            this.jEditorPane2.getEditorPane().setCaretPosition(off2);
            JScrollBar leftScrollBar = this.jEditorPane1.getScrollPane().getVerticalScrollBar();
            JScrollBar rightScrollBar = this.jEditorPane2.getScrollPane().getVerticalScrollBar();
            int value = leftScrollBar.getValue();
            rightScrollBar.setValue((int)((double)value / this.manager.getScrollFactor()));
            this.updateCurrentDifference();
        }
        catch (IndexOutOfBoundsException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDifferenceImpl(int location) {
        if (location < -1 || location >= this.diffs.length) {
            throw new IllegalArgumentException("Illegal difference number: " + location);
        }
        if (location != -1) {
            if (this.getDifferenceIndex() == location) {
                return;
            }
            try {
                this.isSetCurrentDifferenceContext = true;
                this.setDifferenceIndex(location);
                this.showCurrentDifference();
            }
            finally {
                this.isSetCurrentDifferenceContext = false;
            }
        }
    }

    public JComponent getJComponent() {
        return this.jSplitPane1;
    }

    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    private void initColors() {
        Lookup.Result dv = Lookup.getDefault().lookup(new Lookup.Template(DiffVisualizer.class));
        Collection c = dv.allInstances();
        for (Object o : c) {
            if (!(o instanceof GraphicalDiffVisualizer)) continue;
            GraphicalDiffVisualizer gdv = (GraphicalDiffVisualizer)o;
            this.colorAdded = gdv.getColorAdded();
            this.colorChanged = gdv.getColorChanged();
            this.colorMissing = gdv.getColorMissing();
        }
    }

    public void ancestorAdded(AncestorEvent event) {
        this.expandFolds();
        this.initGlobalSizes();
        this.addChangeListeners();
        this.refreshDiff(50);
        if (this.editableCookie == null) {
            return;
        }
        this.refreshEditableDocument();
        this.editableCookie.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void refreshEditableDocument() {
        StyledDocument doc = null;
        try {
            doc = this.editableCookie.openDocument();
        }
        catch (IOException e) {
            Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, "Getting new Document from EditorCookie", e);
            return;
        }
        this.editableDocument.removeDocumentListener(this);
        if (doc != this.editableDocument) {
            this.editableDocument = doc;
            this.jEditorPane2.getEditorPane().setDocument(this.editableDocument);
            this.refreshDiff(20);
        }
        this.editableDocument.addDocumentListener(this);
    }

    public void ancestorRemoved(AncestorEvent event) {
        if (this.editableCookie != null) {
            this.editableDocument.removeDocumentListener(this);
            this.saveModifiedDocument();
            this.editableCookie.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.editableCookie.getOpenedPanes() == null) {
                this.editableCookie.close();
            }
        }
    }

    private void saveModifiedDocument() {
        SaveCookie sc;
        DataObject dao = (DataObject)this.editableDocument.getProperty("stream");
        if (dao != null && (sc = (SaveCookie)dao.getCookie(SaveCookie.class)) != null) {
            try {
                sc.save();
            }
            catch (IOException e) {
                Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, "Error saving Diff document", e);
            }
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.refreshDiff(50);
    }

    public void removeUpdate(DocumentEvent e) {
        this.refreshDiff(50);
    }

    public void changedUpdate(DocumentEvent e) {
        this.refreshDiff(50);
    }

    Color getColor(Difference ad) {
        if (ad.getType() == 1) {
            return this.colorAdded;
        }
        if (ad.getType() == 2) {
            return this.colorChanged;
        }
        return this.colorMissing;
    }

    JComponent getMyDivider() {
        return this.spui.divider.getDivider();
    }

    DiffContentPanel getEditorPane1() {
        return this.jEditorPane1;
    }

    DiffContentPanel getEditorPane2() {
        return this.jEditorPane2;
    }

    public DiffViewManager getManager() {
        return this.manager;
    }

    Difference[] getDifferences() {
        return this.diffs;
    }

    void rollback(Difference diff) {
        if (diff == null) {
            try {
                Document dest = this.getEditorPane2().getEditorPane().getDocument();
                Document src = this.getEditorPane1().getEditorPane().getDocument();
                dest.remove(0, dest.getLength());
                dest.insertString(0, src.getText(0, src.getLength()), null);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return;
        }
        try {
            Document document = this.getEditorPane2().getEditorPane().getDocument();
            if (diff.getType() == 1) {
                int start = DiffViewManager.getRowStartFromLineOffset(document, diff.getSecondStart() - 1);
                int end = DiffViewManager.getRowStartFromLineOffset(document, diff.getSecondEnd());
                document.remove(start, end - start);
            } else if (diff.getType() == 0) {
                int start = DiffViewManager.getRowStartFromLineOffset(document, diff.getSecondStart());
                document.insertString(start, diff.getFirstText(), null);
            } else {
                int start = DiffViewManager.getRowStartFromLineOffset(document, diff.getSecondStart() - 1);
                int end = DiffViewManager.getRowStartFromLineOffset(document, diff.getSecondEnd());
                document.remove(start, end - start);
                document.insertString(start, diff.getFirstText(), null);
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    Stroke getBoldStroke() {
        return this.boldStroke;
    }

    public boolean requestFocusInWindow() {
        return this.jEditorPane1.requestFocusInWindow();
    }

    public JComponent getComponent() {
        return this.jSplitPane1;
    }

    public int getDifferenceCount() {
        return this.diffs.length;
    }

    public boolean canSetCurrentDifference() {
        return true;
    }

    public void setCurrentDifference(int diffNo) throws UnsupportedOperationException {
        this.setLocation(null, DiffController.LocationType.DifferenceIndex, diffNo);
    }

    public int getCurrentDifference() {
        return this.getDifferenceIndex();
    }

    private int computeCurrentDifference() {
        if (this.manager == null) {
            return 0;
        }
        Rectangle viewRect = this.jViewport2.getViewRect();
        int bottom = viewRect.y + viewRect.height * 4 / 5;
        DiffViewManager.DecoratedDifference[] ddiffs = this.manager.getDecorations();
        for (int i = 0; i < ddiffs.length; ++i) {
            int startLine = ddiffs[i].getTopRight();
            int endLine = ddiffs[i].getBottomRight();
            if (endLine <= bottom && (endLine != -1 || startLine <= bottom)) continue;
            return Math.max(0, i - 1);
        }
        return ddiffs.length - 1;
    }

    void updateCurrentDifference() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.isSetCurrentDifferenceContext) {
            return;
        }
        int cd = this.computeCurrentDifference();
        this.setDifferenceIndex(cd);
    }

    public JToolBar getToolBar() {
        return null;
    }

    private void showCurrentDifference() {
        Difference diff = this.diffs[this.getDifferenceIndex()];
        this.initGlobalSizes();
        try {
            int off1 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getEditorPane().getDocument()), (int)(diff.getFirstStart() > 0 ? diff.getFirstStart() - 1 : 0));
            int off2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getEditorPane().getDocument()), (int)(diff.getSecondStart() > 0 ? diff.getSecondStart() - 1 : 0));
            this.jEditorPane1.getEditorPane().setCaretPosition(off1);
            this.jEditorPane2.getEditorPane().setCaretPosition(off2);
            DiffViewManager.DecoratedDifference ddiff = this.manager.getDecorations()[this.getDifferenceIndex()];
            int offset = ddiff.getDiff().getType() == 0 ? this.jEditorPane2.getScrollPane().getViewport().getViewRect().height / 2 + 1 : this.jEditorPane2.getScrollPane().getViewport().getViewRect().height / 5;
            this.jEditorPane2.getScrollPane().getVerticalScrollBar().setValue(ddiff.getTopRight() - offset);
        }
        catch (IndexOutOfBoundsException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        this.manager.scroll();
    }

    private void initComponents() {
        this.fileLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fileLabel1.setHorizontalAlignment(0);
        this.filePanel1.setLayout(new BorderLayout());
        this.filePanel1.add((Component)this.fileLabel1, "First");
        this.fileLabel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fileLabel2.setHorizontalAlignment(0);
        this.filePanel2.setLayout(new BorderLayout());
        this.filePanel2.add((Component)this.fileLabel2, "First");
        if (this.binaryDiff) {
            NoContentPanel ncp1 = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_BinaryFile"));
            this.fileLabel1.setLabelFor(ncp1);
            this.filePanel1.add(ncp1);
            NoContentPanel ncp2 = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_BinaryFile"));
            this.fileLabel2.setLabelFor(ncp2);
            this.filePanel2.add(ncp2);
        } else {
            this.jEditorPane1 = new DiffContentPanel(this, true);
            this.jEditorPane2 = new DiffContentPanel(this, false);
            this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane1A11yName"));
            this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane1A11yDescr"));
            this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane2A11yName"));
            this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane2A11yDescr"));
            this.fileLabel1.setLabelFor(this.jEditorPane1);
            this.filePanel1.add(this.jEditorPane1);
            this.fileLabel2.setLabelFor(this.jEditorPane2);
            this.filePanel2.add(this.jEditorPane2);
        }
        this.jSplitPane1.setLeftComponent(this.filePanel1);
        this.jSplitPane1.setRightComponent(this.filePanel2);
    }

    private void expandFolds(JEditorPane pane) {
        final FoldHierarchy fh = FoldHierarchy.get((JTextComponent)pane);
        FoldUtilities.expandAll((FoldHierarchy)fh);
        fh.addFoldHierarchyListener(new FoldHierarchyListener(){

            public void foldHierarchyChanged(FoldHierarchyEvent evt) {
                FoldUtilities.expandAll((FoldHierarchy)fh);
            }
        });
    }

    private void expandFolds() {
        this.expandFolds(this.jEditorPane1.getEditorPane());
        this.expandFolds(this.jEditorPane2.getEditorPane());
    }

    private void initGlobalSizes() {
        int totHeight;
        int value;
        int numLines2;
        StyledDocument doc1 = (StyledDocument)this.jEditorPane1.getEditorPane().getDocument();
        StyledDocument doc2 = (StyledDocument)this.jEditorPane2.getEditorPane().getDocument();
        int numLines1 = NbDocument.findLineNumber((StyledDocument)doc1, (int)doc1.getEndPosition().getOffset());
        int numLines = Math.max(numLines1, numLines2 = NbDocument.findLineNumber((StyledDocument)doc2, (int)doc2.getEndPosition().getOffset()));
        if (numLines < 1) {
            numLines = 1;
        }
        if ((value = this.jEditorPane2.getSize().height) > (totHeight = this.jEditorPane1.getSize().height)) {
            totHeight = value;
        }
    }

    private void joinScrollBars() {
        final JScrollBar scrollBarH1 = this.jEditorPane1.getScrollPane().getHorizontalScrollBar();
        final JScrollBar scrollBarH2 = this.jEditorPane2.getScrollPane().getHorizontalScrollBar();
        scrollBarH1.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = scrollBarH1.getValue();
                if (value == EditableDiffView.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int max1 = scrollBarH1.getMaximum();
                int max2 = scrollBarH2.getMaximum();
                int ext1 = scrollBarH1.getModel().getExtent();
                int ext2 = scrollBarH2.getModel().getExtent();
                if (max1 == ext1) {
                    EditableDiffView.this.horizontalScroll2ChangedValue = 0;
                } else {
                    EditableDiffView.this.horizontalScroll2ChangedValue = value * (max2 - ext2) / (max1 - ext1);
                }
                EditableDiffView.this.horizontalScroll1ChangedValue = -1;
                scrollBarH2.setValue(EditableDiffView.this.horizontalScroll2ChangedValue);
            }
        });
        scrollBarH2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = scrollBarH2.getValue();
                if (value == EditableDiffView.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int max1 = scrollBarH1.getMaximum();
                int max2 = scrollBarH2.getMaximum();
                int ext1 = scrollBarH1.getModel().getExtent();
                int ext2 = scrollBarH2.getModel().getExtent();
                if (max2 == ext2) {
                    EditableDiffView.this.horizontalScroll1ChangedValue = 0;
                } else {
                    EditableDiffView.this.horizontalScroll1ChangedValue = value * (max1 - ext1) / (max2 - ext2);
                }
                EditableDiffView.this.horizontalScroll2ChangedValue = -1;
                scrollBarH1.setValue(EditableDiffView.this.horizontalScroll1ChangedValue);
            }
        });
    }

    private void customizeEditor(JEditorPane editor) {
        Document document = editor.getDocument();
        try {
            StyledDocument doc = (StyledDocument)editor.getDocument();
        }
        catch (ClassCastException e) {
            DefaultStyledDocument doc = new DefaultStyledDocument();
            try {
                doc.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            editor.setDocument(doc);
        }
    }

    private void addChangeListeners() {
        this.jEditorPane1.getEditorPane().addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditableDiffView.this.diffChanged();
                        EditableDiffView.this.initGlobalSizes();
                        EditableDiffView.this.jEditorPane1.onUISettingsChanged();
                        EditableDiffView.this.getComponent().revalidate();
                        EditableDiffView.this.getComponent().repaint();
                    }
                });
            }
        });
        this.jEditorPane2.getEditorPane().addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditableDiffView.this.diffChanged();
                        EditableDiffView.this.initGlobalSizes();
                        EditableDiffView.this.jEditorPane2.onUISettingsChanged();
                        EditableDiffView.this.getComponent().revalidate();
                        EditableDiffView.this.getComponent().repaint();
                    }
                });
            }
        });
    }

    private synchronized void diffChanged() {
        ++this.diffSerial;
    }

    private void setSource1(StreamSource ss) throws IOException {
        Document doc;
        this.firstSourceAvailable = false;
        EditorKit kit = this.jEditorPane1.getEditorPane().getEditorKit();
        if (kit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document sdoc = this.getSourceDocument(ss);
        Document document = doc = sdoc != null ? sdoc : kit.createDefaultDocument();
        if (!(doc instanceof StyledDocument)) {
            doc = new DefaultStyledDocument(new StyleContext());
            kit = new StyledEditorKit();
            this.jEditorPane1.getEditorPane().setEditorKit(kit);
        }
        if (sdoc == null) {
            Reader r = ss.createReader();
            if (r != null) {
                this.firstSourceAvailable = true;
                try {
                    kit.read(r, doc, 0);
                }
                catch (BadLocationException e) {
                    throw new IOException("Can not locate the beginning of the document.");
                }
                finally {
                    r.close();
                }
            }
        } else {
            this.firstSourceAvailable = true;
        }
        this.jEditorPane1.initActions();
        this.jEditorPane1.getEditorPane().setDocument(doc);
        this.customizeEditor(this.jEditorPane1.getEditorPane());
    }

    private Document getSourceDocument(StreamSource ss) {
        Document sdoc = null;
        FileObject fo = (FileObject)ss.getLookup().lookup(FileObject.class);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dao.getCookie(EditorCookie.class);
                if (ec != null) {
                    sdoc = ec.openDocument();
                }
            }
            catch (Exception e) {}
        } else {
            sdoc = (Document)ss.getLookup().lookup(Document.class);
        }
        return sdoc;
    }

    private void setSource2(StreamSource ss) throws IOException {
        Component c;
        Document doc;
        EditorCookie cookie;
        DataObject dao;
        this.secondSourceAvailable = false;
        EditorKit kit = this.jEditorPane2.getEditorPane().getEditorKit();
        if (kit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document sdoc = this.getSourceDocument(ss);
        if (sdoc != null && ss.isEditable() && (dao = (DataObject)sdoc.getProperty("stream")) != null && (cookie = (EditorCookie)dao.getCookie(EditorCookie.class)) instanceof EditorCookie.Observable) {
            this.editableCookie = (EditorCookie.Observable)cookie;
            this.editableDocument = sdoc;
            this.editorUndoRedo = this.getUndoRedo(cookie);
        }
        Document document = doc = sdoc != null ? sdoc : kit.createDefaultDocument();
        if (!(doc instanceof StyledDocument)) {
            doc = new DefaultStyledDocument(new StyleContext());
            kit = new StyledEditorKit();
            this.jEditorPane2.getEditorPane().setEditorKit(kit);
        }
        if (sdoc == null) {
            Reader r = ss.createReader();
            if (r != null) {
                this.secondSourceAvailable = true;
                try {
                    kit.read(r, doc, 0);
                }
                catch (BadLocationException e) {
                    throw new IOException("Can not locate the beginning of the document.");
                }
                finally {
                    r.close();
                }
            }
        } else {
            this.secondSourceAvailable = true;
        }
        this.jEditorPane2.initActions();
        this.jSplitPane1.putClientProperty(UndoRedo.class, this.editorUndoRedo);
        this.jEditorPane2.getEditorPane().setDocument(doc);
        this.jEditorPane2.getEditorPane().setEditable(this.editableCookie != null);
        if (doc instanceof NbDocument.CustomEditor && (c = ((NbDocument.CustomEditor)doc).createEditor((JEditorPane)this.jEditorPane2.getEditorPane())) instanceof JComponent) {
            this.jEditorPane2.setCustomEditor((JComponent)c);
        }
        this.customizeEditor(this.jEditorPane2.getEditorPane());
        this.jViewport2 = this.jEditorPane2.getScrollPane().getViewport();
        this.joinScrollBars();
    }

    private UndoRedo.Manager getUndoRedo(EditorCookie cookie) {
        try {
            Method method = CloneableEditorSupport.class.getDeclaredMethod("getUndoRedo", new Class[0]);
            method.setAccessible(true);
            return (UndoRedo.Manager)method.invoke((Object)cookie, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("document".equals(evt.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditableDiffView.this.refreshEditableDocument();
                }
            });
        }
    }

    public void setSourceTitle(JLabel label, String title) {
        label.setText(title);
        label.setMinimumSize(new Dimension(3, label.getMinimumSize().height));
    }

    public void setDocument1(Document doc) {
        if (doc != null) {
            this.jEditorPane1.getEditorPane().setDocument(doc);
        }
    }

    public void setDocument2(Document doc) {
        if (doc != null) {
            this.jEditorPane2.getEditorPane().setDocument(doc);
        }
    }

    private void refreshDiff(int delayMillis) {
        this.refreshDiffTask.schedule(delayMillis);
    }

    synchronized int getDiffSerial() {
        return this.diffSerial;
    }

    static Difference getFirstDifference(Difference[] diff, int line) {
        if (line < 0) {
            return null;
        }
        for (int i = 0; i < diff.length; ++i) {
            Difference difference = diff[i];
            if (line < difference.getFirstStart()) {
                return null;
            }
            if (difference.getType() == 1 && line == difference.getFirstStart()) {
                return difference;
            }
            if (line > difference.getFirstEnd()) continue;
            return difference;
        }
        return null;
    }

    static Difference getSecondDifference(Difference[] diff, int line) {
        if (line < 0) {
            return null;
        }
        for (int i = 0; i < diff.length; ++i) {
            Difference difference = diff[i];
            if (line < difference.getSecondStart()) {
                return null;
            }
            if (difference.getType() == 0 && line == difference.getSecondStart()) {
                return difference;
            }
            if (line > difference.getSecondEnd()) continue;
            return difference;
        }
        return null;
    }

    Color getColorLines() {
        return this.colorLines;
    }

    static /* synthetic */ Difference[] access$1602(EditableDiffView x0, Difference[] x1) {
        x0.diffs = x1;
        return x1;
    }

    class DiffSplitPaneUI
    extends BasicSplitPaneUI {
        final DiffSplitPaneDivider divider;

        public DiffSplitPaneUI(JSplitPane splitPane) {
            this.splitPane = splitPane;
            this.divider = new DiffSplitPaneDivider(this, EditableDiffView.this);
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            return this.divider;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EditableDiffMarkProvider
    extends MarkProvider {
        private List<DiffMark> marks = this.getMarksForDifferences();

        public List getMarks() {
            return this.marks;
        }

        void refresh() {
            List<DiffMark> oldMarks = this.marks;
            this.marks = this.getMarksForDifferences();
            this.firePropertyChange("marks", oldMarks, this.marks);
        }

        private List<DiffMark> getMarksForDifferences() {
            if (EditableDiffView.this.diffs == null) {
                return Collections.emptyList();
            }
            ArrayList<DiffMark> marks = new ArrayList<DiffMark>(EditableDiffView.this.diffs.length);
            for (int i = 0; i < EditableDiffView.this.diffs.length; ++i) {
                Difference difference = EditableDiffView.this.diffs[i];
                marks.add(new DiffMark(difference, EditableDiffView.this.getColor(difference)));
            }
            return marks;
        }
    }

    public class RefreshDiffTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EditableDiffView editableDiffView = EditableDiffView.this;
            synchronized (editableDiffView) {
                this.computeDiff();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (EditableDiffView.this.getDifferenceIndex() >= EditableDiffView.this.diffs.length) {
                            EditableDiffView.this.updateCurrentDifference();
                        }
                        EditableDiffView.this.jEditorPane1.setCurrentDiff(EditableDiffView.this.diffs);
                        EditableDiffView.this.jEditorPane2.setCurrentDiff(EditableDiffView.this.diffs);
                        EditableDiffView.this.jSplitPane1.repaint();
                        EditableDiffView.this.diffMarkprovider.refresh();
                    }
                });
            }
        }

        private void computeDiff() {
            if (!EditableDiffView.this.secondSourceAvailable || !EditableDiffView.this.firstSourceAvailable) {
                EditableDiffView.access$1602(EditableDiffView.this, EditableDiffView.this.NO_DIFFERENCES);
                return;
            }
            StringReader first = null;
            StringReader second = null;
            try {
                first = new StringReader(EditableDiffView.this.jEditorPane1.getEditorPane().getDocument().getText(0, EditableDiffView.this.jEditorPane1.getEditorPane().getDocument().getLength()));
                second = new StringReader(EditableDiffView.this.jEditorPane2.getEditorPane().getDocument().getText(0, EditableDiffView.this.jEditorPane2.getEditorPane().getDocument().getLength()));
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            if (diff == null) {
                diff = new BuiltInDiffProvider();
            }
            try {
                EditableDiffView.access$1602(EditableDiffView.this, diff.computeDiff(first, second));
                EditableDiffView.this.diffChanged();
            }
            catch (IOException e) {
                EditableDiffView.access$1602(EditableDiffView.this, EditableDiffView.this.NO_DIFFERENCES);
            }
        }
    }
}

