/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.diff.builtin.visualizer.editable.HotSpot;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class LineNumbersActionsBar
extends JComponent
implements Scrollable,
MouseMotionListener,
MouseListener,
PropertyChangeListener {
    private static final int ACTIONS_BAR_WIDTH = 16;
    private static final int LINES_BORDER_WIDTH = 4;
    private static final Point POINT_ZERO = new Point(0, 0);
    private final Image insertImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/insert.png");
    private final Image removeImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/remove.png");
    private final Image insertActiveImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/insert_active.png");
    private final Image removeActiveImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/remove_active.png");
    private final DiffContentPanel master;
    private final boolean actionsEnabled;
    private final int actionIconsHeight;
    private final int actionIconsWidth;
    private final String lineNumberPadding = "        ";
    private int linesWidth;
    private int actionsWidth;
    private Color linesColor;
    private int linesCount;
    private int maxNumberCount;
    private Point lastMousePosition = POINT_ZERO;
    private HotSpot lastHotSpot = null;
    private List<HotSpot> hotspots = new ArrayList<HotSpot>(0);
    private int oldLinesWidth;

    public LineNumbersActionsBar(DiffContentPanel master, boolean actionsEnabled) {
        this.master = master;
        this.actionsEnabled = actionsEnabled;
        this.actionsWidth = actionsEnabled ? 16 : 0;
        this.actionIconsHeight = this.insertImage.getHeight(this);
        this.actionIconsWidth = this.insertImage.getWidth(this);
        this.setOpaque(true);
        this.setToolTipText("");
        master.getMaster().addPropertyChangeListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.initUI();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    private Font getLinesFont() {
        Map coloringMap = EditorUIHelper.getSharedColoringMapFor(this.master.getEditorPane().getEditorKit().getClass());
        Object colValue = coloringMap.get("line-number");
        Coloring col = null;
        col = colValue != null && colValue instanceof Coloring ? (Coloring)colValue : SettingsDefaults.defaultLineNumberColoring;
        Font font = col.getFont();
        if (font == null) {
            font = ((Coloring)coloringMap.get("default")).getFont();
        }
        return font;
    }

    private void initUI() {
        Color bg;
        Map coloringMap = EditorUIHelper.getSharedColoringMapFor(this.master.getEditorPane().getEditorKit().getClass());
        Object colValue = coloringMap.get("line-number");
        Coloring col = null;
        col = colValue != null && colValue instanceof Coloring ? (Coloring)colValue : SettingsDefaults.defaultLineNumberColoring;
        this.linesColor = col.getForeColor();
        if (this.linesColor == null) {
            this.linesColor = ((Coloring)coloringMap.get("default")).getForeColor();
        }
        if ((bg = col.getBackColor()) == null) {
            bg = ((Coloring)coloringMap.get("default")).getBackColor();
        }
        this.setBackground(bg);
        this.updateStateOnDocumentChange();
    }

    private HotSpot getHotspotAt(Point p) {
        for (HotSpot hotspot : this.hotspots) {
            if (!hotspot.getRect().contains(p)) continue;
            return hotspot;
        }
        return null;
    }

    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        HotSpot spot = this.getHotspotAt(p);
        if (spot == null) {
            return null;
        }
        Difference diff = spot.getDiff();
        if (diff.getType() == 1) {
            return NbBundle.getMessage(LineNumbersActionsBar.class, (String)"TT_DiffPanel_Remove");
        }
        if (diff.getType() == 2) {
            return NbBundle.getMessage(LineNumbersActionsBar.class, (String)"TT_DiffPanel_Replace");
        }
        return NbBundle.getMessage(LineNumbersActionsBar.class, (String)"TT_DiffPanel_Insert");
    }

    private void performAction(HotSpot spot) {
        this.master.getMaster().rollback(spot.getDiff());
    }

    public void mouseClicked(MouseEvent e) {
        HotSpot spot;
        if (!e.isPopupTrigger() && (spot = this.getHotspotAt(e.getPoint())) != null) {
            this.performAction(spot);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.lastMousePosition = POINT_ZERO;
        if (this.lastHotSpot != null) {
            this.repaint(this.lastHotSpot.getRect());
        }
        this.lastHotSpot = null;
    }

    public void mouseMoved(MouseEvent e) {
        Point p;
        this.lastMousePosition = p = e.getPoint();
        HotSpot spot = this.getHotspotAt(p);
        if (this.lastHotSpot != spot) {
            this.repaint(this.lastHotSpot == null ? spot.getRect() : this.lastHotSpot.getRect());
        }
        this.lastHotSpot = spot;
        this.setCursor(spot != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
    }

    public void mouseDragged(MouseEvent e) {
    }

    void onUISettingsChanged() {
        this.initUI();
        this.updateStateOnDocumentChange();
        this.repaint();
    }

    private void updateStateOnDocumentChange() {
        assert (SwingUtilities.isEventDispatchThread());
        StyledDocument doc = (StyledDocument)this.master.getEditorPane().getDocument();
        int lastOffset = doc.getEndPosition().getOffset();
        this.linesCount = NbDocument.findLineNumber((StyledDocument)doc, (int)lastOffset);
        Graphics g = this.getGraphics();
        if (g != null) {
            this.checkLinesWidth(g);
        }
        this.maxNumberCount = this.getNumberCount(this.linesCount);
        this.revalidate();
    }

    private boolean checkLinesWidth(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.getLinesFont());
        Rectangle2D rect = fm.getStringBounds(Integer.toString(this.linesCount), g);
        this.linesWidth = (int)rect.getWidth() + 8;
        if (this.linesWidth != this.oldLinesWidth) {
            this.oldLinesWidth = this.linesWidth;
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    private int getNumberCount(int n) {
        int nc = 0;
        while (n > 0) {
            n /= 10;
            ++nc;
        }
        return nc;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dim = this.master.getEditorPane().getPreferredScrollableViewportSize();
        return new Dimension(this.getBarWidth(), dim.height);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.master.getEditorPane().getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.master.getEditorPane().getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getBarWidth(), Short.MAX_VALUE);
    }

    private int getBarWidth() {
        return this.actionsWidth + this.linesWidth;
    }

    public void onDiffSetChanged() {
        this.updateStateOnDocumentChange();
        this.repaint();
    }

    protected void paintComponent(Graphics gr) {
        Rectangle hotSpot;
        int idx;
        Graphics2D g = (Graphics2D)gr;
        Rectangle clip = g.getClipBounds();
        Stroke cs = g.getStroke();
        if (this.checkLinesWidth(gr)) {
            return;
        }
        EditorUI editorUI = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)this.master.getEditorPane());
        int lineHeight = editorUI.getLineHeight();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(Color.LIGHT_GRAY);
        int x = this.master.isFirst() ? 0 : this.getBarWidth() - 1;
        g.drawLine(x, clip.y, x, clip.y + clip.height - 1);
        DiffViewManager.DecoratedDifference[] diffs = this.master.getMaster().getManager().getDecorations();
        int actionsYOffset = (lineHeight - this.actionIconsHeight) / 2;
        int offset = this.linesWidth;
        int currentDifference = this.master.getMaster().getCurrentDifference();
        ArrayList<HotSpot> newActionIcons = new ArrayList<HotSpot>();
        if (this.master.isFirst()) {
            idx = 0;
            for (DiffViewManager.DecoratedDifference dd : diffs) {
                g.setColor(this.master.getMaster().getColorLines());
                g.setStroke(currentDifference == idx ? this.master.getMaster().getBoldStroke() : cs);
                g.drawLine(0, dd.getTopLeft(), clip.width, dd.getTopLeft());
                if (dd.getBottomLeft() != -1) {
                    g.drawLine(0, dd.getBottomLeft(), clip.width, dd.getBottomLeft());
                }
                if (this.actionsEnabled && dd.canRollback() && dd.getDiff().getType() != 1) {
                    hotSpot = new Rectangle(1, dd.getTopLeft() + actionsYOffset, this.actionIconsWidth, this.actionIconsHeight);
                    if (hotSpot.contains(this.lastMousePosition) || idx == currentDifference) {
                        g.drawImage(this.insertActiveImage, hotSpot.x, hotSpot.y, this);
                    } else {
                        g.drawImage(this.insertImage, hotSpot.x, hotSpot.y, this);
                    }
                    newActionIcons.add(new HotSpot(hotSpot, dd.getDiff()));
                }
                ++idx;
            }
        } else {
            idx = 0;
            for (DiffViewManager.DecoratedDifference dd : diffs) {
                g.setColor(this.master.getMaster().getColorLines());
                g.setStroke(currentDifference == idx ? this.master.getMaster().getBoldStroke() : cs);
                g.drawLine(clip.x, dd.getTopRight(), clip.x + clip.width, dd.getTopRight());
                if (dd.getBottomRight() != -1) {
                    g.drawLine(clip.x, dd.getBottomRight(), clip.x + clip.width, dd.getBottomRight());
                }
                if (this.actionsEnabled && dd.canRollback() && dd.getDiff().getType() == 1) {
                    hotSpot = new Rectangle(offset + 1, dd.getTopRight() + actionsYOffset, this.actionIconsWidth, this.actionIconsHeight);
                    if (hotSpot.contains(this.lastMousePosition) || idx == currentDifference) {
                        g.drawImage(this.removeActiveImage, hotSpot.x, hotSpot.y, this);
                    } else {
                        g.drawImage(this.removeImage, hotSpot.x, hotSpot.y, this);
                    }
                    newActionIcons.add(new HotSpot(hotSpot, dd.getDiff()));
                }
                ++idx;
            }
        }
        this.hotspots = newActionIcons;
        int linesXOffset = this.master.isFirst() ? this.actionsWidth : 0;
        linesXOffset += 4;
        g.setFont(this.getLinesFont());
        g.setColor(this.linesColor);
        int lineNumber = clip.y / lineHeight;
        int yOffset = lineNumber * lineHeight;
        yOffset -= lineHeight / 4;
        int linesDrawn = clip.height / lineHeight + 3;
        int docLines = org.netbeans.editor.Utilities.getRowCount((BaseDocument)((BaseDocument)this.master.getEditorPane().getDocument()));
        if (lineNumber + linesDrawn - 1 > docLines) {
            linesDrawn = docLines - lineNumber + 1;
        }
        for (int i = 0; i < linesDrawn; ++i) {
            g.drawString(this.formatLineNumber(lineNumber), linesXOffset, yOffset);
            ++lineNumber;
            yOffset += lineHeight;
        }
    }

    private String formatLineNumber(int lineNumber) {
        String strNumber = Integer.toString(lineNumber);
        int nc = this.getNumberCount(lineNumber);
        if (nc < this.maxNumberCount) {
            StringBuilder sb = new StringBuilder(10);
            sb.append("        ", 0, this.maxNumberCount - nc);
            sb.append(strNumber);
            return sb.toString();
        }
        return strNumber;
    }

    private static class EditorUIHelper
    extends EditorUI {
        private EditorUIHelper() {
        }

        public static Map getSharedColoringMapFor(Class kitClass) {
            return EditorUIHelper.getSharedColoringMap((Class)kitClass);
        }
    }
}

