/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class LibraryManager {
    public static final String PROP_LIBRARIES = "libraries";
    private static LibraryManager instance;
    private Lookup.Result<LibraryProvider> result;
    private Collection<LibraryProvider> currentStorages = new ArrayList<LibraryProvider>();
    private PropertyChangeListener plistener;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Collection<Library> cache;

    private LibraryManager() {
    }

    public Library getLibrary(String name) {
        assert (name != null);
        Library[] libs = this.getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            if (!name.equals(libs[i].getName())) continue;
            return libs[i];
        }
        return null;
    }

    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            if (this.result == null) {
                this.plistener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        LibraryManager.this.resetCache();
                    }
                };
                this.result = Lookup.getDefault().lookupResult(LibraryProvider.class);
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        LibraryManager.this.resetCache();
                    }
                });
            }
            ArrayList<Library> l = new ArrayList<Library>();
            Collection instances = this.result.allInstances();
            HashSet added = new HashSet(instances);
            added.removeAll(this.currentStorages);
            HashSet<LibraryProvider> removed = new HashSet<LibraryProvider>(this.currentStorages);
            removed.removeAll(instances);
            this.currentStorages.clear();
            for (LibraryProvider storage : instances) {
                this.currentStorages.add(storage);
                for (LibraryImplementation impl : storage.getLibraries()) {
                    l.add(LibraryFactory.createLibrary(impl));
                }
            }
            for (LibraryProvider p : removed) {
                p.removePropertyChangeListener(this.plistener);
            }
            for (LibraryProvider p : added) {
                p.addPropertyChangeListener(this.plistener);
            }
            this.cache = l;
        }
        return this.cache.toArray(new Library[this.cache.size()]);
    }

    public void addLibrary(Library library) throws IOException, IllegalArgumentException {
        assert (library != null);
        if (LibrariesSupport.getLibraryTypeProvider(library.getType()) == null) {
            throw new IllegalArgumentException("Trying to add a library of unknown type: " + library.getType());
        }
        String newLibraryName = library.getName();
        if (newLibraryName == null || this.getLibrary(newLibraryName) != null) {
            throw new IllegalArgumentException("Library hasn't name or the name is already used: " + newLibraryName);
        }
        Collection providers = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
        assert (providers.size() == 1);
        ((WritableLibraryProvider)providers.iterator().next()).addLibrary(library.getLibraryImplementation());
    }

    public void removeLibrary(Library library) throws IOException, IllegalArgumentException {
        assert (library != null);
        Collection providers = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
        assert (providers.size() == 1);
        ((WritableLibraryProvider)providers.iterator().next()).removeLibrary(library.getLibraryImplementation());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        assert (listener != null);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        assert (listener != null);
        this.listeners.removePropertyChangeListener(listener);
    }

    private synchronized void resetCache() {
        this.cache = null;
        this.listeners.firePropertyChange(PROP_LIBRARIES, null, null);
    }

    public static synchronized LibraryManager getDefault() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }
}

