/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.project.libraries.LibraryImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultLibraryImplementation
implements LibraryImplementation {
    private String description;
    private Map<String, List<URL>> contents;
    private String name;
    private String libraryType;
    private String localizingBundle;
    private List<PropertyChangeListener> listeners;

    public DefaultLibraryImplementation(String libraryType, String[] volumeTypes) {
        assert (libraryType != null && volumeTypes != null);
        this.libraryType = libraryType;
        this.contents = new HashMap<String, List<URL>>();
        for (String vtype : volumeTypes) {
            this.contents.put(vtype, Collections.emptyList());
        }
    }

    @Override
    public String getType() {
        return this.libraryType;
    }

    @Override
    public void setName(String name) throws UnsupportedOperationException {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("name", oldName, this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<URL> getContent(String contentType) throws IllegalArgumentException {
        List<URL> content = this.contents.get(contentType);
        if (content == null) {
            throw new IllegalArgumentException();
        }
        return Collections.unmodifiableList(content);
    }

    @Override
    public void setContent(String contentType, List<URL> path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (!this.contents.keySet().contains(contentType)) {
            throw new IllegalArgumentException("Volume '" + contentType + "' is not support by this library. The only acceptable values are: " + this.contents.keySet());
        }
        this.contents.put(contentType, new ArrayList<URL>(path));
        this.firePropertyChange("content", null, null);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String text) {
        String oldDesc = this.description;
        this.description = text;
        this.firePropertyChange("description", oldDesc, this.description);
    }

    @Override
    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    @Override
    public void setLocalizingBundle(String resourceName) {
        this.localizingBundle = resourceName;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public String toString() {
        return "LibraryImplementation[Name=" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String propName, Object oldValue, Object newValue) {
        ArrayList<PropertyChangeListener> ls;
        DefaultLibraryImplementation defaultLibraryImplementation = this;
        synchronized (defaultLibraryImplementation) {
            if (this.listeners == null) {
                return;
            }
            ls = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propName, oldValue, newValue);
        for (PropertyChangeListener l : ls) {
            l.propertyChange(event);
        }
    }
}

