/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewLibraryPanel
extends JPanel {
    private LibrariesModel model;
    private Map<Integer, String> typeMap;
    private DialogDescriptor dd;
    private static final Pattern VALID_LIBRARY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox libraryType;
    private JTextField name;
    private JLabel status;

    public NewLibraryPanel(LibrariesModel model, String preselectedLibraryType) {
        this.model = model;
        this.initComponents();
        this.name.setColumns(25);
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                NewLibraryPanel.this.nameChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                NewLibraryPanel.this.nameChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                NewLibraryPanel.this.nameChanged();
            }
        });
        this.initModel(preselectedLibraryType);
        Color c = UIManager.getColor("nb.errorForeground");
        if (c == null) {
            c = new Color(89, 79, 191);
        }
        this.status.setForeground(c);
    }

    void setDialogDescriptor(DialogDescriptor dd) {
        this.dd = dd;
    }

    public String getLibraryType() {
        return this.typeMap.get(this.libraryType.getSelectedIndex());
    }

    public String getLibraryName() {
        return this.name.getText();
    }

    public void addNotify() {
        super.addNotify();
        this.name.selectAll();
    }

    private void initModel(String preselectedLibraryType) {
        this.typeMap = new HashMap<Integer, String>();
        this.name.setText(NbBundle.getMessage(NewLibraryPanel.class, (String)"TXT_NewLibrary"));
        LibraryTypeRegistry regs = LibraryTypeRegistry.getDefault();
        LibraryTypeProvider[] providers = regs.getLibraryTypeProviders();
        int index = 0;
        for (int i = 0; i < providers.length; ++i) {
            String type = providers[i].getLibraryType();
            if (type.equals(preselectedLibraryType)) {
                index = i;
            }
            this.typeMap.put(i, type);
            String displayName = providers[i].getDisplayName();
            if (displayName == null) {
                displayName = providers[i].getLibraryType();
            }
            this.libraryType.addItem(displayName);
        }
        if (this.libraryType.getItemCount() > 0) {
            this.libraryType.setSelectedIndex(index);
        }
    }

    private void nameChanged() {
        String message;
        String name = this.name.getText();
        boolean valid = false;
        if (name.length() == 0) {
            message = NbBundle.getMessage(NewLibraryPanel.class, (String)"ERR_InvalidName");
        } else {
            valid = LibrariesCustomizer.isValidName(this.model, name);
            if (valid) {
                if (this.isReasonableAntProperty(name)) {
                    message = " ";
                } else {
                    valid = false;
                    message = NbBundle.getMessage(NewLibraryPanel.class, (String)"ERR_InvalidCharacters");
                }
            } else {
                message = NbBundle.getMessage(NewLibraryPanel.class, (String)"ERR_ExistingName", (Object)name);
            }
        }
        if (this.dd != null) {
            this.dd.setValid(valid);
        }
        this.status.setText(message);
    }

    private boolean isReasonableAntProperty(String name) {
        return VALID_LIBRARY_NAME.matcher(name).matches();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.name = new JTextField();
        this.jLabel1 = new JLabel();
        this.libraryType = new JComboBox();
        this.status = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewLibraryPanel.class, (String)"CTL_LibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 6, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 6, 12);
        this.add((Component)this.name, gridBagConstraints);
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewLibraryPanel.class, (String)"AD_LibraryName"));
        this.jLabel1.setLabelFor(this.libraryType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewLibraryPanel.class, (String)"CTL_LibraryType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.libraryType, gridBagConstraints);
        this.libraryType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewLibraryPanel.class, (String)"AD_LibraryType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.status, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle");
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_NewLibraryPanel"));
    }
}

