/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RecentViewList
implements PropertyChangeListener {
    private static RecentViewList instance;
    private List<Reference<TopComponent>> tcWeakList = new ArrayList<Reference<TopComponent>>(20);

    public RecentViewList(WindowManager wm) {
        wm.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public TopComponent[] getTopComponents() {
        ArrayList<TopComponent> tcList = new ArrayList<TopComponent>(this.tcWeakList.size());
        this.clean();
        for (int i = 0; i < this.tcWeakList.size(); ++i) {
            Reference<TopComponent> w = this.tcWeakList.get(i);
            TopComponent tc = w.get();
            if (tc == null || !tc.isOpened()) continue;
            tcList.add(tc);
        }
        return tcList.toArray(new TopComponent[tcList.size()]);
    }

    public void setTopComponents(TopComponent[] tcs) {
        this.tcWeakList.clear();
        for (int i = 0; i < tcs.length; ++i) {
            WeakReference<TopComponent> wr = new WeakReference<TopComponent>(tcs[i]);
            this.tcWeakList.add(wr);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TopComponent tc;
        if ("activated".equals(evt.getPropertyName()) && (tc = (TopComponent)evt.getNewValue()) != null) {
            this.clean();
            Reference<TopComponent> w = this.find(tc);
            if (w != null) {
                this.tcWeakList.remove(w);
                this.tcWeakList.add(0, w);
            } else {
                WeakReference<TopComponent> wr = new WeakReference<TopComponent>(tc);
                this.tcWeakList.add(0, wr);
            }
            this.fillList(TopComponent.getRegistry().getOpened());
        }
    }

    private void clean() {
        int i = 0;
        while (i < this.tcWeakList.size()) {
            WeakReference w = (WeakReference)this.tcWeakList.get(i);
            TopComponent tc = (TopComponent)w.get();
            if (tc == null) {
                this.tcWeakList.remove(w);
                continue;
            }
            ++i;
        }
    }

    private Reference<TopComponent> find(TopComponent tc) {
        for (int i = 0; i < this.tcWeakList.size(); ++i) {
            Reference<TopComponent> w = this.tcWeakList.get(i);
            TopComponent c = w.get();
            if (tc != c) continue;
            return w;
        }
        return null;
    }

    private void fillList(Set<TopComponent> openedTCs) {
        for (TopComponent curTC : openedTCs) {
            WeakReference<TopComponent> wr;
            if (this.find(curTC) != null) continue;
            if (this.tcWeakList.size() > 1) {
                wr = new WeakReference<TopComponent>(curTC);
                this.tcWeakList.add(1, wr);
                continue;
            }
            wr = new WeakReference<TopComponent>(curTC);
            this.tcWeakList.add(wr);
        }
    }
}

