/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegistryImpl
implements TopComponent.Registry {
    private TopComponent activatedTopComponent;
    private WeakReference<TopComponent> previousActivated;
    private final Set<TopComponent> openSet = new WeakSet(30);
    private Node[] currentNodes;
    private Node[] activatedNodes;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final boolean DEBUG = Debug.isLoggable(RegistryImpl.class);

    public synchronized Set<TopComponent> getOpened() {
        return Collections.unmodifiableSet(this.openSet);
    }

    public TopComponent getActivated() {
        return this.activatedTopComponent;
    }

    public Node[] getCurrentNodes() {
        return this.currentNodes;
    }

    public Node[] getActivatedNodes() {
        return this.activatedNodes == null ? new Node[]{} : this.activatedNodes;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    void topComponentActivated(TopComponent tc) {
        if (this.activatedTopComponent == tc && this.activatedNodes != null) {
            return;
        }
        final TopComponent old = this.activatedTopComponent;
        if (old != null && old.getActivatedNodes() != null) {
            this.previousActivated = new WeakReference<TopComponent>(old);
        }
        this.activatedTopComponent = tc;
        Window w = tc == null ? null : SwingUtilities.windowForComponent((Component)tc);
        RegistryImpl.cancelMenu(w);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryImpl.this.doFirePropertyChange("activated", old, RegistryImpl.this.activatedTopComponent);
            }
        });
        this.selectedNodesChanged(this.activatedTopComponent, this.activatedTopComponent == null ? null : this.activatedTopComponent.getActivatedNodes());
    }

    synchronized void topComponentOpened(TopComponent tc) {
        if (this.openSet.contains(tc)) {
            return;
        }
        HashSet<TopComponent> old = new HashSet<TopComponent>(this.openSet);
        this.openSet.add(tc);
        this.doFirePropertyChange("tcOpened", null, tc);
        this.doFirePropertyChange("opened", old, new HashSet<TopComponent>(this.openSet));
    }

    synchronized void topComponentClosed(TopComponent tc) {
        Object[] closedNodes;
        if (!this.openSet.contains(tc)) {
            return;
        }
        HashSet<TopComponent> old = new HashSet<TopComponent>(this.openSet);
        this.openSet.remove(tc);
        this.doFirePropertyChange("tcClosed", null, tc);
        this.doFirePropertyChange("opened", old, new HashSet<TopComponent>(this.openSet));
        if (this.activatedNodes != null && (closedNodes = tc.getActivatedNodes()) != null && Arrays.equals(closedNodes, this.activatedNodes)) {
            this.activatedNodes = null;
            this.doFirePropertyChange("activatedNodes", closedNodes, null);
        }
    }

    public void selectedNodesChanged(TopComponent tc, Node[] newNodes) {
        Object[] oldNodes = this.currentNodes;
        if (tc != this.activatedTopComponent && this.activatedNodes != null && !this.isProperPrevious(tc, newNodes)) {
            return;
        }
        if (Arrays.equals(oldNodes, newNodes) && this.activatedNodes != null) {
            return;
        }
        this.currentNodes = newNodes == null ? null : (Node[])newNodes.clone();
        this.tryFireChanges((Node[])oldNodes, this.currentNodes);
    }

    private boolean isProperPrevious(TopComponent tc, Node[] newNodes) {
        if (this.previousActivated == null || newNodes == null) {
            return false;
        }
        TopComponent previousTC = (TopComponent)this.previousActivated.get();
        if (previousTC == null || !previousTC.equals(tc)) {
            return false;
        }
        return this.activatedTopComponent.getActivatedNodes() == null;
    }

    public static void cancelMenu(Window window) {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] path = msm.getSelectedPath();
        for (int i = 0; i < path.length; ++i) {
            Window w = SwingUtilities.windowForComponent(path[i].getComponent());
            if (w == null || w != window && w.getOwner() != window) continue;
            return;
        }
        msm.clearSelectedPath();
    }

    private void tryFireChanges(Node[] oldNodes, Node[] newNodes) {
        this.doFirePropertyChange("currentNodes", oldNodes, newNodes);
        if (newNodes == null && this.activatedNodes == null) {
            newNodes = new Node[]{};
        }
        if (newNodes != null) {
            oldNodes = this.activatedNodes;
            this.activatedNodes = newNodes;
            this.support.firePropertyChange("activatedNodes", oldNodes, this.activatedNodes);
        }
    }

    private void doFirePropertyChange(final String propName, final Object oldValue, final Object newValue) {
        if (DEBUG) {
            RegistryImpl.debugLog("");
            RegistryImpl.debugLog("Scheduling event firing: propName=" + propName);
            RegistryImpl.debugLog("\toldValue=" + (oldValue instanceof Object[] ? Arrays.asList((Object[])oldValue) : oldValue));
            RegistryImpl.debugLog("\tnewValue=" + (newValue instanceof Object[] ? Arrays.asList((Object[])newValue) : newValue));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.support.firePropertyChange(propName, oldValue, newValue);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RegistryImpl.this.support.firePropertyChange(propName, oldValue, newValue);
                }
            });
        }
    }

    void clear() {
        this.activatedTopComponent = null;
        this.openSet.clear();
        this.currentNodes = null;
        this.activatedNodes = null;
    }

    private static void debugLog(String message) {
        Debug.log(RegistryImpl.class, message);
    }
}

