/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

public class AttachWindowAction
extends AbstractAction
implements Presenter.Menu {
    private static final String PROP_ACTION_CHANGED = "actionChanged";
    private final PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("activated".equals(propName) || "modes".equals(propName) || "editorAreaState".equals(propName)) {
                AttachWindowAction.this.updateState();
            }
        }
    };

    public AttachWindowAction() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        WindowManagerImpl.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)WindowManagerImpl.getInstance())));
        this.updateState();
    }

    public void actionPerformed(ActionEvent evt) {
    }

    private void updateState() {
        TopComponent active = TopComponent.getRegistry().getActivated();
        String param = active == null ? "" : active.getName();
        this.putValue("Name", NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_AttachWindowAction", (Object)param));
        if (WindowManagerImpl.getInstance().getEditorAreaState() == 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(active != null);
        }
        this.firePropertyChange(PROP_ACTION_CHANGED, null, null);
    }

    public JMenuItem getMenuPresenter() {
        LazyPopup mi = new LazyPopup(this);
        Actions.connect((JMenuItem)((Object)mi), (Action)this, (boolean)false);
        return mi;
    }

    private static class AttachAction
    extends AbstractAction {
        private final ModeImpl mode;
        private final String side;

        public AttachAction(ModeImpl mode, String side) {
            String key;
            this.mode = mode;
            this.side = side;
            if (side == null) {
                key = "CTL_SideAsLastTab";
                TopComponent active = TopComponent.getRegistry().getActivated();
                if (mode.getOpenedTopComponents().contains(active)) {
                    this.setEnabled(false);
                }
            } else if (side == "top") {
                key = "CTL_SideTop";
            } else if (side == "left") {
                key = "CTL_SideLeft";
            } else if (side == "bottom") {
                key = "CTL_SideBottom";
            } else if (side == "right") {
                key = "CTL_SideRight";
            } else {
                return;
            }
            this.putValue("Name", NbBundle.getMessage(AttachWindowAction.class, (String)key));
        }

        public void actionPerformed(ActionEvent evt) {
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            ModeImpl activeMode = wm.getActiveMode();
            if (activeMode == null) {
                return;
            }
            TopComponent selected = activeMode.getSelectedTopComponent();
            if (selected == null || !this.mode.canContain(selected)) {
                return;
            }
            if (this.side == null) {
                this.mode.dockInto(selected);
                selected.open();
                selected.requestActive();
            } else {
                wm.attachTopComponentToSide(selected, this.mode, this.side);
            }
        }
    }

    private static class LazyPopup
    extends JMenuPlus
    implements PropertyChangeListener {
        private boolean created = false;

        public LazyPopup(Action action) {
            this.setText((String)action.getValue("Name"));
            action.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action));
        }

        public JPopupMenu getPopupMenu() {
            if (!this.created) {
                this.createMenuItems();
            }
            return super.getPopupMenu();
        }

        private void createMenuItems() {
            this.created = true;
            this.removeAll();
            ModeImpl editorMode = (ModeImpl)WindowManagerImpl.getInstance().findMode("editor");
            if (editorMode != null) {
                this.add(new ModeMenu(editorMode, NbBundle.getMessage(AttachWindowAction.class, (String)"CTL_Documents"), true));
                this.add(new JSeparator());
            }
            Set<? extends Mode> modeSet = WindowManagerImpl.getInstance().getModes();
            for (ModeImpl modeImpl : modeSet) {
                TopComponent tc;
                if ("editor".equals(modeImpl.getName()) || modeImpl.getOpenedTopComponents().isEmpty() || (tc = modeImpl.getSelectedTopComponent()) == null) continue;
                String name = tc.getName();
                this.add(new ModeMenu(modeImpl, name == null ? "null" : name, false));
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("Name".equals(evt.getPropertyName())) {
                this.setText((String)evt.getNewValue());
            } else if (AttachWindowAction.PROP_ACTION_CHANGED.equals(evt.getPropertyName())) {
                this.created = false;
            }
        }
    }

    private static class ModeMenu
    extends JMenu {
        public ModeMenu(ModeImpl mode, String name, boolean editor) {
            super(name);
            TopComponent active = TopComponent.getRegistry().getActivated();
            if (mode.canContain(active)) {
                if (!editor) {
                    this.add(new AttachAction(mode, null));
                    this.add(new JSeparator());
                }
                this.add(new AttachAction(mode, "top"));
                this.add(new AttachAction(mode, "left"));
                this.add(new AttachAction(mode, "bottom"));
                this.add(new AttachAction(mode, "right"));
            } else {
                this.setEnabled(false);
            }
        }
    }
}

