/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.windows.services.ActionPasteType;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolbarFolderNode
extends DataFolder.FolderNode
implements PropertyChangeListener {
    static SystemAction[] topStaticActions;
    private DataFolder folder;

    public ToolbarFolderNode() {
        this(NbPlaces.getDefault().toolbars());
    }

    ToolbarFolderNode(DataFolder folder) {
        DataFolder dataFolder = folder;
        dataFolder.getClass();
        super(dataFolder, (Children)new ToolbarFolderChildren(folder));
        this.folder = folder;
        super.setShortDescription(NbBundle.getBundle(ToolbarFolderNode.class).getString("CTL_Toolbars_hint"));
        this.setIconBaseWithExtension("org/netbeans/core/resources/toolbars.gif");
        ToolbarPool.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ToolbarPool.getDefault()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ToolbarFolderNode.class);
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        PasteType pType = ActionPasteType.getPasteType((DataFolder)this.getDataObject(), t);
        if (pType != null) {
            s.add(pType);
        }
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewType(){

            public String getName() {
                return NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_newToolbarName");
            }

            public void create() throws IOException {
                ToolbarFolderNode.this.newToolbar();
            }
        }};
    }

    void newToolbar() {
        String s;
        ResourceBundle bundle = NbBundle.getBundle(ToolbarFolderNode.class);
        NotifyDescriptor.InputLine il = new NotifyDescriptor.InputLine(bundle.getString("PROP_newToolbarLabel"), bundle.getString("PROP_newToolbarDialog"));
        il.setInputText(bundle.getString("PROP_newToolbar"));
        Object ok = DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
        if (ok == NotifyDescriptor.OK_OPTION && !(s = il.getInputText()).equals("")) {
            FileObject tbFO = this.folder.getPrimaryFile();
            try {
                FileObject newFO = tbFO.getFileObject(s);
                if (newFO == null) {
                    String lastName = this.getLastName();
                    newFO = tbFO.createFolder(s);
                    if (lastName != null) {
                        tbFO.setAttribute(lastName + "/" + newFO.getNameExt(), (Object)Boolean.TRUE);
                    }
                } else {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)MessageFormat.format(bundle.getString("MSG_ToolbarExists"), s));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private String getLastName() {
        Node last;
        DataObject d;
        String lastName = null;
        Node[] ch = this.getChildren().getNodes();
        if (ch.length > 0 && (d = (DataObject)(last = ch[ch.length - 1]).getCookie(DataObject.class)) != null) {
            lastName = d.getPrimaryFile().getNameExt();
        }
        return lastName;
    }

    public Action[] getActions(boolean context) {
        if (topStaticActions == null) {
            topStaticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(NewAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
        }
        return topStaticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[0];
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("configuration".equals(evt.getPropertyName())) {
            this.firePropertyChange("configuration", evt.getOldValue(), evt.getNewValue());
        }
    }

    static final class ToolbarFolderChildren
    extends FilterNode.Children {
        public ToolbarFolderChildren(DataFolder folder) {
            super(folder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
            if (df != null) {
                return new ToolbarNode(df);
            }
            if (node.getCookie(InstanceDataObject.class) != null) {
                return new ToolbarItemNode(node);
            }
            return node.cloneNode();
        }

        protected Node[] createNodes(Node key) {
            Node[] retValue = super.createNodes(key);
            if (retValue.length == 1) {
                InstanceCookie ic = (InstanceCookie)retValue[0].getCookie(InstanceCookie.class);
                boolean isConfig = false;
                if (ic != null) {
                    if (ic instanceof InstanceCookie.Of) {
                        isConfig = ((InstanceCookie.Of)ic).instanceOf(ToolbarConfiguration.class);
                    } else {
                        try {
                            if (ic.instanceClass().equals(ToolbarConfiguration.class)) {
                                isConfig = true;
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
                if (isConfig) {
                    retValue = new Node[]{};
                }
            }
            return retValue;
        }
    }

    static final class ToolbarItemNode
    extends FilterNode {
        static SystemAction[] staticActions;
        static SystemAction[] separatorStaticActions;

        ToolbarItemNode(Node filter) {
            super(filter, FilterNode.Children.LEAF);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return this == o || this.getOriginal().equals(o) || o.equals(this.getOriginal());
        }

        public SystemAction[] getActions() {
            InstanceCookie.Of ic = (InstanceCookie.Of)this.getCookie(InstanceCookie.Of.class);
            if (ic != null && ic.instanceOf(JSeparator.class)) {
                if (null == separatorStaticActions) {
                    separatorStaticActions = new SystemAction[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
                }
                return separatorStaticActions;
            }
            if (staticActions == null) {
                staticActions = new SystemAction[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return staticActions;
        }

        public boolean canRename() {
            return false;
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToolbarNode
    extends DataFolder.FolderNode
    implements PropertyChangeListener {
        static SystemAction[] staticActions;
        private DataFolder folder;
        private PropertyChangeListener wlpc;

        ToolbarNode(DataFolder folder) {
            DataFolder dataFolder = folder;
            dataFolder.getClass();
            super(dataFolder, (Children)new ToolbarFolderChildren(folder));
            this.folder = folder;
            super.setName(folder.getName());
            super.setShortDescription(NbBundle.getBundle(ToolbarFolderNode.class).getString("CTL_Toolbars_hint"));
            this.setIconBaseWithExtension("org/netbeans/core/resources/toolbars.gif");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolbarPool pool = ToolbarPool.getDefault();
                    pool.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)ToolbarNode.this, (Object)pool));
                }
            });
            this.attachConfigListener();
        }

        protected void createPasteTypes(Transferable t, List<PasteType> s) {
            PasteType pType = ActionPasteType.getPasteType((DataFolder)this.getDataObject(), t);
            if (pType != null) {
                s.add(pType);
            }
        }

        public NewType[] getNewTypes() {
            return new NewType[]{new NewType(){

                public String getName() {
                    return NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_newToolbarSeparator");
                }

                public void create() throws IOException {
                    ToolbarNode.this.newToolbarSeparator();
                }
            }};
        }

        public void setName(String name, boolean rename) {
            Toolbar tb = ToolbarPool.getDefault().findToolbar(this.getName());
            if (tb != null) {
                tb.setName(name);
            }
            super.setName(name, rename);
        }

        void newToolbarSeparator() {
            try {
                InstanceDataObject instData = InstanceDataObject.find((DataFolder)this.folder, null, (String)"javax.swing.JToolBar$Separator");
                String lastName = this.getLastName();
                Object d = instData == null ? InstanceDataObject.create((DataFolder)this.folder, null, (String)"javax.swing.JToolBar$Separator") : instData.copy(this.folder);
                if (lastName != null) {
                    this.folder.getPrimaryFile().setAttribute(lastName + "/" + d.getPrimaryFile().getNameExt(), (Object)Boolean.TRUE);
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }

        private String getLastName() {
            Node last;
            DataObject d;
            String lastName = null;
            Node[] ch = this.getChildren().getNodes();
            if (ch.length > 0 && (d = (DataObject)(last = ch[ch.length - 1]).getCookie(DataObject.class)) != null) {
                lastName = d.getPrimaryFile().getNameExt();
            }
            return lastName;
        }

        public Action[] getActions(boolean context) {
            if (staticActions == null) {
                staticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(ReorderAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(NewAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return staticActions;
        }

        public Node.PropertySet[] getPropertySets() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set ss = sheet.get("properties");
            ss.put((Node.Property)new PropertySupport.Name((Node)this, NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_ToolbarName"), NbBundle.getBundle(ToolbarFolderNode.class).getString("HINT_ToolbarName")));
            ss.put((Node.Property)new PropertySupport.ReadWrite<Boolean>("visible", Boolean.class, NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_ToolbarVisible"), NbBundle.getBundle(ToolbarFolderNode.class).getString("HINT_ToolbarVisible")){

                public void setValue(Boolean v) {
                    ToolbarNode.this.currentConfiguration().setToolbarVisible(ToolbarPool.getDefault().findToolbar(ToolbarNode.this.folder.getName()), v);
                }

                public Boolean getValue() {
                    return ToolbarNode.this.currentConfiguration().isToolbarVisible(ToolbarPool.getDefault().findToolbar(ToolbarNode.this.folder.getName())) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            return sheet.toArray();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("configuration".equals(evt.getPropertyName())) {
                ToolbarConfiguration tc = this.configuration((String)evt.getOldValue());
                if (tc != null && this.wlpc != null) {
                    tc.removePropertyChangeListener(this.wlpc);
                }
                this.attachConfigListener();
            } else if ("constraints".equals(evt.getPropertyName())) {
                this.firePropertyChange("visible", evt.getOldValue(), evt.getNewValue());
            }
        }

        private void attachConfigListener() {
            ToolbarConfiguration tc = this.currentConfiguration();
            if (tc != null) {
                this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)tc);
                tc.addPropertyChangeListener(this.wlpc);
            }
        }

        ToolbarConfiguration currentConfiguration() {
            String conf = ToolbarPool.getDefault().getConfiguration();
            return this.configuration(conf);
        }

        ToolbarConfiguration configuration(String conf) {
            DataObject[] obj = NbPlaces.getDefault().toolbars().getChildren();
            for (int i = 0; i < obj.length; ++i) {
                DataObject o = obj[i];
                InstanceCookie ic = (InstanceCookie)o.getCookie(InstanceCookie.class);
                if (ic == null) continue;
                try {
                    ToolbarConfiguration tc;
                    if (!ToolbarConfiguration.class.isAssignableFrom(ic.instanceClass()) || !conf.equals((tc = (ToolbarConfiguration)ic.instanceCreate()).getName())) continue;
                    return tc;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }
}

